/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.google;

import java.awt.Color;
import java.util.List;
import java.util.Random;
import java.util.TimeZone;
import java.util.Vector;
import org.opengts.google.GoogleChart;
import org.opengts.util.ColorTools;
import org.opengts.util.DateTime;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class GoogleChartTemperature
extends GoogleChart {
    protected static final long MIN_DATE = 1L;
    public static final int TEMP_F = 0;
    public static final int TEMP_C = 1;
    private int dispUnits = 0;
    private double minTempC = -17.77777;
    private double maxTempC = 54.44444;
    private int yTickCount = 10;
    private long minDateTS = 0L;
    private long maxDateTS = 0L;
    private TimeZone timeZone = null;
    private String dateFormat = null;
    private String timeFormat = null;
    private int xTickCount = 10;
    private boolean didInitChart = false;
    private static Color[] TEMP_COLOR = new Color[]{Color.red, Color.green, Color.blue, Color.cyan, Color.gray};

    private static double F2C(double F) {
        return (F - 32.0) * 5.0 / 9.0;
    }

    private static double C2F(double C) {
        return C * 9.0 / 5.0 + 32.0;
    }

    public GoogleChartTemperature() {
        this.setType("lxy");
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getDateFormat() {
        return StringTools.isBlank(this.dateFormat) ? this.dateFormat : "MM/dd";
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
    }

    public String getTimeFormat() {
        return StringTools.isBlank(this.timeFormat) ? this.timeFormat : "HH:mm:ss";
    }

    public void setDateRange(DateTime minDate, DateTime maxDate, int tickCount) throws Exception {
        long maxDateTS;
        long minDateTS = minDate != null ? minDate.getTimeSec() : 0L;
        long l = maxDateTS = maxDate != null ? maxDate.getTimeSec() : 0L;
        if (minDate == null || minDateTS < 1L || maxDate == null || maxDateTS < 1L || minDateTS >= maxDateTS || maxDateTS - minDateTS <= 60L) {
            throw new Exception("Invalid Date range specification");
        }
        maxDateTS += (maxDateTS - minDateTS) % (long)tickCount;
        this.minDateTS = minDateTS;
        this.maxDateTS = maxDateTS;
        this.timeZone = minDate.getTimeZone();
        this.xTickCount = tickCount > 0 ? tickCount : 6;
    }

    public int getDateTickCount() {
        return this.xTickCount;
    }

    public void setTemperatureRange(int units, double minTempC, double maxTempC, int tickCount) throws Exception {
        if (minTempC < -40.0 || minTempC > 125.0 || maxTempC < -40.0 || maxTempC > 125.0 || minTempC > maxTempC) {
            throw new Exception("Invalid Temperature range specification");
        }
        if (minTempC == maxTempC) {
            minTempC -= 1.0;
            maxTempC += 1.0;
        }
        this.dispUnits = units == 1 ? 1 : 0;
        this.minTempC = minTempC;
        this.maxTempC = maxTempC;
        this.yTickCount = tickCount > 0 ? tickCount : 10;
        this.appendTitle(this.dispUnits == 1 ? " (C)" : " (F)");
    }

    public int getTemperatureTickCount() {
        return this.yTickCount;
    }

    protected void _initChart() throws Exception {
        if (this.didInitChart) {
            return;
        }
        int yTickCnt = this.getTemperatureTickCount();
        int xTickCnt = this.getDateTickCount();
        this.setGrid(0, yTickCnt);
        StringBuffer ya = new StringBuffer();
        double deltaC = this.maxTempC - this.minTempC;
        for (int y = 0; y <= yTickCnt; ++y) {
            double C = this.minTempC + deltaC * ((double)y / (double)yTickCnt);
            double v = this.dispUnits == 1 ? C : GoogleChartTemperature.C2F(C);
            ya.append("|").append(StringTools.format(v, "0.0"));
        }
        if (this.maxTempC > 0.0 && this.minTempC < 0.0) {
            double sep = Math.abs(this.minTempC) / (this.maxTempC - this.minTempC);
            this.addShapeMarker("r,AA4444,0," + StringTools.format(sep, "0.000") + "," + StringTools.format(sep + 0.002, "0.000"));
        }
        StringBuffer xat = new StringBuffer();
        StringBuffer xad = new StringBuffer();
        double deltaTS = this.maxDateTS - this.minDateTS;
        long lastDN = 0L;
        for (int x = 0; x <= xTickCnt; ++x) {
            long ts = this.minDateTS + Math.round(deltaTS * ((double)x / (double)xTickCnt));
            DateTime dt = new DateTime(ts, this.timeZone);
            long dn = DateTime.getDayNumberFromDate(dt);
            xat.append("|").append(dt.format(this.getTimeFormat()));
            xad.append("|").append(dt.format(this.getDateFormat()));
            if (dn == lastDN) continue;
            long ds = dt.getDayStart();
            if (ds > this.minDateTS) {
                double sep = (double)(ds - this.minDateTS) / deltaTS;
                this.addShapeMarker("R,444444,0," + StringTools.format(sep, "0.000") + "," + StringTools.format(sep + 0.001, "0.000"));
            }
            lastDN = dn;
        }
        this.setAxisLabels("y,x,x", "0:" + ya.toString() + "|1:" + xad.toString() + "|2:" + xat.toString());
        this.didInitChart = true;
    }

    public void addDataSet(Color color, String legend, Data[] data) throws Exception {
        this._initChart();
        String hexColor = ColorTools.toHexString(color, false);
        this.addDatasetColor(hexColor);
        this.addDatasetLegend(legend);
        this.addShapeMarker("d," + hexColor + "," + this.dataSetCount + ",-1,7,1");
        StringBuffer xv = new StringBuffer();
        StringBuffer yv = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            GoogleChartTemperature.GetScaledExtendedEncodedValue(yv, data[i].getTempC(), this.minTempC, this.maxTempC);
            GoogleChartTemperature.GetScaledExtendedEncodedValue(xv, data[i].getTimestamp(), (double)this.minDateTS, (double)this.maxDateTS);
        }
        this.chd = StringTools.isBlank(this.chd) ? "e:" : this.chd + ",";
        this.chd = this.chd + xv.toString() + "," + yv.toString();
        ++this.dataSetCount;
    }

    public void _addRandomSampleData(int setCount, int tempCount) throws Exception {
        long sts = this.minDateTS;
        long ets = this.maxDateTS;
        Random ran = new Random(sts);
        if (setCount <= 0) {
            setCount = 1;
        }
        List[] dataSet = new List[setCount];
        for (int d = 0; d < dataSet.length; ++d) {
            dataSet[d] = new Vector();
        }
        double rangeC = this.maxTempC - this.minTempC;
        long deltaSize = (ets - sts) / (long)tempCount;
        long deltaRangeTS = DateTime.HourSeconds(3L);
        long ts = sts + deltaSize / 2L;
        double Cs = ran.nextDouble() * rangeC * 0.1 + rangeC * 0.05;
        for (int t = 0; t < tempCount; ++t) {
            double[] C = new double[dataSet.length];
            for (int d = 0; d < dataSet.length; ++d) {
                C[d] = ran.nextDouble() * 7.0 + (d == 0 ? Cs : C[d - 1]) - 2.5;
                if (C[d] < this.minTempC) {
                    C[d] = this.minTempC;
                }
                if (C[d] > this.maxTempC) {
                    C[d] = this.maxTempC;
                }
                dataSet[d].add(new Data(ts, C[d]));
            }
            ts = sts + (long)(t + 1) * deltaSize + (long)ran.nextInt((int)deltaRangeTS) + deltaRangeTS / 2L;
            if (ts > ets) {
                ts = ets - 1L;
            }
            Cs = C[0];
        }
        for (int d = 0; d < dataSet.length; ++d) {
            ListTools.sort(dataSet[d], null);
            Color color = TEMP_COLOR[d % TEMP_COLOR.length];
            this.addDataSet(color, "Temp " + (d + 1), dataSet[d].toArray(new Data[dataSet[d].size()]));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("http://chart.apis.google.com/chart?");
        sb.append("uniq=").append(DateTime.getCurrentTimeSec()).append("&");
        sb.append("cht=").append(this.cht).append("&");
        sb.append("chs=").append(this.chs).append("&");
        sb.append("chxt=").append(this.chxt).append("&");
        sb.append("chg=").append(this.chg).append("&");
        sb.append("chxl=").append(this.chxl).append("&");
        sb.append("chts=").append(this.chts).append("&");
        sb.append("chtt=").append(this.chtt).append("&");
        sb.append("chco=").append(this.chco).append("&");
        sb.append("chdl=").append(this.chdl).append("&");
        sb.append("chd=").append(this.chd).append("&");
        sb.append("chm=").append(this.chm);
        return sb.toString();
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        long now = DateTime.getCurrentTimeSec();
        long sts = now - DateTime.DaySeconds(3L);
        long ets = now;
        GoogleChartTemperature gct = new GoogleChartTemperature();
        try {
            gct.setSize(700, 400);
            gct.setTitle(Color.black, 16, "Temperature");
            gct.setTemperatureRange(1, GoogleChartTemperature.F2C(0.0), GoogleChartTemperature.F2C(130.0), 10);
            gct.setDateRange(new DateTime(sts), new DateTime(ets), 8);
            gct.setDateFormat("MM/dd");
            gct.setTimeFormat("HH:mm:ss");
            int setCount = 3;
            int tempCount = 15;
            gct._addRandomSampleData(setCount, tempCount);
            System.out.println(gct.toString());
        }
        catch (Throwable th) {
            Print.logException("Error", th);
            System.exit(1);
        }
    }

    public static class Data {
        private long timestamp = 0L;
        private double tempC = -999.0;
        private String stringVal = null;

        public Data(long ts, double C) {
            this.timestamp = ts;
            this.tempC = C;
        }

        public double getTempC() {
            return this.tempC;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String toString() {
            if (this.stringVal == null) {
                this.stringVal = String.valueOf(this.getTimestamp()) + "," + this.getTempC();
            }
            return this.stringVal;
        }
    }
}

