/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.google;

import java.awt.Color;
import org.opengts.util.ColorTools;
import org.opengts.util.StringTools;

public class GoogleChart {
    public static final String CHART_API_URL = "http://chart.apis.google.com/chart?";
    protected static final String[] Encoding = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "-", "."};
    protected String cht = "lc";
    protected String chs = "700x400";
    protected String chg = "";
    protected String chxt = "y,x";
    protected String chxl = "";
    protected String chts = "000000,15";
    protected String chtt = "Chart";
    protected String chco = "";
    protected String chm = "";
    protected String chdl = "";
    protected int dataSetCount = 0;
    protected String chd = "";

    public static String GetSimpleEncodedValue(int val) {
        if (val >= 0 && val <= 61) {
            return Encoding[val];
        }
        return "_";
    }

    public static String GetScaledSimpleEncodedValue(double val, double minVal, double maxVal) {
        int n = (int)Math.round((val - minVal) / (maxVal - minVal) * 61.0);
        return GoogleChart.GetSimpleEncodedValue(n);
    }

    public static StringBuffer GetScaledSimpleEncodedValue(StringBuffer sb, double[] val, double minVal, double maxVal) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        for (int i = 0; i < val.length; ++i) {
            sb.append(GoogleChart.GetScaledSimpleEncodedValue(val[i], minVal, maxVal));
        }
        return sb;
    }

    public static StringBuffer GetExtendedEncodedValue(StringBuffer sb, int val) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        if (val >= 0 && val <= 4095) {
            sb.append(Encoding[val / 64]).append(Encoding[val % 64]);
            return sb;
        }
        sb.append("__");
        return sb;
    }

    public static StringBuffer GetScaledExtendedEncodedValue(StringBuffer sb, double val, double minVal, double maxVal) {
        int n = (int)Math.round((val - minVal) / (maxVal - minVal) * 4095.0);
        return GoogleChart.GetExtendedEncodedValue(sb, n);
    }

    public static StringBuffer GetScaledExtendedEncodedValue(StringBuffer sb, double[] val, double minVal, double maxVal) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        for (int i = 0; i < val.length; ++i) {
            GoogleChart.GetScaledExtendedEncodedValue(sb, val[i], minVal, maxVal);
        }
        return sb;
    }

    public static String getCircleMarkerURL(int W, Color color) {
        int H = W;
        String C = ColorTools.toHexString(color, false);
        return "http://chart.apis.google.com/chart?cht=v&ext=.png&chs=" + W + "x" + H + "&chf=a,s,FFFFFFFF&chco=" + C + "FF&chd=t:50";
    }

    public static String getPushpinMarkerURL(int W, int H, Color color) {
        String C = ColorTools.toHexString(color, false);
        return "http://chart.apis.google.com/chart?cht=mm&ext=.png&chs=" + W + "x" + H + "&chco=" + C + "FF," + C + "FF,000000FF";
    }

    public void setType(String type) {
        this.cht = type;
    }

    public void setSize(int w, int h) {
        this.chs = w + "x" + h;
    }

    public void setTitle(Color color, int fontSize, String text) {
        if (color == null) {
            color = Color.black;
        }
        this.chts = ColorTools.toHexString(color, false) + "," + fontSize;
        this.chtt = text.replace(' ', '+');
    }

    public void appendTitle(String text) {
        if (this.chtt == null) {
            this.chtt = "";
        }
        this.chtt = this.chtt + text.replace(' ', '+');
    }

    public void addShapeMarker(String marker) {
        if (this.chm == null) {
            this.chm = "";
        }
        if (!StringTools.isBlank(this.chm)) {
            this.chm = this.chm + "|";
        }
        this.chm = this.chm + marker;
    }

    public void addDatasetColor(String hexColor) {
        if (this.chco == null) {
            this.chco = "";
        }
        if (!StringTools.isBlank(this.chco)) {
            this.chco = this.chco + ",";
        }
        this.chco = this.chco + hexColor;
    }

    public void addDatasetLegend(String legend) {
        if (this.chdl == null) {
            this.chdl = "";
        }
        if (!StringTools.isBlank(this.chdl)) {
            this.chdl = this.chdl + "|";
        }
        this.chdl = this.chdl + legend.replace(' ', '+');
    }

    public void setGrid(int xCount, int yCount) {
        this.chg = String.valueOf(xCount) + "," + String.valueOf(yCount) + ",5,5";
    }

    public void setAxisLabels(String type, String value) {
        this.chxt = type;
        this.chxl = value;
    }
}

