/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.util;

import java.io.File;
import java.io.IOException;
import org.opengts.util.ClientSocketThread;
import org.opengts.util.FileTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class RemoteLogClient {
    private static StringBuffer GlobalBuffer = new StringBuffer();
    private static int GlobalCapture = 0;

    private RemoteLogClient() {
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        int port = RTConfig.getInt("port", 0);
        String host = RTConfig.getString("host", "localhost");
        ClientSocketThread cst = new ClientSocketThread(host, port){

            @Override
            protected void handleMessage(String msg) {
                boolean capture;
                if (msg.startsWith("<LogOutput>\n")) {
                    GlobalCapture++;
                    msg = msg.substring("<LogOutput>\n".length());
                }
                boolean bl = capture = GlobalCapture > 0;
                if (msg.endsWith("</LogOutput>\n")) {
                    msg = msg.substring(0, msg.length() - "</LogOutput>\n".length());
                    GlobalCapture = 0;
                }
                if (msg.length() > 0) {
                    if (capture) {
                        GlobalBuffer.append(msg);
                        if (GlobalCapture <= 0) {
                            msg = msg + "\n";
                        }
                    }
                    Print.sysPrint(msg, new Object[0]);
                }
            }
        };
        cst.setReadTimeout(200L);
        cst.startThread();
        while (true) {
            try {
                String cmd;
                while (!(cmd = StringTools.trim(FileTools.readLineNL(System.in))).equalsIgnoreCase("exit")) {
                    int p;
                    if (StringTools.startsWithIgnoreCase(cmd, "get")) {
                        String sub;
                        p = cmd.indexOf(" ");
                        String string = sub = p > 0 ? cmd.substring(p + 1).trim() : null;
                        if (StringTools.isBlank(sub)) {
                            cst.socketWriteLine("get");
                            continue;
                        }
                        if (sub.equalsIgnoreCase("poll") || sub.equalsIgnoreCase("p")) {
                            cst.socketWriteLine("prompt off");
                            do {
                                cst.socketWriteLine("get");
                                if (System.in.available() > 0) break;
                                try {
                                    Thread.sleep(750L);
                                }
                                catch (Throwable th) {
                                    // empty catch block
                                }
                            } while (System.in.available() <= 0);
                            cst.socketWriteLine("prompt on");
                            continue;
                        }
                        if (sub.equalsIgnoreCase("cache") || sub.equalsIgnoreCase("c")) {
                            Print.sysPrintln(GlobalBuffer.toString(), new Object[0]);
                            cst.socketWriteLine("");
                            continue;
                        }
                        Print.sysPrintln("Unrecognized option: " + sub + "\n", new Object[0]);
                        cst.socketWriteLine("");
                        continue;
                    }
                    if (cmd.equalsIgnoreCase("clear")) {
                        GlobalBuffer.setLength(0);
                        cst.socketWriteLine("clear");
                        continue;
                    }
                    if (StringTools.startsWithIgnoreCase(cmd, "save")) {
                        String fileName;
                        if (GlobalBuffer.length() == 0) {
                            Print.sysPrintln("Client GlobalBuffer is empty\n", new Object[0]);
                            cst.socketWriteLine("");
                            continue;
                        }
                        p = cmd.indexOf(" ");
                        String string = fileName = p > 0 ? cmd.substring(p + 1).trim() : null;
                        if (StringTools.isBlank(fileName)) {
                            Print.sysPrintln("Save file not specified\n", new Object[0]);
                            cst.socketWriteLine("");
                            continue;
                        }
                        File outFile = new File(fileName);
                        if (outFile.exists()) {
                            Print.sysPrintln("File already exists: " + outFile + "\n", new Object[0]);
                            cst.socketWriteLine("");
                            continue;
                        }
                        try {
                            byte[] b = GlobalBuffer.toString().getBytes();
                            boolean ok = FileTools.writeFile(b, outFile);
                            if (ok) {
                                Print.sysPrintln("Output saved to file: " + outFile + "\n", new Object[0]);
                            } else {
                                Print.sysPrintln("Unable to save output to file: " + outFile + "\n", new Object[0]);
                            }
                            cst.socketWriteLine("");
                        }
                        catch (IOException ioe) {
                            Print.sysPrintln("Error writing file: " + ioe + "\n", new Object[0]);
                            cst.socketWriteLine("");
                        }
                        continue;
                    }
                    if (cmd.equalsIgnoreCase("help")) {
                        Print.sysPrintln("Help:\n  get        Gets/Resets the latest log contents from RemoteLogServer.\n  get poll   Continues \"get\" until Enter is pressed.\n  get cache  Displays the locally cached log contents.\n  clear      Clears/Resets the log contents (include local cache).\n  save FILE  Saves locally cached log contents to the specified file.\n  exit       Exit this RemoteLogClient\n  help       This help\n\n", new Object[0]);
                        cst.socketWriteLine("");
                        continue;
                    }
                    cst.socketWriteLine(cmd);
                }
            }
            catch (Throwable th) {
                Print.sysPrintln("ERROR: " + th, new Object[0]);
                System.exit(1);
                continue;
            }
            break;
        }
        Print.sysPrintln("Terminating ...", new Object[0]);
        System.exit(0);
    }
}

