/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.Permission;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.opengts.util.DateTime;
import org.opengts.util.ListTools;
import org.opengts.util.MethodAction;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTKey;
import org.opengts.util.StringTools;
import org.opengts.util.ThreadPool;
import org.opengts.util.XMLTools;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Cron {
    private static final String VERSION = "0.1.7";
    private static final String COPYRIGHT = "Copyright(C) 2007-2012 GeoTelematic Solutions, Inc.";
    private static final String CRONTAB_DIR = "crontab";
    private static final String CRONTAB_XML = "crontab.xml";
    private static final long DEFAULT_INTERVAL_SEC = DateTime.MinuteSeconds(1L);
    private static final boolean DEFAULT_AUTO_RELOAD = false;
    private static final boolean DEFAULT_STOP_ON_ERROR = true;
    private static final String TAG_Crontab = "Crontab";
    private static final String TAG_Job = "Job";
    private static final String TAG_Title = "Title";
    private static final String TAG_Class = "Class";
    private static final String TAG_Classpath = "Classpath";
    private static final String TAG_Method = "Method";
    private static final String TAG_Args = "Args";
    private static final String TAG_Arg = "Arg";
    private static final String TAG_When = "When";
    private static final String TAG_Include = "Include";
    private static final String ATTR_interval = "interval";
    private static final String ATTR_timeZone = "timeZone";
    private static final String ATTR_stopOnError = "stopOnError";
    private static final String ATTR_autoReload = "autoReload";
    private static final String ATTR_threadPoolSize = "threadPoolSize";
    private static final String ATTR_name = "name";
    private static final String ATTR_thread = "thread";
    private static final String ATTR_active = "active";
    private static final String ATTR_minute = "minute";
    private static final String ATTR_hour = "hour";
    private static final String ATTR_monthDay = "monthDay";
    private static final String ATTR_month = "month";
    private static final String ATTR_weekDay = "weekDay";
    private static final String ATTR_file = "file";
    private static final int TYPE_MINUTE = 1;
    private static final int TYPE_HOUR = 2;
    private static final int TYPE_MONTH_DAY = 3;
    private static final int TYPE_MONTH = 4;
    private static final int TYPE_WEEK_DAY = 5;
    private static final String PROCESS_INLINE_VAL = "inline";
    private static final String PROCESS_THREAD_VAL = "thread";
    private static final String PROCESS_NEW_VAL = "new";
    private static final int PROCESS_INLINE = 0;
    private static final int PROCESS_THREAD = 1;
    private static final int PROCESS_NEW = 2;
    private static final int DEFAULT_PROCESS = 1;
    private static final RTKey PROP_ThreadPool_CronTask_ = RTKey.valueOf("Cron.ThreadPool.");
    private static final int ThreadPool_CronTask_Size = 20;
    private static final int ThreadPool_CronTask_IdleSec = 0;
    private static final int ThreadPool_CronTask_QueSize = 0;
    private static ThreadPool ThreadPool_CronTask = new ThreadPool("CronTask", PROP_ThreadPool_CronTask_, 20, 0, 0);
    private long intervalSec = DEFAULT_INTERVAL_SEC;
    private boolean autoReload = false;
    private long lastCrontabsReadMS = 0L;
    private File crontabXMLFile = null;
    private OrderedSet<CronJob> cronJobs = null;
    private ThreadPool threadPool = null;
    private TimeZone timeZone = null;
    private static final String WHEN_ALL = "*";
    private static SecurityManager OldSecurityManager = null;
    private static boolean EnableSystemExit = false;
    private static int RecursionCheck = 0;
    private static final String[] ARG_CRONTAB = new String[]{"crontab", "cron", "xml"};

    public Cron() {
    }

    public Cron(File xmlFile) throws FileNotFoundException {
        this();
        if (xmlFile != null) {
            this.setCrontabXMLFile(xmlFile);
        }
    }

    private static File _getDefaultCrontabXMLFile() throws FileNotFoundException {
        File cfgFile = RTConfig.getLoadedConfigFile();
        if (cfgFile == null) {
            throw new FileNotFoundException("Default Crontab XML file directory not found");
        }
        File cronXml = new File(cfgFile.getParentFile(), CRONTAB_XML);
        try {
            return cronXml.getCanonicalFile();
        }
        catch (IOException ioe) {
            return cronXml;
        }
    }

    public void setCrontabXMLFile(File xmlFile) throws FileNotFoundException {
        this.lastCrontabsReadMS = 0L;
        if (xmlFile == null || xmlFile.toString().equals("")) {
            this.crontabXMLFile = Cron._getDefaultCrontabXMLFile();
            if (!this.crontabXMLFile.isFile()) {
                throw new FileNotFoundException("Default Crontab XML file does not exist: " + this.crontabXMLFile);
            }
        } else if (xmlFile.isFile()) {
            this.crontabXMLFile = xmlFile;
        } else {
            this.crontabXMLFile = null;
            throw new FileNotFoundException("Crontab XML file does not exist: " + xmlFile);
        }
    }

    public File getCrontabXMLFile() throws FileNotFoundException {
        if (this.crontabXMLFile == null) {
            throw new FileNotFoundException("Crontab XML file has not been specified");
        }
        return this.crontabXMLFile;
    }

    public void setCronIntervalSec(long intervSec) {
        this.intervalSec = intervSec > 0L ? intervSec : DEFAULT_INTERVAL_SEC;
    }

    public long getCronIntervalSec() {
        if (this.intervalSec <= 0L) {
            this.intervalSec = DEFAULT_INTERVAL_SEC;
        }
        return this.intervalSec;
    }

    public void setTimeZone(String tmzStr) {
        this.setTimeZone(DateTime.getTimeZone(tmzStr));
    }

    public void setTimeZone(TimeZone tmz) {
        this.timeZone = tmz;
    }

    public TimeZone getTimeZone() {
        if (this.timeZone == null) {
            this.timeZone = DateTime.getDefaultTimeZone();
        }
        return this.timeZone;
    }

    protected ThreadPool getThreadPool() {
        if (this.threadPool == null) {
            this.threadPool = new ThreadPool("Cron");
        }
        return this.threadPool;
    }

    protected List<CronJob> getJobList() {
        if (this.cronJobs == null) {
            this.cronJobs = new OrderedSet();
        }
        return this.cronJobs;
    }

    public void cleanJobList() {
        if (this.cronJobs != null) {
            this.cronJobs.clear();
        }
    }

    public int getJobCount() {
        return this.cronJobs != null ? this.cronJobs.size() : 0;
    }

    public boolean hasJobs() {
        return this.getJobCount() > 0;
    }

    public String[] getJobNames() {
        Vector<String> jobNameList = new Vector<String>();
        for (CronJob cj : this.getJobList()) {
            jobNameList.add(cj.getName());
        }
        return jobNameList.toArray(new String[jobNameList.size()]);
    }

    public String getJobDescription(String jobName) {
        if (jobName != null) {
            for (CronJob cj : this.getJobList()) {
                if (!jobName.equals(cj.getName())) continue;
                return cj.toString(false);
            }
        }
        return "";
    }

    public void runCron() throws IOException {
        while (true) {
            this._load(false);
            if (this.hasJobs()) {
                TimeZone tz = this.getTimeZone();
                ThreadPool tp = this.getThreadPool();
                for (CronJob cj : this.getJobList()) {
                    cj.testAndRun(tz, tp);
                }
            }
            long intervalSec = this.getCronIntervalSec();
            long thisTimeSec = DateTime.getCurrentTimeSec();
            long nextTimeSec = (thisTimeSec / intervalSec + 1L) * intervalSec;
            long sleepSec = nextTimeSec - thisTimeSec;
            try {
                Thread.sleep(sleepSec * 1000L + 10L);
                continue;
            }
            catch (Throwable th) {
                Print.logWarn("Sleep interrupted ...", new Object[0]);
                continue;
            }
            break;
        }
    }

    public boolean load(File xmlFile) throws IOException {
        this.setCrontabXMLFile(xmlFile);
        return this._load(true);
    }

    private boolean _load(boolean forceReload) throws IOException {
        String tmzStr;
        String intvKey;
        long threadPoolSize;
        File xmlFile = this.getCrontabXMLFile();
        if (this.lastCrontabsReadMS > 0L) {
            if (!forceReload && this.lastCrontabsReadMS == xmlFile.lastModified()) {
                return this.hasJobs();
            }
            if (!this.autoReload) {
                Print.logDebug("File changed, but 'autoReload' has been disabled", new Object[0]);
                this.lastCrontabsReadMS = xmlFile.lastModified();
                return this.hasJobs();
            }
            Print.logInfo("Reloading Crontab XML file: " + xmlFile, new Object[0]);
        } else {
            Print.logInfo("Loading Crontab XML file: " + xmlFile, new Object[0]);
        }
        this.cleanJobList();
        this.lastCrontabsReadMS = xmlFile.lastModified();
        Document xmlDoc = this.getDocument(xmlFile);
        if (xmlDoc == null) {
            throw new FileNotFoundException("Crontab XML file open/parse error: " + xmlFile);
        }
        Element crontabs = xmlDoc.getDocumentElement();
        if (!crontabs.getTagName().equalsIgnoreCase(TAG_Crontab)) {
            throw new IOException("Invalid root XML tag (expected 'Crontab'): " + xmlFile);
        }
        String rtPrefix_ = "Crontab.";
        String soeKey = rtPrefix_ + ATTR_stopOnError;
        boolean stopOnError = RTConfig.hasProperty(soeKey) ? RTConfig.getBoolean(soeKey, true) : this.getAttributeBoolean(crontabs, ATTR_stopOnError, true);
        String autoKey = rtPrefix_ + ATTR_autoReload;
        this.autoReload = RTConfig.hasProperty(autoKey) ? RTConfig.getBoolean(autoKey, false) : this.getAttributeBoolean(crontabs, ATTR_autoReload, false);
        String tpsKey = rtPrefix_ + ATTR_threadPoolSize;
        long l = threadPoolSize = RTConfig.hasProperty(tpsKey) ? RTConfig.getLong(tpsKey, -1L) : this.getAttributeLong(crontabs, ATTR_threadPoolSize, -1L);
        if (threadPoolSize > 0L) {
            this.getThreadPool().setMaxPoolSize((int)threadPoolSize);
        }
        long interval = RTConfig.hasProperty(intvKey = rtPrefix_ + ATTR_threadPoolSize) ? RTConfig.getLong(intvKey, -1L) : this.getAttributeLong(crontabs, ATTR_interval, -1L);
        this.setCronIntervalSec(interval);
        String tmzKey = rtPrefix_ + ATTR_timeZone;
        String string = tmzStr = RTConfig.hasProperty(tmzKey) ? RTConfig.getString(tmzKey, null) : this.getAttributeString(crontabs, ATTR_timeZone, null);
        if (!StringTools.isBlank(tmzStr)) {
            if (tmzStr.equalsIgnoreCase("system") || tmzStr.equalsIgnoreCase("local") || tmzStr.equalsIgnoreCase("default")) {
                TimeZone tmz = DateTime.getDefaultTimeZone();
                this.setTimeZone(tmz);
                Print.logInfo("TimeZone = " + tmz.getID(), new Object[0]);
            } else {
                if (!DateTime.isValidTimeZone(tmzStr)) {
                    throw new IOException("Invalid TimeZone specified: " + tmzStr);
                }
                this.setTimeZone(tmzStr);
                Print.logInfo("TimeZone = " + tmzStr, new Object[0]);
            }
        }
        NodeList jobNodeList = XMLTools.getChildElements(crontabs, TAG_Job);
        for (int j = 0; j < jobNodeList.getLength(); ++j) {
            String actvKey;
            boolean active;
            Element jobTag = (Element)jobNodeList.item(j);
            String jobName = this.getAttributeString(jobTag, ATTR_name, null);
            if (StringTools.isBlank(jobName)) {
                jobName = "Job_" + j;
                Print.logWarn("Job 'name' attribute missing/blank, assigning name '" + jobName + "'", new Object[0]);
            }
            boolean bl = active = RTConfig.hasProperty(actvKey = rtPrefix_ + jobName + "." + ATTR_active) ? RTConfig.getBoolean(actvKey, true) : this.getAttributeBoolean(jobTag, ATTR_active, true);
            if (!active) {
                Print.logDebug("Skipping inactive Job: " + jobName, new Object[0]);
                continue;
            }
            String threadKey = rtPrefix_ + jobName + "." + "thread";
            boolean threadMode = RTConfig.hasProperty(threadKey) ? RTConfig.getBoolean(threadKey, true) : this.getAttributeBoolean(jobTag, "thread", true);
            int procMode = threadMode ? 1 : 0;
            String title = "";
            String className = "";
            String[] classPath = null;
            String methName = "";
            Vector<String> argList = new Vector<String>();
            StringBuffer argSB = new StringBuffer();
            When when = null;
            NodeList attrList = jobTag.getChildNodes();
            for (int c = 0; c < attrList.getLength(); ++c) {
                Node attrNode = attrList.item(c);
                if (!(attrNode instanceof Element)) continue;
                String attrName = attrNode.getNodeName();
                Element attrElem = (Element)attrNode;
                if (attrName.equalsIgnoreCase(TAG_Title)) {
                    String t = this.getNodeText(attrElem);
                    if (t != null) {
                        String[] ttl = StringTools.parseStringArray(StringTools.replace(t.trim(), "\\n", "\n"), '\n');
                        for (int i = 0; i < ttl.length; ++i) {
                            ttl[i] = ttl[i].trim();
                        }
                        title = StringTools.join(ttl, '\n');
                        continue;
                    }
                    title = null;
                    continue;
                }
                if (attrName.equalsIgnoreCase(TAG_Class)) {
                    className = this.getNodeText(attrElem);
                    if (!className.equals("Cron")) continue;
                    className = StringTools.className(Cron.class);
                    continue;
                }
                if (attrName.equalsIgnoreCase(TAG_Classpath)) {
                    classPath = StringTools.parseArray(this.getNodeText(attrElem), ';');
                    continue;
                }
                if (attrName.equalsIgnoreCase(TAG_Method)) {
                    methName = this.getNodeText(attrElem);
                    continue;
                }
                if (attrName.equalsIgnoreCase(TAG_Arg)) {
                    String arg = RTConfig.insertKeyValues(this.getNodeText(attrElem).trim());
                    arg = StringTools.replace(arg, "\\${", "${");
                    arg = StringTools.replace(arg, "%{", "${");
                    argList.add(arg);
                    continue;
                }
                if (attrName.equalsIgnoreCase(TAG_Args)) {
                    String argStr = this.getNodeText(attrElem);
                    String[] args = ListTools.toArray(new StringTokenizer(argStr, " ", false), String.class);
                    for (int i = 0; i < args.length; ++i) {
                        String arg = RTConfig.insertKeyValues(args[i]);
                        argList.add(arg);
                    }
                    continue;
                }
                if (attrName.equalsIgnoreCase(TAG_When)) {
                    String cron = this.getNodeText(attrElem);
                    if (cron != null && !cron.equals("")) {
                        when = new When(cron);
                        continue;
                    }
                    String minute = this.getAttributeString(attrElem, ATTR_minute, WHEN_ALL);
                    String hour = this.getAttributeString(attrElem, ATTR_hour, WHEN_ALL);
                    String monthDay = this.getAttributeString(attrElem, ATTR_monthDay, WHEN_ALL);
                    String month = this.getAttributeString(attrElem, ATTR_month, WHEN_ALL);
                    String weekDay = this.getAttributeString(attrElem, ATTR_weekDay, WHEN_ALL);
                    when = new When(minute, hour, monthDay, month, weekDay);
                    continue;
                }
                if (stopOnError) {
                    throw new IOException("Unrecognized tag: " + attrName);
                }
                Print.logWarn("Unrecognized tag: " + attrName, new Object[0]);
            }
            String[] args = argList.toArray(new String[argList.size()]);
            try {
                CronJob cronJob = new CronJob(jobName, title, classPath, className, methName, args, when, procMode, "");
                Print.logInfo("Job: " + cronJob, new Object[0]);
                this.getJobList().add(cronJob);
                continue;
            }
            catch (ClassNotFoundException cnfe) {
                Print.logError("Class not found: " + className, new Object[0]);
                if (!stopOnError) continue;
                throw new IOException("Class not found: " + className, cnfe);
            }
            catch (NoSuchMethodException nsme) {
                Print.logError("Class Method not found: " + className + "." + methName, new Object[0]);
                if (!stopOnError) continue;
                throw new IOException("Class Method not found: " + className + "." + methName, nsme);
            }
            catch (Throwable th) {
                Print.logError("Error: " + th, new Object[0]);
                if (!stopOnError) continue;
                throw new IOException("Invalid Job specification", th);
            }
        }
        return this.hasJobs();
    }

    protected Document getDocument(File xmlFile) {
        if (xmlFile == null) {
            return null;
        }
        Document doc = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(xmlFile);
        }
        catch (ParserConfigurationException pce) {
            Print.logError("Parse error: " + pce, new Object[0]);
        }
        catch (SAXException se) {
            Print.logError("Parse error: " + se, new Object[0]);
        }
        catch (IOException ioe) {
            Print.logError("IO error: " + ioe, new Object[0]);
        }
        return doc;
    }

    protected String getNodeText(Node root) {
        StringBuffer sb = new StringBuffer();
        if (root != null) {
            NodeList list = root.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                if (n.getNodeType() == 4) {
                    sb.append(n.getNodeValue());
                    continue;
                }
                if (n.getNodeType() != 3) continue;
                sb.append(n.getNodeValue());
            }
        }
        return sb.toString();
    }

    protected String getAttributeString(Element elem, String key, String dft) {
        if (elem == null || key == null) {
            return dft;
        }
        if (elem.hasAttribute(key)) {
            return elem.getAttribute(key);
        }
        NamedNodeMap nnm = elem.getAttributes();
        if (nnm != null) {
            int len = nnm.getLength();
            for (int i = 0; i < len; ++i) {
                Attr attr = (Attr)nnm.item(i);
                String attrName = attr.getName();
                if (!key.equalsIgnoreCase(attrName)) continue;
                Print.logWarn("Expected attribute '" + key + "', but found '" + attrName + "'", new Object[0]);
                return attr.getValue();
            }
        }
        return dft;
    }

    protected boolean getAttributeBoolean(Element elem, String key, boolean dft) {
        return StringTools.parseBoolean(this.getAttributeString(elem, key, null), dft);
    }

    protected long getAttributeLong(Element elem, String key, long dft) {
        return StringTools.parseLong(this.getAttributeString(elem, key, null), dft);
    }

    private static boolean _printOutput(InputStream in, StringBuffer sb) throws IOException {
        int avail;
        boolean didRead = false;
        while ((avail = in.available()) > 0) {
            didRead = true;
            while (avail > 0) {
                int b = in.read();
                if (b >= 0) {
                    if (b == 10) {
                        Print.sysPrintln(sb.toString(), new Object[0]);
                        sb.setLength(0);
                    } else {
                        sb.append((char)b);
                    }
                } else {
                    return didRead;
                }
                --avail;
            }
        }
        return didRead;
    }

    public static void exec(String[] cmdArgs) {
        block16: {
            if (cmdArgs != null && cmdArgs.length > 0) {
                Process process = null;
                try {
                    if (cmdArgs.length > 1) {
                        process = Runtime.getRuntime().exec(cmdArgs);
                    } else {
                        String cmd = StringTools.join(cmdArgs, ' ');
                        process = Runtime.getRuntime().exec(cmd);
                    }
                    BufferedInputStream stdout = new BufferedInputStream(process.getInputStream());
                    StringBuffer stdoutSB = new StringBuffer();
                    BufferedInputStream stderr = new BufferedInputStream(process.getErrorStream());
                    StringBuffer stderrSB = new StringBuffer();
                    while (true) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Throwable th) {
                            // empty catch block
                        }
                        boolean didReadOut = Cron._printOutput(stdout, stdoutSB);
                        boolean didReadErr = Cron._printOutput(stderr, stderrSB);
                        if (didReadOut || didReadErr) continue;
                        try {
                            process.exitValue();
                        }
                        catch (Throwable th) {
                            continue;
                        }
                        break;
                    }
                    if (stdoutSB.length() > 0) {
                        Print.sysPrintln(stdoutSB.toString(), new Object[0]);
                    }
                    if (stderrSB.length() > 0) {
                        Print.sysPrintln(stderrSB.toString(), new Object[0]);
                    }
                    while (true) {
                        try {
                            process.waitFor();
                            int status = process.exitValue();
                            if (status != 0) {
                                Print.logError("Job process terminated with status " + status, new Object[0]);
                            }
                            return;
                        }
                        catch (InterruptedException ie) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable th) {
                    Print.logException("Job process failed", th);
                    if (process == null) break block16;
                    process.destroy();
                }
            }
        }
    }

    public static boolean TestRange(String range, int value, int type) {
        if (range == null || range.equals("") || range.equals(WHEN_ALL)) {
            return true;
        }
        String[] va = StringTools.parseArray(range, ',');
        for (int i = 0; i < va.length; ++i) {
            int vv;
            String rv;
            int div;
            int dsp = va[i].indexOf(47);
            String dss = dsp >= 0 ? va[i].substring(dsp + 1) : WHEN_ALL;
            int n = div = dss.equals(WHEN_ALL) ? 1 : StringTools.parseInt(dss, 1);
            if (div < 1) {
                div = 1;
            }
            if (value % div != 0) continue;
            String string = rv = dsp >= 0 ? va[i].substring(0, dsp).trim() : va[i];
            if (rv.equals(WHEN_ALL)) {
                return true;
            }
            int rp = rv.indexOf(45);
            if (rp >= 0) {
                int hi;
                int lo;
                String loStr = rv.substring(0, rp);
                String hiStr = rv.substring(rp + 1);
                if (type == 5) {
                    lo = DateTime.getDayIndex(loStr, -1);
                    hi = DateTime.getDayIndex(hiStr, -1);
                } else if (type == 4) {
                    lo = DateTime.getMonthIndex1(loStr, -1);
                    hi = DateTime.getMonthIndex1(hiStr, -1);
                } else {
                    lo = StringTools.parseInt(loStr, 0);
                    hi = StringTools.parseInt(hiStr, 999);
                }
                if (value < lo || value > hi) continue;
                return true;
            }
            int n2 = vv = type == 5 ? DateTime.getDayIndex(rv, -1) : StringTools.parseInt(rv, -1);
            if (value != vv) continue;
            return true;
        }
        return false;
    }

    private static Class getClass(String[] classPath, String className) throws ClassNotFoundException {
        if (classPath == null || classPath.length <= 0) {
            Print.logDebug("Getting class from default ClassLoader: " + className, new Object[0]);
            return Class.forName(className);
        }
        Print.logDebug("Getting class from custom ClassLoader: " + className, new Object[0]);
        Vector<File> cpList = new Vector<File>();
        for (int i = 0; i < classPath.length; ++i) {
            File file = new File(classPath[i]);
            if (file.exists()) {
                cpList.add(file);
                continue;
            }
            Print.logWarn("ClassPath item not found: " + file, new Object[0]);
        }
        File[] filePath = cpList.toArray(new File[cpList.size()]);
        CronClassLoader ccl = new CronClassLoader(filePath);
        return ccl.loadClassAndResolve(className);
    }

    public static void main(String[] argv) {
        if (!RTConfig.isInitialized()) {
            RTConfig.setCommandLineArgs(argv);
        }
        RTConfig.setDebugMode(true);
        Print.setLogLevel(6);
        Print.setLogHeaderLevel(6);
        FileNotFoundException crontabErr = null;
        File crontab = RTConfig.getFile(ARG_CRONTAB, null);
        if (crontab == null || crontab.toString().equals("")) {
            try {
                crontab = Cron._getDefaultCrontabXMLFile();
            }
            catch (FileNotFoundException fnfe) {
                crontabErr = fnfe;
            }
        }
        if (crontabErr == null && !crontab.isFile()) {
            crontabErr = new FileNotFoundException("Crontab file does not exist: " + crontab);
        }
        Print.logInfo("----------------------------------------------------------------", new Object[0]);
        Print.logInfo("Cron Server, Version 0.1.7", new Object[0]);
        Print.logInfo(COPYRIGHT, new Object[0]);
        Print.logInfo("Crontab: " + (crontab != null ? crontab : "<unknown>"), new Object[0]);
        Print.logInfo("----------------------------------------------------------------", new Object[0]);
        if (crontabErr != null) {
            Print.logException("Crontab file not found", crontabErr);
            Print.logInfo("Use \"-cron <file>\" option to override default", new Object[0]);
            System.exit(1);
        }
        if (RecursionCheck > 0) {
            Print.logStackTrace("Recursion not allowed in Cron scheduler!");
            System.exit(2);
        }
        OldSecurityManager = System.getSecurityManager();
        System.setSecurityManager(new SystemExitSecurityManager());
        ++RecursionCheck;
        try {
            Cron cron = new Cron(crontab);
            cron.runCron();
        }
        catch (Throwable th) {
            Print.logException("Cron Error", th);
        }
        --RecursionCheck;
        EnableSystemExit = true;
        System.exit(1);
    }

    private static class SystemExitSecurityManager
    extends SecurityManager {
        private SystemExitSecurityManager() {
        }

        @Override
        public void checkExit(int status) {
            if (!EnableSystemExit) {
                throw new RuntimeException("Job invoked 'System.exit'");
            }
        }

        @Override
        public void checkPermission(Permission perm) {
            if (OldSecurityManager != null) {
                OldSecurityManager.checkPermission(perm);
            }
        }
    }

    public class CronJob
    implements Runnable {
        private String name = "";
        private String title = "";
        private long lastStartSec = 0L;
        private long lastStopSec = 0L;
        private String[] classPath = null;
        private String className = null;
        private String methName = null;
        private String[] args = null;
        private When when = null;
        private MethodAction method = null;
        private int processMode = 1;
        private String processName = null;

        public CronJob(String name, String title, String[] classPath, String className, String methName, String[] args, When when, int processMode, String processName) throws NoSuchMethodException, ClassNotFoundException {
            this.name = name != null ? name : "cron";
            this.title = title;
            this.classPath = classPath;
            this.className = className;
            this.methName = methName;
            this.args = args != null ? args : new String[]{};
            this.when = when;
            Class clazz = Cron.getClass(this.classPath, this.className);
            this.method = new MethodAction((Object)clazz, this.methName, String[].class);
            this.processMode = processMode;
            this.processName = processName;
        }

        public String getName() {
            return this.name;
        }

        public String[] getClassPath() {
            return this.classPath;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methName;
        }

        public String[] getArgs() {
            return this.args;
        }

        public int getProcessMode() {
            return this.processMode;
        }

        public String getProcessName() {
            return this.processName;
        }

        public boolean runInThread() {
            int p = this.getProcessMode();
            if (p == 0) {
                return false;
            }
            if (p == 2) {
                return true;
            }
            return true;
        }

        public boolean runInProcess() {
            return false;
        }

        public boolean testAndRun(TimeZone tz, ThreadPool threadPool) {
            long intervalSec;
            long nowSec = DateTime.getCurrentTimeSec();
            long lastStart = this.getLastStartSec();
            if (lastStart / (intervalSec = Cron.this.getCronIntervalSec()) == nowSec / intervalSec) {
                Print.logWarn("Time schedule already Tested: " + this, new Object[0]);
                return false;
            }
            if (this.when == null && lastStart > 0L) {
                return false;
            }
            if (this.when == null || this.when.testNow(nowSec, tz)) {
                if (lastStart > 0L && lastStart > this.getLastStopSec()) {
                    Print.logError("Previous Job has not completed!: " + this, new Object[0]);
                } else {
                    switch (this.getProcessMode()) {
                        case 1: 
                        case 2: {
                            if (threadPool != null) {
                                threadPool.run(this);
                            } else {
                                this.run();
                            }
                            return true;
                        }
                    }
                    this.run();
                    return true;
                }
            }
            return false;
        }

        @Override
        public void run() {
            Print.logInfo("==============================================================================", new Object[0]);
            Print.logInfo("CronTime : " + new DateTime(), new Object[0]);
            Print.logInfo("CronBegin: " + this, new Object[0]);
            this.lastStartSec = DateTime.getCurrentTimeSec();
            try {
                if (!StringTools.isBlank(this.title)) {
                    Print.logInfo("CronTitle: " + this.title, new Object[0]);
                }
                this.method.invoke(new Object[]{this.args});
            }
            catch (Throwable th) {
                Print.logException(this.toString(), th);
            }
            this.lastStopSec = DateTime.getCurrentTimeSec();
            Print.logInfo("CronEnd  : " + this, new Object[0]);
        }

        public long getLastStartSec() {
            return this.lastStartSec;
        }

        public long getLastStopSec() {
            return this.lastStopSec;
        }

        public String toString() {
            return this.toString(true);
        }

        public String toString(boolean longVers) {
            StringBuffer sb = new StringBuffer();
            if (longVers) {
                sb.append("[").append(this.getName()).append("] ");
            }
            sb.append(this.className).append(".").append(this.methName);
            sb.append(":");
            for (int i = 0; i < this.args.length; ++i) {
                if (this.args[i].equalsIgnoreCase("-debugMode")) continue;
                sb.append(" ").append(this.args[i]);
            }
            if (this.when != null) {
                sb.append(" [").append(this.when.toString()).append("]");
            } else {
                sb.append(" [<RunOnce>]");
            }
            if (longVers) {
                switch (this.getProcessMode()) {
                    case 0: {
                        sb.append(" {inline}");
                        break;
                    }
                    case 2: {
                        sb.append(" {process}");
                        break;
                    }
                    case 1: {
                        sb.append(" {thread}");
                        break;
                    }
                    default: {
                        sb.append(" {unknown}");
                    }
                }
            }
            return sb.toString();
        }
    }

    private static class CronClassLoader
    extends URLClassLoader {
        public CronClassLoader(File[] cpFile) {
            super(new URL[0]);
            for (int i = 0; i < cpFile.length; ++i) {
                try {
                    URL url = new URL("file:///" + cpFile[i].getAbsolutePath() + "/");
                    this.addURL(url);
                    continue;
                }
                catch (MalformedURLException mue) {
                    Print.logError("Invalid file specification: " + cpFile[i], new Object[0]);
                }
            }
        }

        public Class loadClassAndResolve(String className) throws ClassNotFoundException {
            return this.loadClass(className, true);
        }
    }

    public static class When {
        private String minute = null;
        private String hour = null;
        private String monthDay = null;
        private String month = null;
        private String weekDay = null;

        public When(String minute, String hour, String monthDay, String month, String weekDay) {
            this._setWhen(minute, hour, monthDay, month, weekDay);
        }

        public When(String wh) {
            String[] c = ListTools.toArray(new StringTokenizer(wh, " ", false), String.class);
            String minute = c.length > 0 ? c[0] : null;
            String hour = c.length > 1 ? c[1] : null;
            String monthDay = c.length > 2 ? c[2] : null;
            String month = c.length > 3 ? c[3] : null;
            String weekDay = c.length > 4 ? c[4] : null;
            this._setWhen(minute, hour, monthDay, month, weekDay);
        }

        private void _setWhen(String minute, String hour, String monthDay, String month, String weekDay) {
            this.minute = minute != null && !minute.trim().equals("") ? minute.trim() : Cron.WHEN_ALL;
            this.hour = hour != null && !hour.trim().equals("") ? hour.trim() : Cron.WHEN_ALL;
            this.monthDay = monthDay != null && !monthDay.trim().equals("") ? monthDay.trim() : Cron.WHEN_ALL;
            this.month = month != null && !month.trim().equals("") ? month.trim() : Cron.WHEN_ALL;
            this.weekDay = weekDay != null && !weekDay.trim().equals("") ? weekDay.trim() : Cron.WHEN_ALL;
        }

        public String getMinute() {
            return this.minute;
        }

        public String getHour() {
            return this.hour;
        }

        public String getMonthDay() {
            return this.monthDay;
        }

        public String getMonth() {
            return this.month;
        }

        public String getWeekDay() {
            return this.weekDay;
        }

        public boolean testNow(long timeSec, TimeZone tz) {
            DateTime dt = new DateTime(timeSec, tz);
            if (!Cron.TestRange(this.getMonth(), dt.getMonth1(), 4)) {
                return false;
            }
            if (!Cron.TestRange(this.getMonthDay(), dt.getDayOfMonth(), 3)) {
                return false;
            }
            if (!Cron.TestRange(this.getWeekDay(), dt.getDayOfWeek(), 5)) {
                return false;
            }
            if (!Cron.TestRange(this.getHour(), dt.getHour24(), 2)) {
                return false;
            }
            return Cron.TestRange(this.getMinute(), dt.getMinute(), 1);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getMinute());
            sb.append(" ");
            sb.append(this.getHour());
            sb.append(" ");
            sb.append(this.getMonthDay());
            sb.append(" ");
            sb.append(this.getMonth());
            sb.append(" ");
            sb.append(this.getWeekDay());
            return sb.toString();
        }
    }
}

