/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.shapefile;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.opengts.extra.shapefile.DBFParser;
import org.opengts.extra.shapefile.Field;
import org.opengts.extra.shapefile.SHPParser;
import org.opengts.extra.shapefile.Shape;
import org.opengts.util.DateTime;
import org.opengts.util.FileTools;
import org.opengts.util.GeoPoint;
import org.opengts.util.GeoPolygon;
import org.opengts.util.Payload;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class ShapefileSet {
    public static final String MIME_TYPE_ZIP = "application/x-zip-compressed";
    private String filePrefix = null;
    private DBFParser dbf = null;
    private SHPParser shp = null;
    public static final String[] ARG_FILE = new String[]{"file"};
    public static final String[] ARG_ENTRY_NAME = new String[]{"name"};
    public static final String[] ARG_SAVEAS = new String[]{"saveAs", "save"};

    public ShapefileSet() {
        this.dbf = new DBFParser();
        this.shp = new SHPParser();
    }

    public ShapefileSet(String filePfx) throws IOException {
        this.filePrefix = filePfx;
        this.dbf = new DBFParser(new File(this.filePrefix + ".dbf"));
        this.shp = new SHPParser(new File(this.filePrefix + ".shp"));
    }

    public void addField(Field fld) {
        this.dbf.addField(fld);
    }

    public void addStringField(String name, int len) {
        this.addField(new Field(name, len));
    }

    public void addPoint(GeoPoint gp, String ... fieldValues) {
        this.dbf.addRecord(fieldValues);
        this.shp.addShape(new Shape(this.shp.getShapeCount() + 1, gp));
    }

    public void addPolygon(GeoPolygon gp, String ... fieldValues) {
        this.dbf.addRecord(fieldValues);
        this.shp.addShape(new Shape(this.shp.getShapeCount() + 1, gp));
    }

    public int getShapeCount() {
        return this.shp.getShapeCount();
    }

    public boolean isEmpty() {
        return this.shp.isEmpty();
    }

    public void writeToZipOutput(ZipOutput zo, String entryDirName, String entryFileName) throws IOException {
        if (zo == null) {
            throw new IOException("No ZipOutput specified");
        }
        if (StringTools.isBlank(entryFileName)) {
            entryFileName = "shapefile_" + DateTime.getCurrentTimeSec();
        }
        String entryName = StringTools.isBlank(entryDirName) ? entryFileName : entryDirName + "/" + entryFileName;
        Payload dbfPayload = new Payload(this.dbf.getFileLength() + 100);
        this.dbf.write(dbfPayload);
        byte[] dbfBytes = dbfPayload.getBytes();
        Payload shpPayload = new Payload(this.shp.getFileLength(false) + 100);
        Payload shxPayload = new Payload(this.shp.getFileLength(true) + 100);
        this.shp.writeFile(shpPayload, shxPayload);
        byte[] shpBytes = shpPayload.getBytes();
        byte[] shxBytes = shxPayload.getBytes();
        String dbfName = entryName + ".dbf";
        Print.logInfo("Creating DBF entry: " + dbfName + " [size=" + dbfBytes.length + "]", new Object[0]);
        zo.writeZipEntry(dbfName, dbfBytes);
        String shpName = entryName + ".shp";
        Print.logInfo("Creating SHP entry: " + shpName + " [size=" + shpBytes.length + "]", new Object[0]);
        zo.writeZipEntry(shpName, shpBytes);
        String shxName = entryName + ".shx";
        Print.logInfo("Creating SHX entry: " + shxName + " [size=" + shxBytes.length + "]", new Object[0]);
        zo.writeZipEntry(shxName, shxBytes);
    }

    public byte[] createZipByteArray(String entryDirName, String entryFileName) {
        try {
            ZipOutput zo = new ZipOutput();
            this.writeToZipOutput(zo, entryDirName, entryFileName);
            return zo.toByteArray();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public boolean saveAs(File zipFile) {
        String entryName;
        if (zipFile == null) {
            Print.logError("Zip file specification is null", new Object[0]);
            return false;
        }
        if (zipFile.exists()) {
            Print.logError("File already exists: " + zipFile, new Object[0]);
            return false;
        }
        String fileName = zipFile.getName();
        int p = fileName.lastIndexOf(".");
        String string = entryName = p > 0 ? fileName.substring(0, p) : this.filePrefix;
        if (StringTools.isBlank(entryName)) {
            entryName = "shapefile";
        }
        try {
            byte[] zip = this.createZipByteArray(null, entryName);
            boolean ok = FileTools.writeFile(zip, zipFile);
            if (ok) {
                Print.logInfo("Shapefile created: " + zipFile, new Object[0]);
            } else {
                Print.logError("Unable to create shapefile: " + zipFile, new Object[0]);
            }
            return ok;
        }
        catch (IOException ioe) {
            Print.logException("Error creating shapefile", ioe);
            return false;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("-----------------------------------------------\n");
        if (this.dbf != null) {
            sb.append(this.dbf.toString());
        }
        if (this.shp != null) {
            sb.append(this.shp.toString());
        }
        sb.append("-----------------------------------------------\n");
        return sb.toString();
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        String filePfx = RTConfig.getString(ARG_FILE, null);
        if (filePfx == null) {
            Print.sysPrintln("ERROR: missing 'file' specification", new Object[0]);
            System.exit(99);
        }
        ShapefileSet sfs = null;
        try {
            sfs = new ShapefileSet(filePfx);
        }
        catch (IOException ioe) {
            Print.logException("Loading ShapefileSet zip file", ioe);
            System.exit(99);
        }
        Print.sysPrintln(sfs.toString(), new Object[0]);
        String saveAsFile = RTConfig.getString(ARG_SAVEAS, null);
        if (!StringTools.isBlank(saveAsFile)) {
            String entryName = RTConfig.getString(ARG_ENTRY_NAME, "test");
            try {
                byte[] zipBytes = sfs.createZipByteArray(null, entryName);
                File zipFile = new File("/tmp/" + entryName + ".zip");
                Print.sysPrintln("Saving Zip file: " + zipFile, new Object[0]);
                FileTools.writeFile(zipBytes, zipFile);
            }
            catch (IOException ioe) {
                Print.logException("Creating ShapefileSet zip file", ioe);
                System.exit(1);
            }
            System.exit(0);
        }
    }

    public static class ZipOutput {
        private ByteArrayOutputStream baos = new ByteArrayOutputStream();
        private ZipOutputStream zos = new ZipOutputStream(this.baos);

        public void writeZipEntry(String name, byte[] data) {
            if (this.zos != null) {
                try {
                    ZipEntry ze = new ZipEntry(name);
                    this.zos.putNextEntry(ze);
                    this.zos.write(data, 0, data.length);
                    this.zos.closeEntry();
                }
                catch (IOException ioe) {
                    Print.logException("Unexpected ZipOutput exception", ioe);
                }
            } else {
                Print.logError("ZipOutputStream is closed", new Object[0]);
            }
        }

        public void close() {
            if (this.zos != null) {
                try {
                    this.zos.close();
                }
                catch (IOException ioe) {
                    Print.logException("Unexpected ZipOutput exception", ioe);
                }
                this.zos = null;
            }
        }

        public byte[] toByteArray() {
            this.close();
            return this.baos.toByteArray();
        }

        public boolean saveAs(File zipFile) throws IOException {
            if (zipFile == null) {
                throw new IOException("'saveAs' file is null");
            }
            if (zipFile.exists()) {
                throw new IOException("'saveAs' file already exists: " + zipFile);
            }
            if (!zipFile.toString().toLowerCase().endsWith(".zip")) {
                throw new IOException("'saveAs' file does not end with '.zip': " + zipFile);
            }
            byte[] zip = this.toByteArray();
            return FileTools.writeFile(zip, zipFile);
        }
    }
}

