/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.shapefile;

import java.util.Vector;
import org.opengts.extra.shapefile.BoundingBox;
import org.opengts.extra.shapefile.Point;
import org.opengts.extra.shapefile.Range;
import org.opengts.util.GeoPoint;
import org.opengts.util.GeoPointProvider;
import org.opengts.util.GeoPolygon;
import org.opengts.util.ListTools;
import org.opengts.util.Payload;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class Shape {
    public static final int MAX_SHAPE_SIZE = 60000;
    public static final int SHAPETYPE_UNDEFINED = -1;
    public static final int SHAPETYPE_NULL = 0;
    public static final int SHAPETYPE_POINT = 1;
    public static final int SHAPETYPE_POLYLINE = 3;
    public static final int SHAPETYPE_POLYGON = 5;
    public static final int SHAPETYPE_MULTIPOINT = 8;
    public static final int SHAPETYPE_POINT_Z = 11;
    public static final int SHAPETYPE_POLYLINE_Z = 13;
    public static final int SHAPETYPE_POLYGON_Z = 15;
    public static final int SHAPETYPE_MULTIPOINT_Z = 18;
    public static final int SHAPETYPE_POINT_M = 21;
    public static final int SHAPETYPE_POLYLINE_M = 23;
    public static final int SHAPETYPE_POLYGON_M = 25;
    public static final int SHAPETYPE_MULTIPOINT_M = 28;
    public static final int SHAPETYPE_MULTIPATCH = 31;
    public static final int PARTTYPE_TRIANGLE_STRIP = 0;
    public static final int PARTTYPE_TRIANGLE_FAN = 1;
    public static final int PARTTYPE_OUTER_RING = 2;
    public static final int PARTTYPE_INNER_RING = 3;
    public static final int PARTTYPE_FIRST_RING = 4;
    public static final int PARTTYPE_RING = 5;
    private int rcdIndex = 0;
    private int shapeType = 0;
    private BoundingBox shapeBB = null;
    private Point[] shapePoints = null;
    private int[] shapeParts = null;
    private int[] shapePartTypes = null;
    private Range shapeZRange = null;
    private Range shapeMRange = null;
    private GeoPolygon[] shapePolygon = null;

    public static String GetShapeTypeDescription(int shapeType) {
        switch (shapeType) {
            case 0: {
                return "Null";
            }
            case 1: {
                return "Point";
            }
            case 3: {
                return "Polyline";
            }
            case 5: {
                return "Polygon";
            }
            case 8: {
                return "MultiPoint";
            }
            case 11: {
                return "Point-Z";
            }
            case 13: {
                return "Polyline-Z";
            }
            case 15: {
                return "Polygon-Z";
            }
            case 18: {
                return "MultiPoint-Z";
            }
            case 21: {
                return "Point-M";
            }
            case 23: {
                return "Polyline-M";
            }
            case 25: {
                return "Polygon-M";
            }
            case 28: {
                return "MultiPoint-M";
            }
            case 31: {
                return "MultiPatch";
            }
        }
        return "?UNKNOWN?";
    }

    private static GeoPolygon[] CreateGeoPolygon(Point[] shapePoints, int[] shapeParts) {
        int[] nArray;
        if (shapePoints == null) {
            return null;
        }
        if (!ListTools.isEmpty(shapeParts)) {
            nArray = shapeParts;
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        }
        int[] parts = nArray;
        if (parts[0] != 0) {
            Print.logWarn("Polygon Parts does not begin at '0': " + StringTools.join(parts, ","), new Object[0]);
            return null;
        }
        for (int i = 1; i < parts.length; ++i) {
            if (parts[i] <= parts[i - 1]) {
                Print.logError("Invalid 'Parts': " + StringTools.join(parts, ","), new Object[0]);
                return null;
            }
            if (parts[i] < shapePoints.length) continue;
            Print.logError("'Parts' beyond end of Points: " + StringTools.join(parts, ","), new Object[0]);
            return null;
        }
        Vector<GeoPolygon> polyOuter = new Vector<GeoPolygon>();
        Vector<GeoPolygon> polyInner = new Vector<GeoPolygon>();
        for (int p = 0; p < parts.length; ++p) {
            int ps = parts[p];
            int pe = p + 1 < parts.length ? parts[p + 1] : shapePoints.length;
            GeoPointProvider[] ringPoints = new Point[pe - ps];
            System.arraycopy(shapePoints, ps, ringPoints, 0, ringPoints.length);
            GeoPolygon poly = new GeoPolygon(ringPoints);
            if (poly.isClockwise()) {
                polyOuter.add(poly);
                continue;
            }
            polyInner.add(poly);
        }
        if (polyOuter.size() == 0) {
            if (polyInner.size() != 0) {
                Print.logError("Found 'inner' polygons, but no 'outer' polygons!", new Object[0]);
            }
        } else if (polyInner.size() != 0) {
            if (polyOuter.size() == 1) {
                ((GeoPolygon)polyOuter.get(0)).addNegativeRings(polyInner);
            } else {
                for (GeoPolygon inner : polyInner) {
                    GeoPoint gp = inner.getGeoPoint(0);
                    for (GeoPolygon outer : polyOuter) {
                        if (!outer.containsPoint(gp)) continue;
                        outer.addNegativeRing(inner);
                        gp = null;
                        break;
                    }
                    if (gp == null) continue;
                    Print.logError("No outer polygon found for inner polygon", new Object[0]);
                }
            }
        }
        return polyOuter.toArray(new GeoPolygon[polyOuter.size()]);
    }

    private Shape() {
    }

    public Shape(Shape s) {
        this();
        this.rcdIndex = s.rcdIndex;
        this.shapeType = s.shapeType;
        this.shapeBB = s.shapeBB;
        this.shapePoints = s.shapePoints;
        this.shapeParts = s.shapeParts;
        this.shapePartTypes = s.shapePartTypes;
        this.shapeMRange = s.shapeMRange;
        this.shapeZRange = s.shapeZRange;
        this.shapePolygon = s.shapePolygon;
    }

    public Shape(Payload p) {
        this();
        this.rcdIndex = (int)p.readLong(4, 0L);
        long len = p.readLong(4, 0L);
        byte[] cb = p.readBytes((int)len * 2);
        Payload c = new Payload(cb);
        this.shapeType = (int)c.readLong(4, 0L, false);
        this.shapeBB = null;
        this.shapePoints = null;
        this.shapeParts = null;
        this.shapePartTypes = null;
        this.shapeMRange = null;
        this.shapeZRange = null;
        this.shapePolygon = null;
        switch (this.shapeType) {
            case 0: {
                break;
            }
            case 1: {
                this.shapePoints = new Point[]{new Point(c)};
                break;
            }
            case 3: {
                int i;
                this.shapeBB = new BoundingBox(c);
                int numParts = (int)c.readLong(4, 0L, false);
                int numPoints = (int)c.readLong(4, 0L, false);
                this.shapeParts = new int[numParts];
                for (i = 0; i < numParts; ++i) {
                    this.shapeParts[i] = (int)c.readLong(4, 0L, false);
                }
                this.shapePoints = new Point[numPoints];
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i] = new Point(c);
                }
                break;
            }
            case 5: {
                int i;
                this.shapeBB = new BoundingBox(c);
                int numParts = (int)c.readLong(4, 0L, false);
                int numPoints = (int)c.readLong(4, 0L, false);
                this.shapeParts = new int[numParts];
                for (i = 0; i < numParts; ++i) {
                    this.shapeParts[i] = (int)c.readLong(4, 0L, false);
                }
                this.shapePoints = new Point[numPoints];
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i] = new Point(c);
                }
                break;
            }
            case 8: {
                this.shapeBB = new BoundingBox(c);
                int numPoints = (int)c.readLong(4, 0L, false);
                this.shapePoints = new Point[numPoints];
                for (int i = 0; i < numPoints; ++i) {
                    this.shapePoints[i] = new Point(c);
                }
                break;
            }
            case 11: {
                this.shapePoints = new Point[]{new Point(c)};
                this.shapePoints[0].setM(c.readDouble(8, 0.0, false));
                this.shapePoints[0].setZ(c.readDouble(8, 0.0, false));
                break;
            }
            case 13: {
                int i;
                this.shapeBB = new BoundingBox(c);
                int numParts = (int)c.readLong(4, 0L, false);
                int numPoints = (int)c.readLong(4, 0L, false);
                this.shapeParts = new int[numParts];
                for (i = 0; i < numParts; ++i) {
                    this.shapeParts[i] = (int)c.readLong(4, 0L, false);
                }
                this.shapePoints = new Point[numPoints];
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i] = new Point(c);
                }
                this.shapeZRange = new Range(c);
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].setZ(c.readDouble(8, 0.0, false));
                }
                this.shapeMRange = new Range(c);
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].setM(c.readDouble(8, 0.0, false));
                }
                break;
            }
            case 15: {
                int i;
                this.shapeBB = new BoundingBox(c);
                int numParts = (int)c.readLong(4, 0L, false);
                int numPoints = (int)c.readLong(4, 0L, false);
                this.shapeParts = new int[numParts];
                for (i = 0; i < numParts; ++i) {
                    this.shapeParts[i] = (int)c.readLong(4, 0L, false);
                }
                this.shapePoints = new Point[numPoints];
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i] = new Point(c);
                }
                this.shapeZRange = new Range(c);
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].setZ(c.readDouble(8, 0.0, false));
                }
                this.shapeMRange = new Range(c);
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].setM(c.readDouble(8, 0.0, false));
                }
                break;
            }
            case 18: {
                int i;
                this.shapeBB = new BoundingBox(c);
                int numPoints = (int)c.readLong(4, 0L, false);
                this.shapePoints = new Point[numPoints];
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i] = new Point(c);
                }
                this.shapeZRange = new Range(c);
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].setZ(c.readDouble(8, 0.0, false));
                }
                this.shapeMRange = new Range(c);
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].setM(c.readDouble(8, 0.0, false));
                }
                break;
            }
            case 21: {
                this.shapePoints = new Point[]{new Point(c)};
                this.shapePoints[0].setM(c.readDouble(8, 0.0, false));
                break;
            }
            case 23: {
                int i;
                this.shapeBB = new BoundingBox(c);
                int numParts = (int)c.readLong(4, 0L, false);
                int numPoints = (int)c.readLong(4, 0L, false);
                this.shapeParts = new int[numParts];
                for (i = 0; i < numParts; ++i) {
                    this.shapeParts[i] = (int)c.readLong(4, 0L, false);
                }
                this.shapePoints = new Point[numPoints];
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i] = new Point(c);
                }
                this.shapeMRange = new Range(c);
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].setM(c.readDouble(8, 0.0, false));
                }
                break;
            }
            case 25: {
                int i;
                this.shapeBB = new BoundingBox(c);
                int numParts = (int)c.readLong(4, 0L, false);
                int numPoints = (int)c.readLong(4, 0L, false);
                this.shapeParts = new int[numParts];
                for (i = 0; i < numParts; ++i) {
                    this.shapeParts[i] = (int)c.readLong(4, 0L, false);
                }
                this.shapePoints = new Point[numPoints];
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i] = new Point(c);
                }
                this.shapeMRange = new Range(c);
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].setM(c.readDouble(8, 0.0, false));
                }
                break;
            }
            case 28: {
                int i;
                this.shapeBB = new BoundingBox(c);
                int numPoints = (int)c.readLong(4, 0L, false);
                this.shapePoints = new Point[numPoints];
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i] = new Point(c);
                }
                this.shapeMRange = new Range(c);
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].setM(c.readDouble(8, 0.0, false));
                }
                break;
            }
            case 31: {
                int i;
                this.shapeBB = new BoundingBox(c);
                int numParts = (int)c.readLong(4, 0L, false);
                int numPoints = (int)c.readLong(4, 0L, false);
                this.shapeParts = new int[numParts];
                for (i = 0; i < numParts; ++i) {
                    this.shapeParts[i] = (int)c.readLong(4, 0L, false);
                }
                this.shapePartTypes = new int[numParts];
                for (i = 0; i < numParts; ++i) {
                    this.shapePartTypes[i] = (int)c.readLong(4, 0L, false);
                }
                this.shapePoints = new Point[numPoints];
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i] = new Point(c);
                }
                this.shapeZRange = new Range(c);
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].setZ(c.readDouble(8, 0.0, false));
                }
                this.shapeMRange = new Range(c);
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].setM(c.readDouble(8, 0.0, false));
                }
                break;
            }
            default: {
                Print.logError("Unrecognized shape type: " + this.shapeType, new Object[0]);
            }
        }
        if (this.shapeParts != null) {
            this.shapePolygon = Shape.CreateGeoPolygon(this.shapePoints, this.shapeParts);
        }
    }

    public Shape(int rcdNdx, int type, BoundingBox bb, Point[] pp, int[] parts, int[] partTypes, Range mRange, Range zRange) {
        this();
        this.rcdIndex = rcdNdx;
        this.shapeType = type;
        this.shapeBB = bb;
        this.shapePoints = pp;
        this.shapeParts = parts;
        this.shapePartTypes = partTypes;
        this.shapeMRange = mRange;
        this.shapeZRange = zRange;
        if (this.shapeParts != null) {
            this.shapePolygon = Shape.CreateGeoPolygon(this.shapePoints, this.shapeParts);
        }
    }

    public Shape(int rcdNdx, GeoPoint gp) {
        this();
        this.rcdIndex = rcdNdx;
        this.shapeType = 1;
        this.shapeBB = null;
        this.shapePoints = Point.getPoints(gp);
        this.shapeParts = null;
        this.shapePartTypes = null;
        this.shapeMRange = null;
        this.shapeZRange = null;
        this.shapePolygon = null;
    }

    public Shape(int rcdNdx, GeoPolygon gp) {
        this();
        this.rcdIndex = rcdNdx;
        this.shapeType = 5;
        this.shapeBB = BoundingBox.getBoundingBox(gp);
        this.shapePoints = Point.getPoints(gp);
        this.shapeParts = new int[]{0};
        this.shapePartTypes = null;
        this.shapeMRange = null;
        this.shapeZRange = null;
        this.shapePolygon = Shape.CreateGeoPolygon(this.shapePoints, this.shapeParts);
    }

    public int getRecordIndex() {
        return this.rcdIndex;
    }

    public int getShapeType() {
        return this.shapeType;
    }

    public BoundingBox getBoundingBox() {
        return this.shapeBB;
    }

    public Point[] getShapePoints() {
        return this.shapePoints;
    }

    public int[] getShapeParts() {
        return this.shapeParts;
    }

    public int[] getShapePartTypes() {
        return this.shapePartTypes;
    }

    public Range getShapeMRange() {
        return this.shapeMRange;
    }

    public Range getShapeZRange() {
        return this.shapeZRange;
    }

    public GeoPolygon[] getPolygons() {
        return this.shapePolygon;
    }

    protected byte[] createShapeBytes() {
        Payload c = this.createShapePayload(true);
        return c.getBytes();
    }

    protected Payload createShapePayload(boolean saveData) {
        Payload c = saveData ? new Payload(60000) : new Payload(-1);
        c.writeLong(this.shapeType, 4, false);
        switch (this.shapeType) {
            case 0: {
                break;
            }
            case 1: {
                this.shapePoints[0].write(c);
                break;
            }
            case 3: {
                int i;
                this.shapeBB.write(c);
                int numParts = this.shapeParts.length;
                c.writeLong(numParts, 4, false);
                int numPoints = this.shapePoints.length;
                c.writeLong(numPoints, 4, false);
                for (i = 0; i < numParts; ++i) {
                    c.writeLong(this.shapeParts[i], 4, false);
                }
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].write(c);
                }
                break;
            }
            case 5: {
                int i;
                this.shapeBB.write(c);
                int numParts = this.shapeParts.length;
                c.writeLong(numParts, 4, false);
                int numPoints = this.shapePoints.length;
                c.writeLong(numPoints, 4, false);
                for (i = 0; i < numParts; ++i) {
                    c.writeLong(this.shapeParts[i], 4, false);
                }
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].write(c);
                }
                break;
            }
            case 8: {
                this.shapeBB.write(c);
                int numPoints = this.shapePoints.length;
                c.writeLong(numPoints, 4, false);
                for (int i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].write(c);
                }
                break;
            }
            case 11: {
                this.shapePoints[0].write(c);
                this.shapePoints[0].writeM(c);
                this.shapePoints[0].writeZ(c);
                break;
            }
            case 13: {
                int i;
                this.shapeBB.write(c);
                int numParts = this.shapeParts.length;
                c.writeLong(numParts, 4, false);
                int numPoints = this.shapePoints.length;
                c.writeLong(numPoints, 4, false);
                for (i = 0; i < numParts; ++i) {
                    c.writeLong(this.shapeParts[i], 4, false);
                }
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].write(c);
                }
                this.shapeZRange.write(c);
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].writeZ(c);
                }
                this.shapeMRange.write(c);
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].writeM(c);
                }
                break;
            }
            case 15: {
                int i;
                this.shapeBB.write(c);
                int numParts = this.shapeParts.length;
                c.writeLong(numParts, 4, false);
                int numPoints = this.shapePoints.length;
                c.writeLong(numPoints, 4, false);
                for (i = 0; i < numParts; ++i) {
                    c.writeLong(this.shapeParts[i], 4, false);
                }
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].writeZ(c);
                }
                this.shapeZRange.write(c);
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].writeZ(c);
                }
                this.shapeMRange.write(c);
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].writeM(c);
                }
                break;
            }
            case 18: {
                int i;
                this.shapeBB.write(c);
                int numPoints = this.shapePoints.length;
                c.writeLong(numPoints, 4, false);
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].write(c);
                }
                this.shapeZRange.write(c);
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].writeZ(c);
                }
                this.shapeMRange.write(c);
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].writeM(c);
                }
                break;
            }
            case 21: {
                this.shapePoints[0].write(c);
                this.shapePoints[0].writeM(c);
                break;
            }
            case 23: {
                int i;
                this.shapeBB.write(c);
                int numParts = this.shapeParts.length;
                c.writeLong(numParts, 4, false);
                int numPoints = this.shapePoints.length;
                c.writeLong(numPoints, 4, false);
                for (i = 0; i < numParts; ++i) {
                    c.writeLong(this.shapeParts[i], 4, false);
                }
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].write(c);
                }
                this.shapeMRange.write(c);
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].writeM(c);
                }
                break;
            }
            case 25: {
                int i;
                this.shapeBB.write(c);
                int numParts = this.shapeParts.length;
                c.writeLong(numParts, 4, false);
                int numPoints = this.shapePoints.length;
                c.writeLong(numPoints, 4, false);
                for (i = 0; i < numParts; ++i) {
                    c.writeLong(this.shapeParts[i], 4, false);
                }
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].write(c);
                }
                this.shapeMRange.write(c);
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].writeM(c);
                }
                break;
            }
            case 28: {
                int i;
                this.shapeBB.write(c);
                int numPoints = this.shapePoints.length;
                c.writeLong(numPoints, 4, false);
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].write(c);
                }
                this.shapeMRange.write(c);
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].writeM(c);
                }
                break;
            }
            case 31: {
                int i;
                this.shapeBB.write(c);
                int numParts = this.shapeParts.length;
                c.writeLong(numParts, 4, false);
                int numPoints = this.shapePoints.length;
                c.writeLong(numPoints, 4, false);
                for (i = 0; i < numParts; ++i) {
                    c.writeLong(this.shapeParts[i], 4, false);
                }
                for (i = 0; i < numParts; ++i) {
                    c.writeLong(this.shapePartTypes[i], 4, false);
                }
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].write(c);
                }
                this.shapeZRange.write(c);
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].writeZ(c);
                }
                this.shapeMRange.write(c);
                for (i = 0; i < numPoints; ++i) {
                    this.shapePoints[i].writeM(c);
                }
                break;
            }
            default: {
                Print.logError("Unrecognized shape type: " + this.shapeType, new Object[0]);
            }
        }
        return c;
    }

    public int getShapeLength() {
        Payload c = this.createShapePayload(false);
        return 8 + c.getSize();
    }

    public int writeShape(Payload p, int rcdNdx) {
        byte[] cb = this.createShapeBytes();
        int rndx = rcdNdx >= 0 ? rcdNdx : this.rcdIndex;
        p.writeLong(rndx, 4);
        p.writeLong(cb.length / 2, 4);
        p.writeBytes(cb);
        return cb.length;
    }

    public String toString(StringBuffer sb) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        sb.append("  Shape      : [" + this.shapeType + "] " + Shape.GetShapeTypeDescription(this.shapeType)).append("\n");
        sb.append("  Record#    : " + this.rcdIndex).append("\n");
        if (this.shapeBB != null) {
            sb.append("  BoundingBox: " + this.shapeBB).append("\n");
        }
        if (this.shapeZRange != null) {
            sb.append("  Z Range: " + this.shapeZRange).append("\n");
        }
        if (this.shapeMRange != null) {
            sb.append("  M Range: " + this.shapeMRange).append("\n");
        }
        if (!ListTools.isEmpty(this.shapeParts) && this.shapeParts.length > 1) {
            sb.append("  Parts: " + StringTools.join(this.shapeParts, ",")).append("\n");
        }
        if (!ListTools.isEmpty(this.shapePartTypes)) {
            sb.append("  PartTypes: " + StringTools.join(this.shapePartTypes, ",")).append("\n");
        }
        if (this.shapePolygon != null) {
            for (int i = 0; i < this.shapePolygon.length; ++i) {
                sb.append("  ShapePoly count [" + i + "]: " + this.shapePolygon[i].toString()).append("\n");
            }
        } else if (this.shapePoints != null) {
            int max = 2;
            sb.append("  ShapePoints count: " + this.shapePoints.length);
            for (int p = 0; p < this.shapePoints.length && p < max; ++p) {
                if (p > 0) {
                    sb.append(", ");
                }
                sb.append(" (").append(this.shapePoints[p].toString()).append(")");
            }
            if (this.shapePoints.length > max) {
                sb.append(", ...");
            }
            sb.append("\n");
        }
        return sb.toString().trim();
    }

    public String toString() {
        return this.toString(new StringBuffer());
    }
}

