/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.shapefile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.opengts.extra.shapefile.BoundingBox;
import org.opengts.extra.shapefile.Range;
import org.opengts.extra.shapefile.Shape;
import org.opengts.util.FileTools;
import org.opengts.util.ListTools;
import org.opengts.util.Payload;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class SHPParser {
    private int fileCode = 9994;
    private int fileLength16 = -1;
    private int version = 1000;
    private int shapeTypes = 0;
    private BoundingBox fileBB = null;
    private Range fileZRange = null;
    private Range fileMRange = null;
    private List<Shape> shapeList = null;
    private static final String[] ARG_FILE = new String[]{"file", "shp"};

    public SHPParser() {
        this.fileCode = 9994;
        this.fileLength16 = -1;
        this.version = 1000;
        this.shapeTypes = -1;
        this.fileBB = null;
        this.fileZRange = null;
        this.fileMRange = null;
        this.shapeList = null;
    }

    public SHPParser(int shapeTypes, BoundingBox bb, Range zRange, Range mRange, List<Shape> shapes) {
        this();
        this.shapeTypes = shapeTypes;
        this.fileBB = bb;
        this.fileZRange = zRange;
        this.fileMRange = mRange;
        this.shapeList = shapes;
    }

    public SHPParser(SHPParser other) {
        this.fileCode = 9994;
        this.fileLength16 = other.fileLength16;
        this.version = 1000;
        this.shapeTypes = other.shapeTypes;
        this.fileBB = other.fileBB != null ? new BoundingBox(other.fileBB) : null;
        this.fileZRange = other.fileZRange != null ? new Range(other.fileZRange) : null;
        this.fileMRange = other.fileMRange != null ? new Range(other.fileMRange) : null;
        this.shapeList = other.shapeList != null ? new Vector<Shape>(other.shapeList) : null;
    }

    public SHPParser(byte[] shpData) throws IOException {
        this._parse(shpData);
        if (this.shapeList == null) {
            throw new IOException("No shapes defined");
        }
    }

    public SHPParser(File shpFile) throws IOException {
        if (!FileTools.isFile(shpFile, "shp")) {
            throw new IOException("Invalid file specification");
        }
        FileInputStream fis = null;
        byte[] shpData = null;
        try {
            fis = new FileInputStream(shpFile);
            shpData = FileTools.readStream(fis);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
        this._parse(shpData);
        if (this.shapeList == null) {
            throw new IOException("Invalid SHP data");
        }
    }

    public int getFileCode() {
        return this.fileCode;
    }

    public void clearFileLength() {
        this.fileLength16 = -1;
    }

    public int getFileLength16(boolean isIndex) {
        if (isIndex) {
            return (100 + 4 * this.getShapeCount()) / 2;
        }
        if (this.fileLength16 <= 0) {
            int len = 100;
            if (this.shapeList != null) {
                for (Shape s : this.shapeList) {
                    int shapeLen = s.getShapeLength();
                    len += shapeLen;
                }
            }
            this.fileLength16 = (len + 1) / 2;
        }
        return this.fileLength16;
    }

    public int getFileLength(boolean isIndex) {
        return this.getFileLength16(isIndex) * 2;
    }

    public int getVersion() {
        return this.version;
    }

    public int getShapeTypes() {
        return this.shapeTypes;
    }

    public BoundingBox getBoundingBox() {
        return this.fileBB;
    }

    public Range getFileZRange() {
        return this.fileZRange;
    }

    public Range getFileMRange() {
        return this.fileMRange;
    }

    public int getShapeCount() {
        return ListTools.size(this.shapeList);
    }

    public boolean isEmpty() {
        return ListTools.isEmpty(this.shapeList);
    }

    public List<Shape> getShapes() {
        return this.shapeList;
    }

    public Shape getShapeAt(int ndx) {
        if (ndx >= 0 && ndx < ListTools.size(this.shapeList)) {
            return this.shapeList.get(ndx);
        }
        return null;
    }

    public void addShape(Shape sh) {
        if (sh != null) {
            if (this.shapeTypes == -1) {
                this.shapeTypes = sh.getShapeType();
            }
            if (this.shapeTypes != sh.getShapeType()) {
                Print.logError("Invalid shapeType: " + sh.getShapeType(), new Object[0]);
            } else {
                if (this.shapeList == null) {
                    this.shapeList = new Vector<Shape>();
                }
                this.shapeList.add(sh);
            }
            this.clearFileLength();
        }
    }

    private void _parse(byte[] data) throws IOException {
        if (ListTools.isEmpty(data)) {
            throw new IOException("Empty/Null data");
        }
        if (data.length < 100) {
            throw new IOException("Invalid SHP data length: missing header");
        }
        Payload shpData = new Payload(data);
        this.fileCode = (int)shpData.readLong(4, 0L);
        shpData.readSkip(20);
        this.fileLength16 = (int)shpData.readLong(4, 0L);
        this.version = (int)shpData.readLong(4, 0L, false);
        this.shapeTypes = (int)shpData.readLong(4, 0L, false);
        this.fileBB = new BoundingBox(shpData);
        this.fileZRange = new Range(shpData);
        this.fileMRange = new Range(shpData);
        this.shapeList = new Vector<Shape>();
        while (shpData.getAvailableReadLength() > 0) {
            Shape shape = new Shape(shpData);
            this.shapeList.add(shape);
        }
    }

    public void writeFile(Payload data, Payload index) {
        data.writeLong(this.fileCode, 4);
        data.writeZeroFill(20);
        int fileLenIndex = data.getIndex();
        data.writeLong(0L, 4);
        data.writeLong(this.version, 4, false);
        data.writeLong(this.shapeTypes, 4, false);
        if (this.fileBB == null) {
            this.fileBB = new BoundingBox(this.getShapes());
        }
        this.fileBB.write(data);
        if (this.fileZRange == null) {
            this.fileZRange = new Range(0.0, 0.0);
        }
        this.fileZRange.write(data);
        if (this.fileMRange == null) {
            this.fileMRange = new Range(0.0, 0.0);
        }
        this.fileMRange.write(data);
        byte[] header = data.getBytes();
        index.writeBytes(header);
        List<Shape> shapes = this.getShapes();
        if (!ListTools.isEmpty(shapes)) {
            int rcdNdx = 1;
            for (Shape s : shapes) {
                int offset16 = (data.getIndex() + 1) / 2;
                int length16 = (s.writeShape(data, rcdNdx++) + 1) / 2;
                index.writeULong(offset16, 4);
                index.writeULong(length16, 4);
            }
        } else {
            Print.logWarn("No shapes to write to stream", new Object[0]);
        }
        int dataSize = data.getSize();
        data.resetIndex(fileLenIndex);
        int shpFileLen = (dataSize + 1) / 2;
        data.writeLong(shpFileLen, 4);
        data.resetIndex(dataSize);
        this.fileLength16 = shpFileLen;
        int indexSize = index.getSize();
        index.resetIndex(fileLenIndex);
        int shxFileLen = (indexSize + 1) / 2;
        index.writeLong(shxFileLen, 4);
        index.resetIndex(indexSize);
    }

    public String toString() {
        SHPParser shpp = this;
        StringBuffer sb = new StringBuffer();
        sb.append("FileCode   : " + shpp.getFileCode()).append("\n");
        sb.append("FileLength : " + shpp.getFileLength(false) + " bytes").append("\n");
        sb.append("Version    : " + shpp.getVersion()).append("\n");
        sb.append("ShapeTypes : " + shpp.getShapeTypes()).append("\n");
        sb.append("BoundingBox: " + shpp.getBoundingBox()).append("\n");
        sb.append("Z Range    : " + shpp.getFileZRange()).append("\n");
        sb.append("M Range    : " + shpp.getFileMRange()).append("\n");
        List<Shape> shapes = shpp.getShapes();
        if (!ListTools.isEmpty(shapes)) {
            for (Shape s : shapes) {
                sb.append(s.toString()).append("\n");
                sb.append("").append("\n");
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        File shpFile = RTConfig.getFile(ARG_FILE, null);
        if (shpFile == null) {
            Print.sysPrintln("Missing '-file' specification", new Object[0]);
            System.exit(99);
        } else if (!FileTools.isFile(shpFile, "shp")) {
            Print.sysPrintln("Not a 'shp' file: " + shpFile, new Object[0]);
            System.exit(99);
        }
        FileInputStream fis = null;
        byte[] shpData = null;
        try {
            fis = new FileInputStream(shpFile);
            shpData = FileTools.readStream(fis);
        }
        catch (IOException ioe) {
            Print.logException("Invalid file specification", ioe);
            System.exit(99);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
        SHPParser shpp = null;
        try {
            shpp = new SHPParser(shpData);
        }
        catch (Throwable th) {
            Print.logException("Error", th);
        }
        Print.sysPrintln(shpp.toString(), new Object[0]);
        int origSHPLen = shpp.getFileLength(false);
        Print.sysPrintln("-------------------------------", new Object[0]);
        SHPParser shapeCopy = new SHPParser(shpp);
        Print.sysPrintln("-------------------------------", new Object[0]);
        shapeCopy.clearFileLength();
        int copySHPLen = shapeCopy.getFileLength(false);
        Print.sysPrintln("Original Length " + origSHPLen + ", Copy Length " + copySHPLen, new Object[0]);
        Payload shapePayload = new Payload(shapeCopy.getFileLength(false) + 100);
        Payload indexPayload = new Payload(shapeCopy.getFileLength(true) + 100);
        shapeCopy.writeFile(shapePayload, indexPayload);
        byte[] shapeBytes = shapePayload.getBytes();
        byte[] indexBytes = indexPayload.getBytes();
        Print.sysPrintln("Original shapefile: ", new Object[0]);
        Print.sysPrintln(StringTools.formatHexString(shpData).toString(), new Object[0]);
        Print.sysPrintln("", new Object[0]);
        Print.sysPrintln("Copy: ", new Object[0]);
        Print.sysPrintln(StringTools.formatHexString(shapeBytes).toString(), new Object[0]);
        Print.sysPrintln("Index: ", new Object[0]);
        Print.sysPrintln(StringTools.formatHexString(indexBytes).toString(), new Object[0]);
        Print.sysPrintln("", new Object[0]);
        Print.sysPrintln("Diff: " + StringTools.diff(shpData, shapeBytes), new Object[0]);
    }
}

