/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.shapefile;

import org.opengts.util.Payload;
import org.opengts.util.Print;

public class Range {
    private double Min = 0.0;
    private double Max = 0.0;

    public Range(Range r) {
        if (r == null) {
            Print.logError("Invalid SHP data length: missing range", new Object[0]);
        }
        this.Min = r.Min;
        this.Max = r.Max;
    }

    public Range(Payload p) {
        if (p.getAvailableReadLength() < 16) {
            Print.logError("Invalid SHP data length: missing range", new Object[0]);
        }
        this.Min = p.readDouble(8, 0.0, false);
        this.Max = p.readDouble(8, 0.0, false);
    }

    public Range(double min, double max) {
        this.Min = min;
        this.Max = max;
    }

    public double getMin() {
        return this.Min;
    }

    public double getMax() {
        return this.Max;
    }

    public Payload write(Payload p) {
        p.writeDouble(this.getMin(), 8, false);
        p.writeDouble(this.getMax(), 8, false);
        return p;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Min=").append(this.getMin());
        sb.append(", ");
        sb.append("Max=").append(this.getMax());
        return sb.toString();
    }
}

