/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.shapefile;

import org.opengts.util.GeoPoint;
import org.opengts.util.GeoPointProvider;
import org.opengts.util.GeoPolygon;
import org.opengts.util.Payload;
import org.opengts.util.Print;

public class Point
implements GeoPointProvider {
    private double X = 0.0;
    private double Y = 0.0;
    private boolean hasZ = false;
    private double Z = 0.0;
    private boolean hasM = false;
    private double M = 0.0;

    public static Point[] getPoints(GeoPoint gp) {
        if (gp != null) {
            return new Point[]{new Point(gp)};
        }
        return new Point[0];
    }

    public static Point[] getPoints(GeoPoint ... gp) {
        if (gp != null) {
            Point[] pt = new Point[gp.length];
            for (int i = 0; i < gp.length; ++i) {
                pt[i] = new Point(gp[i]);
            }
            return pt;
        }
        return new Point[0];
    }

    public static Point[] getPoints(GeoPolygon gp) {
        if (gp != null) {
            return Point.getPoints(gp.getGeoPoints());
        }
        return new Point[0];
    }

    public Point(Point p) {
        if (p == null) {
            Print.logError("Invalid SHP data length: missing point", new Object[0]);
        }
        this.X = p.X;
        this.Y = p.Y;
        this.hasZ = p.hasZ;
        this.Z = p.Z;
        this.hasM = p.hasM;
        this.M = p.M;
    }

    public Point(Payload p) {
        if (p.getAvailableReadLength() < 16) {
            Print.logError("Invalid SHP data length: missing point", new Object[0]);
        }
        this.X = p.readDouble(8, 0.0, false);
        this.Y = p.readDouble(8, 0.0, false);
    }

    public Point(double x, double y) {
        this.X = x;
        this.Y = y;
    }

    public Point(GeoPoint gp) {
        this.X = gp != null ? gp.getX() : 0.0;
        this.Y = gp != null ? gp.getY() : 0.0;
    }

    public double getX() {
        return this.X;
    }

    public double getLongitude() {
        return this.getX();
    }

    public double getY() {
        return this.Y;
    }

    public double getLatitude() {
        return this.getY();
    }

    @Override
    public GeoPoint getGeoPoint() {
        return new GeoPoint(this.getLatitude(), this.getLongitude());
    }

    public void setZ(double z) {
        this.Z = z;
        this.hasZ = true;
    }

    public boolean hasZ() {
        return this.hasZ;
    }

    public double getZ() {
        return this.Z;
    }

    public void setM(double m) {
        this.M = m;
        this.hasM = true;
    }

    public boolean hasM() {
        return this.hasM;
    }

    public double getM() {
        return this.M;
    }

    public Payload write(Payload p) {
        p.writeDouble(this.getX(), 8, false);
        p.writeDouble(this.getY(), 8, false);
        return p;
    }

    public Payload writeZ(Payload p) {
        if (this.hasZ()) {
            p.writeDouble(this.getZ(), 8, false);
        }
        return p;
    }

    public Payload writeM(Payload p) {
        if (this.hasM()) {
            p.writeDouble(this.getM(), 8, false);
        }
        return p;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("X=").append(this.getX());
        sb.append(", ");
        sb.append("Y=").append(this.getY());
        if (this.hasZ()) {
            sb.append(", ");
            sb.append("Z=").append(this.getZ());
        }
        if (this.hasM()) {
            sb.append(", ");
            sb.append("M=").append(this.getM());
        }
        return sb.toString();
    }
}

