/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.shapefile;

import org.opengts.util.Payload;
import org.opengts.util.StringTools;

public class Field {
    public static final int DATATYPE_STRING = 67;
    public static final int DATATYPE_DATE = 68;
    public static final int DATATYPE_FLOAT = 70;
    public static final int DATATYPE_DOUBLE = 78;
    public static final int DATATYPE_BOOLEAN = 76;
    public static final int DATATYPE_MEMO = 77;
    public static final int DATATYPE_TIMESTAMP = 64;
    private String name = "";
    private int dataType = 0;
    private int length = 0;
    private int decimal = 0;
    private int workAreaID = 0;
    private int flags = 0;
    private int index = 0;

    private static String TRIM(String str) {
        String s = StringTools.trim(str);
        int z = s.indexOf(0);
        if (z >= 0) {
            s = s.substring(0, z);
        }
        return s;
    }

    public Field(Payload p) {
        this.name = Field.TRIM(p.readString(11, false));
        this.dataType = (int)p.readULong(1, 0L);
        p.readSkip(4);
        this.length = (int)p.readULong(1, 0L, false);
        this.decimal = (int)p.readULong(1, 0L);
        p.readSkip(2);
        this.workAreaID = (int)p.readULong(1, 0L);
        p.readSkip(2);
        this.flags = (int)p.readULong(1, 0L);
        p.readSkip(7);
        this.index = (int)p.readULong(1, 0L);
    }

    public Field(String name, int type, int len, int dec, int waid, int flags, int ndx) {
        this.name = Field.TRIM(name);
        this.dataType = type;
        this.length = len;
        this.decimal = dec;
        this.workAreaID = waid;
        this.flags = flags;
        this.index = ndx;
    }

    public Field(String name, int len) {
        this.name = Field.TRIM(name);
        this.dataType = 67;
        this.length = len;
        this.decimal = 0;
        this.workAreaID = 0;
        this.flags = 0;
        this.index = 0;
    }

    public String getName() {
        return this.name;
    }

    public int getDataType() {
        return this.dataType;
    }

    public int getLength() {
        return this.length;
    }

    public int getDecimal() {
        return this.decimal;
    }

    public int getWorkAreaID() {
        return this.workAreaID;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int dt = this.getDataType();
        sb.append("name=").append(this.getName());
        sb.append(" type=").append(dt).append(",").append(dt > 32 && dt < 127 ? (char)dt : (char)'?');
        sb.append(" len=").append(this.getLength());
        if (dt == 70 || dt == 78 || this.getDecimal() > 0) {
            sb.append(" dec=").append(this.getDecimal());
        }
        if (this.getWorkAreaID() != 0) {
            sb.append(" waid=").append(this.getWorkAreaID());
        }
        if (this.getFlags() != 0) {
            sb.append(" flag=").append(this.getFlags());
        }
        if (this.getIndex() != 0) {
            sb.append(" ndx=").append(this.getIndex());
        }
        return sb.toString();
    }

    public Payload write(Payload p) {
        p.writeString(this.name, 11, false);
        p.writeULong(this.dataType, 1);
        p.writeZeroFill(4);
        p.writeULong(this.length, 1);
        p.writeULong(this.decimal, 1);
        p.writeZeroFill(2);
        p.writeULong(this.workAreaID, 1);
        p.writeZeroFill(2);
        p.writeULong(this.flags, 1);
        p.writeZeroFill(7);
        p.writeULong(this.index, 1);
        return p;
    }
}

