/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.shapefile;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.opengts.extra.shapefile.Field;
import org.opengts.util.DateTime;
import org.opengts.util.FileTools;
import org.opengts.util.ListTools;
import org.opengts.util.Payload;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class DBFParser {
    public static final int VERSION = 3;
    public static final int TERMINATOR = 13;
    public static final int END_OF_DATA = 26;
    private int version = 3;
    private DateTime updateDate = null;
    private int incomplete = 0;
    private int encryption = 0;
    private int mdxProduction = 0;
    private int langDriverID = 0;
    private List<Field> fieldList = null;
    private List<String[]> dataRecords = null;
    private static final String[] ARG_FILE = new String[]{"file", "dbf"};

    public DBFParser() {
    }

    public DBFParser(DBFParser other) {
        this();
        this.fieldList = other.fieldList != null ? new Vector<Field>(other.fieldList) : null;
        this.dataRecords = other.dataRecords != null ? new Vector<String[]>(other.dataRecords) : null;
        this.version = 3;
        this.updateDate = other.updateDate;
        this.incomplete = 0;
        this.encryption = 0;
        this.mdxProduction = 0;
        this.langDriverID = 0;
    }

    public DBFParser(List<Field> fields) {
        this();
        this.fieldList = fields;
    }

    public DBFParser(byte[] dbfData) throws IOException {
        this();
        boolean parseOK = this._parse(dbfData);
        if (!parseOK) {
            throw new IOException("Invalid DBF data");
        }
    }

    public DBFParser(File dbfFile) throws IOException {
        this();
        if (!FileTools.isFile(dbfFile, "dbf")) {
            throw new IOException("Invalid file specification");
        }
        FileInputStream fis = null;
        byte[] dbfData = null;
        try {
            fis = new FileInputStream(dbfFile);
            dbfData = FileTools.readStream(fis);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
        boolean parseOK = this._parse(dbfData);
        if (!parseOK) {
            throw new IOException("Invalid DBF data");
        }
    }

    public void setUpdateTime(DateTime updateTime) {
        this.updateDate = updateTime;
    }

    public void setUpdateTime(int updYYYY, int updMM, int updDD) {
        this.updateDate = new DateTime(DateTime.getGMTTimeZone(), updYYYY, updMM, updDD, 0, 0, 0);
    }

    public int getFieldCount() {
        return ListTools.size(this.fieldList);
    }

    public boolean hasFields() {
        return this.getFieldCount() > 0;
    }

    public List<Field> getFields() {
        return this.fieldList;
    }

    public void addField(Field fld) {
        if (fld != null) {
            if (this.fieldList == null) {
                this.fieldList = new Vector<Field>();
            }
            this.fieldList.add(fld);
        }
    }

    public Field getFieldAt(int ndx) {
        if (ndx >= 0 && ndx < ListTools.size(this.fieldList)) {
            return this.fieldList.get(ndx);
        }
        return null;
    }

    public String getFieldNameAt(int ndx) {
        Field fld = this.getFieldAt(ndx);
        return fld != null ? fld.getName() : "";
    }

    public int getRecordSize() {
        int rcdLen = 0;
        if (this.fieldList != null) {
            for (Field fld : this.fieldList) {
                rcdLen += fld.getLength();
            }
        }
        return rcdLen + 1;
    }

    public void addRecord(String[] rcd) {
        if (!ListTools.isEmpty(rcd)) {
            if (rcd.length != this.getFieldCount()) {
                Print.logError("Invalid number of data fields in record: " + rcd.length, new Object[0]);
            } else {
                if (this.dataRecords == null) {
                    this.dataRecords = new Vector<String[]>();
                }
                this.dataRecords.add(rcd);
            }
        }
    }

    public int getRecordCount() {
        return ListTools.size(this.dataRecords);
    }

    public boolean hasRecords() {
        return !ListTools.isEmpty(this.dataRecords);
    }

    public String[] getRecordAt(int ndx) {
        if (ndx >= 0 && ndx < ListTools.size(this.dataRecords)) {
            return this.dataRecords.get(ndx);
        }
        return null;
    }

    public RTProperties getPropertiesAt(int ndx, boolean ignoreCase) {
        String[] rcd = this.getRecordAt(ndx);
        if (!ListTools.isEmpty(rcd) && this.hasFields()) {
            RTProperties rtp = new RTProperties();
            rtp.setIgnoreKeyCase(ignoreCase);
            List<Field> fields = this.getFields();
            for (int f = 0; f < fields.size(); ++f) {
                String key = fields.get(f).getName();
                String val = f < rcd.length ? rcd[f] : "";
                rtp.setString(key, val);
            }
            return rtp;
        }
        return null;
    }

    public int getHeaderSize() {
        int hdrLen = 32 + this.getFieldCount() * 32 + 1;
        return hdrLen;
    }

    public int getFileLength() {
        int headerDataLength = 32 + this.getFieldCount() * 32 + 1;
        int recordDataLength = this.getRecordSize() * this.getRecordCount();
        return headerDataLength + recordDataLength;
    }

    private boolean _parse(byte[] data) throws IOException {
        int rcdType;
        int expectedLength;
        int dataByteLength;
        this.fieldList = null;
        this.dataRecords = null;
        if (ListTools.isEmpty(data)) {
            throw new IOException("Empty/Null data");
        }
        Payload dbfData = new Payload(data);
        if (dbfData.getAvailableReadLength() < 32) {
            throw new IOException("Invalid DBF data length: missing header");
        }
        this.version = (int)dbfData.readULong(1, 0L);
        int updYYYY = (int)dbfData.readULong(1, 0L) + 1900;
        int updMM = (int)dbfData.readULong(1, 0L);
        int updDD = (int)dbfData.readULong(1, 0L);
        this.updateDate = new DateTime(DateTime.getGMTTimeZone(), updYYYY, updMM, updDD, 0, 0, 0);
        int recordCount = (int)dbfData.readULong(4, 0L, false);
        int headerSize = (int)dbfData.readULong(2, 0L, false);
        int recordSize = (int)dbfData.readULong(2, 0L, false);
        dbfData.readSkip(2);
        this.incomplete = (int)dbfData.readLong(1, 0L);
        this.encryption = (int)dbfData.readLong(1, 0L);
        dbfData.readSkip(12);
        this.mdxProduction = (int)dbfData.readLong(1, 0L);
        this.langDriverID = (int)dbfData.readLong(1, 0L);
        dbfData.readSkip(2);
        if (this.version != 3) {
            Print.logWarn("Unexpected Version: " + this.version, new Object[0]);
        }
        int fieldCount = (headerSize - 33) / 32;
        if ((headerSize - 33) % 32 != 0) {
            Print.logError("Invalid Header Size: " + headerSize, new Object[0]);
        }
        this.fieldList = new Vector<Field>();
        int fi = 0;
        while (dbfData.getAvailableReadLength() > 0) {
            int peekByte = dbfData.peekByte();
            if (peekByte == 13) {
                dbfData.readSkip(1);
                break;
            }
            if (fi >= fieldCount) break;
            if (dbfData.getAvailableReadLength() < 32) {
                Print.logError("Invalid DBF data length: missing field definition", new Object[0]);
                break;
            }
            byte[] fieldbytes = dbfData.readBytes(32);
            Payload pField = new Payload(fieldbytes);
            Field fld = new Field(pField);
            this.fieldList.add(fld);
            Print.logDebug("Field: " + fld, new Object[0]);
            ++fi;
        }
        if (dbfData.getIndex() != headerSize) {
            if (dbfData.getIndex() < headerSize) {
                int skipLen = headerSize - dbfData.getIndex();
                dbfData.readSkip(skipLen);
            } else {
                Print.logError("We've somehow read more bytes that are in the header!", new Object[0]);
            }
        }
        if ((dataByteLength = dbfData.getSize()) < (expectedLength = recordSize * recordCount)) {
            Print.logError("Invalid Record Byte length: " + dataByteLength + " [expecting " + expectedLength + "]", new Object[0]);
        }
        if (recordSize != this.getRecordSize()) {
            Print.logError("File record length does not match calculated record length: " + recordSize + " != " + this.getRecordSize(), new Object[0]);
        }
        int ri = 0;
        while (dbfData.getAvailableReadLength() > 0 && (rcdType = (int)dbfData.readULong(1, 0L)) != 26) {
            if (rcdType == 42) {
                if (dbfData.getAvailableReadLength() < recordSize - 1) {
                    Print.logError("Invalid DBF data length: missing record definition", new Object[0]);
                }
                dbfData.readSkip(recordSize - 1);
            } else {
                if (ri >= recordCount) break;
                String[] valueArray = new String[this.fieldList.size()];
                for (int i = 0; i < this.fieldList.size() && dbfData.getAvailableReadLength() > 0; ++i) {
                    Field f = this.fieldList.get(i);
                    String key = f.getName();
                    String val = null;
                    if (dbfData.getAvailableReadLength() < f.getLength()) {
                        Print.logError("Invalid DBF data length: missing field data [C]", new Object[0]);
                    }
                    switch (f.getDataType()) {
                        case 67: {
                            val = StringTools.trim(dbfData.readString(f.getLength(), false));
                            break;
                        }
                        case 68: {
                            val = dbfData.readString(4, false) + "/" + dbfData.readString(2, false) + "/" + dbfData.readString(2, false);
                            break;
                        }
                        case 70: {
                            val = StringTools.trim(dbfData.readString(f.getLength(), false));
                            break;
                        }
                        case 78: {
                            val = StringTools.trim(dbfData.readString(f.getLength(), false));
                            break;
                        }
                        case 76: {
                            int B = (int)dbfData.readULong(1, 0L);
                            val = B == 89 || B == 121 || B == 84 || B == 116 ? "true" : "false";
                            break;
                        }
                        case 77: {
                            val = StringTools.trim(dbfData.readString(f.getLength(), false));
                            break;
                        }
                        default: {
                            val = "";
                        }
                    }
                    valueArray[i] = val;
                }
                this.addRecord(valueArray);
            }
            ++ri;
        }
        return this.hasRecords();
    }

    public Payload write(Payload p) {
        if (this.updateDate == null) {
            this.updateDate = new DateTime(DateTime.getGMTTimeZone());
        }
        int recordCount = this.getRecordCount();
        int headerSize = this.getHeaderSize();
        int recordSize = this.getRecordSize();
        p.writeULong(3L, 1);
        p.writeULong((long)this.updateDate.getYear() - 1900L, 1);
        p.writeULong(this.updateDate.getMonth1(), 1);
        p.writeULong(this.updateDate.getDayOfMonth(), 1);
        p.writeULong(recordCount, 4, false);
        p.writeULong(headerSize, 2, false);
        p.writeULong(recordSize, 2, false);
        p.writeZeroFill(2);
        p.writeULong(this.incomplete, 1);
        p.writeULong(this.encryption, 1);
        p.writeZeroFill(12);
        p.writeULong(this.mdxProduction, 1);
        p.writeULong(this.langDriverID, 1);
        p.writeZeroFill(2);
        if (!ListTools.isEmpty(this.fieldList)) {
            for (Field fld : this.fieldList) {
                fld.write(p);
            }
        }
        p.writeULong(13L, 1);
        if (!ListTools.isEmpty(this.fieldList)) {
            int rcdCnt = this.getRecordCount();
            for (int r = 0; r < rcdCnt; ++r) {
                p.writeULong(32L, 1);
                String[] rcd = this.getRecordAt(r);
                block10: for (int fi = 0; fi < this.fieldList.size(); ++fi) {
                    Field fld = this.fieldList.get(fi);
                    int len = fld.getLength();
                    String key = fld.getName();
                    String val = fi < rcd.length ? rcd[fi] : "";
                    switch (fld.getDataType()) {
                        case 67: {
                            Object s = StringTools.leftAlign(val, len);
                            p.writeString((String)s, len, false);
                            continue block10;
                        }
                        case 68: {
                            Object s = StringTools.split(val, '/');
                            if (((String[])s).length < 3) {
                                s = new String[]{"0000", "00", "00"};
                            }
                            p.writeString(StringTools.padLeft(s[0], '0', 4 - s[0].length()), 4, false);
                            p.writeString(StringTools.padLeft(s[1], '0', 2 - s[1].length()), 2, false);
                            p.writeString(StringTools.padLeft(s[2], '0', 2 - s[2].length()), 2, false);
                            continue block10;
                        }
                        case 70: {
                            Object s = StringTools.leftAlign(val, len);
                            p.writeString((String)s, len, false);
                            continue block10;
                        }
                        case 78: {
                            Object s = StringTools.leftAlign(val, len);
                            p.writeString((String)s, len, false);
                            continue block10;
                        }
                        case 76: {
                            Object s = val.equalsIgnoreCase("true") ? "T" : "F";
                            p.writeString((String)s, 1, false);
                            continue block10;
                        }
                        case 77: {
                            Object s = StringTools.leftAlign(val, len);
                            p.writeString((String)s, len, false);
                            continue block10;
                        }
                        default: {
                            Object s = StringTools.leftAlign(val, len);
                            p.writeString((String)s, len, false);
                        }
                    }
                }
            }
            p.writeULong(26L, 1);
        }
        return p;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Version      : " + this.version).append("\n");
        sb.append("Updated      : " + this.updateDate).append("\n");
        sb.append("Record Count : " + this.getRecordCount()).append("\n");
        sb.append("Header Size  : " + this.getHeaderSize()).append("\n");
        sb.append("Record Size  : " + this.getRecordSize()).append("\n");
        sb.append("Incomplete   : " + this.incomplete).append("\n");
        sb.append("Encryption   : " + this.encryption).append("\n");
        sb.append("MDX File?    : " + this.mdxProduction).append("\n");
        sb.append("LangDriverID : " + this.langDriverID).append("\n");
        sb.append("Contents     : ").append("\n");
        List<Field> dbFields = this.getFields();
        if (!ListTools.isEmpty(dbFields)) {
            StringBuffer H = new StringBuffer();
            for (Field f : dbFields) {
                if (H.length() > 0) {
                    H.append(",");
                }
                H.append(StringTools.quoteCSVString(f.getName()));
            }
            sb.append("   ").append(H.toString()).append("\n");
            int rcdCount = this.getRecordCount();
            for (int r = 0; r < rcdCount; ++r) {
                String[] rcd = this.getRecordAt(r);
                if (ListTools.isEmpty(rcd)) continue;
                StringBuffer R = new StringBuffer();
                for (int c = 0; c < rcd.length; ++c) {
                    if (R.length() > 0) {
                        R.append(",");
                    }
                    R.append(StringTools.quoteCSVString(rcd[c]));
                }
                sb.append("   ").append(R.toString()).append("\n");
            }
        } else {
            sb.append("   ").append("none").append("\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        File dbfFile = RTConfig.getFile(ARG_FILE, null);
        if (dbfFile == null) {
            Print.sysPrintln("Missing '-file' specification", new Object[0]);
            System.exit(99);
        } else if (!FileTools.isFile(dbfFile, "dbf")) {
            Print.sysPrintln("Not a 'dbf' file: " + dbfFile, new Object[0]);
            System.exit(99);
        }
        FileInputStream fis = null;
        byte[] dbfData = null;
        try {
            fis = new FileInputStream(dbfFile);
            dbfData = FileTools.readStream(fis);
        }
        catch (IOException ioe) {
            Print.logException("Invalid file specification", ioe);
            System.exit(99);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
        DBFParser dbfp = null;
        try {
            dbfp = new DBFParser(dbfData);
        }
        catch (Throwable th) {
            Print.logException("Error", th);
        }
        Print.sysPrintln(dbfp.toString(), new Object[0]);
        List<Field> dbFields = dbfp.getFields();
        if (!ListTools.isEmpty(dbFields)) {
            StringBuffer H = new StringBuffer();
            for (Field f : dbFields) {
                if (H.length() > 0) {
                    H.append(",");
                }
                H.append(StringTools.quoteCSVString(f.getName()));
            }
            Print.sysPrintln(H.toString(), new Object[0]);
            int rcdCount = dbfp.getRecordCount();
            for (int r = 0; r < rcdCount; ++r) {
                String[] rcd = dbfp.getRecordAt(r);
                if (ListTools.isEmpty(rcd)) continue;
                StringBuffer R = new StringBuffer();
                for (int c = 0; c < rcd.length; ++c) {
                    if (R.length() > 0) {
                        R.append(",");
                    }
                    R.append(StringTools.quoteCSVString(rcd[c]));
                }
                Print.sysPrintln(R.toString(), new Object[0]);
            }
        }
        Payload copyPayload = new Payload(dbfp.getFileLength() + 100);
        DBFParser copy = new DBFParser(dbfp);
        copy.write(copyPayload);
        byte[] copyBytes = copyPayload.getBytes();
        Print.sysPrintln("Original DBF file: ", new Object[0]);
        Print.sysPrintln(StringTools.formatHexString(dbfData).toString(), new Object[0]);
        Print.sysPrintln("", new Object[0]);
        Print.sysPrintln("Copy: ", new Object[0]);
        Print.sysPrintln(StringTools.formatHexString(copyBytes).toString(), new Object[0]);
        Print.sysPrintln("", new Object[0]);
        Print.sysPrintln("Diff: " + StringTools.diff(dbfData, copyBytes), new Object[0]);
    }
}

