/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.extra.shapefile;

import java.util.Collection;
import org.opengts.extra.shapefile.Shape;
import org.opengts.util.GeoBounds;
import org.opengts.util.GeoPoint;
import org.opengts.util.GeoPointProvider;
import org.opengts.util.GeoPolygon;
import org.opengts.util.ListTools;
import org.opengts.util.Payload;
import org.opengts.util.Print;

public class BoundingBox {
    private double Xmin = 0.0;
    private double Xmax = 0.0;
    private double Ymin = 0.0;
    private double Ymax = 0.0;

    public static BoundingBox getBoundingBox(GeoPoint ... gp) {
        return new BoundingBox(new GeoBounds(gp));
    }

    public static BoundingBox getBoundingBox(GeoPolygon gp) {
        return new BoundingBox(new GeoBounds(gp));
    }

    public BoundingBox(Shape sh) {
        if (sh != null) {
            GeoBounds gb = new GeoBounds();
            gb.extendByPoint(sh.getShapePoints());
            this.Xmin = gb.getMinX();
            this.Ymin = gb.getMinY();
            this.Xmax = gb.getMaxX();
            this.Ymax = gb.getMaxY();
        }
    }

    public BoundingBox(Collection<Shape> shapes) {
        if (shapes != null) {
            GeoBounds gb = new GeoBounds();
            for (Shape sh : shapes) {
                GeoPointProvider[] pts = sh.getShapePoints();
                if (ListTools.isEmpty(pts)) continue;
                gb.extendByPoint(pts);
            }
            this.Xmin = gb.getMinX();
            this.Ymin = gb.getMinY();
            this.Xmax = gb.getMaxX();
            this.Ymax = gb.getMaxY();
        }
    }

    public BoundingBox(GeoBounds gb) {
        if (gb != null) {
            this.Xmin = gb.getMinX();
            this.Ymin = gb.getMinY();
            this.Xmax = gb.getMaxX();
            this.Ymax = gb.getMaxY();
        }
    }

    public BoundingBox(BoundingBox bb) {
        if (bb == null) {
            Print.logError("Invalid SHP data length: missing bounding box", new Object[0]);
        }
        this.Xmin = bb.Xmin;
        this.Ymin = bb.Ymin;
        this.Xmax = bb.Xmax;
        this.Ymax = bb.Ymax;
    }

    public BoundingBox(Payload p) {
        if (p == null || p.getAvailableReadLength() < 32) {
            Print.logError("Invalid SHP data length: missing bounding box", new Object[0]);
        }
        this.Xmin = p.readDouble(8, 0.0, false);
        this.Ymin = p.readDouble(8, 0.0, false);
        this.Xmax = p.readDouble(8, 0.0, false);
        this.Ymax = p.readDouble(8, 0.0, false);
    }

    public BoundingBox(double xmin, double ymin, double xmax, double ymax) {
        this.Xmin = xmin;
        this.Ymin = ymin;
        this.Xmax = xmax;
        this.Ymax = ymax;
    }

    public double getXMin() {
        return this.Xmin;
    }

    public double getXMax() {
        return this.Xmax;
    }

    public double getYMin() {
        return this.Ymin;
    }

    public double getYMax() {
        return this.Ymax;
    }

    public GeoPoint getMinGeoPoint() {
        return new GeoPoint(this.getYMin(), this.getXMin());
    }

    public GeoPoint getMaxGeoPoint() {
        return new GeoPoint(this.getYMax(), this.getXMax());
    }

    public GeoBounds getGeoBounds() {
        return new GeoBounds(this.getMinGeoPoint(), this.getMaxGeoPoint());
    }

    public Payload write(Payload p) {
        p.writeDouble(this.getXMin(), 8, false);
        p.writeDouble(this.getYMin(), 8, false);
        p.writeDouble(this.getXMax(), 8, false);
        p.writeDouble(this.getYMax(), 8, false);
        return p;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("X min/max = " + this.getXMin() + "/" + this.getXMax());
        sb.append(", ");
        sb.append("Y min/max = " + this.getYMin() + "/" + this.getYMax());
        return sb.toString();
    }
}

