/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.dbtools;

import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class DBWhere {
    public static int KEY_FULL = 0;
    public static int KEY_PARTIAL_FIRST = 1;
    public static int KEY_PARTIAL_ALL = 2;
    public static int KEY_PARTIAL_ALL_EMPTY = 3;
    public static int KEY_AUTO_INDEX = 4;
    private DBFactory factory = null;
    private StringBuffer tempSB = null;
    private StringBuffer accumSB = null;

    public DBWhere(DBFactory fact) {
        this.factory = fact;
        this.tempSB = new StringBuffer();
    }

    private StringBuffer _getTempSB() {
        this.tempSB.setLength(0);
        return this.tempSB;
    }

    private String _quoteValue(String fldName, Object value) {
        DBField fld;
        DBField dBField = fld = this.factory != null ? this.factory.getField(fldName) : null;
        if (fld == null) {
            return DBField.quote(value != null ? value.toString() : "");
        }
        return fld.getQValue(value);
    }

    private StringBuffer _getAccumSB() {
        if (this.accumSB == null) {
            this.accumSB = new StringBuffer();
        }
        return this.accumSB;
    }

    public StringBuffer append(String s) {
        StringBuffer sb = this._getAccumSB();
        if (sb.length() > 0) {
            return sb.append(s);
        }
        return sb.append(s);
    }

    public String toString() {
        return this._getAccumSB().toString();
    }

    public String AND_(String op) {
        if (op != null) {
            StringBuffer sb = this._getTempSB();
            sb.append(" AND ");
            sb.append(op);
            return sb.toString();
        }
        return "";
    }

    public String _AND_(String op1, String op2) {
        StringBuffer sb = this._getTempSB();
        sb.append(op1);
        if (op2 != null) {
            sb.append(" AND ");
            sb.append(op2);
        }
        return sb.toString();
    }

    public String AND(String op1, String op2) {
        return this.AND(op1, op2, null, null);
    }

    public String AND(String op1, String op2, String op3) {
        return this.AND(op1, op2, op3, null);
    }

    public String AND(String op1, String op2, String op3, String op4) {
        StringBuffer sb = this._getTempSB();
        sb.append("( ");
        sb.append(op1);
        if (op2 != null) {
            sb.append(" AND ");
            sb.append(op2);
        }
        if (op3 != null) {
            sb.append(" AND ");
            sb.append(op3);
        }
        if (op4 != null) {
            sb.append(" AND ");
            sb.append(op4);
        }
        sb.append(" )");
        return sb.toString();
    }

    public String AND(String op1, String op2, String op3, String op4, String op5) {
        StringBuffer sb = this._getTempSB();
        sb.append("( ");
        sb.append(op1);
        if (op2 != null) {
            sb.append(" AND ");
            sb.append(op2);
        }
        if (op3 != null) {
            sb.append(" AND ");
            sb.append(op3);
        }
        if (op4 != null) {
            sb.append(" AND ");
            sb.append(op4);
        }
        if (op5 != null) {
            sb.append(" AND ");
            sb.append(op5);
        }
        sb.append(" )");
        return sb.toString();
    }

    public String AND(String[] op) {
        StringBuffer sb = this._getTempSB();
        sb.append("( ");
        for (int i = 0; i < op.length; ++i) {
            if (i > 0) {
                sb.append(" AND ");
            }
            sb.append(op[i]);
        }
        sb.append(" )");
        return sb.toString();
    }

    public String OR_(String op) {
        if (op != null) {
            StringBuffer sb = this._getTempSB();
            sb.append(" OR ");
            sb.append(op);
            return sb.toString();
        }
        return "";
    }

    public String _OR_(String op1, String op2) {
        StringBuffer sb = this._getTempSB();
        sb.append(op1);
        if (op2 != null) {
            sb.append(" OR ");
            sb.append(op2);
        }
        return sb.toString();
    }

    public String OR(String op1, String op2) {
        return this.OR(op1, op2, null, null);
    }

    public String OR(String op1, String op2, String op3) {
        return this.OR(op1, op2, op3, null);
    }

    public String OR(String op1, String op2, String op3, String op4) {
        StringBuffer sb = this._getTempSB();
        sb.append("( ");
        sb.append(op1);
        if (op2 != null) {
            sb.append(" OR ");
            sb.append(op2);
        }
        if (op3 != null) {
            sb.append(" OR ");
            sb.append(op3);
        }
        if (op4 != null) {
            sb.append(" OR ");
            sb.append(op4);
        }
        sb.append(" )");
        return sb.toString();
    }

    public String OR(String[] op) {
        StringBuffer sb = this._getTempSB();
        sb.append("( ");
        for (int i = 0; i < op.length; ++i) {
            if (i > 0) {
                sb.append(" OR ");
            }
            sb.append(op[i]);
        }
        sb.append(" )");
        return sb.toString();
    }

    public String EQ(String fld, Object value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        sb.append(DBProvider.getProvider().quoteColumnName(fld));
        sb.append("=").append(this._quoteValue(fld, value));
        sb.append(")");
        return sb.toString();
    }

    public String EQ(String fld, int value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        sb.append(DBProvider.getProvider().quoteColumnName(fld));
        sb.append("=").append(value);
        sb.append(")");
        return sb.toString();
    }

    public String EQ(String fld, long value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        sb.append(DBProvider.getProvider().quoteColumnName(fld));
        sb.append("=").append(value);
        sb.append(")");
        return sb.toString();
    }

    public String EQ(String fld, double value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        sb.append(DBProvider.getProvider().quoteColumnName(fld));
        sb.append("=").append(value);
        sb.append(")");
        return sb.toString();
    }

    public String EQ(String fld, boolean value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        if (value) {
            sb.append(DBProvider.getProvider().quoteColumnName(fld));
            sb.append("!=0");
        } else {
            sb.append(DBProvider.getProvider().quoteColumnName(fld));
            sb.append("=0");
        }
        sb.append(")");
        return sb.toString();
    }

    public String NE(String fld, Object value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        sb.append(DBProvider.getProvider().quoteColumnName(fld));
        sb.append("!=").append(this._quoteValue(fld, value));
        sb.append(")");
        return sb.toString();
    }

    public String NE(String fld, int value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        sb.append(DBProvider.getProvider().quoteColumnName(fld));
        sb.append("!=").append(value);
        sb.append(")");
        return sb.toString();
    }

    public String NE(String fld, long value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        sb.append(DBProvider.getProvider().quoteColumnName(fld));
        sb.append("!=").append(value);
        sb.append(")");
        return sb.toString();
    }

    public String NE(String fld, double value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        sb.append(DBProvider.getProvider().quoteColumnName(fld));
        sb.append("!=").append(value);
        sb.append(")");
        return sb.toString();
    }

    public String NE(String fld, boolean value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        if (value) {
            sb.append(DBProvider.getProvider().quoteColumnName(fld));
            sb.append("=0");
        } else {
            sb.append(DBProvider.getProvider().quoteColumnName(fld));
            sb.append("!=0");
        }
        sb.append(")");
        return sb.toString();
    }

    public String GT(String fld, Object value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        sb.append(DBProvider.getProvider().quoteColumnName(fld));
        sb.append(">").append(this._quoteValue(fld, value));
        sb.append(")");
        return sb.toString();
    }

    public String GT(String fld, int value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        sb.append(DBProvider.getProvider().quoteColumnName(fld));
        sb.append(">").append(value);
        sb.append(")");
        return sb.toString();
    }

    public String GT(String fld, long value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        sb.append(DBProvider.getProvider().quoteColumnName(fld));
        sb.append(">").append(value);
        sb.append(")");
        return sb.toString();
    }

    public String GT(String fld, double value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        sb.append(DBProvider.getProvider().quoteColumnName(fld));
        sb.append(">").append(value);
        sb.append(")");
        return sb.toString();
    }

    public String GE(String fld, Object value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        sb.append(DBProvider.getProvider().quoteColumnName(fld));
        sb.append(">=").append(this._quoteValue(fld, value));
        sb.append(")");
        return sb.toString();
    }

    public String GE(String fld, int value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        sb.append(DBProvider.getProvider().quoteColumnName(fld));
        sb.append(">=").append(value);
        sb.append(")");
        return sb.toString();
    }

    public String GE(String fld, long value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        sb.append(DBProvider.getProvider().quoteColumnName(fld));
        sb.append(">=").append(value);
        sb.append(")");
        return sb.toString();
    }

    public String GE(String fld, double value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        sb.append(DBProvider.getProvider().quoteColumnName(fld));
        sb.append(">=").append(value);
        sb.append(")");
        return sb.toString();
    }

    public String LT(String fld, Object value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        sb.append(DBProvider.getProvider().quoteColumnName(fld));
        sb.append("<").append(this._quoteValue(fld, value));
        sb.append(")");
        return sb.toString();
    }

    public String LT(String fld, int value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        sb.append(DBProvider.getProvider().quoteColumnName(fld));
        sb.append("<").append(value);
        sb.append(")");
        return sb.toString();
    }

    public String LT(String fld, long value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        sb.append(DBProvider.getProvider().quoteColumnName(fld));
        sb.append("<").append(value);
        sb.append(")");
        return sb.toString();
    }

    public String LT(String fld, double value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        sb.append(DBProvider.getProvider().quoteColumnName(fld));
        sb.append("<").append(value);
        sb.append(")");
        return sb.toString();
    }

    public String LE(String fld, Object value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        sb.append(DBProvider.getProvider().quoteColumnName(fld));
        sb.append("<=").append(this._quoteValue(fld, value));
        sb.append(")");
        return sb.toString();
    }

    public String LE(String fld, int value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        sb.append(DBProvider.getProvider().quoteColumnName(fld));
        sb.append("<=").append(value);
        sb.append(")");
        return sb.toString();
    }

    public String LE(String fld, long value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        sb.append(DBProvider.getProvider().quoteColumnName(fld));
        sb.append("<=").append(value);
        sb.append(")");
        return sb.toString();
    }

    public String LE(String fld, double value) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        sb.append(DBProvider.getProvider().quoteColumnName(fld));
        sb.append("<=").append(value);
        sb.append(")");
        return sb.toString();
    }

    public String LIKE(String fld, String value) {
        if (fld != null) {
            String likeVal = StringTools.replace(value != null ? value : "", "*", "%");
            if (likeVal.indexOf("%") < 0) {
                likeVal = likeVal + "%";
            }
            StringBuffer sb = this._getTempSB();
            sb.append("(");
            sb.append(DBProvider.getProvider().quoteColumnName(fld));
            sb.append(" like ").append(this._quoteValue(fld, likeVal));
            sb.append(")");
            return sb.toString();
        }
        return "";
    }

    public String STARTSWITH(String fld, String value) {
        return this.LIKE(fld, value + "*");
    }

    public String INLIST(String fld, Iterable<?> list) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        int i = 0;
        for (Object val : list) {
            if (i++ > 0) {
                sb.append(" OR ");
            }
            sb.append(DBProvider.getProvider().quoteColumnName(fld));
            sb.append("=").append(this._quoteValue(fld, val));
        }
        sb.append(")");
        return sb.toString();
    }

    public String INLIST(String fld, Object[] list) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        for (int i = 0; i < list.length; ++i) {
            if (i > 0) {
                sb.append(" OR ");
            }
            sb.append(DBProvider.getProvider().quoteColumnName(fld));
            sb.append("=").append(this._quoteValue(fld, list[i]));
        }
        sb.append(")");
        return sb.toString();
    }

    public String INLIST(String fld, int[] list) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        for (int i = 0; i < list.length; ++i) {
            if (i > 0) {
                sb.append(" OR ");
            }
            sb.append(DBProvider.getProvider().quoteColumnName(fld));
            sb.append("=").append(list[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    public String INLIST(String fld, long[] list) {
        StringBuffer sb = this._getTempSB();
        sb.append("(");
        for (int i = 0; i < list.length; ++i) {
            if (i > 0) {
                sb.append(" OR ");
            }
            sb.append(DBProvider.getProvider().quoteColumnName(fld));
            sb.append("=").append(list[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    public String WHERE_(String conditions) {
        StringBuffer sb = this._getTempSB();
        if (!StringTools.isBlank(conditions)) {
            sb.append(" WHERE ");
            sb.append(conditions);
        }
        return sb.toString();
    }

    public String WHERE(String conditions) {
        StringBuffer sb = this._getTempSB();
        if (!StringTools.isBlank(conditions)) {
            String c = conditions.trim();
            if (c.startsWith("AND ")) {
                c = c.substring(4);
            } else if (c.startsWith("OR ")) {
                c = c.substring(3);
            }
            sb.append(" WHERE ( ");
            sb.append(c);
            sb.append(" )");
        }
        return sb.toString();
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        DBFactory fact = null;
        String FLD_this = "this";
        String FLD_that = "that";
        String val = "value";
        DBWhere wh = new DBWhere(fact);
        String where_1 = wh.WHERE(wh.AND(wh.OR(wh.EQ(FLD_this, val), wh.EQ(FLD_that, val)), wh.OR(wh.EQ(FLD_this, val), wh.EQ(FLD_that, val))));
        Print.sysPrintln(where_1, new Object[0]);
        String where_2 = wh.WHERE(wh.OR(wh.AND(wh.GT(FLD_this, val), wh.LE(FLD_that, val)), wh.AND(wh.GE(FLD_this, val), wh.LT(FLD_that, val))));
        Print.sysPrintln(where_2, new Object[0]);
        String where_3 = wh.WHERE(wh.EQ(FLD_this, val));
        Print.sysPrintln(where_3, new Object[0]);
    }
}

