/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.dbtools;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class DBTableIndexMap {
    private String utableName = null;
    private int count = 0;
    private Set<String> alternateIndexes = null;
    private Map<String, Set<String>> mapFieldsToIndexes = null;
    private Map<String, Set<String>> mapIndexesToFields = null;

    public DBTableIndexMap(String utableName) {
        this.utableName = utableName;
        this.count = 0;
        this.alternateIndexes = null;
        this.mapFieldsToIndexes = new HashMap<String, Set<String>>();
        this.mapIndexesToFields = new HashMap<String, Set<String>>();
    }

    public void addIndexColumn(String ndxName, String colName) {
        if (ndxName != null && !ndxName.equals("") && colName != null && !colName.equals("")) {
            Set<String> ndxSet;
            ++this.count;
            if (!ndxName.equalsIgnoreCase("PRIMARY")) {
                if (this.alternateIndexes == null) {
                    this.alternateIndexes = new HashSet<String>();
                }
                this.alternateIndexes.add(ndxName);
            }
            if ((ndxSet = this.mapFieldsToIndexes.get(colName)) == null) {
                ndxSet = new HashSet<String>();
                this.mapFieldsToIndexes.put(colName, ndxSet);
            }
            ndxSet.add(ndxName);
            Set<String> colSet = this.mapIndexesToFields.get(ndxName);
            if (colSet == null) {
                colSet = new HashSet<String>();
                this.mapIndexesToFields.put(ndxName, colSet);
            }
            colSet.add(colName);
        }
    }

    public Set<String> getAlternateIndexes() {
        return this.alternateIndexes;
    }

    public Set<String> getIndexes() {
        return this.mapIndexesToFields.keySet();
    }

    public Set<String> getIndexesForColumn(String colName) {
        return colName != null ? this.mapFieldsToIndexes.get(colName) : null;
    }

    public Set<String> getColumns() {
        return this.mapFieldsToIndexes.keySet();
    }

    public Set<String> getColumnsForIndex(String ndxName) {
        return ndxName != null ? this.mapIndexesToFields.get(ndxName) : null;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }
}

