/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.dbtools;

import java.util.Set;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordKey;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class DBSelect<gDBR extends DBRecord> {
    private DBFactory<gDBR> factory = null;
    private String[] selectFields = null;
    private String utableName = null;
    private String where = null;
    private String[] orderByFields = null;
    private boolean ascending = true;
    private long limit = 0L;
    private long offset = 0L;

    public DBSelect(DBFactory<gDBR> fact) {
        this.factory = fact;
    }

    public DBSelect(DBFactory<gDBR> fact, String where) {
        this(fact);
        this.setWhere(where);
    }

    public DBSelect(DBFactory<gDBR> fact, DBWhere where) {
        this(fact);
        this.setWhere(where);
    }

    public boolean hasFactory() {
        return this.factory != null;
    }

    public DBFactory<gDBR> getFactory() {
        return this.factory;
    }

    public void setSelectedFields(Set<String> sf) {
        if (ListTools.isEmpty(sf)) {
            this.selectFields = null;
        } else {
            this.setSelectedFields(sf.toArray(new String[sf.size()]));
        }
    }

    public void setSelectedFields(String ... sf) {
        if (ListTools.isEmpty(sf)) {
            this.selectFields = null;
        } else {
            DBFactory<gDBR> fact = this.getFactory();
            if (fact != null) {
                for (int i = 0; i < sf.length; ++i) {
                    if (sf[i] == null) {
                        Print.logError("DBFactory field is null: %s.%s", fact.getUntranslatedTableName(), sf[i]);
                        continue;
                    }
                    if (fact.hasField(sf[i]) || sf[i].equalsIgnoreCase(DBProvider.FLD_COUNT())) continue;
                    Print.logError("DBFactory field does not exist: %s.%s", fact.getUntranslatedTableName(), sf[i]);
                }
            }
            this.selectFields = sf;
        }
    }

    public boolean hasSelectedFields() {
        return this.selectFields != null;
    }

    public String[] getSelectedFields() {
        return this.selectFields != null && this.selectFields.length > 0 ? this.selectFields : null;
    }

    public void setUntranslatedTableName(String utableName) {
        this.utableName = !StringTools.isBlank(utableName) ? utableName : null;
    }

    public String getUntranslatedTableName() {
        if (this.utableName != null) {
            return this.utableName;
        }
        if (this.hasFactory()) {
            return this.getFactory().getUntranslatedTableName();
        }
        return "UNKNOWN";
    }

    public String getTranslatedTableName(DBProvider dbp) {
        return DBProvider.translateTableName(dbp, this.getUntranslatedTableName());
    }

    public String getTranslatedTableName() {
        return DBProvider.translateTableName(this.getUntranslatedTableName());
    }

    public DBWhere createDBWhere() {
        return new DBWhere(this.getFactory());
    }

    public void setWhere(DBWhere wh) {
        this.setWhere(wh != null ? wh.toString() : null);
    }

    public void setWhere(String wh) {
        this.where = StringTools.isBlank(wh) ? null : (StringTools.startsWithIgnoreCase(wh = wh.trim(), "WHERE ") ? wh : "WHERE ( " + wh + " )");
    }

    public boolean hasWhere() {
        return this.where != null;
    }

    public String getWhere() {
        return this.where;
    }

    public void setOrderByFields(String ... obf) {
        if (obf == null || obf.length == 0) {
            this.orderByFields = null;
        } else {
            DBFactory<gDBR> fact = this.getFactory();
            if (fact != null) {
                for (int i = 0; i < obf.length; ++i) {
                    if (obf[i] == null) {
                        Print.logError("DBFactory field is null: %s.%s", fact.getUntranslatedTableName(), obf[i]);
                        continue;
                    }
                    if (fact.hasField(obf[i])) continue;
                    Print.logError("DBFactory field does not exist: %s.%s", fact.getUntranslatedTableName(), obf[i]);
                }
            }
            this.orderByFields = obf;
        }
    }

    public boolean hasOrderByFields() {
        return this.orderByFields != null;
    }

    public void setOrderAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public boolean isOrderAscending() {
        return this.ascending;
    }

    public String[] getOrderByFields() {
        return this.orderByFields != null && this.orderByFields.length > 0 ? this.orderByFields : null;
    }

    public boolean supportsLimit() {
        return DBProvider.getProvider().supportsLimit();
    }

    public void setLimit(long limit) {
        long l = this.limit = limit > 0L ? limit : 0L;
        if (this.limit > 0L && !this.supportsLimit()) {
            Print.logStackTrace("Warning: LIMIT not supported by DBProvider: " + this.limit);
        }
    }

    public boolean hasLimit() {
        return this.limit > 0L;
    }

    public long getLimit() {
        return this.limit;
    }

    public boolean supportsOffset() {
        return DBProvider.getProvider().supportsOffset();
    }

    public void setOffset(long offset) {
        long l = this.offset = offset > 0L ? offset : -1L;
        if (this.offset > 0L && !this.supportsOffset()) {
            Print.logStackTrace("Warning: OFFSET not supported by DBProvider: " + this.offset);
        }
    }

    public boolean hasOffset() {
        return this.offset > 0L;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setLastRecordKey(DBRecordKey<gDBR> rcdKey) {
    }

    public String toString(String dbpName) {
        DBProvider dbp = DBProvider.getProvider(dbpName);
        if (dbp != null) {
            return this._toString(dbp, true);
        }
        Print.logWarn("DBProvider not found: " + dbpName, new Object[0]);
        return "";
    }

    public String toString() {
        DBProvider dbp = DBProvider.getProvider();
        return this._toString(dbp, true);
    }

    private String _toString(DBProvider dbp, boolean inclSelect) {
        int i;
        String[] fld;
        int dbid = dbp.getID();
        StringBuffer sb = new StringBuffer();
        if (inclSelect) {
            sb.append("SELECT ");
            if (dbid == 4 && this.hasLimit()) {
                sb.append("TOP ").append(this.getLimit()).append(" ");
            }
            if (this.hasSelectedFields()) {
                fld = this.getSelectedFields();
                for (i = 0; i < fld.length; ++i) {
                    if (i > 0) {
                        sb.append(",");
                    }
                    sb.append(dbp.quoteColumnName(fld[i]));
                }
            } else {
                sb.append("*");
            }
            sb.append(" FROM ");
            sb.append(dbp.quoteTableName(this.getTranslatedTableName(dbp)));
        }
        if (this.hasWhere()) {
            sb.append(" ").append(this.getWhere());
        }
        if (this.hasOrderByFields()) {
            sb.append(" ORDER BY ");
            fld = this.getOrderByFields();
            for (i = 0; i < fld.length; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(dbp.quoteColumnName(fld[i]));
            }
            if (!this.isOrderAscending()) {
                sb.append(" DESC");
            }
        }
        if (this.hasLimit()) {
            switch (dbid) {
                case 1: {
                    sb.append(" LIMIT ").append(this.getLimit());
                    if (!this.hasOffset()) break;
                    sb.append(" OFFSET ").append(this.getOffset());
                    break;
                }
                case 2: {
                    sb.append(" LIMIT ").append(this.getLimit());
                    if (!this.hasOffset()) break;
                    sb.append(" OFFSET ").append(this.getOffset());
                    break;
                }
                case 4: {
                    break;
                }
            }
        }
        return sb.toString();
    }
}

