/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.dbtools;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Set;
import org.opengts.dbtools.DBAlternateIndex;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBDelete;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBFieldValues;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.ServiceRequest;
import org.opengts.util.StringTools;
import org.opengts.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class DBRecordKey<gDBR extends DBRecord> {
    public static final String FLD_autoIndex = "autoIndex";
    private DBFieldValues keyValues = null;
    private DBFieldValues fieldValues = null;
    private gDBR record = null;
    private Set<String> taggedFields = null;

    protected DBRecordKey() {
    }

    public abstract DBFactory<gDBR> getFactory();

    public String getUntranslatedTableName() {
        return this.getFactory().getUntranslatedTableName();
    }

    public String getTranslatedTableName() {
        return this.getFactory().getTranslatedTableName();
    }

    public DBField[] getFields() {
        return this.getFactory().getFields();
    }

    public DBField getField(String fldName) {
        return this.getFactory().getField(fldName);
    }

    public DBField[] getKeyFields() {
        return this.getFactory().getKeyFields();
    }

    protected DBField[] getAltKeyFields(String indexName) {
        DBAlternateIndex altKey = this.getFactory().getAlternateIndex(indexName);
        return altKey != null ? altKey.getFields() : null;
    }

    public Set<String> getTaggedFieldNames() {
        return this.taggedFields;
    }

    public void setTaggedFieldNames(Set<String> taggedFields) {
        this.taggedFields = taggedFields;
    }

    public boolean hasTaggedFields() {
        return !ListTools.isEmpty(this.taggedFields);
    }

    public boolean isTaggedFieldName(String fldName) {
        return this.taggedFields != null && this.taggedFields.contains(fldName);
    }

    public boolean isFullKey() {
        DBField[] keyFlds = this.getKeyFields();
        if (ListTools.isEmpty(keyFlds)) {
            return false;
        }
        DBFieldValues keyVals = this.getKeyValues();
        for (int i = 0; i < keyFlds.length; ++i) {
            String keyName = keyFlds[i].getName();
            if (keyVals.hasFieldValue(keyName)) continue;
            return false;
        }
        return true;
    }

    public boolean isPartialKey() {
        return !this.isFullKey();
    }

    public DBFieldValues getKeyValues() {
        if (this.keyValues == null) {
            if (DBField.AllowUpdateKeyFields()) {
                this.keyValues = new DBFieldValues(this, this.getFieldValues());
                this.keyValues.setName("Keys");
            } else {
                this.keyValues = this.getFieldValues();
            }
        }
        return this.keyValues;
    }

    public boolean hasKeyValue(String fldName) {
        return this.getKeyValues().hasFieldValue(fldName);
    }

    public Object getKeyValue(String fldName) {
        return this.getKeyValues().getFieldValue(fldName);
    }

    public String getKeyValueAsString(String fldName) {
        return this.getKeyValues().getFieldValueAsString(fldName);
    }

    public boolean setKeyValue(String fldName, Object val) {
        return this.getKeyValues().setFieldValue(fldName, val);
    }

    public boolean setKeyValue(String fldName, boolean val) {
        return this.getKeyValues().setFieldValue(fldName, val);
    }

    public boolean setKeyValue(String fldName, int val) {
        return this.getKeyValues().setFieldValue(fldName, val);
    }

    public boolean setKeyValue(String fldName, long val) {
        return this.getKeyValues().setFieldValue(fldName, val);
    }

    public boolean setKeyValue(String fldName, double val) {
        return this.getKeyValues().setFieldValue(fldName, val);
    }

    public DBFieldValues getFieldValues() {
        if (this.fieldValues == null) {
            this.fieldValues = new DBFieldValues(this);
            this.fieldValues.setName("Fields");
        }
        return this.fieldValues;
    }

    public boolean hasFieldValue(String fldName) {
        return this.getFieldValues().hasFieldValue(fldName);
    }

    public Object getFieldValue(String fldName) {
        return this.getFieldValues().getFieldValue(fldName);
    }

    public String getFieldValueAsString(String fldName) {
        return this.getFieldValues().getFieldValueAsString(fldName);
    }

    public boolean setFieldValue(String fldName, Object val) {
        return this.getFieldValues().setFieldValue(fldName, val);
    }

    public boolean setFieldValue(String fldName, boolean val) {
        return this.getFieldValues().setFieldValue(fldName, val);
    }

    public boolean setFieldValue(String fldName, int val) {
        return this.getFieldValues().setFieldValue(fldName, val);
    }

    public boolean setFieldValue(String fldName, long val) {
        return this.getFieldValues().setFieldValue(fldName, val);
    }

    public boolean setFieldValue(String fldName, double val) {
        return this.getFieldValues().setFieldValue(fldName, val);
    }

    public boolean exists() throws DBException {
        try {
            return this._exists(null, DBWhere.KEY_FULL);
        }
        catch (SQLException sqe) {
            DBProvider.sendJdbcCommunicationExceptionNotification(sqe);
            String tn = this.getUntranslatedTableName();
            throw new DBException("Record existance " + tn + "='" + this + "'", sqe);
        }
    }

    public boolean exists(int whereKeyType) throws DBException {
        try {
            return this._exists(null, whereKeyType);
        }
        catch (SQLException sqe) {
            String tn = this.getUntranslatedTableName();
            throw new DBException("Record existance " + tn + "='" + this + "'", sqe);
        }
    }

    public boolean exists(boolean fullKeyOnly) throws DBException {
        try {
            int whereKeyType = fullKeyOnly ? DBWhere.KEY_FULL : DBWhere.KEY_PARTIAL_FIRST;
            return this._exists(null, whereKeyType);
        }
        catch (SQLException sqe) {
            String tn = this.getUntranslatedTableName();
            throw new DBException("Record existance " + tn + "='" + this + "'", sqe);
        }
    }

    public boolean altIndexExists(String indexName) throws DBException {
        try {
            if (indexName == null) {
                indexName = "altIndex";
            }
            return this._exists(indexName, DBWhere.KEY_FULL);
        }
        catch (SQLException sqe) {
            String tn = this.getUntranslatedTableName();
            throw new DBException("Record existance " + tn + "='" + this + "'", sqe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean _exists(String altIndexName, int whereKeyType) throws SQLException, DBException {
        boolean exists;
        block23: {
            DBField lastField;
            DBField[] kfld;
            boolean usePrimaryKey = StringTools.isBlank(altIndexName);
            DBField[] dBFieldArray = kfld = usePrimaryKey ? this.getKeyFields() : this.getAltKeyFields(altIndexName);
            if (ListTools.isEmpty(kfld)) {
                throw new DBException("No keys found!");
            }
            if (whereKeyType == DBWhere.KEY_FULL && (lastField = kfld[kfld.length - 1]).isAutoIncrement() && !this.getKeyValues().hasFieldValue(lastField.getName())) {
                return false;
            }
            String firstKey = kfld[0].getName();
            DBSelect<gDBR> dsel = new DBSelect<gDBR>(this.getFactory());
            dsel.setSelectedFields(firstKey);
            dsel.setWhere(this._getWhereClause(altIndexName, whereKeyType));
            DBConnection dbc = null;
            Statement stmt = null;
            ResultSet rs = null;
            exists = false;
            try {
                dbc = DBConnection.getDefaultConnection();
                stmt = dbc.execute(dsel.toString());
                rs = stmt.getResultSet();
                exists = rs.next();
            }
            catch (SQLException sqe) {
                if (sqe.getErrorCode() == 1100) {
                    Print.logError("SQL Lock Error: " + sqe, new Object[0]);
                    Print.logError("Hackery! Forcing lock on table: " + this.getUntranslatedTableName(), new Object[0]);
                    if (DBProvider.lockTableForRead(this.getUntranslatedTableName(), true)) {
                        stmt = dbc.execute(dsel.toString());
                        rs = stmt.getResultSet();
                        exists = rs.next();
                        DBProvider.unlockTables();
                    }
                    break block23;
                }
                throw sqe;
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable t) {}
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable t) {}
                }
                DBConnection.release(dbc);
            }
        }
        return exists;
    }

    public boolean parentsExist() throws DBException {
        DBFactory<gDBR> dbFact = this.getFactory();
        DBFieldValues myKeyVals = this.getKeyValues();
        List<String> parentList = dbFact.getParentTables();
        for (String parentTable : parentList) {
            DBField[] parentKeyFlds;
            Print.logInfo("[%s] Parent table: %s", this.getUntranslatedTableName(), parentTable);
            DBFactory parentFact = DBFactory.getFactoryByName(parentTable);
            if (parentFact == null) {
                Print.logError("Unexpected error finding parent table: " + parentTable, new Object[0]);
                return false;
            }
            DBRecordKey parentKey = parentFact.createKey();
            for (DBField pkf : parentKeyFlds = parentFact.getKeyFields()) {
                String pfn = pkf.getName();
                DBField myKeyFld = this.getField(pfn);
                if (myKeyFld == null) {
                    Print.logError("Unexpected error finding field: [" + this.getUntranslatedTableName() + "] " + pfn, new Object[0]);
                    return false;
                }
                Object pkv = myKeyVals.getFieldValue(pfn);
                if (pkv == null) {
                    Print.logError("Unexpected error finding parent field: [" + parentTable + "] " + pfn, new Object[0]);
                    return false;
                }
                if (myKeyFld.isDefaultValue(pkv)) {
                    Print.logInfo("This key contains a global value, skipping parent check: " + parentTable, new Object[0]);
                    parentKey = null;
                    break;
                }
                parentKey.setKeyValue(pfn, pkv);
            }
            if (parentKey == null || parentKey.exists()) continue;
            Print.logError("Parent record does not exist: [" + parentTable + "] " + parentKey, new Object[0]);
            return false;
        }
        return true;
    }

    public void delete() throws DBException {
        this.delete(false);
    }

    public void delete(boolean delDeps) throws DBException {
        try {
            if (delDeps) {
                this._deleteDependencies();
            }
            int whereKeyType = DBWhere.KEY_FULL;
            this._delete(null, whereKeyType);
        }
        catch (SQLException sqe) {
            throw new DBException("Record deletion", sqe);
        }
    }

    public void altIndexDelete(String indexName) throws DBException {
        try {
            if (indexName == null) {
                indexName = "altIndex";
            }
            int whereKeyType = DBWhere.KEY_FULL;
            this._delete(indexName, whereKeyType);
        }
        catch (SQLException sqe) {
            throw new DBException("Record deletion", sqe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _delete(String altIndexName, int whereKeyType) throws SQLException, DBException {
        DBDelete ddel = new DBDelete(this.getFactory());
        ddel.setWhere(this._getWhereClause(altIndexName, whereKeyType));
        DBConnection dbc = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            dbc.executeUpdate(ddel.toString());
        }
        finally {
            DBConnection.release(dbc);
        }
    }

    protected void _deleteDependencies() throws DBException {
        DBField[] keyFlds = this.getKeyFields();
        DBFieldValues keyVals = this.getKeyValues();
        DBFactory<gDBR> fact = this.getFactory();
        DBFactory<DBRecord>[] childFact = fact.getChildFactories();
        for (int i = 0; i < childFact.length; ++i) {
            DBRecordKey<DBRecord> key = childFact[i].createKey();
            for (int k = 0; k < keyFlds.length; ++k) {
                String fldName = keyFlds[k].getName();
                if (!keyVals.hasFieldValue(fldName)) {
                    throw new DBException("Missing dependent key fields!");
                }
                Object fldValue = keyVals.getFieldValue(fldName);
                key.setKeyValue(fldName, fldValue);
            }
            try {
                int whereKeyType = DBWhere.KEY_PARTIAL_ALL;
                key._delete(null, whereKeyType);
                continue;
            }
            catch (SQLException sqe) {
                throw new DBException("Record deletion", sqe);
            }
        }
    }

    public String getWhereClause(int whereKeyType) throws DBException {
        return this._getWhereClause(null, whereKeyType);
    }

    protected String _getWhereClause(String altIndexName, int whereKeyType) throws DBException {
        DBField[] keyFlds;
        boolean usePrimaryKey = StringTools.isBlank(altIndexName);
        DBField[] dBFieldArray = keyFlds = usePrimaryKey ? this.getKeyFields() : this.getAltKeyFields(altIndexName);
        if (ListTools.isEmpty(keyFlds)) {
            throw new DBException("No keys defined: " + this.getUntranslatedTableName());
        }
        DBWhere dwh = new DBWhere(this.getFactory());
        DBFieldValues keyVals = this.getKeyValues();
        int keyCnt = 0;
        boolean hasPartialKey = false;
        for (int i = 0; i < keyFlds.length; ++i) {
            String m;
            String fldName = keyFlds[i].getName();
            if (keyVals.hasFieldValue(fldName)) {
                if (!hasPartialKey || whereKeyType == DBWhere.KEY_PARTIAL_ALL) {
                    String fev = dwh.EQ(fldName, keyVals.getFieldValueAsString(fldName));
                    if (keyCnt > 0) {
                        dwh.append(dwh.AND_(fev));
                    } else {
                        dwh.append(fev);
                    }
                    ++keyCnt;
                    continue;
                }
                m = "Additional partial key in 'WHERE' clause! [" + this.getUntranslatedTableName() + "." + fldName + "]";
                Print.logWarn("******************************************************************", new Object[0]);
                Print.logWarn(m, new Object[0]);
                Print.logWarn("******************************************************************", new Object[0]);
                continue;
            }
            if (i == 0 && whereKeyType != DBWhere.KEY_PARTIAL_ALL_EMPTY) {
                if (keyFlds[i].isAutoIncrement()) {
                    m = "First key field for 'WHERE' clause is 'auto_increment' and field is not present [" + this.getUntranslatedTableName() + "." + fldName + "]";
                    throw new DBException(m);
                }
                m = "Missing first key field for 'WHERE' clause! [" + this.getUntranslatedTableName() + "." + fldName + "]";
                throw new DBException(m);
            }
            if (whereKeyType == DBWhere.KEY_FULL) {
                m = "Missing key for 'WHERE' clause! [" + this.getUntranslatedTableName() + "." + fldName + "]";
                throw new DBException(m);
            }
            hasPartialKey = true;
        }
        return keyCnt > 1 ? dwh.WHERE(dwh.toString()) : dwh.WHERE_(dwh.toString());
    }

    gDBR _getDBRecord() {
        return this.record;
    }

    void _setDBRecord(DBRecord<gDBR> rcd) {
        this.record = rcd;
    }

    public gDBR getDBRecord() {
        return this.getDBRecord(false);
    }

    public gDBR getDBRecord(boolean reload) {
        if (this.record == null) {
            try {
                this.record = DBRecord._createDBRecord(this);
            }
            catch (DBException dbe) {
                Print.logStackTrace("Implementation error - cant' create DB record", dbe);
                return null;
            }
        }
        if (reload) {
            ((DBRecord)this.record).reload();
        }
        return this.record;
    }

    public gDBR getVirtualDBRecord(ServiceRequest servReq) throws DBException {
        String CMD_dbget = "dbget";
        String TAG_Response = servReq.getTagResponse();
        String TAG_Record = "Record";
        String ATTR_command = servReq.getAttrCommand();
        String ATTR_result = servReq.getAttrResult();
        Document xmlDoc = null;
        try {
            xmlDoc = servReq.sendRequest(CMD_dbget, new ServiceRequest.RequestBody(){

                @Override
                public StringBuffer appendRequestBody(StringBuffer sb, int indent) {
                    return DBRecordKey.this.toRequestXML(sb, indent);
                }
            });
        }
        catch (IOException ioe) {
            Print.logException("Error", ioe);
            throw new DBException("Request read error", ioe);
        }
        Element gtsResponse = xmlDoc.getDocumentElement();
        if (!gtsResponse.getTagName().equalsIgnoreCase(TAG_Response)) {
            Print.logError("Request XML does not start with '%s'", TAG_Response);
            throw new DBException("Response XML does not begin eith '" + TAG_Response + "'");
        }
        String cmd = StringTools.trim(gtsResponse.getAttribute(ATTR_command));
        String result = StringTools.trim(gtsResponse.getAttribute(ATTR_result));
        if (StringTools.isBlank(result)) {
            result = StringTools.trim(gtsResponse.getAttribute("type"));
        }
        if (!result.equalsIgnoreCase("success")) {
            Print.logError("Response indicates failure", new Object[0]);
            throw new DBException("Response does not indicate 'success'");
        }
        NodeList rcdList = XMLTools.getChildElements(gtsResponse, TAG_Record);
        if (rcdList.getLength() <= 0) {
            Print.logError("No 'Record' tags", new Object[0]);
            throw new DBException("GTSResponse does not contain any 'Record' tags");
        }
        Element rcdElem = (Element)rcdList.item(0);
        DBRecord<?> dbr = DBFactory.parseXML_DBRecord(rcdElem);
        dbr.setVirtual(true);
        return (gDBR)dbr;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.getClass().equals(other.getClass())) {
            DBField[] othrKfld;
            DBField[] thisKfld = this.getKeyFields();
            if (thisKfld.length != (othrKfld = ((DBRecordKey)other).getKeyFields()).length) {
                return false;
            }
            DBFieldValues thisFval = this.getFieldValues();
            DBFieldValues othrFval = ((DBRecordKey)other).getFieldValues();
            for (int i = 0; i < thisKfld.length; ++i) {
                if (!thisKfld[i].equals(othrKfld[i])) {
                    return false;
                }
                Object thisKey = thisFval.getFieldValue(thisKfld[i].getName());
                Object othrKey = othrFval.getFieldValue(othrKfld[i].getName());
                if (!(thisKey == null || othrKey == null ? thisKey != othrKey : !thisKey.equals(othrKey))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        DBField[] kf = this.getKeyFields();
        if (kf.length == 0) {
            return "<null>";
        }
        DBFieldValues fv = this.getFieldValues();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < kf.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(fv.getFieldValueAsString(kf[i].getName()));
        }
        return sb.toString();
    }

    public static void printXML(PrintStream out, DBRecordKey ... dbrk) {
        if (out != null) {
            DBRecordKey.printXML(new PrintWriter(out), dbrk);
            out.flush();
        }
    }

    public static void printXML(PrintWriter out, DBRecordKey ... dbrk) {
        if (out != null) {
            out.write("<RecordKeys>\n");
            for (int i = 0; i < dbrk.length; ++i) {
                dbrk[i].printXML(out, 4);
            }
            out.write("</RecordKeys>\n");
            out.flush();
        }
    }

    public void printXML(PrintWriter out, int indent) {
        this.printXML(out, indent, -1, false);
    }

    public void printXML(PrintWriter out, int indent, int sequence) {
        this.printXML(out, indent, sequence, false);
    }

    public void printXML(PrintWriter out, int indent, int sequence, boolean soapXML) {
        if (out != null) {
            out.write(this.toXML(null, indent, sequence, soapXML).toString());
            out.flush();
        }
    }

    public StringBuffer toXML(StringBuffer sb, int indent) {
        return this.toXML(sb, indent, -1, false);
    }

    public StringBuffer toXML(StringBuffer sb, int indent, int sequence) {
        return this.toXML(sb, indent, sequence, false);
    }

    public StringBuffer toXML(StringBuffer sb, int indent, int sequence, boolean soapXML) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        String prefix = StringTools.replicateString(" ", indent);
        DBRecordKey recKey = this;
        String utableName = recKey.getUntranslatedTableName();
        DBField[] keyFlds = recKey.getKeyFields();
        DBFieldValues keyVals = recKey.getKeyValues();
        String PFX1 = XMLTools.PREFIX(soapXML, indent);
        sb.append(PFX1);
        sb.append(XMLTools.startTAG(soapXML, "RecordKey", XMLTools.ATTR("table", utableName) + (sequence > 0 ? XMLTools.ATTR("sequence", sequence) : ""), false, true));
        DBFactory.writeXML_DBFields(sb, 2 * indent, keyFlds, keyVals, soapXML);
        sb.append(PFX1);
        sb.append(XMLTools.endTAG(soapXML, "RecordKey", true));
        return sb;
    }

    private StringBuffer toRequestXML(StringBuffer sb, int indent) {
        boolean isSoapReq = false;
        if (sb == null) {
            sb = new StringBuffer();
        }
        DBRecordKey recKey = this;
        String utableName = recKey.getUntranslatedTableName();
        DBField[] keyFlds = recKey.getKeyFields();
        DBFieldValues keyVals = recKey.getKeyValues();
        String PFX1 = XMLTools.PREFIX(isSoapReq, indent);
        sb.append(PFX1);
        sb.append(XMLTools.startTAG(isSoapReq, "Record", XMLTools.ATTR("table", utableName), false, true));
        DBFactory.writeXML_DBFields(sb, 2 * indent, keyFlds, keyVals, isSoapReq);
        sb.append(PFX1);
        sb.append(XMLTools.endTAG(isSoapReq, "Record", true));
        return sb;
    }

    public static boolean isValidIDChar(char ch) {
        if (Character.isLetterOrDigit(ch)) {
            return true;
        }
        if (ch == '.' || ch == '_') {
            return true;
        }
        return ch == '@' || ch == '&' || ch == '-';
    }

    public static String FilterID(String text) {
        if (text != null) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < text.length(); ++i) {
                char ch = Character.toLowerCase(text.charAt(i));
                if (!DBRecordKey.isValidIDChar(ch)) continue;
                sb.append(ch);
            }
            return sb.toString();
        }
        return "";
    }
}

