/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.dbtools;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBNotFoundException;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordKey;
import org.opengts.dbtools.DBSelect;
import org.opengts.util.ListTools;

public class DBRecordIterator<DBR extends DBRecord> {
    public static final long DEFAULT_LIMIT = 50L;
    private Iterator<DBR> iterator = null;
    private DBSelect<DBR> dbSelector = null;
    private long offset = 0L;
    private long limit = 50L;
    private DBRecordKey<DBR> lastRecordKey = null;

    public DBRecordIterator(DBR[] records) {
        this.iterator = ListTools.toIterator(records);
        this.dbSelector = null;
    }

    public DBRecordIterator(Iterable<DBR> iterable) {
        this.iterator = ListTools.toIterator(iterable);
        this.dbSelector = null;
    }

    public DBRecordIterator(Iterator<DBR> iterator) {
        this.iterator = iterator;
        this.dbSelector = null;
    }

    public DBRecordIterator(DBSelect<DBR> dbSel) throws DBException {
        this.iterator = null;
        this.dbSelector = dbSel;
        if (this.dbSelector != null) {
            if (!this.dbSelector.supportsLimit()) {
                throw new DBException("DB provider does not support LIMIT");
            }
            if (!this.dbSelector.supportsOffset()) {
                throw new DBException("DB provider does not support OFFSET");
            }
        }
    }

    public long getLimit() {
        return this.limit;
    }

    public void setLimit(long limit) {
        this.limit = limit > 0L ? limit : 50L;
    }

    public boolean hasNext() throws DBException {
        try {
            return this.fetch().hasNext();
        }
        catch (DBNotFoundException nfe) {
            return false;
        }
    }

    public DBR next() throws DBException, DBNotFoundException {
        try {
            return (DBR)((DBRecord)this.fetch().next());
        }
        catch (NoSuchElementException nse) {
            throw new DBNotFoundException("", nse);
        }
    }

    protected DBSelect<DBR> getDBSelect() {
        return this.dbSelector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator<DBR> fetch() throws DBException, DBNotFoundException {
        if (this.iterator != null && this.iterator.hasNext()) {
            return this.iterator;
        }
        if (this.dbSelector == null) {
            throw new DBNotFoundException("No db selector");
        }
        this.dbSelector.setOffset(this.offset);
        this.dbSelector.setLimit(this.limit);
        this.dbSelector.setLastRecordKey(this.lastRecordKey);
        DBRecord[] rcdArry = null;
        rcdArry = DBRecord.select(this.dbSelector, null);
        if (rcdArry == null || rcdArry.length == 0) {
            this.dbSelector = null;
            this.iterator = null;
            this.lastRecordKey = null;
            throw new DBNotFoundException("No more records");
        }
        this.lastRecordKey = rcdArry[rcdArry.length - 1].getRecordKey();
        this.offset += (long)rcdArry.length;
        this.iterator = ListTools.toIterator(rcdArry);
        return this.iterator;
    }
}

