/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.dbtools;

import java.io.PrintWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Vector;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBFieldValues;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecordHandler;
import org.opengts.dbtools.DBRecordKey;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.DateTime;
import org.opengts.util.ListTools;
import org.opengts.util.MethodAction;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;
import org.opengts.util.XMLTools;

public abstract class DBRecord<gDBR extends DBRecord> {
    public static final int NOTIFY_GROUP = 1;
    public static final int ID_SIZE = 32;
    public static final String PSEUDO_FIELD_CHAR = "$";
    public static final String FLD_description = "description";
    public static final String FLD_creationTime = "creationTime";
    public static final String FLD_creationMillis = "creationMillis";
    public static final String FLD_lastUpdateTime = "lastUpdateTime";
    public static final String FLD_lastUpdateUser = "lastUpdateUser";
    private static String currentUser = "";
    private static final Object sqlExceptionCountLock = new Object();
    private static long totalSQLErrors = 0L;
    private static long totalSQLCommErrors = 0L;
    private static long lastSQLCommErrorTimeMS = 0L;
    private DBRecordKey<gDBR> recordKey = null;
    private boolean changed = false;
    private Vector<DBChangeListener> changeNotification = null;
    private boolean isVirtual = false;
    protected boolean isValidating = false;
    protected SQLException lastSQLException = null;
    protected boolean hasError = false;
    protected String errorDescription = null;
    protected Set<String> excludedUpdateFields = null;
    protected RTProperties tempProps = null;

    public static String getTableDescription(Locale loc) {
        return "";
    }

    public static String adjustStringLength(String v, int maxLen) {
        String val = StringTools.trim(v);
        if (maxLen > 0 && val.length() > maxLen) {
            val = val.substring(0, maxLen).trim();
        }
        return val;
    }

    public static String adjustStringLength_1(String v, int maxLen) {
        String val = StringTools.trim(v);
        if (maxLen > 1 && val.length() >= maxLen) {
            val = val.substring(0, maxLen - 1).trim();
        }
        return val;
    }

    public static <T extends DBRecord> long getRecordCount(DBFactory<T> fact) throws DBException {
        return DBRecord.getRecordCount(fact, "");
    }

    public static <T extends DBRecord> long getRecordCount(DBFactory<T> fact, StringBuffer where) throws DBException {
        return DBRecord.getRecordCount(fact, where != null ? where.toString() : null);
    }

    public static <T extends DBRecord> long getRecordCount(DBFactory<T> fact, String where) throws DBException {
        if (fact == null || where == null) {
            return 0L;
        }
        return DBRecord.getRecordCount(new DBSelect<T>(fact, where));
    }

    public static <T extends DBRecord> long getRecordCount(DBFactory<T> fact, DBWhere where) throws DBException {
        if (fact == null || where == null) {
            return 0L;
        }
        return DBRecord.getRecordCount(new DBSelect<T>(fact, where));
    }

    public static <T extends DBRecord> long getRecordCount(DBSelect<T> dsel) throws DBException {
        if (dsel == null) {
            return 0L;
        }
        DBFactory<T> fact = dsel.getFactory();
        if (fact == null) {
            return 0L;
        }
        boolean innodb = fact.isMySQLInnoDB();
        if (innodb) {
            if (!dsel.hasWhere()) {
                Print.logDebug("Using TableStatus for InnoDB record count ...", new Object[0]);
                return fact.getMySQLTableStatus();
            }
            if (!fact.getAllowInnoDBCOUNT()) {
                Print.logError("'COUNT(*)' not allowed for this InnoDB!", new Object[0]);
                return -1L;
            }
            Print.logDebug("Warn: Using 'COUNT(*)' for InnoDB query ...", new Object[0]);
        }
        dsel.setSelectedFields(DBProvider.FLD_COUNT());
        dsel.setOrderByFields(null);
        DBConnection dbc = null;
        Statement stmt = null;
        ResultSet rs = null;
        long count = 0L;
        try {
            dbc = DBConnection.getDefaultConnection();
            stmt = dbc.execute(dsel.toString());
            rs = stmt.getResultSet();
            if (rs.next()) {
                count = rs.getLong(1);
            }
        }
        catch (SQLException sqe) {
            throw new DBException("Record Count", sqe);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
            DBConnection.release(dbc);
        }
        return count;
    }

    public static String GetCurrentUser() {
        if (!StringTools.isBlank(currentUser)) {
            return currentUser;
        }
        String userID = RTConfig.getString("session.user", "");
        return userID;
    }

    public static void SetCurrentUser(String user) {
    }

    static <T extends DBRecord> T _createDBRecord(DBRecordKey<T> rcdKey) throws DBException {
        DBFactory<T> factory = rcdKey.getFactory();
        Class<T> dbrClass = factory.getRecordClass();
        Class<DBRecordKey<T>> dbkClass = factory.getKeyClass();
        try {
            Constructor<T> con = dbrClass.getConstructor(dbkClass);
            return (T)((DBRecord)con.newInstance(rcdKey));
        }
        catch (Throwable t) {
            throw new DBException("Unable to create DBRecord", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void incrementSQLExceptionCount(SQLException sqe) {
        if (sqe != null) {
            Object object = sqlExceptionCountLock;
            synchronized (object) {
                ++totalSQLErrors;
                if (DBException.isCommunicationsException(sqe)) {
                    long nowTimeMS = System.currentTimeMillis();
                    ++totalSQLCommErrors;
                    lastSQLCommErrorTimeMS = nowTimeMS;
                }
            }
        }
    }

    public DBRecord() {
    }

    protected DBRecord(DBRecordKey<gDBR> key) {
        this();
        this.recordKey = key;
        if (this.recordKey != null) {
            this.recordKey._setDBRecord(this);
        }
    }

    public DBRecordKey<gDBR> getRecordKey() {
        if (this.recordKey == null) {
            try {
                this.recordKey = this.getFactory(true).createKey();
                this.recordKey._setDBRecord(this);
            }
            catch (DBException dbe) {
                dbe.printException();
                return null;
            }
        }
        return this.recordKey;
    }

    public static <T extends DBRecord> DBFactory<T> getFactory(DBRecord<T> dbr) {
        return dbr != null ? dbr._getFactory() : null;
    }

    public DBFactory<gDBR> getFactory(boolean required) throws DBException {
        DBFactory<gDBR> fact = this._getFactory();
        if (required && fact == null) {
            throw new DBException("No DBFactory defined for this DBRecord");
        }
        return fact;
    }

    protected DBFactory<gDBR> _getFactory() {
        if (this.recordKey != null) {
            return this.recordKey.getFactory();
        }
        try {
            MethodAction methGetFactory = new MethodAction(this.getClass(), "getFactory");
            DBFactory fact = (DBFactory)methGetFactory.invoke();
            return fact;
        }
        catch (Throwable t) {
            Print.logException("Getting table factory [via reflection]", t);
            return null;
        }
    }

    public static <T extends DBRecord> T[] getNextGroup(DBFactory<T> fact, ResultSet rs, int max) throws DBException {
        Vector<T> rcdList = new Vector<T>();
        try {
            int cnt = 0;
            while ((max < 0 || cnt++ < max) && rs.next()) {
                DBRecordKey<T> rcdKey = fact.createKey(rs);
                if (rcdKey != null) {
                    T rcd = rcdKey.getDBRecord();
                    ((DBRecord)rcd).setAllFieldValues(rs);
                    rcdList.add(rcd);
                    continue;
                }
                Print.logError("Unable to create key: " + fact.getUntranslatedTableName(), new Object[0]);
            }
        }
        catch (SQLException sqe) {
            throw new DBException("Read next record group", sqe);
        }
        try {
            Class<T> rcdClass = fact.getRecordClass();
            DBRecord[] ra = (DBRecord[])Array.newInstance(rcdClass, rcdList.size());
            return rcdList.toArray(ra);
        }
        catch (Throwable t) {
            throw new DBException("Array conversion", t);
        }
    }

    public static <T extends DBRecord> T[] getRecords(DBFactory<T> fact, String where, String[] orderBy, boolean ascending) throws DBException {
        return DBRecord.select(fact, (String)where, null, (String[])orderBy, (boolean)ascending, (long)-1L, (long)-1L, null);
    }

    public static <T extends DBRecord> T[] getRecords(DBFactory<T> fact, String where, String addtnlSel, String[] orderBy, boolean ascending, long limit, long offset) throws DBException {
        return DBRecord.select(fact, (String)where, (String)addtnlSel, (String[])orderBy, (boolean)ascending, (long)limit, (long)offset, null);
    }

    protected static <T extends DBRecord> T[] select(DBFactory<T> fact, String where, String addtnlSel, String[] orderBy, boolean ascending, long limit, long offset, DBRecordHandler<T> rcdHandler) throws DBException {
        DBSelect<T> dsel = new DBSelect<T>(fact);
        if (addtnlSel != null) {
            dsel.setWhere(where + " " + addtnlSel);
        } else {
            dsel.setWhere(where);
        }
        if (orderBy != null && orderBy.length > 0) {
            dsel.setOrderByFields(orderBy);
            dsel.setOrderAscending(ascending);
        }
        if (limit > 0L) {
            dsel.setLimit(limit);
        }
        if (offset >= 0L) {
            dsel.setOffset(offset);
        }
        return DBRecord.select(dsel, rcdHandler);
    }

    protected static <T extends DBRecord> T[] select(DBSelect<T> dsel) throws DBException {
        return DBRecord.select(dsel, null);
    }

    protected static <T extends DBRecord> T[] select(DBSelect<T> dsel, DBRecordHandler<T> rcdHandler) throws DBException {
        long rcdCnt = 0L;
        DBConnection dbc = null;
        Statement stmt = null;
        ResultSet rs = null;
        Vector<T> rcdList = new Vector<T>();
        DBFactory<T> fact = dsel.getFactory();
        try {
            dbc = DBConnection.getDefaultConnection();
            stmt = dbc.execute(dsel.toString());
            rs = stmt.getResultSet();
            while (rs.next()) {
                ++rcdCnt;
                DBRecordKey<T> rcdKey = fact.createKey(rs);
                if (rcdKey == null) continue;
                T rcd = rcdKey.getDBRecord();
                ((DBRecord)rcd).setAllFieldValues(rs);
                if (rcdHandler != null) {
                    int rcdStatus = rcdHandler.handleDBRecord(rcd);
                    if (rcdStatus == 0) {
                        break;
                    }
                    if (rcdStatus != 2) continue;
                    rcdList.add(rcd);
                    continue;
                }
                rcdList.add(rcd);
            }
        }
        catch (SQLException sqe) {
            throw new DBException("Record Selection (Record #" + rcdCnt + ")", sqe);
        }
        catch (OutOfMemoryError oome) {
            throw new DBException("Out Of Memory (Record #" + rcdCnt + ")", oome);
        }
        catch (Throwable th) {
            throw new DBException("Unexpected error (Record #" + rcdCnt + ")", th);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
            DBConnection.release(dbc);
        }
        if (rcdList != null) {
            try {
                Class<T> rcdClass = fact.getRecordClass();
                return (DBRecord[])ListTools.toArray(rcdList, rcdClass);
            }
            catch (Throwable t) {
                throw new DBException("Array conversion", t);
            }
        }
        return null;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void setChanged(String fieldName) {
        this.changed = true;
        this.fireChangeNotification(fieldName);
    }

    public void setChanged(String fieldName, Object oldVal, Object newVal) {
        if (oldVal != newVal) {
            if (oldVal == null || newVal == null) {
                this.setChanged(fieldName);
            } else if (!oldVal.equals(newVal)) {
                this.setChanged(fieldName);
            }
        }
    }

    public void clearChanged() {
        this.changed = false;
    }

    public void addChangedNotification(DBChangeListener cl) {
        if (this.changeNotification == null) {
            this.changeNotification = new Vector();
        }
        if (cl != null && !this.changeNotification.contains(cl)) {
            this.changeNotification.add(cl);
        }
    }

    public void removeChangedNotification(DBChangeListener cl) {
        if (this.changeNotification != null) {
            this.changeNotification.remove(cl);
        }
    }

    public void fireChangeNotification(String fieldName) {
        if (this.changeNotification != null) {
            for (DBChangeListener dbcr : this.changeNotification) {
                dbcr.fieldChanged(this, fieldName);
            }
        }
    }

    public boolean hasError() {
        return this.hasError;
    }

    public void clearError() {
        this.hasError = false;
        this.errorDescription = null;
    }

    public void setError() {
        this.hasError = true;
    }

    public void setError(String desc) {
        this.hasError = true;
        this.errorDescription = desc;
    }

    public String getErrorDescription() {
        return this.hasError ? this.errorDescription : null;
    }

    public gDBR reload() {
        try {
            return this._reload(new String[0]);
        }
        catch (DBException dbe) {
            dbe.printException();
            return null;
        }
    }

    public gDBR reload(String ... fldNames) {
        try {
            return this._reload(fldNames);
        }
        catch (DBException dbe) {
            dbe.printException();
            return null;
        }
    }

    /*
     * Loose catch block
     */
    protected gDBR _reload(String ... fldNames) throws DBException {
        gDBR gDBR;
        ResultSet rs;
        Statement stmt;
        DBConnection dbc;
        block27: {
            String wh;
            DBRecordKey<gDBR> recKey;
            block25: {
                DBRecord dBRecord;
                block26: {
                    if (!this.isOkToReload()) {
                        throw new DBException("Reload not allowed");
                    }
                    dbc = null;
                    stmt = null;
                    rs = null;
                    recKey = this.getRecordKey();
                    DBSelect<gDBR> dsel = new DBSelect<gDBR>(recKey.getFactory());
                    if (!ListTools.isEmpty(fldNames)) {
                        dsel.setSelectedFields(fldNames);
                    }
                    wh = recKey.getWhereClause(DBWhere.KEY_FULL);
                    dsel.setWhere(wh);
                    dbc = DBConnection.getDefaultConnection();
                    stmt = dbc.execute(dsel.toString());
                    rs = stmt.getResultSet();
                    if (!rs.next()) break block25;
                    if (!ListTools.isEmpty(fldNames)) {
                        this.setAllFieldValues(rs, fldNames);
                    } else {
                        this.setAllFieldValues(rs);
                        this.clearChanged();
                    }
                    dBRecord = this;
                    if (rs == null) break block26;
                    try {
                        rs.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                DBConnection.release(dbc);
                return (gDBR)dBRecord;
            }
            Print.logWarn("Key not found: [" + recKey.getUntranslatedTableName() + "] " + wh, new Object[0]);
            gDBR = null;
            if (rs == null) break block27;
            try {
                rs.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        DBConnection.release(dbc);
        return gDBR;
        catch (SQLException sqe) {
            try {
                this.setLastCaughtSQLException(sqe);
                throw new DBException("Reload", sqe);
            }
            catch (Throwable throwable) {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                DBConnection.release(dbc);
                throw throwable;
            }
        }
    }

    public void setCreationDefaultValues() {
    }

    public String[] getDefaultFieldValueKey(String fieldName) {
        DBRecordKey<gDBR> recKey = this.getRecordKey();
        String utableName = recKey.getUntranslatedTableName();
        return new String[]{utableName + ".default." + fieldName, utableName + "." + fieldName};
    }

    public void setRuntimeDefaultValues() {
        DBRecordKey<gDBR> recKey = this.getRecordKey();
        String utableName = recKey.getUntranslatedTableName();
        DBField[] fld = recKey.getFields();
        for (int i = 0; i < fld.length; ++i) {
            String fn = fld[i].getName();
            String[] dk = this.getDefaultFieldValueKey(fn);
            String val = RTConfig.getString(dk, null);
            if (val == null) continue;
            if (!fld[i].isPrimaryKey()) {
                this.setFieldValue(fn, fld[i].parseStringValue(val));
                continue;
            }
            Print.logError("Refusing to set a default value for a primary key field: " + fn, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends DBRecord> long getLastUpdateTime(DBFactory<T> factory) throws DBException {
        if (factory == null) {
            Print.logStackTrace("NULL DBFactory specified");
            return -1L;
        }
        String fldUpdTime = FLD_lastUpdateTime;
        if (factory.getField(fldUpdTime) == null) {
            return -1L;
        }
        DBSelect<T> dsel = new DBSelect<T>(factory);
        dsel.setOrderByFields(fldUpdTime);
        dsel.setOrderAscending(false);
        dsel.setLimit(1L);
        DBConnection dbc = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            stmt = dbc.execute(dsel.toString());
            rs = stmt.getResultSet();
            if (rs.next()) {
                long l = rs.getLong(fldUpdTime);
                return l;
            }
        }
        catch (SQLException sqe) {
            Print.logSQLError("Unable to get '" + fldUpdTime + "': " + factory.getUntranslatedTableName(), sqe);
            long l = -1L;
            return l;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
            DBConnection.release(dbc);
        }
        return 0L;
    }

    protected static DBField newField_description() {
        return DBRecord.newField_description(null);
    }

    protected static DBField newField_description(String xAttr) {
        String attr = "edit=2 utf8=true" + (StringTools.isBlank(xAttr) ? "" : " " + xAttr);
        return new DBField(FLD_description, String.class, DBField.TYPE_STRING(128), "Description", attr);
    }

    public String getDescription() {
        String v = (String)this.getFieldValue(FLD_description);
        return v != null ? v : "";
    }

    public void setDescription(String v) {
        this.setFieldValue(FLD_description, v != null ? v : "");
    }

    public static DBField newField_creationTime(boolean isAltKey) {
        String attr = isAltKey ? "format=time altkey=createtime" : "format=time";
        return new DBField(FLD_creationTime, Long.TYPE, "UINT32", "Creation Time", attr);
    }

    public static DBField newField_creationTime() {
        return DBRecord.newField_creationTime(false);
    }

    public String getCreationDateTime(TimeZone tz, String fmt) {
        long ts = this.getCreationTime();
        if (ts <= 0L) {
            return "";
        }
        DateTime dt = new DateTime(ts);
        String dtFmt = dt.format(fmt, tz);
        return dtFmt;
    }

    public long getCreationTime() {
        Long v = (Long)this.getFieldValue(FLD_creationTime);
        return v != null ? v : -1L;
    }

    protected boolean setCreationTime(long time) {
        if (this.hasField(FLD_creationTime)) {
            long t = time >= 0L ? time : 0L;
            this.setFieldValue(FLD_creationTime, t);
            return true;
        }
        return false;
    }

    public static DBField newField_creationMillis(String xAttr) {
        String attr = !StringTools.isBlank(xAttr) ? xAttr : "";
        return new DBField(FLD_creationMillis, Long.TYPE, "INT64", "Creation Time (millis)", attr);
    }

    public long getCreationMillis() {
        Long v = (Long)this.getFieldValue(FLD_creationMillis);
        return v != null ? v : -1L;
    }

    protected boolean setCreationMillis(long millis) {
        if (this.hasField(FLD_creationMillis)) {
            long tms = millis >= 0L ? millis : 0L;
            this.setFieldValue(FLD_creationMillis, tms);
            return true;
        }
        return false;
    }

    public static DBField newField_lastUpdateTime() {
        return new DBField(FLD_lastUpdateTime, Long.TYPE, "UINT32", "Last Update Time", "format=time");
    }

    public long getLastUpdateTime() {
        Long v = (Long)this.getFieldValue(FLD_lastUpdateTime);
        return v != null ? v : -1L;
    }

    protected boolean setLastUpdateTime(long time) {
        if (this.hasField(FLD_lastUpdateTime)) {
            long t = time >= 0L ? time : 0L;
            this.setFieldValue(FLD_lastUpdateTime, t);
            return true;
        }
        return false;
    }

    public static DBField newField_lastUpdateUser(boolean checkRTP) {
        if (checkRTP && RTConfig.getBoolean("db.includeLastUpdateUser")) {
            return DBRecord.newField_lastUpdateUser();
        }
        return null;
    }

    public static DBField newField_lastUpdateUser() {
        return new DBField(FLD_lastUpdateUser, String.class, DBField.TYPE_STRING(32), "Last Update User", null);
    }

    public String getLastUpdateUser() {
        String v = (String)this.getFieldValue(FLD_lastUpdateUser);
        return v != null ? v : "";
    }

    public boolean setLastUpdateUser(String user, boolean allowBlank) {
        if (!allowBlank && StringTools.isBlank(user)) {
            return false;
        }
        if (!this.hasField(FLD_lastUpdateUser)) {
            return false;
        }
        String u = user != null ? user : "";
        this.setFieldValue(FLD_lastUpdateUser, u);
        return true;
    }

    public void insert() throws DBException {
        if (!this.isOkToSave()) {
            throw new DBException("Update not allowed");
        }
        try {
            long nowTimeMS = DateTime.getCurrentTimeMillis();
            long nowTime = nowTimeMS / 1000L;
            this.setCreationMillis(nowTimeMS);
            this.setCreationTime(nowTime);
            this.setLastUpdateTime(nowTime);
            this.setLastUpdateUser(DBRecord.GetCurrentUser(), true);
            this.recordWillInsert();
            DBProvider.insertRecordIntoTable(this);
            this.recordDidInsert();
            this.clearChanged();
        }
        catch (SQLException sqe) {
            this.setLastCaughtSQLException(sqe);
            DBRecordKey<gDBR> dbKey = this.getRecordKey();
            if (this.isLastCaughtSQLExceptionErrorCode(1062)) {
                Print.logInfo("Insert duplicate key ignored: [" + dbKey.getUntranslatedTableName() + "] " + dbKey, new Object[0]);
            }
            throw new DBException("Unable to insert record  [" + dbKey.getUntranslatedTableName() + "] '" + dbKey + "'", sqe);
        }
    }

    public void update() throws DBException {
        this.update((Set<String>)null);
    }

    public void update(String ... updFldArray) throws DBException {
        if (updFldArray == null) {
            this.update((Set<String>)null);
        } else {
            this.update(ListTools.toSet(updFldArray, null));
        }
    }

    public void update(Set<String> updFldSet) throws DBException {
        if (!this.isOkToSave()) {
            throw new DBException("Update not allowed");
        }
        try {
            String updUserID = DBRecord.GetCurrentUser();
            boolean updTime = this.setLastUpdateTime(DateTime.getCurrentTimeSec());
            boolean updUser = this.setLastUpdateUser(updUserID, false);
            if (updFldSet != null) {
                if (updTime) {
                    updFldSet.add(FLD_lastUpdateTime);
                }
                if (updUser) {
                    updFldSet.add(FLD_lastUpdateUser);
                }
            }
            this.recordWillUpdate();
            DBProvider.updateRecordInTable(this, updFldSet);
            this.recordDidUpdate();
            this.clearChanged();
        }
        catch (SQLException sqe) {
            this.setLastCaughtSQLException(sqe);
            DBRecordKey<gDBR> dbKey = this.getRecordKey();
            throw new DBException("Update record '" + dbKey + "'", sqe);
        }
    }

    public void clearExcludedUpdateFields() {
        this.excludedUpdateFields = null;
    }

    public void addExcludedUpdateFields(String ... fldNames) {
        if (!ListTools.isEmpty(fldNames)) {
            if (this.excludedUpdateFields == null) {
                this.excludedUpdateFields = new HashSet<String>();
            }
            for (int i = 0; i < fldNames.length; ++i) {
                if (StringTools.isBlank(fldNames[i])) continue;
                this.excludedUpdateFields.add(fldNames[i]);
            }
        }
    }

    public boolean excludeFieldFromUpdate(DBField fld) {
        if (fld == null) {
            return true;
        }
        return this.excludeFieldFromUpdate(fld.getName());
    }

    public boolean excludeFieldFromUpdate(String fldName) {
        if (StringTools.isBlank(fldName)) {
            return true;
        }
        if (this.excludedUpdateFields == null) {
            return false;
        }
        return this.excludedUpdateFields.contains(fldName);
    }

    public void setVirtual(boolean isVirtual) {
        this.isVirtual = isVirtual;
    }

    public boolean getVirtual() {
        return this.isVirtual;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public boolean isOkToSave() {
        return !this.isVirtual();
    }

    public boolean isOkToReload() {
        return !this.isVirtual();
    }

    public void save() throws DBException {
        DBRecordKey<gDBR> dbKey = this.getRecordKey();
        if (dbKey.exists()) {
            this.update();
        } else {
            this.insert();
        }
    }

    public boolean lockWrite() throws DBException {
        return this.lock(new String[]{this.getFactory(true).getUntranslatedTableName()}, null);
    }

    public boolean lockRead() throws DBException {
        return this.lock(null, new String[]{this.getFactory(true).getUntranslatedTableName()});
    }

    public boolean lock(String[] writeTables, String[] readTables) throws DBException {
        if (writeTables == null) {
            writeTables = new String[]{this.getFactory(true).getUntranslatedTableName()};
        }
        return DBProvider.lockTables(writeTables, readTables);
    }

    public boolean unlock() throws DBException {
        return DBProvider.unlockTables();
    }

    public String getFieldName(String fldName) {
        return this.getRecordKey().getFieldValues().getFieldName(fldName);
    }

    public void setIgnoreInvalidFields(boolean state) {
        this.getRecordKey().getFieldValues().setIgnoreInvalidFields(state);
    }

    public DBField getField(String fldName) {
        return this.getRecordKey().getField(fldName);
    }

    public boolean hasField(String fldName) {
        return this.getRecordKey().getFieldValues().hasField(fldName);
    }

    public boolean hasFieldValue(String fldName) {
        return this.getRecordKey().getFieldValues().hasFieldValue(fldName);
    }

    public boolean isFieldUnsigned(String fldName) {
        DBField fld = this.getField(fldName);
        return fld != null ? fld.isUnsigned() : false;
    }

    public boolean hasOptionalFieldValue(String fldName) {
        Object obj = this.getOptionalFieldValue(fldName);
        return obj != null;
    }

    public Object getOptionalFieldValue(String fldName) {
        return this.getRecordKey().getFieldValues().getOptionalFieldValue(fldName);
    }

    public Object getOptionalFieldValue(String fldName, Object dft) {
        Object obj = this.getOptionalFieldValue(fldName);
        return obj != null ? obj : dft;
    }

    public void setOptionalFieldValue(String fldName, Object value) {
        this.getRecordKey().getFieldValues().setOptionalFieldValue(fldName, value);
    }

    public Object getKeyValue(String fldName) {
        return this.getRecordKey().getKeyValues().getFieldValue(fldName);
    }

    public Object geKeyValue(String fldName, Object dft) {
        Object obj = this.getKeyValue(fldName);
        return obj != null ? obj : dft;
    }

    public boolean setKeyValue(String fldName, Object value) {
        return this.getRecordKey().getKeyValues().setFieldValue(fldName, value);
    }

    public Object getFieldValue(String fldName) {
        return this.getRecordKey().getFieldValues().getFieldValue(fldName);
    }

    public Object getFieldValue(String fldName, Object dft) {
        Object obj = this.getFieldValue(fldName);
        return obj != null ? obj : dft;
    }

    public boolean setFieldValue(String fldName, Object value) {
        return this.getRecordKey().getFieldValues().setFieldValue(fldName, value);
    }

    public Object getValue(String fldName) {
        DBField fld = this.getField(fldName);
        if (fld != null) {
            String meth = MethodAction.getterMethodName(fldName);
            try {
                return new MethodAction((Object)this, meth, (Class[])null).invoke();
            }
            catch (Throwable th) {
                return this.getFieldValue(fldName);
            }
        }
        return null;
    }

    public void setValue(String fldName, Object value) {
        DBField fld = this.getField(fldName);
        if (fld != null) {
            String meth = MethodAction.setterMethodName(fldName);
            try {
                MethodAction m = new MethodAction((Object)this, meth, fld.getTypeClass());
                m.invoke(value);
                return;
            }
            catch (Throwable th) {
                this.setFieldValue(fldName, value);
            }
        }
    }

    public String getOptionalFieldValue(String fldName, String dft) {
        Object obj = this.getOptionalFieldValue(fldName);
        return StringTools.trim(obj != null ? obj.toString() : dft);
    }

    public String getFieldValue(String fldName, String dft) {
        Object obj = this.getFieldValue(fldName);
        return StringTools.trim(obj != null ? obj.toString() : dft);
    }

    public String getFieldString(String fldName) {
        return this.getFieldValue(fldName, "");
    }

    public void setOptionalFieldValue(String fldName, String value) {
        this.getRecordKey().getFieldValues().setOptionalFieldValue(fldName, value);
    }

    public void setFieldValue(String fldName, String value) {
        this.getRecordKey().getFieldValues().setFieldValue(fldName, value);
    }

    public void setValue(String fldName, String value) {
        this.setValue(fldName, (Object)(value != null ? value : ""));
    }

    public boolean getOptionalFieldValue(String fldName, boolean dft) {
        Object obj = this.getOptionalFieldValue(fldName);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue() != 0;
        }
        return dft;
    }

    public boolean getFieldValue(String fldName, boolean dft) {
        Object obj = this.getFieldValue(fldName);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue() != 0;
        }
        return dft;
    }

    public boolean getFieldBoolean(String fldName) {
        return this.getFieldValue(fldName, false);
    }

    public void setOptionalFieldValue(String fldName, boolean value) {
        this.getRecordKey().getFieldValues().setOptionalFieldValue(fldName, value);
    }

    public void setFieldValue(String fldName, boolean value) {
        this.getRecordKey().getFieldValues().setFieldValue(fldName, value);
    }

    public void setValue(String fldName, boolean value) {
        this.setValue(fldName, new Boolean(value));
    }

    public int getOptionalFieldValue(String fldName, int dft) {
        Object obj = this.getOptionalFieldValue(fldName);
        return obj instanceof Number ? ((Number)obj).intValue() : dft;
    }

    public int getFieldValue(String fldName, int dft) {
        Object obj = this.getFieldValue(fldName);
        return obj instanceof Number ? ((Number)obj).intValue() : dft;
    }

    public int getFieldInt(String fldName) {
        return this.getFieldValue(fldName, 0);
    }

    public void setOptionalFieldValue(String fldName, int value) {
        this.getRecordKey().getFieldValues().setOptionalFieldValue(fldName, value);
    }

    public void setFieldValue(String fldName, int value) {
        this.getRecordKey().getFieldValues().setFieldValue(fldName, value);
    }

    public void setValue(String fldName, int value) {
        this.setValue(fldName, new Integer(value));
    }

    public long getOptionalFieldValue(String fldName, long dft) {
        Object obj = this.getOptionalFieldValue(fldName);
        return obj instanceof Number ? ((Number)obj).longValue() : dft;
    }

    public long getFieldValue(String fldName, long dft) {
        Object obj = this.getFieldValue(fldName);
        return obj instanceof Number ? ((Number)obj).longValue() : dft;
    }

    public long getFieldLong(String fldName) {
        return this.getFieldValue(fldName, 0L);
    }

    public void setOptionalFieldValue(String fldName, long value) {
        this.getRecordKey().getFieldValues().setOptionalFieldValue(fldName, value);
    }

    public void setFieldValue(String fldName, long value) {
        this.getRecordKey().getFieldValues().setFieldValue(fldName, value);
    }

    public void setValue(String fldName, long value) {
        this.setValue(fldName, new Long(value));
    }

    public float getOptionalFieldValue(String fldName, float dft) {
        Object obj = this.getOptionalFieldValue(fldName);
        return obj instanceof Number ? ((Number)obj).floatValue() : dft;
    }

    public float getFieldValue(String fldName, float dft) {
        Object obj = this.getFieldValue(fldName);
        return obj instanceof Number ? ((Number)obj).floatValue() : dft;
    }

    public float getFieldFloat(String fldName) {
        return this.getFieldValue(fldName, 0.0f);
    }

    public void setOptionalFieldValue(String fldName, float value) {
        this.getRecordKey().getFieldValues().setOptionalFieldValue(fldName, value);
    }

    public void setFieldValue(String fldName, float value) {
        this.getRecordKey().getFieldValues().setFieldValue(fldName, value);
    }

    public void setValue(String fldName, float value) {
        this.setValue(fldName, new Float(value));
    }

    public double getOptionalFieldValue(String fldName, double dft) {
        Object obj = this.getOptionalFieldValue(fldName);
        return obj instanceof Number ? ((Number)obj).doubleValue() : dft;
    }

    public double getFieldValue(String fldName, double dft) {
        Object obj = this.getFieldValue(fldName);
        return obj instanceof Number ? ((Number)obj).doubleValue() : dft;
    }

    public double getFieldDouble(String fldName) {
        return this.getFieldValue(fldName, 0.0);
    }

    public void setOptionalFieldValue(String fldName, double value) {
        this.getRecordKey().getFieldValues().setOptionalFieldValue(fldName, value);
    }

    public void setFieldValue(String fldName, double value) {
        this.getRecordKey().getFieldValues().setFieldValue(fldName, value);
    }

    public void setValue(String fldName, double value) {
        this.setValue(fldName, new Double(value));
    }

    public DateTime getOptionalFieldValue(String fldName, DateTime dft) {
        Object obj = this.getOptionalFieldValue(fldName);
        if (obj instanceof DateTime) {
            return (DateTime)obj;
        }
        if (obj instanceof Long) {
            TimeZone tmz = dft != null ? dft.getTimeZone() : DateTime.getGMTTimeZone();
            return new DateTime((Long)obj, tmz);
        }
        return dft;
    }

    public DateTime getFieldValue(String fldName, DateTime dft) {
        Object obj = this.getFieldValue(fldName);
        if (obj instanceof DateTime) {
            return (DateTime)obj;
        }
        if (obj instanceof Long) {
            TimeZone tmz = dft != null ? dft.getTimeZone() : DateTime.getGMTTimeZone();
            return new DateTime((Long)obj, tmz);
        }
        return dft;
    }

    public DateTime getFieldDateTime(String fldName) {
        return this.getFieldValue(fldName, (DateTime)null);
    }

    public void setOptionalFieldValue(String fldName, DateTime value) {
        this.getRecordKey().getFieldValues().setOptionalFieldValue(fldName, value);
    }

    public void setAllFieldValues(DBRecord<gDBR> rcd) throws DBException {
        if (rcd != null) {
            DBFieldValues thisFldVals = this.getRecordKey().getFieldValues();
            DBFieldValues rcdFldVals = rcd.getRecordKey().getFieldValues();
            thisFldVals.clearFieldValues();
            thisFldVals.setFieldValues(rcdFldVals, false, false);
        }
    }

    public void setAllFieldValues(ResultSet rs) throws DBException {
        if (rs != null) {
            try {
                DBFieldValues fldVals = this.getRecordKey().getFieldValues();
                fldVals.clearFieldValues();
                fldVals.setAllFieldValues(rs, false);
            }
            catch (SQLException sqe) {
                this.setLastCaughtSQLException(sqe);
                throw new DBException("Setting field values", sqe);
            }
        }
    }

    public void setAllFieldValues(ResultSet rs, String ... fldNames) throws DBException {
        if (rs != null) {
            try {
                DBFieldValues fldVals = this.getRecordKey().getFieldValues();
                if (!ListTools.isEmpty(fldNames)) {
                    DBField[] fldList = this._getFactory().getFields(fldNames);
                    fldVals.clearFieldValues(fldList);
                    fldVals.setAllFieldValues(rs, false, fldList);
                } else {
                    fldVals.clearFieldValues();
                    fldVals.setAllFieldValues(rs, false);
                }
            }
            catch (SQLException sqe) {
                this.setLastCaughtSQLException(sqe);
                throw new DBException("Setting field values", sqe);
            }
        }
    }

    public void setAllFieldValues(Map<String, String> valMap) throws DBException {
        if (valMap != null) {
            DBFieldValues fldVals = this.getRecordKey().getFieldValues();
            fldVals.clearFieldValues();
            fldVals.setAllFieldValues(valMap, false);
        }
    }

    public void appendFieldValues(Map<String, String> valMap) throws DBException {
        if (valMap != null) {
            DBFieldValues fldVals = this.getRecordKey().getFieldValues();
            fldVals.setFieldValues(valMap, false, false);
        }
    }

    protected void setLastCaughtSQLException(SQLException sqe) {
        this.lastSQLException = sqe;
    }

    public void clearLastCaughtSQLException() {
        this.setLastCaughtSQLException(null);
    }

    public SQLException getLastCaughtSQLException() {
        return this.lastSQLException;
    }

    public boolean isLastCaughtSQLExceptionErrorCode(int code) {
        SQLException sqe = this.getLastCaughtSQLException();
        if (sqe == null) {
            return false;
        }
        return sqe.getErrorCode() == code;
    }

    protected void setValidating(boolean validate) {
        this.isValidating = validate;
    }

    protected boolean isValidating() {
        return this.isValidating;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DBRecord)) {
            return false;
        }
        if (this.getClass().isAssignableFrom(obj.getClass())) {
            return ((DBRecord)obj).getRecordKey().equals(this.getRecordKey());
        }
        return false;
    }

    public String toString() {
        return this.getRecordKey().toString();
    }

    public static void printXML(PrintWriter out, DBRecord<?> ... dbr) {
        DBRecord.printXML(out, 0, null, dbr);
    }

    public static void printXML(PrintWriter out, int indent, Set<String> fldNames, DBRecord<?> ... dbr) {
        if (out != null) {
            out.write("<Records>\n");
            if (dbr != null) {
                for (int i = 0; i < dbr.length; ++i) {
                    dbr[i].printXML(out, indent, fldNames, i + 1);
                }
            }
            out.write("</Records>\n");
        }
    }

    public void printXML(PrintWriter out, int indent, Set<String> fldNames) {
        this.printXML(out, indent, fldNames, -1, false);
    }

    public void printXML(PrintWriter out, int indent, Set<String> fldNames, boolean soapXml) {
        this.printXML(out, indent, fldNames, -1, soapXml);
    }

    public void printXML(PrintWriter out, int indent, Set<String> fldNames, int sequence) {
        if (out != null) {
            out.write(this.toXML(null, indent, fldNames, sequence).toString());
        }
    }

    public void printXML(PrintWriter out, int indent, Set<String> fldNames, int sequence, boolean soapXML) {
        if (out != null) {
            out.write(this.toXML(null, indent, fldNames, sequence, soapXML).toString());
        }
    }

    public StringBuffer toXML(StringBuffer sb, int indent, Set<String> fldNames) {
        return this.toXML(sb, indent, fldNames, -1);
    }

    public StringBuffer toXML(StringBuffer sb, int indent, Set<String> fldNames, boolean soapXML) {
        return this.toXML(sb, indent, fldNames, -1, true, soapXML);
    }

    public StringBuffer toXML(StringBuffer sb, int indent, Set<String> fldNames, int sequence) {
        return this.toXML(sb, indent, fldNames, sequence, true, false);
    }

    public StringBuffer toXML(StringBuffer sb, int indent, Set<String> fldNames, int sequence, boolean soapXML) {
        return this.toXML(sb, indent, fldNames, sequence, true, false);
    }

    public StringBuffer toXML(StringBuffer sb, int indent, Set<String> fldNames, int sequence, boolean inclBlank, boolean soapXML) {
        int i;
        if (sb == null) {
            sb = new StringBuffer();
        }
        DBRecordKey<gDBR> recKey = this.getRecordKey();
        String utableName = recKey.getUntranslatedTableName();
        DBField[] fld = recKey.getFields();
        DBFieldValues fldVals = recKey.getFieldValues();
        String PFX1 = XMLTools.PREFIX(soapXML, indent);
        sb.append(PFX1);
        sb.append(XMLTools.startTAG(soapXML, "Record", XMLTools.ATTR("table", utableName) + (!ListTools.isEmpty(fldNames) ? XMLTools.ATTR("partial", "true") : "") + (sequence > 0 ? XMLTools.ATTR("sequence", sequence) : ""), false, true));
        for (i = 0; i < fld.length; ++i) {
            if (!fld[i].isPrimaryKey()) continue;
            String value = fldVals.getFieldValueAsString(fld[i].getName());
            if (!inclBlank && StringTools.isBlank(value)) continue;
            DBFactory.writeXML_DBField(sb, 2 * indent, fld[i], false, value, soapXML);
        }
        for (i = 0; i < fld.length; ++i) {
            if (fld[i].isPrimaryKey()) continue;
            String name = fld[i].getName();
            if (fldNames != null && !fldNames.contains(name)) continue;
            String value = fldVals.getFieldValueAsString(name);
            DBFactory.writeXML_DBField(sb, 2 * indent, fld[i], false, value, soapXML);
        }
        sb.append(PFX1);
        sb.append(XMLTools.endTAG(soapXML, "Record", true));
        return sb;
    }

    protected void recordWillInsert() {
        DBFactory<DBRecord> fact = this._getFactory();
        if (fact != null) {
            fact.recordWillInsert(this);
        }
    }

    protected void recordDidInsert() {
        DBFactory<DBRecord> fact = this._getFactory();
        if (fact != null) {
            fact.recordDidInsert(this);
        }
    }

    protected void recordWillUpdate() {
        DBFactory<DBRecord> fact = this._getFactory();
        if (fact != null) {
            fact.recordWillUpdate(this);
        }
    }

    protected void recordDidUpdate() {
        DBFactory<DBRecord> fact = this._getFactory();
        if (fact != null) {
            fact.recordDidUpdate(this);
        }
    }

    public RTProperties getTemporaryProperties() {
        if (this.tempProps == null) {
            this.tempProps = new RTProperties();
        }
        return this.tempProps;
    }

    public boolean hasTemporaryProperties() {
        return this.tempProps != null;
    }

    public static interface DBChangeListener {
        public void fieldChanged(DBRecord var1, String var2);
    }
}

