/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.dbtools;

import java.io.File;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.opengts.dbtools.DBAlternateIndex;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBFieldValues;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordKey;
import org.opengts.dbtools.DBTableIndexMap;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class DBProvider {
    public static final String PRIMARY_INDEX_NAME = "PRIMARY";
    public static final String UNIQUE_INDEX_NAME = "UNIQUE";
    public static final String DEFAULT_ALT_INDEX_NAME = "altIndex";
    public static final String LIKE_WILDCARD = "%";
    private static final String FLD_count_ = "COUNT(*)";
    private static final String FLD_sum_ = "SUM";
    public static final String TYPE_UNKNOWN = "UNKNOWN";
    public static final String TYPE_BOOLEAN = "BOOLEAN";
    public static final String TYPE_INT8 = "INT8";
    public static final String TYPE_UINT8 = "UINT8";
    public static final String TYPE_INT16 = "INT16";
    public static final String TYPE_UINT16 = "UINT16";
    public static final String TYPE_INT32 = "INT32";
    public static final String TYPE_UINT32 = "UINT32";
    public static final String TYPE_INT64 = "INT64";
    public static final String TYPE_UINT64 = "UINT64";
    public static final String TYPE_FLOAT = "FLOAT";
    public static final String TYPE_DOUBLE = "DOUBLE";
    public static final String TYPE_SBLOB = "SBLOB";
    public static final String TYPE_BLOB = "BLOB";
    public static final String TYPE_MBLOB = "MBLOB";
    public static final String TYPE_TEXT = "TEXT";
    public static final String TYPE_STRING = "STRING";
    public static final String TYPE_DATETIME = "DATETIME";
    public static final String[] TYPE_ARRAY = new String[]{"UNKNOWN", "BOOLEAN", "INT8", "UINT8", "INT16", "UINT16", "INT32", "UINT32", "INT64", "UINT64", "FLOAT", "DOUBLE", "SBLOB", "BLOB", "MBLOB", "TEXT", "STRING", "DATETIME"};
    public static final int SQL_UNKNOWN = 0;
    public static final int SQL_BOOLEAN = 1;
    public static final int SQL_INT8 = 2;
    public static final int SQL_UINT8 = 3;
    public static final int SQL_INT16 = 4;
    public static final int SQL_UINT16 = 5;
    public static final int SQL_INT32 = 6;
    public static final int SQL_UINT32 = 7;
    public static final int SQL_INT64 = 8;
    public static final int SQL_UINT64 = 9;
    public static final int SQL_FLOAT = 10;
    public static final int SQL_DOUBLE = 11;
    public static final int SQL_SBLOB = 12;
    public static final int SQL_BLOB = 13;
    public static final int SQL_MBLOB = 14;
    public static final int SQL_TEXT = 15;
    public static final int SQL_VARCHAR = 16;
    public static final int SQL_DATETIME = 17;
    public static final int DATATYPE_NONE = 0;
    public static final int DATATYPE_BOOLEAN = 1;
    public static final int DATATYPE_UNSIGNED = 2;
    public static final int DATATYPE_SIGNED = 4;
    public static final int DATATYPE_DECIMAL = 8;
    public static final int DATATYPE_STRING = 16;
    public static final int DATATYPE_BINARY = 32;
    public static final int DATATYPE_DATETIME = 64;
    public static final int DATATYPE_NUMERIC = 14;
    public static final int[] DATATYPE_ARRAY = new int[]{0, 1, 4, 2, 4, 2, 4, 2, 4, 2, 8, 8, 32, 32, 32, 16, 16, 64};
    public static final int DB_MYSQL = 1;
    public static final int DB_POSTGRESQL = 2;
    public static final int DB_DERBY = 3;
    public static final int DB_SQLSERVER = 4;
    public static final int DB_ORACLEXE = 5;
    public static final long FLAGS_NONE = 0L;
    public static final long FLAGS_LIMIT = 1L;
    public static final long FLAGS_OFFSET = 2L;
    public static final String MySQL_Old_Name = "mysql_old";
    protected static DBProvider MySQL_Old_Provider = new DBProvider("mysql_old", 1, 3306, new String[]{"com.mysql.jdbc.Driver", "org.gjt.mm.mysql.Driver"}, null, null, null, "type=MyISAM", 3L, new String[]{"", "TINYINT", "TINYINT", "TINYINT UNSIGNED", "SMALLINT", "SMALLINT UNSIGNED", "INT", "INT UNSIGNED", "BIGINT", "BIGINT UNSIGNED", "FLOAT", "DOUBLE", "BLOB", "BLOB", "MEDIUMBLOB", "TEXT", "VARCHAR", "DATETIME"});
    public static final String MySQL_MyISAM_Name = "mysql_myisam";
    protected static DBProvider MySQL_MyISAM_Provider = new DBProvider("mysql_myisam", 1, 3306, new String[]{"com.mysql.jdbc.Driver", "org.gjt.mm.mysql.Driver"}, null, null, null, "engine=MyISAM", 3L, new String[]{"", "TINYINT", "TINYINT", "TINYINT UNSIGNED", "SMALLINT", "SMALLINT UNSIGNED", "INT", "INT UNSIGNED", "BIGINT", "BIGINT UNSIGNED", "FLOAT", "DOUBLE", "BLOB", "BLOB", "MEDIUMBLOB", "TEXT", "VARCHAR", "DATETIME"});
    public static final String MySQL_InnoDB_Name = "mysql_innodb";
    protected static DBProvider MySQL_InnoDB_Provider = new DBProvider("mysql_innodb", 1, 3306, new String[]{"com.mysql.jdbc.Driver", "org.gjt.mm.mysql.Driver"}, null, null, null, "engine=InnoDB", 3L, new String[]{"", "TINYINT", "TINYINT", "TINYINT UNSIGNED", "SMALLINT", "SMALLINT UNSIGNED", "INT", "INT UNSIGNED", "BIGINT", "BIGINT UNSIGNED", "FLOAT", "DOUBLE", "BLOB", "BLOB", "MEDIUMBLOB", "TEXT", "VARCHAR", "DATETIME"});
    public static final String Oracle_XE_Name = "oraclexe";
    protected static DBProvider Oracle_XE_Provider = new DBProvider("oraclexe", 5, 1521, new String[]{"oracle.jdbc.OracleDriver"}, null, null, null, "", 3L, new String[]{"", "TINYINT", "TINYINT", "TINYINT UNSIGNED", "SMALLINT", "SMALLINT UNSIGNED", "INT", "INT UNSIGNED", "BIGINT", "BIGINT UNSIGNED", "FLOAT", "DOUBLE", "BLOB", "BLOB", "MEDIUMBLOB", "TEXT", "VARCHAR", "DATETIME"});
    public static final String PostgreSQL_Name = "postgresql";
    protected static DBProvider PostgreSQL_Provider = new DBProvider("postgresql", 2, 5432, new String[]{"org.postgresql.Driver"}, new NameFilter(""), null, new NameFilterLowerCase(""), null, 3L, new String[]{"", "SMALLINT", "SMALLINT", "SMALLINT", "SMALLINT", "INTEGER", "INTEGER", "BIGINT", "BIGINT", "NUMERIC(20)", "FLOAT", "DOUBLE PRECISION", "BYTEA", "BYTEA", "BYTEA", "TEXT", "VARCHAR", "TIMESTAMP"});
    public static final String PostgreSQL_Name_old = "postgresql";
    protected static DBProvider PostgreSQL_Provider_old = new DBProvider("postgresql", 2, 5432, new String[]{"org.postgresql.Driver"}, null, null, new NameFilter("PG"), null, 3L, new String[]{"", "TINYINT", "TINYINT", "TINYINT UNSIGNED", "SMALLINT", "SMALLINT UNSIGNED", "INT", "INT UNSIGNED", "BIGINT", "BIGINT UNSIGNED", "FLOAT", "DOUBLE", "BLOB", "BLOB", "MEDIUMBLOB", "TEXT", "VARCHAR", "DATETIME"});
    public static final String Derby_Name = "derby";
    protected static DBProvider Derby_Provider = new DBProvider("derby", 3, 1527, new String[]{"org.apache.derby.jdbc.ClientDriver", "org.apache.derby.jdbc.EmbeddedDriver"}, new NameFilterUpperCase(""), null, new NameFilterUpperCase("DB"), null, 0L, new String[]{"", "SMALLINT", "SMALLINT", "SMALLINT", "SMALLINT", "SMALLINT", "INTEGER", "INTEGER", "BIGINT", "BIGINT", "FLOAT", "DOUBLE", "BLOB", "BLOB", "BLOB", "CLOB", "VARCHAR", "DATETIME"});
    public static final String MS_SQLServer_Name = "sqlserver";
    protected static DBProvider MS_SQLServer_Provider = new DBProvider("sqlserver", 4, 1433, new String[]{"com.microsoft.sqlserver.jdbc.SQLServerDriver"}, null, null, new NameFilter("MS"), null, 1L, new String[]{"", "TINYINT", "SMALLINT", "SMALLINT", "INT", "INT", "BIGINT", "BIGINT", "BIGINT", "BIGINT", "FLOAT", "FLOAT", "VARBINARY", "IMAGE", "IMAGE", "TEXT", "VARCHAR", "DATETIME"});
    private static DBProvider globalDBProvider = null;
    private static HashMap<String, DBProvider> globalDBProviderMap = new HashMap();
    private static boolean didLogJdbcURL;
    private static String[] JDBC_URL;
    private static String[] JDBC_URL_DB;
    private static Boolean lockingEnabled;
    private static Stack<Throwable> lockLevel;
    private static int lockSeq;
    private static int unlockSeq;
    private int jdbcId = 0;
    private String jdbcName = null;
    private String[] jdbcDrivers = null;
    private String tableIndexType = null;
    private String[] dataTypes = null;
    private long jdbcFlags = 0L;
    private int defaultPort = 0;
    private NameFilter tableNameFilter = null;
    private NameFilter columnNameFilter = null;
    private NameFilter indexNameFilter = null;

    public static String FLD_COUNT() {
        return FLD_count_;
    }

    public static String FLD_SUM(String col) {
        return "SUM(" + col + ")";
    }

    public static String TYPE_STRING(int size) {
        return "STRING[" + size + "]";
    }

    public static String TYPE_INT(String val) {
        if (!StringTools.isBlank(val)) {
            if (val.equalsIgnoreCase(TYPE_INT8)) {
                return TYPE_INT8;
            }
            if (val.equalsIgnoreCase(TYPE_UINT8)) {
                return TYPE_UINT8;
            }
            if (val.equalsIgnoreCase(TYPE_INT16)) {
                return TYPE_INT16;
            }
            if (val.equalsIgnoreCase(TYPE_UINT16)) {
                return TYPE_UINT16;
            }
            if (val.equalsIgnoreCase(TYPE_INT32)) {
                return TYPE_INT32;
            }
            if (val.equalsIgnoreCase(TYPE_UINT32)) {
                return TYPE_UINT32;
            }
            if (val.equalsIgnoreCase(TYPE_INT64)) {
                return TYPE_INT64;
            }
            if (val.equalsIgnoreCase(TYPE_UINT64)) {
                return TYPE_UINT64;
            }
        }
        Print.logStackTrace("ERROR: Invalid INTEGER type: " + val);
        return StringTools.trim(val);
    }

    public static String SQL_VARCHAR(int size) {
        return "16(" + size + ")";
    }

    public static DBProvider getProvider(String dbpName) {
        return globalDBProviderMap.get(dbpName);
    }

    public static DBProvider getProvider() {
        if (globalDBProvider == null) {
            String dbpName = RTConfig.getString("db.sql.provider");
            if (StringTools.isBlank(dbpName)) {
                globalDBProvider = MySQL_MyISAM_Provider;
                Print.logWarn("DBProvider not specified, using default (" + globalDBProvider.getJDBCName() + ").", new Object[0]);
            } else {
                globalDBProvider = globalDBProviderMap.get(dbpName);
                if (globalDBProvider == null) {
                    globalDBProvider = MySQL_MyISAM_Provider;
                    if (!dbpName.equalsIgnoreCase("mysql")) {
                        Print.logWarn("DBProvider '" + dbpName + "' not found, using default (" + globalDBProvider.getJDBCName() + ").", new Object[0]);
                    }
                } else {
                    Print.logDebug("DBProvider installed: " + globalDBProvider.getJDBCName(), new Object[0]);
                }
            }
            DBProvider.isTableLockingEnabled();
        }
        return globalDBProvider;
    }

    public static String getProviderName() {
        return DBProvider.getProvider().getJDBCName();
    }

    public static String getProviderIndexType() {
        return DBProvider.getProvider().getTableIndexType();
    }

    public static boolean isMySqlInnoDB() {
        String ndxType = StringTools.trim(DBProvider.getProviderIndexType()).toLowerCase();
        return ndxType.equalsIgnoreCase("engine=innodb");
    }

    public static String loadJDBCDriver() {
        String[] driver = DBProvider.getProvider().getDrivers();
        if (driver != null) {
            for (int i = 0; i < driver.length; ++i) {
                try {
                    Class.forName(driver[i]);
                    return driver[i];
                }
                catch (Throwable t) {
                    Print.logWarn("JDBC driver class not found: " + driver[i], new Object[0]);
                    continue;
                }
            }
            Print.logError("-------------------------------------------------------------------------", new Object[0]);
            String extDir = System.getProperty("java.ext.dirs");
            if (extDir != null) {
                String[] edir = StringTools.split(extDir, File.pathSeparatorChar);
                if (edir.length > 1) {
                    Print.logError("Install the JDBC jar file in one of the following directories:", new Object[0]);
                    for (int i = 0; i < edir.length; ++i) {
                        Print.logError(" > " + edir[i], new Object[0]);
                    }
                } else {
                    Print.logError("Install the JDBC jar file in the following directory:", new Object[0]);
                    Print.logError(" > " + extDir, new Object[0]);
                }
            } else {
                Print.logError("Install JDBC drivers", new Object[0]);
            }
            Print.logError("(NOTE: The installed jar file permissions must also be world-readable)", new Object[0]);
            Print.logError("-------------------------------------------------------------------------", new Object[0]);
        }
        return null;
    }

    public static boolean sendJdbcCommunicationExceptionNotification(Throwable th) {
        if (th == null) {
            return false;
        }
        String cn = StringTools.className(th);
        if (cn.indexOf("CommunicationException") < 0) {
            return false;
        }
        return false;
    }

    public static String getDBHost() {
        return RTConfig.getString("db.sql.host");
    }

    public static int getDBPort() {
        return DBProvider.getProvider().getDefaultPort();
    }

    public static String getDBName() {
        return RTConfig.getString("db.sql.dbname");
    }

    public static String getDBUsername() {
        if (RTConfig.hasProperty("db.sql.user", false)) {
            return RTConfig.getString("db.sql.user", "");
        }
        String user = RTConfig.getString("db.sql.user");
        return user != null ? user : "";
    }

    public static String getDBPassword() {
        if (RTConfig.hasProperty("db.sql.password", false)) {
            return RTConfig.getString("db.sql.password");
        }
        String pass = RTConfig.getString("db.sql.password");
        return pass != null ? pass : "";
    }

    public static String getDBUri(boolean inclDBName) {
        String urlStr = null;
        if (inclDBName) {
            urlStr = RTConfig.getString(JDBC_URL_DB, "").trim();
            if (!StringTools.isBlank(urlStr)) {
                return urlStr;
            }
            urlStr = RTConfig.getString(JDBC_URL, "").trim();
        } else {
            urlStr = RTConfig.getString(JDBC_URL, "").trim();
            if (!StringTools.isBlank(urlStr)) {
                return urlStr;
            }
        }
        StringBuffer uri = new StringBuffer(urlStr);
        DBProvider dbProv = DBProvider.getProvider();
        switch (dbProv.getID()) {
            case 1: {
                if (uri.length() == 0) {
                    uri.append("jdbc:mysql://").append(DBProvider.getDBHost()).append(":").append(DBProvider.getDBPort()).append("/");
                }
                if (!inclDBName) break;
                uri.append(DBProvider.getDBName());
                break;
            }
            case 2: {
                if (uri.length() == 0) {
                    uri.append("jdbc:postgresql://").append(DBProvider.getDBHost()).append(":").append(DBProvider.getDBPort()).append("/");
                }
                if (!inclDBName) break;
                uri.append(DBProvider.getDBName());
                break;
            }
            case 3: {
                if (uri.length() != 0) break;
                uri.append("jdbc:derby://").append(DBProvider.getDBHost()).append(":").append(DBProvider.getDBPort()).append("/");
                uri.append(DBProvider.getDBName()).append(";create=true");
                break;
            }
            case 4: {
                if (uri.length() == 0) {
                    uri.append("jdbc:sqlserver://").append(DBProvider.getDBHost()).append(":").append(DBProvider.getDBPort());
                }
                if (!inclDBName || uri.indexOf("databaseName=") >= 0) break;
                uri.append(";databaseName=").append(DBProvider.getDBName());
                break;
            }
            default: {
                Print.logInfo("DBProvider unrecognized provider: " + dbProv.getID(), new Object[0]);
                return null;
            }
        }
        if (!didLogJdbcURL) {
            didLogJdbcURL = true;
            if (uri.length() > 0) {
                Print.logDebug("Connection URL: " + uri, new Object[0]);
            }
        }
        return uri.toString();
    }

    protected static int _getTypeIndex(String localType, boolean isDefinedType) {
        if (localType != null) {
            localType = localType.toUpperCase();
            for (int i = 1; i < TYPE_ARRAY.length; ++i) {
                if (!localType.equals(TYPE_ARRAY[i])) continue;
                return i;
            }
            if (localType.startsWith("STRING[")) {
                return 16;
            }
        }
        if (isDefinedType) {
            Print.logWarn("Type not found: " + localType, new Object[0]);
        }
        return 0;
    }

    public static boolean areTypesEquivalent(String defType, String actType) {
        boolean equivalent = false;
        if (defType == null || actType == null) {
            equivalent = false;
        } else if (defType.equalsIgnoreCase(actType)) {
            equivalent = true;
        } else if (defType.startsWith("STRING[")) {
            equivalent = false;
        } else {
            int defNdx = DBProvider._getTypeIndex(defType, true);
            int actNdx = DBProvider._getTypeIndex(actType, false);
            String[] sqlTypes = DBProvider.getProvider().getSQLTypes();
            equivalent = sqlTypes[defNdx].equals(sqlTypes[actNdx]);
        }
        return equivalent;
    }

    public static String getSqlTypeFromDataType(String localType) {
        if (localType != null) {
            if ((localType = localType.toUpperCase()).startsWith("STRING[")) {
                String x = localType.substring(TYPE_STRING.length() + 1);
                int len = StringTools.parseInt(x, 32);
                return DBProvider.getSQLType(16) + "(" + len + ")";
            }
            int ndx = DBProvider._getTypeIndex(localType, true);
            return DBProvider.getSQLType(ndx);
        }
        return "";
    }

    public static String getDataTypeFromSqlType(String sqlType) {
        if (sqlType != null) {
            DBProvider dbProv;
            String[] sqlTypes;
            if ((sqlType = sqlType.toUpperCase()).startsWith((sqlTypes = (dbProv = DBProvider.getProvider()).getSQLTypes())[2])) {
                return sqlType.indexOf("UNSIGNED") > 0 ? TYPE_UINT8 : TYPE_INT8;
            }
            if (sqlType.startsWith(sqlTypes[1])) {
                return TYPE_BOOLEAN;
            }
            if (sqlType.startsWith(sqlTypes[4])) {
                return sqlType.indexOf("UNSIGNED") > 0 ? TYPE_UINT16 : TYPE_INT16;
            }
            if (sqlType.startsWith(sqlTypes[6])) {
                return sqlType.indexOf("UNSIGNED") > 0 ? TYPE_UINT32 : TYPE_INT32;
            }
            if (sqlType.startsWith(sqlTypes[8])) {
                return sqlType.indexOf("UNSIGNED") > 0 ? TYPE_UINT64 : TYPE_INT64;
            }
            if (sqlType.startsWith(sqlTypes[10])) {
                return TYPE_FLOAT;
            }
            if (sqlType.startsWith(sqlTypes[11])) {
                return TYPE_DOUBLE;
            }
            if (sqlType.startsWith(sqlTypes[12])) {
                return TYPE_SBLOB;
            }
            if (sqlType.startsWith(sqlTypes[13])) {
                return TYPE_BLOB;
            }
            if (sqlType.startsWith(sqlTypes[14])) {
                return TYPE_MBLOB;
            }
            if (sqlType.startsWith(sqlTypes[15])) {
                return TYPE_TEXT;
            }
            if (sqlType.startsWith(sqlTypes[16] + "(")) {
                String x = sqlType.substring(sqlTypes[16].length() + 1);
                int len = StringTools.parseInt(x, 32);
                return DBProvider.TYPE_STRING(len);
            }
            Print.logWarn("Unrecognized SQL type: " + sqlType, new Object[0]);
            return TYPE_UNKNOWN;
        }
        return TYPE_UNKNOWN;
    }

    public static String getSQLType(int dataTypeNdx) {
        try {
            String[] dt = DBProvider.getProvider().getSQLTypes();
            return dt[dataTypeNdx];
        }
        catch (Throwable th) {
            return "";
        }
    }

    private static String rs_GetString(ResultSet rs, String colName, String dft) {
        try {
            return rs.getString(colName);
        }
        catch (SQLException sqe) {
            return dft;
        }
    }

    public static DBField[] getActualTableFields(String utableName) throws DBException {
        DBTableIndexMap indexMap = null;
        try {
            indexMap = DBProvider.getActualTableIndexMap(utableName);
        }
        catch (DBException dbe) {
            Print.logWarn("Unable to retrieve table index information: " + dbe.getMessage(), new Object[0]);
        }
        String colName_Field = "Field";
        String colName_Type = "Type";
        String colName_CharSet = "Collation";
        String colName_Default = "Default";
        String colName_Extra = "Extra";
        String colName_Key = "Key";
        String xtableName = DBProvider.translateTableName(utableName);
        DBProvider dbp = DBProvider.getProvider();
        String showCols = null;
        String dftCharSet = "";
        if (dbp.getID() == 1) {
            showCols = "SHOW FULL COLUMNS FROM " + xtableName;
            dftCharSet = "latin1_swedish_ci";
        } else if (dbp.getID() == 4) {
            showCols = "SELECT column_name as [Field],(CAST(Data_type as nvarchar) + '(' + CAST(isnull(Character_maximum_length,numeric_precision) as nvarchar) + ')' ) as [Type], 'KEY' = CASE IS_NULLABLE WHEN 'NO' THEN 'PRI' ELSE '' END from information_schema.columns WHERE table_name='" + xtableName + "';";
            dftCharSet = "SQL_Latin1_General_CP1_CI_AS";
        } else if (dbp.getID() == 3) {
            showCols = "SELECT T.TABLENAME,C.COLUMNNAME,C.REFERENCEID,C.COLUMNNUMBER,C.COLUMNDATATYPE,C.COLUMNDEFAULT,N.TYPE FROM SYS.SYSCOLUMNS C, SYS.SYSCONSTRAINTS N, SYS.SYSTABLES T WHERE T.TABLENAME = '" + xtableName.toUpperCase() + "' AND T.TABLEID=C.REFERENCEID AND T.TABLEID=N.TABLEID " + "ORDER BY C.COLUMNNUMBER";
            colName_Field = "COLUMNNAME";
            colName_Type = "COLUMNDATATYPE";
            colName_Key = "TYPE";
            dftCharSet = "utf8";
        } else if (dbp.getID() == 2) {
            showCols = "SELECT  column_name as \"Field\",  data_type as \"Type\",  collation_name as \"Collation\",  column_default as \"Default\",  '' as \"Extra\",  '' as \"Key\" FROM information_schema.columns WHERE table_name ='" + xtableName + "'";
            dftCharSet = "utf8";
        } else {
            return null;
        }
        DBConnection dbc = null;
        Statement stmt = null;
        ResultSet rs = null;
        HashSet<String> dbfn = new HashSet<String>();
        Vector<DBField> dbf = new Vector<DBField>();
        try {
            dbc = DBConnection.getDefaultConnection();
            stmt = dbc.execute(showCols);
            rs = stmt.getResultSet();
            while (rs.next()) {
                String fldName = rs.getString(colName_Field);
                if (dbfn.contains(fldName)) continue;
                String fldType = rs.getString(colName_Type);
                String charSet = StringTools.trim(DBProvider.rs_GetString(rs, colName_CharSet, dftCharSet));
                String fldDflt = StringTools.trim(DBProvider.rs_GetString(rs, colName_Default, ""));
                String fldExtr = StringTools.trim(DBProvider.rs_GetString(rs, colName_Extra, ""));
                Set<String> ndxSet = null;
                if (indexMap != null) {
                    ndxSet = indexMap.getIndexesForColumn(fldName);
                } else {
                    ndxSet = new HashSet<String>();
                    String keyType = DBProvider.rs_GetString(rs, colName_Key, null);
                    if (keyType == null) {
                        ndxSet.add("?");
                    } else if (keyType.equalsIgnoreCase("PRI") || keyType.equalsIgnoreCase("P")) {
                        ndxSet.add(PRIMARY_INDEX_NAME);
                    } else if (keyType.equalsIgnoreCase("UNI") || keyType.equalsIgnoreCase("U")) {
                        ndxSet.add(UNIQUE_INDEX_NAME);
                    } else if (keyType.equalsIgnoreCase("MUL")) {
                        ndxSet.add(DEFAULT_ALT_INDEX_NAME);
                    } else if (!keyType.equals("")) {
                        ndxSet.add(PRIMARY_INDEX_NAME);
                    }
                    if (ndxSet.isEmpty()) {
                        ndxSet = null;
                    }
                }
                boolean autoIncr = fldExtr.equalsIgnoreCase("auto_increment");
                DBField field = new DBField(utableName, fldName, fldType, autoIncr, charSet, ndxSet);
                dbf.add(field);
                dbfn.add(fldName);
            }
        }
        catch (SQLException sqe) {
            Print.logWarn("Table Error.  Displaying column info [" + sqe, new Object[0]);
            if (rs != null) {
                try {
                    ResultSetMetaData rsmd = rs.getMetaData();
                    int colCnt = rsmd.getColumnCount();
                    for (int i = 1; i <= colCnt; ++i) {
                        Print.logWarn(i + ") Column Name: " + rsmd.getColumnName(i), new Object[0]);
                    }
                }
                catch (SQLException sqle) {
                    Print.logError("Unable to read ResultSet MetaData ... " + sqle, new Object[0]);
                }
                catch (Throwable th) {
                    Print.logException("Unexpected exception while reading ResultSet MetaData:", th);
                }
            }
            throw new DBException("Unable to get fields", sqe);
        }
        catch (DBException dbe) {
            Print.logError("DBException: " + dbe, new Object[0]);
            throw dbe;
        }
        catch (Throwable th) {
            throw new DBException("Unexpected Exception", th);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
            DBConnection.release(dbc);
        }
        return dbf.toArray(new DBField[dbf.size()]);
    }

    public static DBTableIndexMap getActualTableIndexMap(String utableName) throws DBException {
        String colName_Table_name = "Table";
        String colName_Column_name = "Column_name";
        String colName_Key_name = "Key_name";
        String xtableName = DBProvider.translateTableName(utableName);
        DBProvider dbp = DBProvider.getProvider();
        String showCols = null;
        if (dbp.getID() == 1) {
            showCols = "SHOW INDEXES FROM " + xtableName;
        } else if (dbp.getID() == 4) {
            showCols = "SELECT t.name AS Table_name, ind.name AS Key_name, col.name AS Column_name FROM sys.indexes ind INNER JOIN sys.index_columns ic ON ind.object_id = ic.object_id and ind.index_id = ic.index_id INNER JOIN sys.columns col ON ic.object_id = col.object_id and ic.column_id = col.column_id INNER JOIN sys.tables t ON ind.object_id = t.object_id WHERE t.name = '" + xtableName + "' " + ";";
        } else if (dbp.getID() == 2) {
            showCols = " select     t.relname as table_name,    i.relname as \"Key_name\",    a.attname as \"Column_name\" from    pg_class t,    pg_class i,    pg_index ix,    pg_attribute a where    t.oid = ix.indrelid    and i.oid = ix.indexrelid    and a.attrelid = t.oid    and a.attnum = ANY(ix.indkey)    and t.relkind = 'r'    and t.relname = '" + xtableName + "'";
        } else {
            return null;
        }
        DBConnection dbc = null;
        Statement stmt = null;
        ResultSet rs = null;
        DBTableIndexMap indexMap = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            stmt = dbc.execute(showCols);
            rs = stmt.getResultSet();
            while (rs.next()) {
                String fldName = rs.getString(colName_Column_name);
                String ndxName = rs.getString(colName_Key_name);
                if (!StringTools.isBlank(fldName) && !StringTools.isBlank(ndxName)) {
                    if (indexMap == null) {
                        indexMap = new DBTableIndexMap(utableName);
                    }
                    if (dbp.getID() == 4) {
                        if (ndxName.startsWith("PK__")) {
                            ndxName = PRIMARY_INDEX_NAME;
                        } else if (ndxName.startsWith("UQ__")) {
                            ndxName = UNIQUE_INDEX_NAME;
                        }
                    }
                    indexMap.addIndexColumn(ndxName, fldName);
                    continue;
                }
                throw new DBException("Expected index column names not found");
            }
        }
        catch (SQLException sqe) {
            throw new DBException("Unable to get indexes", sqe);
        }
        catch (Throwable th) {
            Print.logException("Unexpected exception: ", th);
            throw new DBException("Unexpected exception", th);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
            DBConnection.release(dbc);
        }
        return indexMap;
    }

    public static int getDataTypeMask(String localType) {
        int ndx = DBProvider._getTypeIndex(localType, true);
        return DATATYPE_ARRAY[ndx];
    }

    public static boolean isDataTypeBoolean(int typeNdx) {
        return (typeNdx & 1) != 0;
    }

    public static boolean isDataTypeBoolean(String localType) {
        return DBProvider.isDataTypeBoolean(DBProvider.getDataTypeMask(localType));
    }

    public static boolean isDataTypeNumeric(int typeNdx) {
        return (typeNdx & 0xE) != 0;
    }

    public static boolean isDataTypeNumeric(String localType) {
        return DBProvider.isDataTypeNumeric(DBProvider.getDataTypeMask(localType));
    }

    public static boolean isDataTypeDecimal(int typeNdx) {
        return (typeNdx & 8) != 0;
    }

    public static boolean isDataTypeDecimal(String localType) {
        return DBProvider.isDataTypeDecimal(DBProvider.getDataTypeMask(localType));
    }

    public static boolean isDataTypeUnsigned(int typeNdx) {
        return (typeNdx & 2) != 0;
    }

    public static boolean isDataTypeUnsigned(String localType) {
        return DBProvider.isDataTypeUnsigned(DBProvider.getDataTypeMask(localType));
    }

    public static boolean isDataTypeString(int typeNdx) {
        return (typeNdx & 0x10) != 0;
    }

    public static boolean isDataTypeString(String localType) {
        return DBProvider.isDataTypeString(DBProvider.getDataTypeMask(localType));
    }

    public static boolean isDataTypeBinary(int typeNdx) {
        return (typeNdx & 0x20) != 0;
    }

    public static boolean isDataTypeBinary(String localType) {
        return DBProvider.isDataTypeBinary(DBProvider.getDataTypeMask(localType));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDatabase(String rootUser, String rootPass) throws DBException, SQLException {
        String dbName = DBProvider.getDBName();
        if (StringTools.isBlank(dbName)) {
            throw new DBException("No database name specified");
        }
        String dbUri = DBProvider.getDBUri(false);
        DBConnection dbc = null;
        switch (DBProvider.getProvider().getID()) {
            case 1: {
                dbc = DBConnection.getDBConnection(dbUri, rootUser, rootPass);
                try {
                    dbc.executeUpdate("CREATE DATABASE " + dbName + ";");
                    break;
                }
                finally {
                    DBConnection.release(dbc);
                }
            }
            case 2: {
                dbc = DBConnection.getDBConnection(dbUri, rootUser, rootPass);
                try {
                    dbc.executeUpdate("CREATE DATABASE " + dbName + ";");
                    break;
                }
                finally {
                    DBConnection.release(dbc);
                }
            }
            case 3: {
                dbc = DBConnection.getDBConnection(dbUri, rootUser, rootPass);
                DBConnection.release(dbc);
                break;
            }
            case 4: {
                dbc = DBConnection.getDBConnection(dbUri, rootUser, rootPass);
                try {
                    dbc.executeUpdate("CREATE DATABASE " + dbName + ";");
                    break;
                }
                finally {
                    DBConnection.release(dbc);
                }
            }
        }
        Print.logInfo("Database created: " + dbName, new Object[0]);
    }

    public static String translateTableName(DBProvider dbprov, String tn) {
        DBProvider dbp = dbprov != null ? dbprov : DBProvider.getProvider();
        NameFilter tnf = dbp.getTableNameFilter();
        return tnf != null ? tnf.name(tn) : tn;
    }

    public static String translateTableName(String tn) {
        DBProvider dbp = DBProvider.getProvider();
        NameFilter tnf = dbp.getTableNameFilter();
        return tnf != null ? tnf.name(tn) : tn;
    }

    public static String _translateTableName(String tn) {
        return tn;
    }

    public static String translateColumnName(String cn) {
        DBProvider dbp = DBProvider.getProvider();
        NameFilter cnf = dbp.getColumnNameFilter();
        return cnf != null ? cnf.name(cn) : cn;
    }

    public static void createTable(DBFactory factory) throws SQLException, DBException {
        String utableName = factory.getUntranslatedTableName();
        DBField[] fields = factory.getFields();
        DBField[] priKeys = factory.getKeyFields();
        String priKeyType = factory.getKeyType();
        DBProvider.createTable(utableName, fields, priKeys, priKeyType, factory.getAlternateIndexes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTable(String utableName, DBField[] flds, DBField[] priKeys, String keyType, DBAlternateIndex[] altIndexes) throws SQLException, DBException {
        DBProvider dbp = DBProvider.getProvider();
        int dbProvID = dbp.getID();
        String xtableName = DBProvider.translateTableName(utableName);
        StringBuffer sb = new StringBuffer();
        sb.append("CREATE TABLE ").append(xtableName).append(" (");
        DBField autoIncrField = null;
        for (int fx = 0; fx < flds.length; ++fx) {
            if (fx > 0) {
                sb.append(",");
            }
            sb.append(flds[fx].getFieldDefinition());
            if (dbProvID != 1) continue;
            if (flds[fx].isAutoIncrement()) {
                autoIncrField = flds[fx];
                sb.append(" NOT NULL");
                sb.append(" auto_increment");
                Print.logInfo("Adding 'auto_increment' key: " + xtableName + "." + autoIncrField.getName(), new Object[0]);
                continue;
            }
            if (!flds[fx].isUTF8()) continue;
            sb.append(" CHARACTER SET utf8");
        }
        if (priKeys != null && priKeys.length > 0) {
            sb.append(", ");
            sb.append(keyType).append(" (");
            for (int pkx = 0; pkx < priKeys.length; ++pkx) {
                if (pkx > 0) {
                    sb.append(",");
                }
                sb.append(priKeys[pkx].getName());
            }
            sb.append(")");
        }
        sb.append(")");
        String indexType = dbp.getTableIndexType();
        if (indexType != null) {
            sb.append(" ").append(indexType);
        }
        DBConnection dbc = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            dbc.executeUpdate(sb.toString());
        }
        finally {
            DBConnection.release(dbc);
        }
        if (altIndexes != null && altIndexes.length > 0) {
            for (int i = 0; i < altIndexes.length; ++i) {
                DBProvider.createAlternateIndex(utableName, altIndexes[i]);
            }
        }
        if (autoIncrField != null) {
            String altIndexName = "autoIncrement";
            Print.logInfo("Adding 'auto_increment' altIndex: " + xtableName + " " + altIndexName, new Object[0]);
            DBField[] altNdxFlds = new DBField[]{autoIncrField};
            DBProvider.createAlternateIndex(utableName, altIndexName, altNdxFlds, true);
        }
    }

    public static void createAlternateIndex(String utableName, DBAlternateIndex altIndex) throws SQLException, DBException {
        String indexName = altIndex.getIndexName();
        DBField[] indexFlds = altIndex.getFields();
        boolean isUnique = altIndex.isUnique();
        DBProvider.createAlternateIndex(utableName, indexName, indexFlds, isUnique);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createAlternateIndex(String utableName, String indexName, DBField[] altKeys, boolean isUnique) throws SQLException, DBException {
        String xtableName = DBProvider.translateTableName(utableName);
        if (altKeys != null && altKeys.length > 0) {
            if (StringTools.isBlank(indexName)) {
                indexName = DEFAULT_ALT_INDEX_NAME;
            }
            switch (DBProvider.getProvider().getID()) {
                case 3: {
                    indexName = utableName + "_" + indexName;
                }
            }
            DBFactory.KeyType keyType = isUnique ? DBFactory.KeyType.UNIQUE_INDEX : DBFactory.KeyType.INDEX;
            StringBuffer altSB = new StringBuffer();
            altSB.append("CREATE ");
            altSB.append(DBFactory.getKeyTypeName(keyType)).append(" ");
            altSB.append(indexName).append(" ");
            altSB.append("ON ").append(xtableName).append(" ");
            altSB.append("(");
            for (int akx = 0; akx < altKeys.length; ++akx) {
                if (akx > 0) {
                    altSB.append(",");
                }
                altSB.append(altKeys[akx].getName());
            }
            altSB.append(")");
            DBConnection dbc = null;
            try {
                dbc = DBConnection.getDefaultConnection();
                dbc.executeUpdate(altSB.toString());
            }
            finally {
                DBConnection.release(dbc);
            }
        } else {
            Print.logWarn("Ignoring alternate index with no specified fields: " + xtableName + " " + indexName, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAlternateIndex(String utableName, String indexName) throws SQLException, DBException {
        String xtableName = DBProvider.translateTableName(utableName);
        if (StringTools.isBlank(indexName)) {
            indexName = DEFAULT_ALT_INDEX_NAME;
        }
        switch (DBProvider.getProvider().getID()) {
            case 4: {
                break;
            }
            case 3: {
                indexName = utableName + "_" + indexName;
            }
        }
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ").append(xtableName).append(" ");
        sb.append("DROP ");
        sb.append(DBFactory.getKeyTypeName(DBFactory.KeyType.INDEX));
        sb.append(" ");
        sb.append(indexName);
        DBConnection dbc = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            dbc.executeUpdate(sb.toString());
        }
        finally {
            DBConnection.release(dbc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createPrimaryIndex(DBFactory dbFact) throws SQLException, DBException {
        DBField[] priKeys;
        DBField[] dBFieldArray = priKeys = dbFact != null ? dbFact.getKeyFields() : null;
        if (priKeys != null && priKeys.length > 0) {
            String xtableName = dbFact.getTranslatedTableName();
            switch (DBProvider.getProvider().getID()) {
                default: 
            }
            StringBuffer sb = new StringBuffer();
            sb.append("ALTER TABLE ").append(xtableName);
            sb.append(" ADD ").append(dbFact.getKeyType());
            sb.append(" (");
            for (int pkx = 0; pkx < priKeys.length; ++pkx) {
                if (pkx > 0) {
                    sb.append(",");
                }
                sb.append(priKeys[pkx].getName());
            }
            sb.append(")");
            DBConnection dbc = null;
            try {
                dbc = DBConnection.getDefaultConnection();
                dbc.executeUpdate(sb.toString());
            }
            finally {
                DBConnection.release(dbc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePrimaryIndex(String utableName) throws SQLException, DBException {
        String xtableName = DBProvider.translateTableName(utableName);
        switch (DBProvider.getProvider().getID()) {
            default: 
        }
        StringBuffer altSB = new StringBuffer();
        altSB.append("ALTER TABLE ").append(xtableName).append(" ");
        altSB.append("DROP PRIMARY KEY");
        DBConnection dbc = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            dbc.executeUpdate(altSB.toString());
        }
        finally {
            DBConnection.release(dbc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dropTable(String utableName) throws SQLException, DBException {
        String xtableName = DBProvider.translateTableName(utableName);
        String drop = null;
        switch (DBProvider.getProvider().getID()) {
            case 1: {
                drop = "DROP TABLE IF EXISTS " + xtableName;
                break;
            }
            case 2: {
                drop = "DROP TABLE " + xtableName;
                break;
            }
            case 3: {
                drop = "DROP TABLE " + xtableName;
                break;
            }
            case 4: {
                drop = "DROP TABLE " + xtableName;
            }
        }
        if (drop != null) {
            DBConnection dbc = null;
            try {
                dbc = DBConnection.getDefaultConnection();
                dbc.executeUpdate(drop);
            }
            catch (SQLException sqe) {
                String sqlMsg = sqe.getMessage();
                int errCode = sqe.getErrorCode();
                if (errCode == 1146) {
                }
                if (errCode == 3701) {
                }
                if (sqlMsg.indexOf("does not exist") >= 0) {
                }
                throw sqe;
            }
            finally {
                DBConnection.release(dbc);
            }
        } else {
            Print.logError("SQL 'DROP' not supported", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean insertRecordIntoTable(DBRecord rec) throws SQLException, DBException {
        DBRecordKey recKey = rec.getRecordKey();
        StringBuffer sb = new StringBuffer();
        String xtableName = recKey.getTranslatedTableName();
        DBFactory recFact = recKey.getFactory();
        Map<String, DBField> existingColumns = recFact.getExistingColumnMap(false);
        DBField[] field = recKey.getFields();
        DBField autoIncrField = null;
        DBFieldValues fieldValues = recKey.getFieldValues();
        boolean addedField = false;
        sb.append("INSERT INTO ").append(recKey.getTranslatedTableName());
        StringBuffer colSB = new StringBuffer();
        StringBuffer valSB = new StringBuffer();
        for (int i = 0; i < field.length; ++i) {
            String fldName = field[i].getName();
            String xFldName = DBProvider.translateColumnName(fldName);
            if (field[i].isAutoIncrement()) {
                autoIncrField = field[i];
                continue;
            }
            if (existingColumns == null || existingColumns.containsKey(xFldName)) {
                if (addedField) {
                    colSB.append(",");
                    valSB.append(",");
                }
                Object fldVal = fieldValues.getFieldValue(fldName, true);
                String dbVal = field[i].getQValue(fldVal);
                colSB.append(DBProvider.getProvider().quoteColumnName(fldName));
                valSB.append(dbVal);
                addedField = true;
                continue;
            }
            if (!recFact.logMissingColumnWarning()) continue;
            Print.logWarn("Insert: Field does not exist: " + xtableName + "." + fldName + " [ignored]", new Object[0]);
        }
        sb.append(" (").append(colSB).append(")");
        sb.append(" VALUES (").append(valSB).append(")");
        if (addedField) {
            DBConnection dbc = null;
            try {
                dbc = DBConnection.getDefaultConnection();
                if (autoIncrField != null) {
                    long autoIncrVal = dbc.executeUpdate(sb.toString(), true);
                    if (autoIncrVal >= 0L) {
                        Print.logDebug("Auto-Increment value: " + autoIncrVal, new Object[0]);
                        fieldValues.setFieldValue(autoIncrField.getName(), autoIncrVal);
                    }
                } else {
                    dbc.executeUpdate(sb.toString());
                }
            }
            finally {
                DBConnection.release(dbc);
            }
            return true;
        }
        Print.logInfo("No columns specified to insert!!! [" + xtableName + "]", new Object[0]);
        if (existingColumns != null) {
            Print.logInfo("Existing columns: ", new Object[0]);
            for (String fldName : existingColumns.keySet()) {
                Print.logInfo("  Column " + fldName, new Object[0]);
            }
        }
        return false;
    }

    public static boolean updateRecordInTable(DBRecord rec, String[] updFldArray) throws SQLException, DBException {
        HashSet<String> updFldSet = null;
        if (updFldArray != null) {
            updFldSet = new HashSet<String>();
            for (int i = 0; i < updFldArray.length; ++i) {
                if (updFldArray[i] == null) continue;
                updFldSet.add(updFldArray[i]);
            }
        }
        return DBProvider.updateRecordInTable(rec, updFldSet);
    }

    public static boolean updateRecordInTable(DBRecord rec, Set<String> updFldSet) throws SQLException, DBException {
        DBRecordKey recKey = rec.getRecordKey();
        StringBuffer sb = new StringBuffer();
        String xtableName = recKey.getTranslatedTableName();
        sb.append("UPDATE ").append(xtableName);
        sb.append(" SET ");
        DBFactory recFact = recKey.getFactory();
        Map<String, DBField> existingColumns = recFact.getExistingColumnMap(false);
        DBFieldValues fieldValues = recKey.getFieldValues();
        DBField[] field = recKey.getFields();
        boolean addedField = false;
        for (int i = 0; i < field.length; ++i) {
            String fldName = field[i].getName();
            if (updFldSet != null && !updFldSet.contains(fldName)) continue;
            if (!field[i].isUpdateAllowed()) {
                if (updFldSet == null) continue;
                String type = field[i].isPrimaryKey() ? "Primary key" : "Field";
                Print.logWarn(type + " update not allowed: " + xtableName + "." + fldName + " [ignored]", new Object[0]);
                continue;
            }
            if (field[i].isAutoIncrement() || updFldSet == null && (rec.excludeFieldFromUpdate(field[i]) || fldName.equals("creationTime") || fldName.equals("creationMillis"))) continue;
            if (existingColumns != null && !existingColumns.containsKey(fldName)) {
                if (!recFact.logMissingColumnWarning()) continue;
                Print.logWarn("Update: Field does not exist: " + xtableName + "." + fldName + " [ignored]", new Object[0]);
                continue;
            }
            if (addedField) {
                sb.append(", ");
            }
            Object fldVal = fieldValues.getFieldValue(fldName, true);
            String dbVal = field[i].getQValue(fldVal);
            sb.append(DBProvider.getProvider().quoteColumnName(fldName));
            sb.append("=").append(dbVal);
            addedField = true;
        }
        sb.append(recKey.getWhereClause(DBWhere.KEY_FULL));
        if (addedField) {
            DBConnection dbc = null;
            try {
                dbc = DBConnection.getDefaultConnection();
                dbc.executeUpdate(sb.toString());
            }
            catch (SQLException sqle) {
                Print.logError("SQL(ExecuteUpdate): " + sb, new Object[0]);
                throw sqle;
            }
            catch (DBException dbe) {
                Print.logError("SQL(ExecuteUpdate): " + sb, new Object[0]);
                throw dbe;
            }
            finally {
                DBConnection.release(dbc);
            }
            return true;
        }
        Print.logInfo("No columns specified to update!!! [" + xtableName + "]", new Object[0]);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void grantDBUser(String rootUser, String rootPass) throws DBException, SQLException {
        grantUser = DBProvider.getDBUsername();
        grantPass = DBProvider.getDBPassword();
        dbName = DBProvider.getDBName();
        if (StringTools.isBlank(rootUser)) {
            throw new DBException("Root user not specified");
        }
        if (StringTools.isBlank(grantUser)) {
            throw new DBException("User not specified for GRANT access");
        }
        if (grantUser.equalsIgnoreCase("root")) {
            throw new DBException("Refusing to change privileges for 'root'");
        }
        if (StringTools.isBlank(dbName)) {
            throw new DBException("No database name specified");
        }
        dbUri = DBProvider.getDBUri(false);
        dbc = DBConnection.getDBConnection(dbUri, rootUser, rootPass);
        try {
            switch (DBProvider.getProvider().getID()) {
                case 1: {
                    grantS = "GRANT ALL ON " + dbName + ".* TO " + grantUser + "@";
                    grantE = " IDENTIFIED BY " + DBField.quote(grantPass) + " WITH GRANT OPTION;";
                    dbc.executeUpdate(grantS + "localhost" + grantE);
                    dbc.executeUpdate(grantS + DBField.quote("%") + grantE);
                    dbc.executeUpdate("FLUSH PRIVILEGES;");
                    ** break;
lbl23:
                    // 1 sources

                    break;
                }
                case 2: {
                    grantS = "GRANT ALL ON " + dbName + " TO " + grantUser;
                    grantE = " WITH GRANT OPTION;";
                    dbc.executeUpdate(grantS + grantE);
                    ** break;
lbl29:
                    // 1 sources

                    break;
                }
                case 3: {
                    ** break;
lbl32:
                    // 1 sources

                    break;
                }
                case 4: {
                    try {
                        createLogin = "CREATE LOGIN " + grantUser + " WITH PASSWORD='" + grantPass + "', DEFAULT_DATABASE=[" + dbName + "]";
                        dbc.executeUpdate(createLogin);
                    }
                    catch (SQLException sqe) {
                        errCode = sqe.getErrorCode();
                        if (errCode == 15025) {
                            Print.logWarn("This login already exists: " + grantUser, new Object[0]);
                        }
                        throw sqe;
                    }
                    try {
                        createUser = "USE " + dbName + "; CREATE USER " + grantUser + " FOR LOGIN " + grantUser;
                        dbc.executeUpdate(createUser);
                    }
                    catch (SQLException sqe) {
                        errCode = sqe.getErrorCode();
                        if (errCode == 15023) {
                            Print.logWarn("This user already exists: " + grantUser, new Object[0]);
                        }
                        throw sqe;
                    }
                    alterRole = "USE " + dbName + "; ALTER ROLE [db_owner] ADD MEMBER [" + grantUser + "]";
                    dbc.executeUpdate(alterRole);
                    perm = "SELECT,INSERT,UPDATE,DELETE,REFERENCES";
                    grantAll = "USE " + dbName + "; GRANT " + perm + " TO " + grantUser;
                    dbc.executeUpdate(grantAll);
                    ** break;
lbl65:
                    // 1 sources

                    break;
                }
                ** default:
lbl69:
                // 1 sources

                break;
            }
        }
        finally {
            DBConnection.release(dbc);
        }
        Print.logInfo("Privileges granted to user: " + grantUser, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static String getDefaultCharacterSet() throws DBException, SQLException {
        user = DBProvider.getDBUsername();
        pass = DBProvider.getDBPassword();
        dbName = DBProvider.getDBName();
        if (StringTools.isBlank(user)) {
            throw new DBException("User not specified");
        }
        if (StringTools.isBlank(dbName)) {
            throw new DBException("No database name specified");
        }
        charSet = new StringBuffer();
        dbc = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            stmt = null;
            rs = null;
            switch (DBProvider.getProvider().getID()) {
                case 1: {
                    try {
                        stmt = dbc.execute("SHOW VARIABLES LIKE 'character_set_database'");
                        rs = stmt.getResultSet();
                        if (rs.next()) {
                            charSet.append(StringTools.trim(rs.getString("Value")));
                        }
                    }
                    finally {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable t) {}
                        }
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable t) {}
                        }
                    }
                    try {
                        stmt = dbc.execute("SHOW VARIABLES LIKE 'collation_database'");
                        rs = stmt.getResultSet();
                        if (rs.next()) {
                            charSet.append("[").append(StringTools.trim(rs.getString("Value"))).append("]");
                        }
                        if (rs == null) ** GOTO lbl61
                    }
                    catch (Throwable var10_14) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable t) {
                                // empty catch block
                            }
                        }
                        throw var10_14;
                    }
                    try {
                        rs.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
lbl61:
                    // 3 sources

                    if (stmt == null) ** break;
                    try {
                        stmt.close();
                        ** break;
lbl65:
                        // 1 sources

                    }
                    catch (Throwable t) {
                        ** break;
                    }
lbl68:
                    // 1 sources

                    break;
                }
                ** default:
lbl70:
                // 1 sources

                break;
            }
        }
        finally {
            DBConnection.release(dbc);
        }
        return charSet.toString();
    }

    public static boolean isTableLockingEnabled() {
        if (DBConnection.ALWAYS_NEW_CONNECTION) {
            Print.logDebug("Table locking is disabled (per DBConnection.ALWAYS_NEW_CONNECTION)", new Object[0]);
            return false;
        }
        if (lockingEnabled == null) {
            lockingEnabled = new Boolean(RTConfig.getBoolean("db.tableLocking"));
            Print.logDebug("Table locking is " + (lockingEnabled != false ? "enabled" : "disabled"), new Object[0]);
        }
        return lockingEnabled;
    }

    public static int getLockLevel() {
        return lockLevel.size();
    }

    public static boolean lockTables(String[] writeTables, String[] readTables) throws DBException {
        return DBProvider._lockTables(writeTables, readTables, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean _lockTables(String[] writeTables, String[] readTables, boolean forceLock) throws DBException {
        ++lockSeq;
        if (writeTables == null && readTables == null) {
            return false;
        }
        DBProvider dbp = DBProvider.getProvider();
        int dbid = dbp.getID();
        if (dbid != 1) {
            return false;
        }
        if (!lockLevel.empty()) {
            Print.logStackTrace("Locking: Lock-Level is not empty!");
            Print.logStackTrace("Location of prior table locking", lockLevel.peek());
        }
        try {
            String xtableName;
            StringBuffer sb = new StringBuffer();
            sb.append("LOCK TABLES ");
            if (writeTables != null) {
                for (int w = 0; w < writeTables.length; ++w) {
                    if (w > 0) {
                        sb.append(",");
                    }
                    xtableName = DBProvider.translateTableName(writeTables[w]);
                    sb.append(xtableName).append(" WRITE");
                }
            }
            if (readTables != null) {
                if (writeTables != null) {
                    sb.append(",");
                }
                for (int r = 0; r < readTables.length; ++r) {
                    if (r > 0) {
                        sb.append(",");
                    }
                    xtableName = DBProvider.translateTableName(readTables[r]);
                    sb.append(xtableName).append(" READ");
                }
            }
            if (forceLock || DBProvider.isTableLockingEnabled()) {
                Throwable t = new Throwable();
                t.fillInStackTrace();
                DBConnection dbc = null;
                try {
                    dbc = DBConnection.getDefaultConnection();
                    dbc.executeUpdate(sb.toString());
                }
                finally {
                    DBConnection.release(dbc);
                }
                lockLevel.push(t);
            }
            return true;
        }
        catch (SQLException sqe) {
            Print.logSQLError("Read/Write lock", sqe);
            return false;
        }
    }

    public static boolean lockTableForRead(String utableName, boolean forceLock) throws DBException {
        return DBProvider._lockTables(null, new String[]{utableName}, forceLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unlockTables() throws DBException {
        ++unlockSeq;
        DBProvider dbp = DBProvider.getProvider();
        int dbid = dbp.getID();
        if (dbid != 1) {
            return false;
        }
        try {
            if (DBProvider.isTableLockingEnabled() || !lockLevel.empty()) {
                String unlockSql = "UNLOCK TABLES";
                DBConnection dbc = null;
                try {
                    dbc = DBConnection.getDefaultConnection();
                    dbc.executeUpdate(unlockSql);
                }
                finally {
                    DBConnection.release(dbc);
                }
                if (!lockLevel.empty()) {
                    lockLevel.pop();
                } else {
                    Print.logStackTrace("Lock-Level stack is empty");
                }
            }
            if (!lockLevel.empty()) {
                Print.logStackTrace("Unlock: Lock-Level is not empty!");
            }
            return true;
        }
        catch (SQLException sqe) {
            Print.logSQLError("unlock tables", sqe);
            return false;
        }
    }

    public DBProvider(String name, int id, int dftPort, String[] drivers, NameFilter colNameFlt, NameFilter ndxNameFlt, NameFilter tblNameFlt, String tblNdxType, long flags, String[] dataTypes) {
        this.jdbcId = id;
        this.jdbcName = name;
        this.jdbcDrivers = drivers;
        this.jdbcFlags = flags;
        this.defaultPort = dftPort;
        this.columnNameFilter = colNameFlt;
        this.indexNameFilter = ndxNameFlt;
        this.tableNameFilter = tblNameFlt;
        this.tableIndexType = tblNdxType != null ? tblNdxType : "";
        this.dataTypes = dataTypes;
        if (this.dataTypes == null || this.dataTypes.length != TYPE_ARRAY.length) {
            String msg = "Invalid number of data-types for DBProvider: " + this.jdbcName;
            Print.logStackTrace(msg);
            throw new RuntimeException(msg);
        }
    }

    public int getID() {
        return this.jdbcId;
    }

    public String getJDBCName() {
        return this.jdbcName;
    }

    public String[] getDrivers() {
        return this.jdbcDrivers;
    }

    public int getDefaultPort() {
        if (RTConfig.hasProperty("db.sql.port", false)) {
            return RTConfig.getInt("db.sql.port");
        }
        return this.defaultPort;
    }

    public NameFilter getColumnNameFilter() {
        return this.columnNameFilter;
    }

    public NameFilter getTableNameFilter() {
        return this.tableNameFilter;
    }

    public String getTableIndexType() {
        return this.tableIndexType;
    }

    public String[] getSQLTypes() {
        return this.dataTypes;
    }

    public long getFlags() {
        return this.jdbcFlags;
    }

    public boolean supportsLimit() {
        return (this.jdbcFlags & 1L) != 0L;
    }

    public boolean supportsOffset() {
        return (this.jdbcFlags & 2L) != 0L;
    }

    public String quoteColumnName(String colName) {
        switch (DBProvider.getProvider().getID()) {
            case 2: {
                return "\"" + colName + "\"";
            }
            case 1: {
                return colName;
            }
            case 4: {
                return colName;
            }
            case 3: {
                return colName;
            }
        }
        return colName;
    }

    public String quoteTableName(String tblName) {
        switch (DBProvider.getProvider().getID()) {
            case 2: {
                return "\"" + tblName + "\"";
            }
            case 1: {
                return tblName;
            }
            case 4: {
                return tblName;
            }
            case 3: {
                return tblName;
            }
        }
        return tblName;
    }

    static {
        globalDBProviderMap.put(MySQL_MyISAM_Provider.getJDBCName(), MySQL_MyISAM_Provider);
        globalDBProviderMap.put(MySQL_InnoDB_Provider.getJDBCName(), MySQL_InnoDB_Provider);
        globalDBProviderMap.put(MySQL_Old_Provider.getJDBCName(), MySQL_Old_Provider);
        globalDBProviderMap.put(MS_SQLServer_Provider.getJDBCName(), MS_SQLServer_Provider);
        globalDBProviderMap.put(PostgreSQL_Provider.getJDBCName(), PostgreSQL_Provider);
        globalDBProviderMap.put(Oracle_XE_Provider.getJDBCName(), Oracle_XE_Provider);
        globalDBProviderMap.put(Derby_Provider.getJDBCName(), Derby_Provider);
        didLogJdbcURL = false;
        JDBC_URL = new String[]{"db.sql.url"};
        JDBC_URL_DB = new String[]{"db.sql.url.db"};
        lockingEnabled = null;
        lockLevel = new Stack();
        lockSeq = 0;
        unlockSeq = 0;
    }

    private static class NameFilterLowerCase
    extends NameFilter {
        public NameFilterLowerCase() {
        }

        public NameFilterLowerCase(String pfx) {
            super(pfx);
        }

        @Override
        protected String adjustCase(String n) {
            return n != null ? n.toLowerCase() : n;
        }
    }

    private static class NameFilterUpperCase
    extends NameFilter {
        public NameFilterUpperCase() {
        }

        public NameFilterUpperCase(String pfx) {
            super(pfx);
        }

        @Override
        protected String adjustCase(String n) {
            return n != null ? n.toUpperCase() : n;
        }
    }

    private static class NameFilter {
        private String prefix = null;

        public NameFilter() {
        }

        public NameFilter(String pfx) {
            this.prefix = !StringTools.isBlank(pfx) ? this.adjustCase(pfx) : null;
        }

        public String name(String name) {
            String n = this.adjustCase(name);
            if (n == null) {
                return "";
            }
            if (this.prefix == null || this.prefix.equals("")) {
                return n;
            }
            return n.startsWith(this.prefix) ? n : this.prefix + n;
        }

        protected String adjustCase(String n) {
            return n;
        }
    }
}

