/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.dbtools;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBFieldType;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordKey;
import org.opengts.util.DateTime;
import org.opengts.util.OrderedMap;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class DBFieldValues {
    private static boolean VALIDATE_FIELD_VALUES = false;
    private String name = "";
    private DBRecordKey recordKey = null;
    private OrderedMap<String, Object> valueMap = new OrderedMap();
    private OrderedMap<String, DBField> fieldMap = new OrderedMap();
    private Map<String, String> caseMap = new HashMap<String, String>();
    private DBFieldValues fieldDelegate = null;
    private boolean mustExist = true;

    public static void setValidateFieldValues(boolean validate) {
        VALIDATE_FIELD_VALUES = validate;
    }

    private DBFieldValues() {
    }

    public DBFieldValues(DBRecordKey rcdKey) {
        this(rcdKey, null);
    }

    public DBFieldValues(DBRecordKey rcdKey, DBFieldValues delegate) {
        this();
        this.recordKey = rcdKey;
        this.fieldDelegate = delegate;
        DBField[] fld = this.fieldDelegate == null ? rcdKey.getFields() : rcdKey.getKeyFields();
        for (int i = 0; i < fld.length; ++i) {
            String fldName = DBProvider.translateColumnName(fld[i].getName());
            this.fieldMap.put(fldName, fld[i]);
            this.caseMap.put(fldName.toLowerCase(), fldName);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = StringTools.trim(name);
    }

    public void setIgnoreInvalidFields(boolean state) {
        this.mustExist = !state;
    }

    public boolean getIgnoreInvalidFields() {
        return !this.mustExist;
    }

    public String getUntranslatedTableName() {
        if (this.recordKey != null) {
            return this.recordKey.getUntranslatedTableName();
        }
        return "";
    }

    public void clearFieldValues() {
        this.clearFieldValues(null);
    }

    public void clearFieldValues(DBField[] fldList) {
        if (this.recordKey != null) {
            DBField[] fld = fldList != null ? fldList : this.recordKey.getFields();
            for (int i = 0; i < fld.length; ++i) {
                if (fld[i].isPrimaryKey()) continue;
                this._setFieldValue(fld[i], null);
            }
        } else {
            Print.logStackTrace("DBRecordKey has not been set!");
        }
    }

    public DBField getField(String fldName) {
        if (this.recordKey != null) {
            return this.recordKey.getField(fldName);
        }
        Print.logStackTrace("DBRecordKey has not been set!");
        return null;
    }

    protected boolean _setFieldValue(String fldName, boolean requiredField, Object newVal) {
        DBField fld = this.getField(fldName);
        if (fld == null) {
            if (this.fieldDelegate != null) {
                return this.fieldDelegate._setFieldValue(fldName, requiredField, newVal);
            }
            if (requiredField && !this.getIgnoreInvalidFields()) {
                String tn = this.getUntranslatedTableName();
                Print.logError("Field does not exist: " + tn + "." + fldName, new Object[0]);
            }
            return false;
        }
        return this._setFieldValue(fld, newVal);
    }

    public boolean _setFieldValue(DBField fld, Object newVal) {
        DBRecord rcd;
        if (newVal != null) {
            Class fldTypeClass = fld.getTypeClass();
            if (!(newVal.getClass() == fldTypeClass || newVal instanceof Boolean && fld.isTypeBoolean() || newVal instanceof Integer && fld.isTypeInteger() || newVal instanceof Long && fld.isTypeLong() || newVal instanceof Float && fld.isTypeFloat() || newVal instanceof Double && fld.isTypeDouble() || newVal instanceof byte[] && fld.isTypeBLOB() || newVal instanceof DateTime && fld.isTypeDateTime())) {
                Print.logStackTrace("Invalid type[" + fld.getName() + "]:" + " found '" + StringTools.className(newVal) + "'" + ", expected '" + StringTools.className(fldTypeClass) + "'");
                if (String.class.isAssignableFrom(fldTypeClass)) {
                    newVal = newVal.toString();
                    Print.logWarn("Converted to data type: " + StringTools.className(newVal), new Object[0]);
                } else if (Number.class.isAssignableFrom(fldTypeClass) && newVal instanceof Number) {
                    if (Byte.class.equals((Object)fldTypeClass)) {
                        newVal = new Byte(((Number)newVal).byteValue());
                    } else if (Short.class.equals((Object)fldTypeClass)) {
                        newVal = new Short(((Number)newVal).shortValue());
                    } else if (Integer.class.equals((Object)fldTypeClass)) {
                        newVal = new Integer(((Number)newVal).intValue());
                    } else if (Long.class.equals((Object)fldTypeClass)) {
                        newVal = new Long(((Number)newVal).longValue());
                    } else if (Float.class.equals((Object)fldTypeClass)) {
                        newVal = new Float(((Number)newVal).floatValue());
                    } else if (Double.class.equals((Object)fldTypeClass)) {
                        newVal = new Double(((Number)newVal).doubleValue());
                    } else {
                        return false;
                    }
                    Print.logWarn("Converted to data type: " + StringTools.className(newVal), new Object[0]);
                } else {
                    return false;
                }
            }
        }
        String fldName = fld.getName();
        Object oldVal = this._getFieldValue(fldName, true);
        this.valueMap.put(fldName, newVal);
        if (this.fieldDelegate != null) {
            return this.fieldDelegate._setFieldValue(fld, newVal);
        }
        DBRecord dBRecord = rcd = this.recordKey != null ? (DBRecord)this.recordKey._getDBRecord() : null;
        if (rcd != null) {
            rcd.setChanged(fldName, oldVal, newVal);
        } else if (!fld.isKeyField()) {
            Print.logStackTrace("DBRecordKey does not point to a DBRecord! ...");
        }
        return true;
    }

    public boolean setOptionalFieldValue(String fldName, Object newVal) {
        return this._setFieldValue(fldName, false, newVal);
    }

    public boolean setFieldValue(String fldName, Object newVal) {
        return this._setFieldValue(fldName, true, newVal);
    }

    public boolean setOptionalFieldValue(String fldName, String val) {
        return this._setFieldValue(fldName, false, StringTools.trim(val));
    }

    public boolean setFieldValue(String fldName, String val) {
        return this._setFieldValue(fldName, true, StringTools.trim(val));
    }

    public boolean setOptionalFieldValue(String fldName, int val) {
        return this._setFieldValue(fldName, false, new Integer(val));
    }

    public boolean setFieldValue(String fldName, int val) {
        return this._setFieldValue(fldName, true, new Integer(val));
    }

    public boolean setOptionalFieldValue(String fldName, long val) {
        return this._setFieldValue(fldName, false, new Long(val));
    }

    public boolean setFieldValue(String fldName, long val) {
        return this._setFieldValue(fldName, true, new Long(val));
    }

    public boolean setOptionalFieldValue(String fldName, float val) {
        return this._setFieldValue(fldName, false, new Float(val));
    }

    public boolean setFieldValue(String fldName, float val) {
        return this._setFieldValue(fldName, true, new Float(val));
    }

    public boolean setOptionalFieldValue(String fldName, double val) {
        return this._setFieldValue(fldName, false, new Double(val));
    }

    public boolean setFieldValue(String fldName, double val) {
        return this._setFieldValue(fldName, true, new Double(val));
    }

    public boolean setOptionalFieldValue(String fldName, boolean val) {
        return this._setFieldValue(fldName, false, new Boolean(val));
    }

    public boolean setFieldValue(String fldName, boolean val) {
        return this._setFieldValue(fldName, true, new Boolean(val));
    }

    public boolean setOptionalFieldValue(String fldName, byte[] val) {
        return this._setFieldValue(fldName, false, val != null ? val : new byte[]{});
    }

    public boolean setFieldValue(String fldName, byte[] val) {
        return this._setFieldValue(fldName, true, val != null ? val : new byte[]{});
    }

    public boolean setOptionalFieldValue(String fldName, DateTime val) {
        return this._setFieldValue(fldName, false, val);
    }

    public boolean setFieldValue(String fldName, DateTime val) {
        return this._setFieldValue(fldName, true, val);
    }

    public void setAllFieldValues(ResultSet rs) throws SQLException {
        this.setAllFieldValues(rs, true, null);
    }

    public void setAllFieldValues(ResultSet rs, boolean setPrimaryKey) throws SQLException {
        this.setAllFieldValues(rs, setPrimaryKey, null);
    }

    public void setAllFieldValues(ResultSet rs, boolean setPrimaryKey, DBField[] fldList) throws SQLException {
        if (rs != null) {
            if (this.recordKey != null) {
                String utableName = this.getUntranslatedTableName();
                DBField[] fld = fldList != null ? fldList : this.recordKey.getFields();
                boolean logMissingCols = this.recordKey.getFactory().logMissingColumnWarning();
                for (int i = 0; i < fld.length; ++i) {
                    if (!setPrimaryKey && fld[i].isPrimaryKey()) continue;
                    try {
                        Object val = fld[i].getResultSetValue(rs);
                        this._setFieldValue(fld[i], val);
                        continue;
                    }
                    catch (SQLException sqe) {
                        long errCnt;
                        int errCode = sqe.getErrorCode();
                        String tblColName = utableName + "." + fld[i].getName();
                        if (errCode == 1054) {
                            errCnt = fld[i].incrementErrorCount();
                            if (errCnt % 50L != 1L) continue;
                            Print.logException("Unknown Column: '" + tblColName + "'", sqe);
                            continue;
                        }
                        if (sqe.getMessage().indexOf("Column") >= 0) {
                            if (DBField.IgnoreColumnError(utableName, fld[i].getName())) continue;
                            if (RTConfig.isDebugMode() && logMissingCols) {
                                Print.logError("Column '" + tblColName + "'? " + sqe, new Object[0]);
                                continue;
                            }
                            errCnt = fld[i].incrementErrorCount();
                            if (errCnt % 50L != 1L || !logMissingCols) continue;
                            Print.logError("Column '" + tblColName + "'? " + sqe, new Object[0]);
                            continue;
                        }
                        throw sqe;
                    }
                }
            } else {
                Print.logStackTrace("DBRecordKey has not been set!");
            }
        }
    }

    public void setAllFieldValues(Map<String, String> valMap) throws DBException {
        this.setAllFieldValues(valMap, true);
    }

    public void setAllFieldValues(Map<String, String> valMap, boolean setPrimaryKey) throws DBException {
        this.setFieldValues(valMap, setPrimaryKey, true);
    }

    public void setFieldValues(Map<String, String> valMap, boolean setPrimaryKey, boolean requireAllFields) throws DBException {
        if (this.recordKey != null) {
            String utableName = this.getUntranslatedTableName();
            DBField[] fld = this.recordKey.getFields();
            for (int i = 0; i < fld.length; ++i) {
                Object v;
                String name = fld[i].getName();
                String val = valMap.get(name);
                if (fld[i].isPrimaryKey()) {
                    if (!setPrimaryKey) continue;
                    if (val != null) {
                        v = fld[i].parseStringValue(val);
                        this._setFieldValue(fld[i], v);
                        continue;
                    }
                    throw new DBException("Setting Key Field Values: value not defined for field - " + name);
                }
                if (val != null) {
                    v = fld[i].parseStringValue(val);
                    this._setFieldValue(fld[i], v);
                    continue;
                }
                if (!requireAllFields) continue;
                Print.logError("Column '" + utableName + "." + name + "' value not specified.", new Object[0]);
            }
        } else {
            Print.logStackTrace("DBRecordKey has not been set!");
        }
    }

    public void setFieldValues(DBFieldValues fldVals, boolean setPrimaryKey, boolean requireAllFields) throws DBException {
        if (this.recordKey != null && fldVals != null) {
            String utableName = this.getUntranslatedTableName();
            DBField[] fld = this.recordKey.getFields();
            for (int i = 0; i < fld.length; ++i) {
                String name = fld[i].getName();
                Object val = fldVals.getOptionalFieldValue(name);
                if (fld[i].isPrimaryKey()) {
                    if (!setPrimaryKey) continue;
                    if (val != null) {
                        this._setFieldValue(fld[i], val);
                        continue;
                    }
                    throw new DBException("Setting Key Field Values: value not defined for field - " + name);
                }
                if (val != null) {
                    this._setFieldValue(fld[i], val);
                    continue;
                }
                if (!requireAllFields) continue;
                Print.logError("Column '" + utableName + "." + name + "' value not specified.", new Object[0]);
            }
        } else {
            Print.logStackTrace("DBRecordKey has not been set!");
        }
    }

    public String getFieldName(String fldName) {
        if (fldName != null) {
            return this.caseMap.get(fldName.toLowerCase());
        }
        return null;
    }

    public boolean hasField(String fldName) {
        if (fldName == null) {
            return false;
        }
        String fn = DBProvider.translateColumnName(fldName);
        return this.fieldMap.containsKey(fn);
    }

    public boolean hasFieldValue(String fldName) {
        if (fldName == null) {
            return false;
        }
        if (this.valueMap.containsKey(fldName)) {
            return true;
        }
        if (this.fieldDelegate != null) {
            return this.fieldDelegate.hasFieldValue(fldName);
        }
        return false;
    }

    protected Object _getFieldValue(String fldName, boolean requiredField) {
        if (fldName == null) {
            return null;
        }
        Object val = this.valueMap.get(fldName);
        if (val != null) {
            return val;
        }
        if (this.fieldDelegate != null) {
            return this.fieldDelegate._getFieldValue(fldName, requiredField);
        }
        if (this.hasField(fldName)) {
            return null;
        }
        if (requiredField && !this.getIgnoreInvalidFields()) {
            String utableName = this.getUntranslatedTableName();
            Print.logStackTrace("(" + this.getName() + ") Field not found: " + utableName + "." + fldName);
            return null;
        }
        return null;
    }

    protected Object _getFieldValue(String fldName, boolean requiredField, boolean rtnDft) {
        Object obj = this._getFieldValue(fldName, requiredField);
        if (obj == null && rtnDft) {
            DBField fld = this.getField(fldName);
            if (fld != null) {
                obj = fld.getDefaultValue();
                if (obj == null) {
                    Print.logStackTrace("Field doesn't support a default value: " + fldName);
                    return null;
                }
            } else {
                return null;
            }
        }
        return obj;
    }

    public Object getOptionalFieldValue(String fldName) {
        return this._getFieldValue(fldName, false, false);
    }

    public Object getOptionalFieldValue(String fldName, boolean rtnDft) {
        return this._getFieldValue(fldName, false, rtnDft);
    }

    public Object getFieldValue(String fldName) {
        return this._getFieldValue(fldName, true, false);
    }

    public Object getFieldValue(String fldName, boolean rtnDft) {
        return this._getFieldValue(fldName, true, rtnDft);
    }

    public String getFieldValueAsString(String fldName) {
        String fmt;
        DBField fld;
        Object val = this.getFieldValue(fldName, true);
        if (val instanceof Number && (fld = this.getField(fldName)) != null && (fmt = fld.getFormat()) != null && fmt.startsWith("X")) {
            return fld.formatValue(val);
        }
        return DBFieldValues.toStringValue(val);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        String utableName = this.getUntranslatedTableName();
        sb.append(this.getName()).append(" ");
        sb.append("[").append(utableName).append("]");
        for (String fld : this.valueMap.keySet()) {
            Object val = this.valueMap.get(fld);
            sb.append(" ");
            sb.append(fld).append("=").append(StringTools.trim(val));
        }
        return sb.toString();
    }

    public static String toStringValue(Object obj) {
        if (obj == null) {
            return "";
        }
        if (obj instanceof DBFieldType) {
            obj = ((DBFieldType)obj).getObject();
        }
        if (obj instanceof String) {
            return ((String)obj).trim();
        }
        if (obj instanceof Double) {
            Double N = (Double)obj;
            if (N.isNaN()) {
                Print.logWarn("Invalid Double value: " + N, new Object[0]);
                return "0.0";
            }
            if (N.isInfinite()) {
                Print.logWarn("Invalid Double value: " + N, new Object[0]);
                return new Double(N >= 0.0 ? Double.MAX_VALUE : -1.7976931348623157E308).toString();
            }
            return N.toString();
        }
        if (obj instanceof Float) {
            Float N = (Float)obj;
            if (N.isNaN()) {
                Print.logWarn("Invalid Float value: " + N, new Object[0]);
                return "0.0";
            }
            if (N.isInfinite()) {
                Print.logWarn("Invalid Float value: " + N, new Object[0]);
                return new Float((double)N.floatValue() >= 0.0 ? Float.MAX_VALUE : -3.4028235E38f).toString();
            }
            return N.toString();
        }
        if (obj instanceof Number) {
            return obj.toString();
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj != false ? "1" : "0";
        }
        if (obj instanceof byte[]) {
            String hex = StringTools.toHexString((byte[])obj);
            return "0x" + hex;
        }
        if (obj instanceof DateTime) {
            DateTime dt = (DateTime)obj;
            return dt.format("yyyy-MM-dd HH:mm:ss", DateTime.getGMTTimeZone());
        }
        Print.logWarn("Converting object to string: " + StringTools.className(obj), new Object[0]);
        return obj.toString();
    }
}

