/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.dbtools;

import java.lang.reflect.Constructor;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBFieldType;
import org.opengts.dbtools.DBFieldValues;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.util.DateTime;
import org.opengts.util.EnumTools;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class DBField {
    private static final boolean DEFAULT_REQUIRED = true;
    public static final String TYPE_BOOLEAN = "BOOLEAN";
    public static final String TYPE_INT8 = "INT8";
    public static final String TYPE_UINT8 = "UINT8";
    public static final String TYPE_INT16 = "INT16";
    public static final String TYPE_UINT16 = "UINT16";
    public static final String TYPE_INT32 = "INT32";
    public static final String TYPE_UINT32 = "UINT32";
    public static final String TYPE_INT64 = "INT64";
    public static final String TYPE_UINT64 = "UINT64";
    public static final String TYPE_FLOAT = "FLOAT";
    public static final String TYPE_DOUBLE = "DOUBLE";
    public static final String TYPE_SBLOB = "SBLOB";
    public static final String TYPE_BLOB = "BLOB";
    public static final String TYPE_MBLOB = "MBLOB";
    public static final String TYPE_TEXT = "TEXT";
    public static final String TYPE_STRING = "STRING";
    public static final String TYPE_DATETIME = "DATETIME";
    public static final String SQL_AUTO_INCREMENT = "auto_increment";
    public static final String SQL_NOT_NULL = "NOT NULL";
    public static final int EDIT_NEVER = -1;
    public static final int EDIT_NEW = 0;
    public static final int EDIT_ADMIN = 1;
    public static final int EDIT_PUBLIC = 2;
    public static final String ATTR_KEY = "key";
    public static final String ATTR_UNIQUE = "unique";
    public static final String ATTR_ALTKEY = "altkey";
    public static final String ATTR_OPTIONAL = "optional";
    public static final String ATTR_REQUIRED = "required";
    public static final String ATTR_EDIT = "edit";
    public static final String ATTR_FORMAT = "format";
    public static final String ATTR_ENUM = "enum";
    public static final String ATTR_MASK = "mask";
    public static final String ATTR_EDITOR = "editor";
    public static final String ATTR_PRESEP = "presep";
    public static final String ATTR_UPDATE = "update";
    public static final String ATTR_UTF8 = "utf8";
    public static final String ATTR_AUTO_INCR = "auto";
    public static final String ATTR_UNITS = "units";
    public static final char ENUM_TYPE_SEPARATOR = '|';
    public static final char ENUM_VALUE_SEPARATOR = ':';
    public static final char MASK_TYPE_SEPARATOR = '|';
    public static final char MASK_VALUE_SEPARATOR = ':';
    public static final char ALT_INDEX_SEPARATOR = ',';
    private static final char ESCAPE_CHAR = '\\';
    private static final char QUOTE_CHAR = '\'';
    private String name = "";
    private Class javaClass = null;
    private String sqlType = null;
    private String charSet = "";
    private String dataType = "";
    private boolean isTypeMatch = false;
    private int stringLength = -1;
    private boolean isRequired = true;
    private boolean isAutoIncr = false;
    private boolean isPriKey = false;
    private boolean isUniqueAltKey = false;
    private String[] altIndexNames = null;
    private boolean isUpdAllowed = true;
    private int typeMask = 0;
    private I18N.Text i18nTitle = null;
    private RTProperties attr = null;
    private int editMode = 0;
    private boolean enumInit = false;
    private Class<? extends Enum> enumClass = null;
    private boolean maskInit = false;
    private Class<? extends Enum> maskClass = null;
    private DBFactory factory = null;
    private Object defaultValue = null;
    private long errorCount = 0L;
    private static boolean ALLOW_ESCAPE_CHARACTERS_IN_ASCII_BLOB = false;
    private static byte[] EMPTY_BLOB = new byte[0];

    public static String TYPE_STRING(int n) {
        return DBProvider.TYPE_STRING(n);
    }

    public static String TYPE_STRING(String T, int D) {
        return DBField.TYPE_STRING(RTConfig.getInt("db.typeSize." + T, D));
    }

    public static String TYPE_ID() {
        return DBField.TYPE_STRING("ID", 32);
    }

    public static String TYPE_ACCT_ID() {
        return DBField.TYPE_STRING("accountID", 32);
    }

    public static String TYPE_USER_ID() {
        return DBField.TYPE_STRING("userID", 32);
    }

    public static String TYPE_DEV_ID() {
        return DBField.TYPE_STRING("deviceID", 32);
    }

    public static String TYPE_XPORT_ID() {
        return DBField.TYPE_STRING("transportID", 32);
    }

    public static String TYPE_GROUP_ID() {
        return DBField.TYPE_STRING("groupID", 32);
    }

    public static String TYPE_ROLE_ID() {
        return DBField.TYPE_STRING("roleID", 32);
    }

    public static String TYPE_RULE_ID() {
        return DBField.TYPE_STRING("ruleID", 32);
    }

    public static String TYPE_CORR_ID() {
        return DBField.TYPE_STRING("corridorID", 32);
    }

    public static String TYPE_DRIVER_ID() {
        return DBField.TYPE_STRING("driverID", 32);
    }

    public static String TYPE_ENTITY_ID() {
        return DBField.TYPE_STRING("entityID", 32);
    }

    public static String TYPE_ZONE_ID() {
        return DBField.TYPE_STRING("zoneID", 32);
    }

    public static String TYPE_POI_ID() {
        return DBField.TYPE_STRING("poiID", 32);
    }

    public static String TYPE_PROP_ID() {
        return DBField.TYPE_STRING("propertyID", 32);
    }

    public static String TYPE_ADDRESS() {
        return DBField.TYPE_STRING("address", 90);
    }

    public static String TYPE_EMAIL_LIST() {
        return DBField.TYPE_STRING("emailList", 128);
    }

    public static String TYPE_UNIQ_ID() {
        return DBField.TYPE_STRING("uniqueID", 40);
    }

    public static String TYPE_DESC() {
        return DBField.TYPE_STRING("description", 128);
    }

    public static String TYPE_INT(String i) {
        return DBProvider.TYPE_INT(i);
    }

    public static String TYPE_INT(String T, String I) {
        return DBField.TYPE_INT(RTConfig.getString("db.typeInt." + T, I));
    }

    public static String TYPE_STOP_INDEX() {
        return DBField.TYPE_INT("stopIndex", TYPE_INT16);
    }

    public static String quote(String s) {
        return DBField.quote(s, '\'', true);
    }

    public static String quote(String s, char q, boolean escapeQuote) {
        if (s == null) {
            s = "";
        }
        char[] ch = s.toCharArray();
        int len = ch.length;
        StringBuffer qsb = new StringBuffer();
        qsb.append(q);
        for (int c = 0; c < len; ++c) {
            if (ch[c] == q) {
                if (escapeQuote) {
                    qsb.append('\\').append(q);
                    continue;
                }
                qsb.append(q).append(q);
                continue;
            }
            if (ch[c] == '\\') {
                qsb.append('\\').append('\\');
                continue;
            }
            if (ch[c] == '\n') {
                qsb.append('\\').append('n');
                continue;
            }
            if (ch[c] == '\r') {
                qsb.append('\\').append('r');
                continue;
            }
            if (ch[c] == '\t') {
                qsb.append('\\').append('t');
                continue;
            }
            qsb.append(ch[c]);
        }
        qsb.append(q);
        return qsb.toString();
    }

    public static boolean AllowUpdateKeyFields() {
        return RTConfig.getBoolean("db.allowUpdateKeyFields");
    }

    public static boolean IgnoreColumnError(String table, String column) {
        if (!StringTools.isBlank(table) && !StringTools.isBlank(column)) {
            String key = "db.ignoreColumnError." + table + "." + column;
            return RTConfig.getBoolean(key, false);
        }
        return false;
    }

    public DBField(String utableName, String colName, String sqlType, boolean autoIncr, String charSet, Set<String> indexNames) {
        this.name = colName != null ? colName : "";
        this.javaClass = null;
        this.sqlType = sqlType != null ? sqlType.toUpperCase() : "";
        this.charSet = charSet != null ? charSet.toLowerCase() : "";
        this.dataType = null;
        this.isTypeMatch = false;
        this.typeMask = 0;
        this.attr = new RTProperties("");
        this.editMode = -1;
        this.isRequired = true;
        this.i18nTitle = null;
        this.isAutoIncr = autoIncr;
        if (indexNames != null && indexNames.contains("PRIMARY")) {
            this.isPriKey = true;
            indexNames.remove("PRIMARY");
        } else {
            this.isPriKey = false;
        }
        if (indexNames != null && indexNames.contains("UNIQUE")) {
            this.isUniqueAltKey = true;
            indexNames.remove("UNIQUE");
        } else {
            this.isUniqueAltKey = false;
        }
        this.altIndexNames = indexNames != null && !indexNames.isEmpty() ? indexNames.toArray(new String[indexNames.size()]) : null;
        DBFactory fact = DBFactory.getFactoryByName(utableName);
        if (fact != null) {
            this.setFactory(fact);
            DBField fld = fact.getField(colName);
            if (fld != null) {
                String prefDT = fld.getDataType();
                String prefST = fld.getSqlType(false);
                if (prefST.equalsIgnoreCase(this.sqlType)) {
                    this.dataType = prefDT;
                    this.isTypeMatch = true;
                    this.typeMask = DBProvider.getDataTypeMask(this.dataType);
                } else {
                    String dbpDT = DBProvider.getDataTypeFromSqlType(this.sqlType);
                    if (DBProvider.areTypesEquivalent(prefDT, dbpDT)) {
                        this.dataType = prefDT;
                        this.isTypeMatch = true;
                        this.typeMask = DBProvider.getDataTypeMask(this.dataType);
                    } else {
                        this.dataType = dbpDT;
                        Print.logInfo("[" + colName + "] Type mismatch - expected:" + prefST + "[" + prefDT + "] ==> found:" + this.sqlType + "[" + dbpDT + "]", new Object[0]);
                        this.isTypeMatch = false;
                        this.typeMask = DBProvider.getDataTypeMask(this.dataType);
                    }
                }
            } else {
                this.dataType = DBProvider.getDataTypeFromSqlType(this.sqlType);
                this.isTypeMatch = false;
                this.typeMask = DBProvider.getDataTypeMask(this.dataType);
            }
        } else {
            this.dataType = DBProvider.getDataTypeFromSqlType(this.sqlType);
            this.isTypeMatch = false;
            this.typeMask = DBProvider.getDataTypeMask(this.dataType);
        }
        this.isUpdAllowed = !this.isPriKey;
        this.getStringLength();
    }

    public DBField(String fldName, Class javaClass, String dataType, String title, String attr) {
        this(fldName, javaClass, dataType, new I18N.Text(title), attr);
    }

    public DBField(String fldName, Class javaClass, String dataType, I18N.Text title, String attr) {
        boolean update;
        this.name = fldName != null ? fldName : "";
        this.javaClass = javaClass;
        this.sqlType = null;
        this.charSet = "";
        this.dataType = dataType != null ? dataType.toUpperCase() : "";
        this.isTypeMatch = true;
        this.typeMask = DBProvider.getDataTypeMask(this.dataType);
        this.attr = new RTProperties(attr != null ? attr : "");
        this.editMode = this.getIntAttribute(ATTR_EDIT, -1);
        this.isRequired = true;
        this.i18nTitle = title;
        this.charSet = RTConfig.getBoolean("db.sql.utf8") && this.getBooleanAttribute(ATTR_UTF8, false) ? ATTR_UTF8 : "";
        this.isPriKey = this.getBooleanAttribute(ATTR_KEY, false);
        this.isUniqueAltKey = this.getBooleanAttribute(ATTR_UNIQUE, false);
        this.altIndexNames = null;
        String[] akn = StringTools.parseStringArray(this.getStringAttribute(ATTR_ALTKEY, null), ',');
        if (akn != null && akn.length > 0) {
            Vector<String> altKeyList = new Vector<String>();
            for (int i = 0; i < akn.length; ++i) {
                if (StringTools.isBlank(akn[i])) {
                    Print.logStackTrace("Invalid alternate key specification for field: " + fldName);
                    continue;
                }
                if (akn[i].equalsIgnoreCase("true") || akn[i].equalsIgnoreCase("yes") || akn[i].equals("1")) {
                    altKeyList.add("altIndex");
                    continue;
                }
                if (akn[i].equals("altIndex")) {
                    altKeyList.add(akn[i]);
                    continue;
                }
                altKeyList.add(akn[i]);
            }
            if (!altKeyList.isEmpty()) {
                this.altIndexNames = altKeyList.toArray(new String[altKeyList.size()]);
            }
        }
        if (this.isPriKey || this.isUniqueAltKey || this.altIndexNames != null) {
            if (this.getBooleanAttribute(ATTR_OPTIONAL, false)) {
                Print.logWarn("'Optional' specification ignored for key field!", new Object[0]);
            }
            this.isRequired = true;
        } else if (this.getBooleanAttribute(ATTR_REQUIRED, false)) {
            this.isRequired = true;
        } else if (this.getBooleanAttribute(ATTR_OPTIONAL, false)) {
            this.isRequired = false;
        }
        this.isAutoIncr = this.getBooleanAttribute(ATTR_AUTO_INCR, false);
        this.isUpdAllowed = this.attr.hasProperty(ATTR_UPDATE) ? (!(update = this.attr.getBoolean(ATTR_UPDATE, true)) ? false : (!this.isPriKey ? true : DBField.AllowUpdateKeyFields())) : !this.isPriKey;
        this.getStringLength();
    }

    public void setFactory(DBFactory factory) {
        this.factory = factory;
    }

    public DBFactory getFactory() {
        return this.factory;
    }

    public Class getTypeClass() {
        return this.javaClass;
    }

    public boolean isTypeString() {
        return this.javaClass == String.class;
    }

    public boolean isTypeInteger() {
        return this.javaClass == Integer.class || this.javaClass == Integer.TYPE;
    }

    public boolean isTypeLong() {
        return this.javaClass == Long.class || this.javaClass == Long.TYPE;
    }

    public boolean isTypeFloat() {
        return this.javaClass == Float.class || this.javaClass == Float.TYPE;
    }

    public boolean isTypeDouble() {
        return this.javaClass == Double.class || this.javaClass == Double.TYPE;
    }

    public boolean isTypeBoolean() {
        return this.javaClass == Boolean.class || this.javaClass == Boolean.TYPE;
    }

    public boolean isTypeBLOB() {
        return this.javaClass == Byte[].class || this.javaClass == byte[].class;
    }

    public boolean isTypeDateTime() {
        return this.javaClass == DateTime.class;
    }

    public boolean isAutoIncrement() {
        return this.isAutoIncr;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public String getCharacterSet() {
        return this.charSet;
    }

    public boolean isUTF8() {
        return this.charSet != null && this.charSet.startsWith(ATTR_UTF8);
    }

    public boolean isPrimaryKey() {
        return this.isPriKey;
    }

    public boolean isKeyField() {
        return this.isPrimaryKey() || this.isAlternateKey();
    }

    public boolean isAlternateKey() {
        return this.altIndexNames != null && this.altIndexNames.length > 0;
    }

    public boolean isUniqueAltKey() {
        return this.isUniqueAltKey;
    }

    public String[] getAlternateIndexes() {
        return this.isAlternateKey() ? this.altIndexNames : null;
    }

    public boolean equalsAlternateIndexes(String[] altIndexes) {
        String[] altNdx = this.getAlternateIndexes();
        if (altIndexes == null || altIndexes.length == 0) {
            return altNdx == null || altNdx.length == 0;
        }
        if (altNdx == null || altNdx.length == 0) {
            return false;
        }
        if (altNdx.length != altIndexes.length) {
            return false;
        }
        for (int i = 0; i < altNdx.length; ++i) {
            boolean found = false;
            for (int j = 0; j < altIndexes.length; ++j) {
                if (!altNdx[i].equals(altIndexes[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public boolean hasMissingAlternateIndexes(String[] altIndexes) {
        if (altIndexes == null || altIndexes.length == 0) {
            return false;
        }
        String[] altNdx = this.getAlternateIndexes();
        if (altNdx == null || altNdx.length == 0) {
            return true;
        }
        for (int i = 0; i < altIndexes.length; ++i) {
            if (ListTools.contains(altNdx, altIndexes[i])) continue;
            return true;
        }
        return false;
    }

    public String[] getMissingAlternateIndexes(String[] altIndexes) {
        if (altIndexes == null || altIndexes.length == 0) {
            return null;
        }
        String[] altNdx = this.getAlternateIndexes();
        if (altNdx == null || altNdx.length == 0) {
            return altIndexes;
        }
        Vector<String> missingNdx = null;
        for (int i = 0; i < altIndexes.length; ++i) {
            if (ListTools.contains(altNdx, altIndexes[i])) continue;
            if (missingNdx == null) {
                missingNdx = new Vector<String>();
            }
            missingNdx.add(altIndexes[i]);
        }
        return !ListTools.isEmpty(missingNdx) ? missingNdx.toArray(new String[missingNdx.size()]) : null;
    }

    public boolean hasExtraAlternateIndexes(String[] altIndexes) {
        String[] altNdx = this.getAlternateIndexes();
        if (altNdx == null || altNdx.length == 0) {
            return false;
        }
        if (altIndexes == null || altIndexes.length == 0) {
            return true;
        }
        for (int i = 0; i < altNdx.length; ++i) {
            if (ListTools.contains(altIndexes, altNdx[i])) continue;
            return true;
        }
        return false;
    }

    public String[] getExtraAlternateIndexes(String[] altIndexes) {
        String[] altNdx = this.getAlternateIndexes();
        if (altNdx == null || altNdx.length == 0) {
            return null;
        }
        if (altIndexes == null || altIndexes.length == 0) {
            return altNdx;
        }
        Vector<String> extraNdx = null;
        for (int i = 0; i < altNdx.length; ++i) {
            if (ListTools.contains(altIndexes, altNdx[i])) continue;
            if (extraNdx == null) {
                extraNdx = new Vector<String>();
            }
            extraNdx.add(altNdx[i]);
        }
        return !ListTools.isEmpty(extraNdx) ? extraNdx.toArray(new String[extraNdx.size()]) : null;
    }

    public boolean isUpdateAllowed() {
        return this.isUpdAllowed;
    }

    public boolean isSqlField() {
        return !StringTools.isBlank(this.sqlType);
    }

    public int getTypeMask() {
        return this.typeMask;
    }

    public boolean isBoolean() {
        return DBProvider.isDataTypeBoolean(this.typeMask);
    }

    public boolean isNumeric() {
        return DBProvider.isDataTypeNumeric(this.typeMask);
    }

    public boolean isDecimal() {
        return DBProvider.isDataTypeDecimal(this.typeMask);
    }

    public boolean isUnsigned() {
        return DBProvider.isDataTypeUnsigned(this.typeMask);
    }

    public boolean isString() {
        return DBProvider.isDataTypeString(this.typeMask);
    }

    public boolean isBinary() {
        return DBProvider.isDataTypeBinary(this.typeMask);
    }

    public void setDataType(String dataType) {
        if (!this.isSqlField()) {
            this.dataType = dataType != null ? dataType.toUpperCase() : "";
            this.typeMask = DBProvider.getDataTypeMask(this.dataType);
            this.stringLength = -1;
            this.getStringLength();
        }
    }

    public String getDataType() {
        return this.dataType;
    }

    public boolean isTypeMatch() {
        return this.isTypeMatch;
    }

    public String getSqlType() {
        return this.getSqlType(true);
    }

    public String getSqlType(boolean inclNotNull) {
        if (this.isSqlField()) {
            if (inclNotNull) {
                return this.sqlType;
            }
            return DBField._removeFieldType(this.sqlType, SQL_NOT_NULL);
        }
        String st = DBProvider.getSqlTypeFromDataType(this.getDataType());
        if (this.isPrimaryKey()) {
            if (inclNotNull) {
                if (DBField._hasFieldType(st, SQL_NOT_NULL)) {
                    return st;
                }
                return st + " " + SQL_NOT_NULL;
            }
            return DBField._removeFieldType(st, SQL_NOT_NULL);
        }
        if (inclNotNull) {
            return st;
        }
        return DBField._removeFieldType(st, SQL_NOT_NULL);
    }

    private static boolean _hasFieldType(String target, String match) {
        int p = target.toUpperCase().indexOf(match.toUpperCase());
        return p >= 0;
    }

    private static String _removeFieldType(String target, String match) {
        int p = target.toUpperCase().indexOf(match.toUpperCase());
        if (p >= 0) {
            return target.substring(0, p).trim() + target.substring(p + match.length());
        }
        return target;
    }

    public int getStringLength() {
        if (this.stringLength < 0) {
            String dt = this.getDataType();
            if (dt.startsWith("STRING[")) {
                String x = dt.substring(TYPE_STRING.length() + 1);
                this.stringLength = StringTools.parseInt(x, 0);
            } else {
                this.stringLength = 0;
            }
        }
        return this.stringLength;
    }

    public boolean isCLOB() {
        String dt = this.getDataType();
        return dt.equalsIgnoreCase(TYPE_TEXT);
    }

    public boolean isBLOB() {
        String dt = this.getDataType();
        return dt.equalsIgnoreCase(TYPE_SBLOB) || dt.equalsIgnoreCase(TYPE_BLOB) || dt.equalsIgnoreCase(TYPE_MBLOB);
    }

    public static byte[] parseBlobString(String val) {
        return DBField.parseBlobString(val, EMPTY_BLOB);
    }

    public static byte[] parseBlobString(String val, byte[] dftBlob) {
        if (val == null) {
            return dftBlob;
        }
        if (val.startsWith("0x") || val.startsWith("0X")) {
            return StringTools.parseHex(val, dftBlob);
        }
        char[] ch = val.toCharArray();
        byte[] ba = new byte[ch.length];
        int b = 0;
        for (int i = 0; i < ch.length; ++i) {
            if (ALLOW_ESCAPE_CHARACTERS_IN_ASCII_BLOB) {
                if (ch[i] == '\\' && i + 1 < ch.length) {
                    if (ch[++i] == '0') {
                        ba[b++] = 0;
                        continue;
                    }
                    if (ch[i] == 'r') {
                        ba[b++] = 13;
                        continue;
                    }
                    if (ch[i] == 'n') {
                        ba[b++] = 10;
                        continue;
                    }
                    if (ch[i] == 't') {
                        ba[b++] = 9;
                        continue;
                    }
                    ba[b++] = (byte)ch[i];
                    continue;
                }
                ba[b++] = (byte)ch[i];
                continue;
            }
            ba[b++] = (byte)ch[i];
        }
        if (b < ba.length) {
            byte[] bb = new byte[b];
            System.arraycopy(ba, 0, bb, 0, b);
            ba = bb;
        }
        return ba;
    }

    public Object getResultSetValue(ResultSet rs) throws SQLException {
        String n = this.getName();
        Class jvc = this.getTypeClass();
        if (jvc == String.class) {
            return rs != null ? rs.getString(n) : "";
        }
        if (jvc == Integer.class || jvc == Integer.TYPE) {
            return new Integer(rs != null ? rs.getInt(n) : 0);
        }
        if (jvc == Long.class || jvc == Long.TYPE) {
            return new Long(rs != null ? rs.getLong(n) : 0L);
        }
        if (jvc == Float.class || jvc == Float.TYPE) {
            return new Float(rs != null ? rs.getFloat(n) : 0.0f);
        }
        if (jvc == Double.class || jvc == Double.TYPE) {
            return new Double(rs != null ? rs.getDouble(n) : 0.0);
        }
        if (jvc == Boolean.class || jvc == Boolean.TYPE) {
            return new Boolean(rs != null ? rs.getInt(n) != 0 : false);
        }
        if (jvc == Byte[].class || jvc == byte[].class) {
            return rs != null ? rs.getBytes(n) : new byte[]{};
        }
        if (jvc == DateTime.class) {
            Timestamp ts;
            Timestamp timestamp = ts = rs != null ? rs.getTimestamp(n) : null;
            if (ts != null) {
                int YY = ts.getYear() + 1900;
                int MM = ts.getMonth() + 1;
                int DD = ts.getDate();
                int hh = ts.getHours();
                int mm = ts.getMinutes();
                int ss = ts.getSeconds();
                return new DateTime(DateTime.getGMTTimeZone(), YY, MM, DD, hh, mm, ss);
            }
            return new DateTime(0L, DateTime.getGMTTimeZone());
        }
        if (DBFieldType.class.isAssignableFrom(jvc)) {
            try {
                Constructor dbftConst = jvc.getConstructor(ResultSet.class, String.class);
                return dbftConst.newInstance(rs, n);
            }
            catch (Throwable t) {
                if (t instanceof SQLException) {
                    throw (SQLException)t;
                }
                if (t.getCause() instanceof SQLException) {
                    throw (SQLException)t.getCause();
                }
                Print.logException("Unable to instantiate", t);
                return null;
            }
        }
        Print.logError("Unsupported Java class: " + StringTools.className(jvc), new Object[0]);
        return null;
    }

    public Object getFieldValue(DBRecord rcd) {
        return rcd != null ? rcd.getFieldValue(this.getName()) : null;
    }

    public Object parseStringValue(String val) {
        Class jvc = this.getTypeClass();
        if (jvc == String.class) {
            return val != null ? val : "";
        }
        if (jvc == Integer.class || jvc == Integer.TYPE) {
            return new Integer(StringTools.parseInt(val, 0));
        }
        if (jvc == Long.class || jvc == Long.TYPE) {
            return new Long(StringTools.parseLong(val, 0L));
        }
        if (jvc == Float.class || jvc == Float.TYPE) {
            return new Float(StringTools.parseFloat(val, 0.0f));
        }
        if (jvc == Double.class || jvc == Double.TYPE) {
            return new Double(StringTools.parseDouble(val, 0.0));
        }
        if (jvc == Boolean.class || jvc == Boolean.TYPE) {
            return new Boolean(StringTools.parseBoolean(val, false));
        }
        if (jvc == Byte[].class || jvc == byte[].class) {
            return DBField.parseBlobString(val);
        }
        if (jvc == DateTime.class) {
            try {
                DateTime.ParsedDateTime pdt = DateTime.parseDateTime(val, DateTime.getGMTTimeZone(), DateTime.DefaultParsedTime.DayStart);
                return pdt.createDateTime();
            }
            catch (DateTime.DateParseException dpe) {
                return new DateTime(0L);
            }
        }
        if (DBFieldType.class.isAssignableFrom(jvc)) {
            try {
                Constructor dbftConst = jvc.getConstructor(String.class);
                return dbftConst.newInstance(val);
            }
            catch (Throwable t) {
                Print.logError("Unable to obtain proper constructor: " + t, new Object[0]);
                return null;
            }
        }
        Print.logError("Unsupported Java class: " + StringTools.className(jvc), new Object[0]);
        return null;
    }

    public void setDefaultValue(Object val) {
        this.defaultValue = val;
    }

    public boolean _hasDefaultValue() {
        return this.defaultValue != null;
    }

    public Object _getDefaultValue() {
        return this.defaultValue;
    }

    public Object getDefaultValue() {
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        try {
            return this.getResultSetValue(null);
        }
        catch (SQLException sqe) {
            return null;
        }
    }

    public boolean isDefaultValue(Object val) {
        if (val == null) {
            return false;
        }
        if (this._hasDefaultValue()) {
            return val.equals(this._getDefaultValue());
        }
        return false;
    }

    public boolean quoteValue() {
        if (this.isCLOB()) {
            return true;
        }
        if (this.isBLOB()) {
            return true;
        }
        if (this.isTypeDateTime()) {
            return true;
        }
        String dt = this.getDataType();
        return dt.startsWith(TYPE_STRING);
    }

    public String getQValue(Object v) {
        String vs = DBFieldValues.toStringValue(v);
        if (this.isBLOB()) {
            int dbid = DBProvider.getProvider().getID();
            if (dbid == 3) {
                String hex = vs.startsWith("0x") ? vs.substring(2) : vs;
                return "CAST(x'" + hex + "' AS BLOB)";
            }
            if (vs.equals("") || vs.equalsIgnoreCase("0x")) {
                return DBField.quote("");
            }
            String hex = vs.startsWith("0x") ? vs : "0x" + vs;
            return hex;
        }
        return this.quoteValue() || vs.equals("") ? DBField.quote(vs) : vs;
    }

    public boolean hasAttribute(String key) {
        return this.attr.hasProperty(key);
    }

    public boolean getBooleanAttribute(String key, boolean dft) {
        return this.hasAttribute(key) ? this.attr.getBoolean(key, true) : dft;
    }

    public int getIntAttribute(String key, int dft) {
        return this.attr.getInt(key, dft);
    }

    public String getStringAttribute(String key, String dft) {
        return this.attr.getString(key, dft);
    }

    public void setFormat(String format) {
        this.attr.setString(ATTR_FORMAT, format);
    }

    public String getFormat() {
        return this.getFormat(null);
    }

    public String getFormat(String dft) {
        DBProvider dbp;
        String fmt = this.getStringAttribute(ATTR_FORMAT, dft);
        if (fmt != null && fmt.startsWith("X") && (dbp = DBProvider.getProvider()).getID() == 3) {
            return null;
        }
        return fmt;
    }

    public String formatValue(Object val) {
        if (val == null) {
            return null;
        }
        Class typeClass = this.getTypeClass();
        if (typeClass == String.class) {
            return val.toString();
        }
        String fmt = this.getFormat();
        if (StringTools.isBlank(fmt)) {
            fmt = null;
        }
        if (val instanceof Number) {
            if (typeClass == Double.class || typeClass == Double.TYPE) {
                double d = ((Number)val).doubleValue();
                return fmt == null ? String.valueOf(d) : StringTools.format(d, fmt);
            }
            if (typeClass == Float.class || typeClass == Float.TYPE) {
                float d = ((Number)val).floatValue();
                return fmt == null ? String.valueOf(d) : StringTools.format(d, fmt);
            }
            if (typeClass == Long.class || typeClass == Long.TYPE) {
                long d = ((Number)val).longValue();
                return fmt == null ? String.valueOf(d) : StringTools.format(d, fmt);
            }
            if (typeClass == Integer.class || typeClass == Integer.TYPE) {
                int d = ((Number)val).intValue();
                return fmt == null ? String.valueOf(d) : StringTools.format(d, fmt);
            }
            if (typeClass == Short.class || typeClass == Short.TYPE) {
                short d = ((Number)val).shortValue();
                return fmt == null ? String.valueOf(d) : StringTools.format((int)d, fmt);
            }
        }
        if (val instanceof byte[]) {
            String hex = StringTools.toHexString((byte[])val);
            return "0x" + hex;
        }
        if (val instanceof DateTime) {
            DateTime dt = (DateTime)val;
            return dt.format("yyyy-MM-dd HH:mm:ss", DateTime.getGMTTimeZone());
        }
        return val.toString();
    }

    public boolean equals(Object other) {
        String othrDT;
        if (!(other instanceof DBField)) {
            return false;
        }
        DBField fld = (DBField)other;
        if (!this.getName().equals(fld.getName())) {
            return false;
        }
        if (this.isPrimaryKey() != fld.isPrimaryKey()) {
            return false;
        }
        if (this.isAlternateKey() != fld.isAlternateKey()) {
            return false;
        }
        if (!this.equalsAlternateIndexes(fld.getAlternateIndexes())) {
            return false;
        }
        if (this.isUpdateAllowed() != fld.isUpdateAllowed()) {
            return false;
        }
        if (this.isUTF8() != fld.isUTF8()) {
            return false;
        }
        String thisDT = this.getDataType();
        if (!thisDT.equals(othrDT = fld.getDataType())) {
            boolean othrBool;
            boolean thisBool = this.isSqlField() && thisDT.equals(TYPE_INT8) || thisDT.equals(TYPE_BOOLEAN);
            boolean bl = othrBool = fld.isSqlField() && othrDT.equals(TYPE_INT8) || othrDT.equals(TYPE_BOOLEAN);
            if (!thisBool || !othrBool) {
                return false;
            }
        }
        return true;
    }

    public String _getName() {
        return this.name;
    }

    public String getName() {
        return DBProvider.translateColumnName(this._getName());
    }

    public String getFieldDefinition() {
        return this.getName() + " " + this.getSqlType();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getFieldDefinition());
        this._getIndexNames(sb);
        return sb.toString();
    }

    public String getIndexNames() {
        StringBuffer sb = this._getIndexNames(null);
        return sb != null ? sb.toString() : "";
    }

    protected StringBuffer _getIndexNames(StringBuffer sb) {
        boolean priKey = this.isPrimaryKey();
        boolean altKey = this.isAlternateKey();
        if (!priKey && !altKey) {
            return sb;
        }
        if (sb == null) {
            sb = new StringBuffer();
        }
        if (sb.length() > 0) {
            sb.append(" ");
        }
        if (priKey) {
            sb.append("PRIMARY");
        }
        if (altKey) {
            if (priKey) {
                sb.append(",");
            }
            sb.append(StringTools.join(this.getAlternateIndexes(), ","));
        }
        return sb;
    }

    public void setTitle(I18N.Text title) {
        this.i18nTitle = title;
    }

    public I18N.Text getTitle() {
        return this.i18nTitle;
    }

    public String getTitle(Locale locale) {
        return this.i18nTitle != null ? this.i18nTitle.toString(locale) : "";
    }

    public void setEditMode(int mode) {
        switch (mode) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                this.editMode = mode;
                break;
            }
            default: {
                this.editMode = -1;
            }
        }
    }

    public int getEditMode() {
        return this.editMode;
    }

    public boolean isEditable(int mode) {
        DBFactory dbf = this.getFactory();
        if (dbf != null && !dbf.isEditable()) {
            return false;
        }
        return mode <= this.editMode;
    }

    public String getEditor() {
        return this.getStringAttribute(ATTR_EDITOR, null);
    }

    public Class<? extends Enum> getEnumClass() {
        if (!this.enumInit) {
            this.enumInit = true;
            String enumValue = this.getStringAttribute(ATTR_ENUM, null);
            if (!StringTools.isBlank(enumValue)) {
                Enum[] e;
                DBFactory fact;
                if (enumValue.indexOf("$") < 0 && (fact = this.getFactory()) != null) {
                    this.enumClass = EnumTools.getEnumClass(fact.getRecordClass(), enumValue);
                }
                if (this.enumClass == null) {
                    this.enumClass = EnumTools.getEnumClass(enumValue);
                }
                if (this.enumClass != null && ((e = this.enumClass.getEnumConstants()) == null || e.length == 0)) {
                    this.enumClass = null;
                }
                if (this.enumClass == null) {
                    Print.logWarn("Enum class not found: [%s] %s", this.getName(), enumValue);
                }
            }
        }
        return this.enumClass;
    }

    public OrderedMap<String, Integer> getEnumValues() {
        Class<? extends Enum> eclz = this.getEnumClass();
        if (eclz != null) {
            Enum[] e = eclz.getEnumConstants();
            OrderedMap<String, Integer> map = new OrderedMap<String, Integer>();
            for (int n = 0; n < e.length; ++n) {
                if (!(e[n] instanceof EnumTools.IntValue)) continue;
                map.put(e[n].toString(), ((EnumTools.IntValue)((Object)e[n])).getIntValue());
            }
            if (!map.isEmpty()) {
                return map;
            }
            Print.logError("No emunerated values found for field: " + this.getName(), new Object[0]);
            return null;
        }
        String enumValue = this.getStringAttribute(ATTR_ENUM, null);
        if (!StringTools.isBlank(enumValue) && enumValue.indexOf(58) >= 0) {
            String[] ev = StringTools.parseStringArray(enumValue, '|');
            if (ev.length > 0) {
                OrderedMap<String, Integer> map = new OrderedMap<String, Integer>();
                for (int i = 0; i < ev.length; ++i) {
                    String[] v = StringTools.parseStringArray(ev[i], ':');
                    if (v.length < 2 || StringTools.isBlank(v[1])) continue;
                    int n = StringTools.parseInt(v[0], 0);
                    map.put(v[1], new Integer(n));
                }
                return !map.isEmpty() ? map : null;
            }
            return null;
        }
        return null;
    }

    public Class<? extends Enum> getMaskClass() {
        if (!this.maskInit) {
            this.maskInit = true;
            String maskValue = this.getStringAttribute(ATTR_MASK, null);
            if (!StringTools.isBlank(maskValue)) {
                DBFactory fact;
                if (maskValue.indexOf("$") < 0 && (fact = this.getFactory()) != null) {
                    this.maskClass = EnumTools.getEnumClass(fact.getRecordClass(), maskValue);
                }
                if (this.maskClass == null) {
                    this.maskClass = EnumTools.getEnumClass(maskValue);
                }
                if (this.maskClass != null) {
                    Enum[] e = this.maskClass.getEnumConstants();
                    if (e == null || e.length == 0) {
                        this.maskClass = null;
                    } else if (!EnumTools.BitMask.class.isAssignableFrom(this.maskClass)) {
                        this.maskClass = null;
                    }
                }
                if (this.maskClass == null) {
                    Print.logWarn("Mask class not found: [%s] %s", this.getName(), maskValue);
                }
            }
        }
        return this.maskClass;
    }

    public OrderedMap<String, Long> getMaskValues() {
        Class<? extends Enum> eclz = this.getMaskClass();
        if (eclz != null && EnumTools.BitMask.class.isAssignableFrom(eclz)) {
            Enum[] e = eclz.getEnumConstants();
            OrderedMap<String, Long> map = new OrderedMap<String, Long>();
            for (int n = 0; n < e.length; ++n) {
                map.put(e[n].toString(), ((EnumTools.BitMask)((Object)e[n])).getLongValue());
            }
            if (!map.isEmpty()) {
                return map;
            }
            Print.logError("No emunerated values found for field: " + this.getName(), new Object[0]);
            return null;
        }
        String maskValue = this.getStringAttribute(ATTR_MASK, null);
        if (!StringTools.isBlank(maskValue) && maskValue.indexOf(58) >= 0) {
            String[] ev = StringTools.parseStringArray(maskValue, '|');
            if (ev.length > 0) {
                OrderedMap<String, Long> map = new OrderedMap<String, Long>();
                for (int i = 0; i < ev.length; ++i) {
                    String[] v = StringTools.parseStringArray(ev[i], ':');
                    if (v.length < 2 || StringTools.isBlank(v[1])) continue;
                    long n = StringTools.parseLong(v[0], 0L);
                    map.put(v[1], n);
                }
                return !map.isEmpty() ? map : null;
            }
            return null;
        }
        return null;
    }

    public long incrementErrorCount() {
        return ++this.errorCount;
    }

    public long getErrorCount() {
        return this.errorCount;
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        String s = "This is a (NOT NULL) test";
        Print.sysPrintln("%s", s);
        if (DBField._hasFieldType(s, SQL_NOT_NULL)) {
            Print.sysPrintln("==> %s", DBField._removeFieldType(s, SQL_NOT_NULL));
        }
    }
}

