/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.dbtools;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.opengts.dbtools.DBAdmin;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBRecord;
import org.opengts.util.OrderedMap;
import org.opengts.util.Print;

public class DBFactoryTree {
    private int level = 0;
    private DBFactory<? extends DBRecord> dbFactory = null;
    private DBFactoryTree parentNode = null;
    private List<DBFactoryTree> childList = null;
    private DBFactoryTree[] childArray = null;
    private DBRecord dbRecord = null;

    private DBFactoryTree() {
        this(0, null, null);
    }

    private DBFactoryTree(int level, DBFactoryTree parent, DBFactory<? extends DBRecord> dbFact) {
        this.level = level;
        this.parentNode = parent;
        this.dbFactory = dbFact;
        this.childList = null;
        this.childArray = null;
    }

    public int getLevel() {
        return this.level;
    }

    public void setParentNode(DBFactoryTree parent) {
        this.parentNode = parent;
    }

    public DBFactoryTree getParentNode() {
        return this.parentNode;
    }

    public boolean hasParentDBRecord() {
        if (this.parentNode != null) {
            return this.parentNode.hasDBRecord();
        }
        return true;
    }

    public boolean hasDBFactory() {
        return this.dbFactory != null;
    }

    public DBFactory<? extends DBRecord> getDBFactory() {
        return this.dbFactory;
    }

    public boolean isEditable() {
        return this.dbFactory != null ? this.dbFactory.isEditable() : false;
    }

    public DBField[] getFields() {
        return this.dbFactory != null ? this.dbFactory.getFields() : null;
    }

    public DBField[] getKeyFields() {
        return this.dbFactory != null ? this.dbFactory.getKeyFields() : null;
    }

    public String[] getKeyNames() {
        return this.dbFactory != null ? this.dbFactory.getKeyNames() : null;
    }

    public DBField getField(String name) {
        return this.dbFactory != null ? this.dbFactory.getField(name) : null;
    }

    public boolean hasDBRecord() {
        return this.dbRecord != null;
    }

    public DBRecord getDBRecord() {
        return this.dbRecord;
    }

    public boolean setDBRecord(DBRecord<?> record) {
        this.dbRecord = null;
        if (record == null) {
            return false;
        }
        if (!this.hasDBFactory()) {
            Print.logError("DBFactory is not defined!", new Object[0]);
            return false;
        }
        DBFactory<?> rcdFact = DBRecord.getFactory(record);
        if (!this.getDBFactory().equals(rcdFact)) {
            Print.logError("Invalid DBFactory for specified DBRecord!", new Object[0]);
            return false;
        }
        this.dbRecord = record;
        return true;
    }

    public String getUntranslatedTableName() {
        return this.dbFactory != null ? this.dbFactory.getUntranslatedTableName() : "";
    }

    public String getName() {
        if (this.dbFactory != null) {
            return this.dbFactory.getUntranslatedTableName();
        }
        if (this.level == 0) {
            return "<root>";
        }
        return "?unknown?";
    }

    public String toString() {
        return this.getName();
    }

    public void addChild(DBFactoryTree dbFactNode) {
        if (this.childList == null) {
            this.childList = new Vector<DBFactoryTree>();
        }
        this.childList.add(dbFactNode);
        this.childArray = null;
    }

    public boolean hasChildren() {
        return this.childList != null;
    }

    public DBFactoryTree[] getChildren() {
        if (this.childList != null && this.childArray == null) {
            this.childArray = new DBFactoryTree[this.childList.size()];
            this.childList.toArray(this.childArray);
        }
        return this.childArray;
    }

    public Map<DBField, Object> getKeyMap() {
        OrderedMap<DBField, Object> keyMap = new OrderedMap<DBField, Object>();
        if (this.dbFactory != null) {
            DBField[] keyField = this.dbFactory.getKeyFields();
            for (int i = 0; i < keyField.length; ++i) {
                String key = keyField[i].getName();
                Object val = null;
                if (this.dbRecord != null) {
                    val = this.dbRecord.getFieldValue(key);
                } else {
                    DBRecord dbr;
                    for (DBFactoryTree parent = this.getParentNode(); parent != null && val == null && (dbr = parent.getDBRecord()) != null; parent = parent.getParentNode()) {
                        DBField parFld;
                        if (!dbr.hasField(key) || (parFld = dbr.getField(key)) == null || !parFld.isPrimaryKey()) continue;
                        val = dbr.getFieldValue(key);
                    }
                }
                if (val != null) {
                    keyMap.put(keyField[i], val);
                    continue;
                }
                keyMap.put(keyField[i], null);
            }
        }
        return keyMap;
    }

    private static void _traverseDBFactoryTree(int level, DBFactory<? extends DBRecord> dbFact, DBFactoryTree parentNode, Set<String> addedTables) {
        if (dbFact == null) {
            Print.logError("Null DBFactory!", new Object[0]);
            return;
        }
        String utableName = dbFact.getUntranslatedTableName();
        if (addedTables.contains(utableName)) {
            return;
        }
        addedTables.add(utableName);
        DBFactoryTree dbFactNode = new DBFactoryTree(level, parentNode, dbFact);
        parentNode.addChild(dbFactNode);
        DBFactory<DBRecord>[] childFact = dbFact.getChildFactories();
        for (int i = 0; i < childFact.length; ++i) {
            int index = childFact[i].getParentTables().indexOf(utableName);
            if (level == index) {
                DBFactoryTree._traverseDBFactoryTree(level + 1, childFact[i], dbFactNode, addedTables);
                continue;
            }
            if (addedTables.contains(childFact[i].getUntranslatedTableName())) continue;
            Print.logWarn("Skipping table in heiarchy: " + utableName + " ==> " + childFact[i].getUntranslatedTableName(), new Object[0]);
        }
    }

    public static DBFactoryTree[] getDBFactoryTree(DBFactory<? extends DBRecord> initialFactory) {
        if (initialFactory != null) {
            return DBFactoryTree.getDBFactoryTree(new DBFactory[]{initialFactory});
        }
        return DBFactoryTree.getDBFactoryTree((DBFactory[])null);
    }

    public static DBFactoryTree[] getDBFactoryTree(DBFactory<? extends DBRecord>[] initialFactories) {
        HashSet<String> addedTables = new HashSet<String>();
        DBFactoryTree rootNode = new DBFactoryTree();
        if (initialFactories != null) {
            for (int i = 0; i < initialFactories.length; ++i) {
                DBFactory<? extends DBRecord> dbf = initialFactories[i];
                DBFactoryTree._traverseDBFactoryTree(0, dbf, rootNode, addedTables);
            }
        }
        OrderedMap<String, DBFactory<? extends DBRecord>> dbFactMap = new OrderedMap<String, DBFactory<? extends DBRecord>>((Map<String, DBFactory<? extends DBRecord>>)DBAdmin.getTableFactoryMap());
        Iterator<String> i = dbFactMap.keyIterator();
        while (i.hasNext()) {
            String tn = i.next();
            DBFactory<? extends DBRecord> dbFact = dbFactMap.get(tn);
            DBFactoryTree._traverseDBFactoryTree(0, dbFact, rootNode, addedTables);
        }
        DBFactoryTree[] roots = rootNode.getChildren();
        if (roots != null) {
            for (int i2 = 0; i2 < roots.length; ++i2) {
                roots[i2].setParentNode(null);
            }
        }
        return roots;
    }
}

