/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.dbtools;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.opengts.dbtools.DBAdmin;
import org.opengts.dbtools.DBAlternateIndex;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBFieldValues;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordKey;
import org.opengts.dbtools.DBRecordListener;
import org.opengts.dbtools.DBSelect;
import org.opengts.dbtools.DBTableIndexMap;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.EnumTools;
import org.opengts.util.FileTools;
import org.opengts.util.ListTools;
import org.opengts.util.MethodAction;
import org.opengts.util.OSTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.OrderedSet;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;
import org.opengts.util.XMLTools;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DBFactory<gDBR extends DBRecord>
implements DBRecordListener<gDBR> {
    private static boolean MYSQL_tableExists_init = false;
    private static boolean MYSQL_tableExists_UseSelectCount = true;
    public static final String ARCHIVE_EXT_CSV = "csv";
    public static final String ARCHIVE_EXT_DUMP = "dump";
    public static final String ARCHIVE_EXT_SQL = "sql";
    public static final String ARCHIVE_EXT_TXT = "txt";
    public static final String ARCHIVE_EXT_XML = "xml";
    public static final String CMD_dbget = "dbget";
    public static final String CMD_dbput = "dbput";
    public static final String CMD_dbdel = "dbdel";
    public static final String CMD_dbcreate = "dbcreate";
    public static final String CMD_dbschema = "dbschema";
    public static final String TAG_TableSchemas = "TableSchemas";
    public static final String TAG_TableSchema = "TableSchema";
    public static final String TAG_Records = "Records";
    public static final String TAG_Record = "Record";
    public static final String TAG_RecordKeys = "RecordKeys";
    public static final String TAG_RecordKey = "RecordKey";
    public static final String TAG_Field = "Field";
    public static final String TAG_Description = "Description";
    public static final String ATTR_table = "table";
    public static final String ATTR_name = "name";
    public static final String ATTR_sequence = "sequence";
    public static final String ATTR_type = "type";
    public static final String ATTR_title = "title";
    public static final String ATTR_primaryKey = "primaryKey";
    public static final String ATTR_alternateKeys = "alternateKeys";
    public static final String ATTR_partial = "partial";
    public static final String ATTR_count = "count";
    public static final int SQLERR_DATABASE_EXISTS = 1007;
    public static final int SQLERR_INVALID_AUTH = 1045;
    public static final int SQLERR_UNKNOWN_DATABASE = 1049;
    public static final int SQLERR_UNKNOWN_COLUMN = 1054;
    public static final int SQLERR_DUPLICATE_KEY = 1062;
    public static final int SQLERR_SYNTAX_ERROR = 1064;
    public static final int SQLERR_TABLE_NOTLOCKED = 1100;
    public static final int SQLERR_TABLE_NONEXIST = 1146;
    public static final int MSQL_ERR_INVALID_OBJECT = 208;
    public static final int MSQL_ERR_CANT_DROP_TABLE = 3701;
    public static final int MSQL_ERR_LOGIN_EXISTS = 15025;
    public static final int MSQL_ERR_USER_EXISTS = 15023;
    private static CustomFactoryHandler factoryHandler = null;
    protected static HashMap<String, String> TableNameMap = null;
    protected static List<DBFactory> factoryList = new Vector<DBFactory>();
    private String utableName = null;
    private Object indexTypeLock = new Object();
    private String indexType = "";
    private Class<gDBR> rcdClass = null;
    private boolean isRequired = false;
    private DBField[] priKeys = null;
    private KeyType keyType = KeyType.PRIMARY;
    private Class<? extends DBRecordKey<gDBR>> keyClass = null;
    private OrderedMap<String, DBAlternateIndex> altIndexMap = null;
    private Object existingFieldLock = new Object();
    private DBField[] existingField = null;
    private Map<String, DBField> existingFieldMap = null;
    private OrderedMap<String, DBField> fieldMap = null;
    private boolean fieldArrayReady = false;
    private DBField[] fieldArray = null;
    private boolean editable = true;
    private boolean viewable = true;
    private Vector<String> parentTables = new Vector();
    private DBFactory<? extends DBRecord>[] childFactories = null;
    private DBRecordListener<gDBR> recordListener = null;
    private boolean logMissingColumns = true;
    private boolean allowInnoDBCOUNT = true;
    private MethodAction tableDescriptionMethod = null;
    public static final String _DUMP_EXT_TXT = ".txt";
    public static final String _DUMP_EXT_SQL = ".sql";
    public static final String _DUMP_EXT_CSV = ".csv";
    public static final String _DUMP_EXT_XML = ".xml";
    public static final int DUMP_FORMAT_CSV = 0;
    public static final int DUMP_FORMAT_SQL = 1;
    public static final int DUMP_FORMAT_XML = 2;
    public static final String _LOAD_EXT_CSV = ".csv";
    public static final String _LOAD_EXT_DUMP = ".dump";
    public static final String _LOAD_EXT_SQL = ".sql";
    public static final String _LOAD_EXT_TXT = ".txt";

    public static boolean mysqlTableExistsUseSelectCount() {
        if (!MYSQL_tableExists_UseSelectCount) {
            return false;
        }
        if (!MYSQL_tableExists_init) {
            MYSQL_tableExists_init = true;
            boolean v = RTConfig.getBoolean("db.mysql.tableExistsSelectCount", MYSQL_tableExists_UseSelectCount);
            if (!v) {
                MYSQL_tableExists_UseSelectCount = false;
                Print.logDebug("MySQL: Explicitly disallow 'SELECT COUNT(*)' for table existence", new Object[0]);
            } else if (OSTools.isWindows()) {
                MYSQL_tableExists_UseSelectCount = false;
                Print.logDebug("MySQL: Windows disallow 'SELECT COUNT(*)' for table existence", new Object[0]);
            } else if (DBProvider.isMySqlInnoDB()) {
                MYSQL_tableExists_UseSelectCount = false;
                Print.logDebug("MySQL/InnoDB: disallow 'SELECT COUNT(*)' for table existence on InnoDB", new Object[0]);
            } else {
                MYSQL_tableExists_UseSelectCount = true;
            }
        }
        return MYSQL_tableExists_UseSelectCount;
    }

    public static void setCustomFactoryHandler(CustomFactoryHandler factoryHandler) {
        DBFactory.factoryHandler = factoryHandler;
    }

    protected static void addActualTableName(String globalTableName, String actualTableName) {
        if (!globalTableName.equals(actualTableName)) {
            if (TableNameMap == null) {
                TableNameMap = new HashMap();
            }
            TableNameMap.put(globalTableName, actualTableName);
        }
    }

    public static String getActualTableName(String utableName) {
        String tn = TableNameMap != null ? TableNameMap.get(utableName) : null;
        return tn != null ? tn : utableName;
    }

    public static DBFactory getFactoryByName(String utableName) {
        String utn = DBFactory.getActualTableName(utableName);
        for (DBFactory fact : factoryList) {
            if (!fact.getUntranslatedTableName().equals(utn)) continue;
            return fact;
        }
        return null;
    }

    public static <T extends DBRecord<T>> DBFactory<T> createDBFactory(String utableName, DBField[] field, KeyType keyType, Class<T> rcdClass, Class<? extends DBRecordKey<T>> keyClass, boolean editable, boolean viewable) {
        if (factoryHandler != null) {
            try {
                DBFactory<T> fact = factoryHandler.createDBFactory(utableName, field, keyType, rcdClass, keyClass, editable, viewable);
                if (fact != null) {
                    return fact;
                }
            }
            catch (Throwable th) {
                Print.logException("'<DBFactory.CustomFactoryHandler>.createDBFactory' failed for table " + utableName, th);
            }
        }
        return new DBFactory<T>(utableName, field, keyType, rcdClass, keyClass, editable, viewable);
    }

    public DBFactory(String utableName, DBField[] field, KeyType keyType, Class<gDBR> rcdClass, Class<? extends DBRecordKey<gDBR>> keyClass, boolean editable, boolean viewable) {
        this.utableName = StringTools.trim(utableName);
        if (StringTools.isBlank(this.utableName)) {
            Print.logError("Table name may not be null/blank!", new Object[0]);
            throw new RuntimeException("Table name may not be null/blank!");
        }
        if (rcdClass == null) {
            Print.logStackTrace("Record class type cannot be null");
            throw new RuntimeException("Record class type cannot be null");
        }
        if (!DBRecord.class.isAssignableFrom(rcdClass)) {
            Print.logStackTrace("Record class must be a subclass of DBRecord");
            throw new RuntimeException("Record class must be a subclass of DBRecord");
        }
        if (keyClass == null) {
            Print.logStackTrace("Key class type cannot be null");
            throw new RuntimeException("Key class type cannot be null");
        }
        if (!DBRecordKey.class.isAssignableFrom(keyClass)) {
            Print.logStackTrace("Key class must be a subclass of DBRecordKey");
            throw new RuntimeException("Key class class must be a subclass of DBRecordKey");
        }
        this.rcdClass = rcdClass;
        this.keyClass = keyClass;
        this.keyType = keyType;
        this.indexType = null;
        EnumTools.registerPublicEnumClasses(this.rcdClass);
        this.editable = editable;
        this.viewable = this.editable || viewable;
        String rcdClassStr = StringTools.className(this.rcdClass);
        int p = rcdClassStr.lastIndexOf(".");
        if (p > 0) {
            String classTableName = rcdClassStr.substring(p + 1);
            DBFactory.addActualTableName(classTableName, this.utableName);
        }
        List<DBField> preList = ListTools.toList(field);
        Iterator<DBField> i = preList.iterator();
        while (i.hasNext()) {
            if (i.next() != null) continue;
            i.remove();
        }
        if (factoryHandler != null) {
            try {
                preList = factoryHandler.selectFields(this, preList);
            }
            catch (Throwable th) {
                Print.logException("'<DBFactory.CustomFactoryHandler>.selectFields' failed for table " + this.utableName, th);
            }
            if (preList == null) {
                Print.logWarn("'<DBFactory.CustomFactoryHandler>.selectFields' returned NULL for table " + this.utableName, new Object[0]);
                preList = new Vector<DBField>();
            }
        }
        this.altIndexMap = null;
        this.fieldMap = new OrderedMap();
        Vector<DBField> pkList = new Vector<DBField>();
        for (DBField fld : preList) {
            String[] altNames;
            fld.setFactory(this);
            String fn = fld.getName();
            if (this.fieldMap.containsKey(fn)) {
                Print.logError("DBField already defined for table: " + this.utableName + "." + fn, new Object[0]);
                continue;
            }
            this.fieldMap.put(fn, fld);
            if (fld.isPrimaryKey()) {
                pkList.add(fld);
            }
            if ((altNames = fld.getAlternateIndexes()) == null || altNames.length <= 0) continue;
            if (this.altIndexMap == null) {
                this.altIndexMap = new OrderedMap();
            }
            for (int a = 0; a < altNames.length; ++a) {
                DBAlternateIndex altKey = this.altIndexMap.get(altNames[a]);
                if (altKey == null) {
                    altKey = new DBAlternateIndex(this, altNames[a]);
                    this.altIndexMap.put(altNames[a], altKey);
                }
                altKey.addField(fld);
            }
        }
        this.priKeys = pkList.toArray(new DBField[pkList.size()]);
        this.fieldArray = null;
        this.fieldArrayReady = false;
        this.getFields();
        String lmcKey = utableName + ".logMissingColumns";
        if (RTConfig.hasProperty(lmcKey)) {
            boolean lmc = RTConfig.getBoolean(lmcKey, true);
            this.setLogMissingColumnWarnings(lmc);
        }
        factoryList.add(this);
    }

    public String getDescription(Locale loc) {
        try {
            if (this.tableDescriptionMethod == null) {
                this.tableDescriptionMethod = new MethodAction(this.rcdClass, "getTableDescription", Locale.class);
            }
            return (String)this.tableDescriptionMethod.invoke(loc);
        }
        catch (Throwable th) {
            Print.logError("Unable to retrieve table description: " + th, new Object[0]);
            return null;
        }
    }

    public void setRequired(boolean required) {
        this.isRequired = required;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isViewable() {
        return this.isEditable() || this.viewable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearExistingColumnMap() {
        Object object = this.existingFieldLock;
        synchronized (object) {
            this.existingField = null;
            this.existingFieldMap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, DBField> getExistingColumnMap(boolean update) throws DBException {
        Object object = this.existingFieldLock;
        synchronized (object) {
            if (update || this.existingFieldMap == null) {
                DBField[] fld = this.getExistingColumns(update);
                if (fld != null) {
                    this.existingFieldMap = new HashMap<String, DBField>();
                    for (int i = 0; i < fld.length; ++i) {
                        String fldName = fld[i].getName();
                        this.existingFieldMap.put(fldName, fld[i]);
                    }
                } else {
                    this.existingFieldMap = null;
                }
            }
        }
        return this.existingFieldMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBField[] getExistingColumns(boolean update) throws DBException {
        Object object = this.existingFieldLock;
        synchronized (object) {
            if (update || this.existingField == null) {
                this.existingFieldMap = null;
                this.existingField = DBProvider.getActualTableFields(this.getUntranslatedTableName());
            }
        }
        return this.existingField;
    }

    public boolean validateColumns() {
        return this.validateColumns(768);
    }

    public boolean validateColumns(int validateMask) {
        return this.validateColumns(validateMask, false);
    }

    public boolean validateColumns(int validateMask, boolean refreshColumns) {
        String columnName;
        int i;
        int i2;
        DBField[] colTable;
        String utableName = this.getUntranslatedTableName();
        boolean addMissingColumns = (validateMask & 2) != 0;
        boolean alterColumnTypes = (validateMask & 4) != 0;
        boolean rebuildKeys = (validateMask & 8) != 0;
        boolean checkColumnEncoding = (validateMask & 0x10) != 0;
        boolean showColumns = (validateMask & 0x400) != 0;
        boolean displayWarnings = (validateMask & 0x200) != 0;
        boolean displayErrors = (validateMask & 0x100) != 0 || displayWarnings || showColumns;
        DBField[] colDefined = this.getFields();
        if (colDefined == null || colDefined.length == 0) {
            if (displayErrors) {
                Print.logInfo("ERROR - " + utableName + ": No table columns defined!!!", new Object[0]);
            }
            return false;
        }
        if (showColumns) {
            Print.logInfo("    Defined columns: " + utableName, new Object[0]);
            for (int i3 = 0; i3 < colDefined.length; ++i3) {
                Print.logInfo("      " + this._columnInfo(i3, colDefined[i3], true), new Object[0]);
            }
        }
        try {
            colTable = this.getExistingColumns(refreshColumns);
            if (colTable == null) {
                if (displayErrors) {
                    Print.logInfo("ERROR - " + utableName + ": Reading table columns not supported!", new Object[0]);
                }
                return false;
            }
        }
        catch (DBException dbe) {
            if (displayErrors) {
                Print.logInfo("ERROR - " + utableName + ": Error reading table columns!", new Object[0]);
            }
            return false;
        }
        if (showColumns) {
            boolean showActual = false;
            if (colTable.length != colDefined.length) {
                showActual = true;
            } else {
                for (i2 = 0; i2 < colTable.length; ++i2) {
                    if (colTable[i2].isTypeMatch() && colDefined[i2].equals(colTable[i2])) continue;
                    showActual = true;
                    break;
                }
            }
            if (showActual) {
                Print.logInfo("    Actual columns: " + utableName + "  (as described in the database)", new Object[0]);
                for (i2 = 0; i2 < colTable.length; ++i2) {
                    Print.logInfo("      " + this._columnInfo(i2, colTable[i2], false), new Object[0]);
                }
            }
        }
        OrderedMap<String, DBField> colTableMap = new OrderedMap<String, DBField>();
        for (i2 = 0; i2 < colTable.length; ++i2) {
            colTableMap.put(colTable[i2].getName(), colTable[i2]);
        }
        boolean columnsOK = true;
        OrderedSet<DBField> missingColumns = new OrderedSet<DBField>();
        OrderedSet<DBField> typeMismatchColumns = new OrderedSet<DBField>();
        OrderedSet<DBField> priKeyMismatchColumns = new OrderedSet<DBField>();
        OrderedSet<DBField> altKeyMismatchColumns = new OrderedSet<DBField>();
        for (i = 0; i < colDefined.length; ++i) {
            columnName = colDefined[i].getName();
            DBField existingField = (DBField)colTableMap.get(columnName);
            if (existingField == null) {
                if (!DBField.IgnoreColumnError(utableName, columnName)) {
                    if (displayErrors) {
                        Print.logInfo("ERROR - " + utableName + ": Column '" + colDefined[i] + "' [" + i + "] not found", new Object[0]);
                    }
                    missingColumns.add(colDefined[i]);
                    columnsOK = false;
                    continue;
                }
                if (!displayErrors) continue;
                Print.logInfo("WARNING - " + utableName + ": Column '" + colDefined[i] + "' [" + i + "] not found (ignored)", new Object[0]);
                continue;
            }
            String actualCS = existingField.getCharacterSet();
            String definedCS = colDefined[i].getCharacterSet();
            if (StringTools.isBlank(definedCS)) {
                definedCS = "<default>";
            }
            if (colDefined[i].isUTF8() && !existingField.isUTF8()) {
                if (!DBField.IgnoreColumnError(utableName, columnName)) {
                    if (displayErrors) {
                        Print.logInfo("ERROR - " + utableName + ": Column '" + columnName + "' UTF8 mismatch '" + definedCS + "' != '" + actualCS + "'", new Object[0]);
                    }
                    typeMismatchColumns.add(colDefined[i]);
                    columnsOK = false;
                } else if (displayErrors) {
                    Print.logInfo("WARNING - " + utableName + ": Column '" + columnName + "' UTF8 mismatch '" + definedCS + "' != '" + actualCS + "' (ignored)", new Object[0]);
                }
            } else if (!colDefined[i].isUTF8() && existingField.isUTF8() && checkColumnEncoding) {
                if (alterColumnTypes) {
                    if (!DBField.IgnoreColumnError(utableName, columnName)) {
                        if (displayErrors) {
                            Print.logInfo("ERROR - " + utableName + ": Column '" + columnName + "' UTF8 mismatch '" + definedCS + "' != '" + actualCS + "'", new Object[0]);
                        }
                        typeMismatchColumns.add(colDefined[i]);
                        columnsOK = false;
                    } else if (displayErrors) {
                        Print.logInfo("WARNING - " + utableName + ": Column '" + columnName + "' UTF8 mismatch '" + definedCS + "' != '" + actualCS + "' (ignored)", new Object[0]);
                    }
                } else if (displayErrors) {
                    Print.logInfo("WARNING - " + utableName + ": Column '" + columnName + "' UTF8 mismatch '" + definedCS + "' != '" + actualCS + "'", new Object[0]);
                }
            }
            String actualType = existingField.getDataType();
            String definedType = colDefined[i].getDataType();
            if (!DBProvider.areTypesEquivalent(definedType, actualType)) {
                if (displayErrors) {
                    Print.logInfo("ERROR - " + utableName + ": Column '" + columnName + "' Type mismatch expected::" + definedType + " != found:" + actualType + "", new Object[0]);
                }
                typeMismatchColumns.add(colDefined[i]);
                columnsOK = false;
            }
            if (existingField.isPrimaryKey() != colDefined[i].isPrimaryKey()) {
                if (displayErrors) {
                    if (colDefined[i].isPrimaryKey()) {
                        Print.logInfo("ERROR - " + utableName + ": Column '" + columnName + "' missing Primary key", new Object[0]);
                    } else {
                        Print.logInfo("ERROR - " + utableName + ": Column '" + columnName + "' extra Primary key", new Object[0]);
                    }
                }
                priKeyMismatchColumns.add(colDefined[i]);
                columnsOK = false;
            } else if (existingField.hasMissingAlternateIndexes(colDefined[i].getAlternateIndexes())) {
                if (displayErrors) {
                    String altKeys = StringTools.join(existingField.getMissingAlternateIndexes(colDefined[i].getAlternateIndexes()), ",");
                    Print.logInfo("ERROR - " + utableName + ": Column '" + columnName + "' missing Alternate key [" + altKeys + "]", new Object[0]);
                }
                altKeyMismatchColumns.add(colDefined[i]);
                columnsOK = false;
            } else if (existingField.hasExtraAlternateIndexes(colDefined[i].getAlternateIndexes()) && displayWarnings) {
                String altKeys = StringTools.join(existingField.getAlternateIndexes(), ",");
                Print.logInfo("Warn - " + utableName + ": Column '" + columnName + "' extra Alternate key [" + altKeys + "]", new Object[0]);
            }
            int colTableNdx = colTableMap.indexOfKey(columnName);
            if (colTableNdx != i && !displayWarnings) continue;
        }
        if (displayWarnings) {
            for (i = 0; i < colTable.length; ++i) {
                columnName = colTable[i].getName();
                DBField definedField = this.getField(columnName);
                if (definedField != null) continue;
                Print.logInfo("WARNING - " + utableName + ": Actual column '" + colTable[i] + "' not used", new Object[0]);
            }
        }
        if (addMissingColumns && missingColumns.size() > 0) {
            try {
                int cnt;
                DBField[] columns = missingColumns.toArray((K[])new DBField[missingColumns.size()]);
                for (int ndx = 0; ndx < columns.length && (cnt = this.addColumns(columns, ndx)) != 0; ndx += cnt) {
                }
                for (int c = 0; c < columns.length; ++c) {
                    if (!columns[c].isAlternateKey()) continue;
                    this.recreateAlternateIndexes();
                    break;
                }
            }
            catch (DBException dbe) {
                if (displayErrors) {
                    Print.logException("ERROR - " + utableName + ": Unable to add missing columns!", dbe);
                }
                return false;
            }
        }
        if (alterColumnTypes && typeMismatchColumns.size() > 0) {
            try {
                int cnt;
                DBField[] columns = typeMismatchColumns.toArray((K[])new DBField[typeMismatchColumns.size()]);
                for (int ndx = 0; ndx < columns.length && (cnt = this.addColumns(columns, ndx)) != 0; ndx += cnt) {
                }
            }
            catch (DBException dbe) {
                if (displayErrors) {
                    Print.logException("ERROR - " + utableName + ": Unable to alter column type!", dbe);
                }
                return false;
            }
        }
        if (rebuildKeys && priKeyMismatchColumns.size() > 0) {
            try {
                this.recreatePrimaryKey();
            }
            catch (DBException dbe) {
                if (displayErrors) {
                    Print.logException("ERROR - " + utableName + ": Unable to rebuild primary key!", dbe);
                }
                return false;
            }
        }
        if (rebuildKeys && altKeyMismatchColumns.size() > 0) {
            try {
                this.recreateAlternateIndexes();
            }
            catch (DBException dbe) {
                if (displayErrors) {
                    Print.logException("ERROR - " + utableName + ": Unable to rebuild alternate keys!", dbe);
                }
                return false;
            }
        }
        if (!columnsOK && displayWarnings) {
            for (int i4 = 0; i4 < colTable.length; ++i4) {
                Print.logInfo("WARNING - " + utableName + ": Found - " + colTable[i4], new Object[0]);
            }
        }
        return columnsOK;
    }

    private String _columnInfo(int i, DBField f, boolean isDefined) {
        String ndx = StringTools.format(i, "00");
        String name = StringTools.leftAlign(f.getName(), 22);
        String desc = isDefined ? ": " + f.getTitle(null) : "";
        String type = f.getSqlType();
        if (f.isPrimaryKey()) {
            type = type + " key";
        }
        if (f.isAlternateKey()) {
            type = type + " altkey";
        }
        if (f.isAutoIncrement()) {
            type = type + " auto";
        }
        if (f.isUTF8()) {
            type = type + " utf8";
        }
        type = StringTools.leftAlign(type, 32);
        return ndx + ") " + name + " " + type + desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBField[] getFields() {
        if (!this.fieldArrayReady) {
            OrderedMap<String, DBField> orderedMap = this.fieldMap;
            synchronized (orderedMap) {
                if (!this.fieldArrayReady) {
                    this.fieldArray = this.fieldMap.valueArray(DBField.class);
                    this.fieldArrayReady = true;
                }
            }
        }
        return this.fieldArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBField[] getFields(Set<String> fieldNames) {
        if (ListTools.isEmpty(fieldNames)) {
            return this.getFields();
        }
        Vector<DBField> fldList = new Vector<DBField>();
        OrderedMap<String, DBField> orderedMap = this.fieldMap;
        synchronized (orderedMap) {
            for (DBField dbf : this.fieldMap.values()) {
                String n = dbf.getName();
                if (!fieldNames.contains(n)) continue;
                fldList.add(dbf);
            }
        }
        return fldList.toArray(new DBField[fldList.size()]);
    }

    public DBField[] getFields(String ... fieldNames) {
        if (ListTools.isEmpty(fieldNames)) {
            return this.getFields();
        }
        return this.getFields(ListTools.toSet(fieldNames, null));
    }

    public String getMappedFieldName(String cn) {
        return DBProvider.translateColumnName(cn);
    }

    public boolean hasField(String name) {
        String n = this.getMappedFieldName(name);
        return n != null ? this.fieldMap.containsKey(n) : false;
    }

    public DBField getField(String name) {
        String n = this.getMappedFieldName(name);
        return n != null ? this.fieldMap.get(n) : null;
    }

    public int getFieldStringLength(String name) {
        DBField fld = this.getField(name);
        return fld != null ? fld.getStringLength() : 0;
    }

    public int getFieldCount() {
        return this.fieldMap.size();
    }

    public String[] getFieldNames() {
        return this.fieldMap.keyArray(String.class);
    }

    public static String[] getFieldNames(DBField[] flds) {
        if (ListTools.isEmpty(flds)) {
            return new String[0];
        }
        String[] fldNames = new String[flds.length];
        for (int i = 0; i < flds.length; ++i) {
            fldNames[i] = flds[i] != null ? flds[i].getName() : "";
        }
        return fldNames;
    }

    public DBField[] getFieldsWithBoolean(String key, boolean value) {
        Vector<DBField> af = new Vector<DBField>();
        Iterator<DBField> i = this.fieldMap.valueIterator();
        while (i.hasNext()) {
            DBField fld = i.next();
            if (fld.getBooleanAttribute(key, false) != value) continue;
            af.add(fld);
        }
        return af.toArray(new DBField[af.size()]);
    }

    public DBField[] getNamedFields(String[] fieldNames) {
        Vector<DBField> fields = new Vector<DBField>();
        for (int i = 0; i < fieldNames.length; ++i) {
            DBField fld = this.getField(fieldNames[i]);
            if (fld != null) {
                fields.add(fld);
                continue;
            }
            Print.logStackTrace("Invalid field for table: " + fieldNames[i]);
        }
        return fields.toArray(new DBField[fields.size()]);
    }

    public boolean setFieldDefaultValue(String fldName, Object dftVal) {
        DBField fld = this.getField(fldName);
        if (fld != null) {
            fld.setDefaultValue(dftVal);
            return true;
        }
        return false;
    }

    public void setLogMissingColumnWarnings(boolean state) {
        this.logMissingColumns = state;
    }

    public boolean logMissingColumnWarning() {
        return this.logMissingColumns;
    }

    public DBField getAutoIndexField() {
        return this.getField("autoIndex");
    }

    public DBField[] getKeyFields() {
        return this.priKeys;
    }

    public String[] getKeyNames() {
        DBField[] f = this.getKeyFields();
        String[] kn = new String[f.length];
        for (int i = 0; i < f.length; ++i) {
            kn[i] = f[i].getName();
        }
        return kn;
    }

    public String getKeyType() {
        return DBFactory.getKeyTypeName(this.keyType);
    }

    public static String getKeyTypeName(KeyType type) {
        switch (type) {
            case PRIMARY: {
                return "PRIMARY KEY";
            }
            case UNIQUE: {
                return "UNIQUE";
            }
            case INDEX: {
                return "INDEX";
            }
            case UNIQUE_INDEX: {
                return "UNIQUE INDEX";
            }
        }
        return "UNKNOWN";
    }

    public Class<? extends DBRecordKey<gDBR>> getKeyClass() {
        return this.keyClass;
    }

    public DBRecordKey<gDBR> createKey() throws DBException {
        if (this.keyClass != null) {
            try {
                Constructor<DBRecordKey<gDBR>> kc = this.keyClass.getConstructor(new Class[0]);
                return kc.newInstance(new Object[0]);
            }
            catch (Throwable t) {
                throw new DBException("Key Creation", t);
            }
        }
        return null;
    }

    public DBRecordKey<gDBR> createKey(ResultSet rs) throws DBException {
        DBRecordKey<gDBR> key = this.createKey();
        if (rs != null) {
            DBField[] pk = this.getKeyFields();
            try {
                for (int i = 0; i < pk.length; ++i) {
                    String name = pk[i].getName();
                    Object val = pk[i].getResultSetValue(rs);
                    key.setKeyValue(name, val);
                }
            }
            catch (SQLException sqe) {
                throw new DBException("Creating Key", sqe);
            }
        }
        return key;
    }

    public DBRecordKey<gDBR> createKey(Map<String, String> valMap) throws DBException {
        return this.createKey(valMap, DBWhere.KEY_FULL);
    }

    public DBRecordKey<gDBR> createKey(Map<String, String> valMap, int partialKeyType) throws DBException {
        DBField[] pk;
        String utableName = this.getUntranslatedTableName();
        if (ListTools.isEmpty(valMap) && partialKeyType != DBWhere.KEY_PARTIAL_ALL_EMPTY) {
            throw new DBException("Creating Key: No key fields - " + utableName);
        }
        if (partialKeyType == DBWhere.KEY_AUTO_INDEX) {
            DBField autoKey = this.getAutoIndexField();
            if (autoKey == null) {
                throw new DBException("Creating Key: auto-index key not found - " + utableName);
            }
            pk = new DBField[]{autoKey};
        } else {
            pk = this.getKeyFields();
        }
        DBRecordKey<gDBR> key = this.createKey();
        for (int i = 0; i < pk.length; ++i) {
            String sval;
            String name = pk[i].getName();
            String string = sval = valMap != null ? valMap.get(name) : null;
            if (sval == null) {
                if (partialKeyType == DBWhere.KEY_AUTO_INDEX) {
                    throw new DBException("Creating Key: auto-index not found - " + utableName + "." + name);
                }
                if (partialKeyType == DBWhere.KEY_FULL) {
                    throw new DBException("Creating Key: field not found - " + utableName + "." + name);
                }
                if (partialKeyType == DBWhere.KEY_PARTIAL_ALL_EMPTY) continue;
                if (i == 0) {
                    throw new DBException("Creating Key: first field not found - " + utableName + "." + name);
                }
                if (partialKeyType != DBWhere.KEY_PARTIAL_FIRST) continue;
                break;
            }
            Object val = pk[i].parseStringValue(sval);
            key.setKeyValue(name, val);
        }
        return key;
    }

    public gDBR createRecord(ResultSet rs) throws DBException {
        DBRecordKey<gDBR> rcdKey = this.createKey(rs);
        if (rcdKey != null) {
            gDBR rcd = rcdKey.getDBRecord();
            ((DBRecord)rcd).setAllFieldValues(rs);
            return rcd;
        }
        Print.logError("Unable to create record: " + this.getUntranslatedTableName(), new Object[0]);
        return null;
    }

    public gDBR createRecord(Map<String, String> valMap) throws DBException {
        DBRecordKey<gDBR> rcdKey = this.createKey(valMap);
        if (rcdKey != null) {
            gDBR rcd = rcdKey.getDBRecord();
            ((DBRecord)rcd).setAllFieldValues(valMap);
            return rcd;
        }
        Print.logError("Unable to create key: " + this.getUntranslatedTableName(), new Object[0]);
        return null;
    }

    public gDBR createRecord(Element record) throws DBException {
        HashMap<String, String> valMap = new HashMap<String, String>();
        NodeList fieldNodes = XMLTools.getChildElements(record, TAG_Field);
        for (int f = 0; f < fieldNodes.getLength(); ++f) {
            Element field = (Element)fieldNodes.item(f);
            String name = XMLTools.getAttribute(field, ATTR_name, null, false);
            if (StringTools.isBlank(name)) {
                throw new DBException("Field does not specify a 'name'");
            }
            String val = XMLTools.getNodeText(field, "\\n", false, "");
            valMap.put(name, val);
        }
        return this.createRecord(valMap);
    }

    public int getAlternateIndexCount() {
        return this.altIndexMap != null ? this.altIndexMap.size() : 0;
    }

    public boolean hasAlternateIndexes() {
        return this.getAlternateIndexCount() > 0;
    }

    public DBAlternateIndex[] getAlternateIndexes() {
        if (!this.hasAlternateIndexes()) {
            return null;
        }
        return this.altIndexMap.valueArray(DBAlternateIndex.class);
    }

    public String[] getAlternateIndexNames() {
        if (!this.hasAlternateIndexes()) {
            return null;
        }
        return this.altIndexMap.keyArray(String.class);
    }

    public DBAlternateIndex getAlternateIndex(String name) {
        if (this.altIndexMap == null) {
            return null;
        }
        String n = !StringTools.isBlank(name) ? name : "altIndex";
        return this.altIndexMap.get(n);
    }

    public Class<gDBR> getRecordClass() {
        return this.rcdClass;
    }

    public String getUntranslatedTableName() {
        return this.utableName;
    }

    public String getTranslatedTableName() {
        return DBProvider.translateTableName(this.getUntranslatedTableName());
    }

    public boolean tableExists() throws DBException {
        DBConnection dbc = null;
        Statement stmt = null;
        ResultSet rs = null;
        boolean innodb = this.isMySQLInnoDB();
        try {
            dbc = DBConnection.getDefaultConnection();
            if (DBProvider.getProvider().getID() != 1) {
                DBSelect dsel = new DBSelect(this);
                dsel.setSelectedFields(DBProvider.FLD_COUNT());
                stmt = dbc.execute(dsel.toString());
                boolean bl = true;
                return bl;
            }
            if (innodb) {
                String xtableName = this.getTranslatedTableName();
                String sqlExists = "SHOW COLUMNS FROM " + this.getTranslatedTableName();
                stmt = dbc.execute(sqlExists);
                boolean t = true;
                return t;
            }
            if (DBFactory.mysqlTableExistsUseSelectCount()) {
                DBSelect dsel = new DBSelect(this);
                dsel.setSelectedFields(DBProvider.FLD_COUNT());
                stmt = dbc.execute(dsel.toString());
                boolean sqlExists = true;
                return sqlExists;
            }
            String xtableName = this.getTranslatedTableName();
            String sqlExists = "SHOW COLUMNS FROM " + this.getTranslatedTableName();
            stmt = dbc.execute(sqlExists);
            boolean t = true;
            return t;
        }
        catch (SQLException sqe) {
            String sqlMsg = sqe.getMessage();
            int errCode = sqe.getErrorCode();
            if (errCode == 1146) {
                boolean t = false;
                return t;
            }
            if (errCode == 1049) {
                String dbName = DBProvider.getDBName();
                Print.logError("Database does not exist '" + dbName + "'", new Object[0]);
                boolean t = false;
                return t;
            }
            if (errCode == 208) {
                boolean dbName = false;
                return dbName;
            }
            if (sqlMsg.indexOf("does not exist") >= 0) {
                boolean dbName = false;
                return dbName;
            }
            String dbName = DBProvider.getDBName();
            throw new DBException("Table Existance '" + dbName + "'", sqe);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
            DBConnection.release(dbc);
        }
    }

    public boolean tableRequired() {
        return true;
    }

    public long getMySQLTableStatus() throws DBException {
        String colName_Name = "Name";
        String colName_Engine = "Engine";
        String colName_Version = "Version";
        String colName_Row_format = "Row_format";
        String colName_Rows = "Rows";
        String colName_Avg_row_length = "Avg_row_length";
        String colName_Data_length = "Data_length";
        String colName_Max_data_length = "Max_data_length";
        String colName_Index_length = "Index_length";
        String colName_Data_free = "Data_free";
        String colName_Auto_increment = "Auto_increment";
        String colName_Create_time = "Create_time";
        String colName_Update_time = "Update_time";
        String colName_Check_time = "Check_time";
        String colName_Collation = "Collation";
        String colName_Checksum = "Checksum";
        String colName_Create_options = "Create_options";
        String colName_Comment = "Comment";
        String utableName = this.getUntranslatedTableName();
        String xtableName = DBProvider.translateTableName(utableName);
        DBProvider dbp = DBProvider.getProvider();
        String showStatus = null;
        String dftNdxType = "?";
        if (dbp.getID() != 1) {
            this._setIndexType("");
            return -1L;
        }
        showStatus = "SHOW TABLE STATUS WHERE Name=\"" + xtableName + "\"";
        dftNdxType = DBProvider.isMySqlInnoDB() ? "InnoDB" : "MyISAM";
        long rows = -1L;
        DBConnection dbc = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            dbc = DBConnection.getDefaultConnection();
            stmt = dbc.execute(showStatus);
            rs = stmt.getResultSet();
            if (rs.next()) {
                this._setIndexType(rs.getString(colName_Engine));
                rows = rs.getLong(colName_Rows);
            } else {
                this._setIndexType(dftNdxType);
                rows = -1L;
            }
        }
        catch (SQLException sqe) {
            Print.logError("SQLException: " + sqe, new Object[0]);
            this._setIndexType(dftNdxType);
            throw new DBException("Unable to get table status", sqe);
        }
        catch (DBException dbe) {
            Print.logError("DBException: " + dbe, new Object[0]);
            this._setIndexType(dftNdxType);
            throw dbe;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
            DBConnection.release(dbc);
        }
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateTable(boolean inclWarn) {
        String utableName = this.getUntranslatedTableName();
        Print.logInfo("", new Object[0]);
        Print.logInfo("Validating " + utableName + ":", new Object[0]);
        boolean pass = true;
        try {
            MethodAction valConst = null;
            try {
                valConst = new MethodAction(this.getRecordClass(), ResultSet.class, ValidationLog.class);
            }
            catch (Throwable t) {
                throw new ValidationNotImplementedException("Missing validation Constructor");
            }
            DBConnection dbc = null;
            Statement stmt = null;
            ResultSet rs = null;
            try {
                DBSelect dsel = new DBSelect(this);
                dbc = DBConnection.getDefaultConnection();
                stmt = dbc.execute(dsel.toString(), true);
                rs = stmt.getResultSet();
                while (rs.next()) {
                    ValidationLog failLog = new ValidationLog(utableName, inclWarn);
                    try {
                        valConst.invoke(rs, failLog);
                        if (failLog.hasErrors()) {
                            Print.logError(failLog.toString(), new Object[0]);
                            pass = false;
                            continue;
                        }
                        if (!inclWarn || failLog.hasHeader()) continue;
                        throw new ValidationNotImplementedException("No log header");
                    }
                    catch (Throwable t) {
                        Print.logException("Validating " + utableName + ": ", t);
                        pass = false;
                    }
                }
            }
            finally {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable t) {}
                }
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (Throwable t) {}
                }
                DBConnection.release(dbc);
            }
            if (pass) {
                String e = inclWarn ? "errors/warnings" : "severe errors";
                Print.logInfo("  No " + e + " detected", new Object[0]);
            }
            return pass;
        }
        catch (ValidationNotImplementedException vnie) {
            Print.logError("  Validation not implemented: " + vnie.getMessage(), new Object[0]);
        }
        catch (DBException dbe) {
            Print.logException("Validating " + utableName + ": ", dbe);
        }
        catch (SQLException sqe) {
            Print.logException("Validating " + utableName + ": ", sqe);
        }
        return false;
    }

    public int addColumns(DBField[] cols, int ndx) throws DBException {
        try {
            return this._addColumns(cols, ndx);
        }
        catch (SQLException sqe) {
            throw new DBException("Adding/Altering column", sqe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int _addColumns(DBField[] cols, int ndx) throws SQLException, DBException {
        DBField col;
        Map<String, DBField> colMap = this.getExistingColumnMap(false);
        if (colMap == null) {
            return 0;
        }
        if (cols == null || ndx < 0 || ndx >= cols.length) {
            return 0;
        }
        int colCount = 0;
        StringBuffer sb = new StringBuffer();
        DBProvider dbp = DBProvider.getProvider();
        String xtableName = this.getTranslatedTableName();
        if (dbp.getID() == 1) {
            sb.append("ALTER TABLE ").append(xtableName);
            while (ndx < cols.length) {
                String colName;
                if (colCount > 0) {
                    sb.append(",");
                }
                if (colMap.containsKey(colName = (col = cols[ndx]).getName())) {
                    sb.append(" CHANGE ").append(colName).append(" ").append(col.getFieldDefinition());
                    if (col.isAutoIncrement()) {
                        sb.append(" auto_increment");
                    }
                    if (col.isUTF8()) {
                        sb.append(" CHARACTER SET utf8");
                    }
                    Print.logInfo("Changing column: " + xtableName + "." + col.getFieldDefinition(), new Object[0]);
                } else {
                    sb.append(" ADD COLUMN ").append(col.getFieldDefinition());
                    if (col.isAutoIncrement()) {
                        sb.append(" auto_increment");
                    } else if (col.isUTF8()) {
                        sb.append(" CHARACTER SET utf8");
                    }
                    Print.logInfo("Adding column: " + xtableName + "." + col.getFieldDefinition(), new Object[0]);
                }
                ++colCount;
                ++ndx;
            }
        } else if (dbp.getID() == 4) {
            sb.append("ALTER TABLE ").append(xtableName);
            col = cols[ndx];
            String colName = col.getName();
            if (colMap.containsKey(colName)) {
                sb.append(" ALTER COLUMN ").append(col.getFieldDefinition());
                Print.logInfo("Changing column: " + xtableName + "." + col.getFieldDefinition(), new Object[0]);
            } else {
                sb.append(" ADD ").append(col.getFieldDefinition());
                Print.logInfo("Adding column: " + xtableName + "." + col.getFieldDefinition(), new Object[0]);
            }
            ++colCount;
        } else if (dbp.getID() == 3) {
            sb.append("ALTER TABLE ").append(xtableName);
            col = cols[ndx];
            String colName = col.getName();
            if (colMap.containsKey(colName)) {
                sb.append(" ALTER ").append(colName).append(" SET DATA TYPE ").append(col.getFieldDefinition());
            } else {
                sb.append(" ADD COLUMN ").append(col.getFieldDefinition());
                Print.logInfo("Adding column: " + xtableName + "." + col.getFieldDefinition(), new Object[0]);
            }
            ++colCount;
        }
        if (sb.length() > 0) {
            Print.logInfo("Executing SQL 'ALTER TABLE ...'", new Object[0]);
            DBConnection dbc = null;
            try {
                dbc = DBConnection.getDefaultConnection();
                dbc.executeUpdate(sb.toString());
            }
            finally {
                DBConnection.release(dbc);
            }
        }
        return colCount;
    }

    public void dropColumn(DBField col) throws DBException {
        if (col != null) {
            try {
                this._dropColumn(col);
            }
            catch (SQLException sqe) {
                throw new DBException("Dropping column", sqe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _dropColumn(DBField col) throws SQLException, DBException {
        String colName = col.getName();
        Map<String, DBField> colMap = this.getExistingColumnMap(false);
        if (colMap != null && colMap.containsKey(colName)) {
            String xtableName = this.getTranslatedTableName();
            String fieldDef = col.getFieldDefinition();
            StringBuffer sb = new StringBuffer();
            DBProvider dbp = DBProvider.getProvider();
            if (dbp.getID() == 1) {
                sb.append("ALTER TABLE ").append(xtableName);
                sb.append(" DROP COLUMN ");
                sb.append(DBProvider.getProvider().quoteColumnName(colName));
                Print.logInfo("Dropping column: " + xtableName + "." + fieldDef, new Object[0]);
            } else if (dbp.getID() == 4) {
                sb.append("ALTER TABLE ").append(xtableName);
                sb.append(" DROP COLUMN ");
                sb.append(DBProvider.getProvider().quoteColumnName(colName));
                Print.logInfo("Dropping column: " + xtableName + "." + fieldDef, new Object[0]);
            } else if (dbp.getID() == 3) {
                sb.append("ALTER TABLE ").append(xtableName);
                sb.append(" DROP COLUMN ");
                sb.append(DBProvider.getProvider().quoteColumnName(colName));
                Print.logInfo("Dropping column: " + xtableName + "." + fieldDef, new Object[0]);
            }
            if (sb.length() > 0) {
                Print.logInfo("SQL Drop Column: " + sb, new Object[0]);
                DBConnection dbc = null;
                try {
                    dbc = DBConnection.getDefaultConnection();
                    dbc.executeUpdate(sb.toString());
                }
                finally {
                    DBConnection.release(dbc);
                }
            }
        }
    }

    public void recreatePrimaryKey() throws DBException {
        try {
            DBProvider.removePrimaryIndex(this.getUntranslatedTableName());
        }
        catch (Throwable th) {
            Print.logWarn("Primary key does not currently exist", new Object[0]);
        }
        try {
            DBProvider.createPrimaryIndex(this);
        }
        catch (SQLException sqe) {
            throw new DBException("Alter primary key", sqe);
        }
    }

    public void recreateAlternateIndexes() throws DBException {
        String utableName = this.getUntranslatedTableName();
        try {
            Set<String> altIndexSet;
            DBTableIndexMap indexMap = DBProvider.getActualTableIndexMap(utableName);
            if (indexMap != null && (altIndexSet = indexMap.getAlternateIndexes()) != null) {
                for (String indexName : altIndexSet) {
                    try {
                        DBProvider.removeAlternateIndex(utableName, indexName);
                        Print.logInfo("Dropped alternate index '" + indexName + "' from table " + utableName, new Object[0]);
                    }
                    catch (Throwable th) {}
                }
            }
        }
        catch (DBException dbe) {
            Print.logWarn("Unable to retrieve index information: " + dbe.getMessage(), new Object[0]);
        }
        DBAlternateIndex[] altIndexes = this.getAlternateIndexes();
        if (altIndexes != null && altIndexes.length > 0) {
            for (int i = 0; i < altIndexes.length; ++i) {
                String indexName = altIndexes[i].getIndexName();
                try {
                    DBProvider.removeAlternateIndex(utableName, indexName);
                }
                catch (Throwable th) {
                    // empty catch block
                }
                try {
                    DBField[] indexFields = altIndexes[i].getFields();
                    DBProvider.createAlternateIndex(utableName, altIndexes[i]);
                    Print.logInfo("Created alternate index '" + indexName + "' for table " + utableName, new Object[0]);
                    continue;
                }
                catch (SQLException sqe) {
                    throw new DBException("Alternate index create error", sqe);
                }
            }
        } else {
            try {
                DBProvider.removeAlternateIndex(utableName, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void createTable() throws DBException {
        try {
            DBProvider.createTable(this);
        }
        catch (SQLException sqe) {
            throw new DBException("Table creation", sqe);
        }
    }

    public void dropTable() throws DBException {
        try {
            DBProvider.dropTable(this.getUntranslatedTableName());
        }
        catch (SQLException sqe) {
            throw new DBException("Drop table", sqe);
        }
    }

    public void dumpTable(File toFile) throws DBException {
        this.dumpTable(toFile, null, null);
    }

    public void dumpTable(File toFile, DBSelect<gDBR> dsel) throws DBException {
        this.dumpTable(toFile, dsel, null);
    }

    public void dumpTable(File toFile, DBSelect<gDBR> dsel, String[] fldn) throws DBException {
        if (toFile == null) {
            throw new DBException("'To' file not specified");
        }
        PrintWriter dumpOutStream = null;
        boolean closeStream = true;
        try {
            String fn = toFile.getName();
            int outputFmt = 0;
            outputFmt = fn.endsWith(".csv") ? 0 : (fn.endsWith(_DUMP_EXT_XML) ? 2 : 1);
            if (fn.startsWith("stdout.")) {
                Print.logDebug("Output to STDOUT ...", new Object[0]);
                dumpOutStream = new PrintWriter(System.out, true);
                closeStream = false;
            } else if (fn.startsWith("stderr.")) {
                Print.logDebug("Output to STDERR ...", new Object[0]);
                dumpOutStream = new PrintWriter(System.err, true);
                closeStream = false;
            } else {
                Print.logDebug("Output to File: '%s' ...", toFile.toString());
                dumpOutStream = new PrintWriter(new FileOutputStream(toFile));
                closeStream = true;
            }
            this._dumpTable(dumpOutStream, dsel, fldn, outputFmt);
        }
        catch (IOException ioe) {
            throw new DBException("Dumping table", ioe);
        }
        finally {
            if (closeStream && dumpOutStream != null) {
                try {
                    dumpOutStream.close();
                }
                catch (Throwable th) {}
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void _dumpTable(PrintWriter dumpOutStream, DBSelect<gDBR> dsel, String[] fldn, int outFmt) throws DBException {
        Statement stmt;
        DBConnection dbc;
        block47: {
            if (dumpOutStream == null) {
                throw new DBException("Output stream not specified");
            }
            if (dsel == null) {
                dsel = new DBSelect(this);
            } else if (!this.equals(dsel.getFactory())) {
                throw new DBException("DBSelect factory does not match this factory");
            }
            dbc = null;
            stmt = null;
            ResultSet rs = null;
            DBField[] fields = this.getFields(fldn);
            try {
                int i;
                StringBuffer sbData = new StringBuffer();
                sbData.setLength(0);
                if (outFmt == 0) {
                    for (i = 0; i < fields.length; ++i) {
                        if (i > 0) {
                            sbData.append(",");
                        }
                        sbData.append("\"" + fields[i].getName() + "\"");
                    }
                    sbData.append("\n");
                } else if (outFmt == 2) {
                    sbData.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                    sbData.append("<Records");
                    sbData.append(" table=\"" + this.getUntranslatedTableName() + "\"");
                    sbData.append(">\n");
                } else if (outFmt == 1) {
                    sbData.append("# ");
                    for (i = 0; i < fields.length; ++i) {
                        if (i > 0) {
                            sbData.append(", ");
                        }
                        sbData.append(fields[i].getName());
                    }
                    sbData.append("\n");
                }
                dumpOutStream.write(sbData.toString());
                sbData.setLength(0);
                try {
                    dbc = DBConnection.getDefaultConnection();
                    stmt = dbc.execute(dsel.toString(), true);
                    rs = stmt.getResultSet();
                }
                catch (OutOfMemoryError oome) {
                    Print.logException("Out of memory", oome);
                    throw new DBException("Out of memeory", oome);
                }
                long recordCount = 0L;
                while (rs.next()) {
                    String v;
                    String n;
                    int i2;
                    ++recordCount;
                    sbData.setLength(0);
                    if (outFmt == 0) {
                        for (i2 = 0; i2 < fields.length; ++i2) {
                            if (i2 > 0) {
                                sbData.append(",");
                            }
                            n = fields[i2].getName();
                            Object r = fields[i2].getResultSetValue(rs);
                            v = r != null ? r.toString() : "";
                            sbData.append(fields[i2].getQValue(v));
                        }
                        sbData.append("\n");
                    } else if (outFmt == 2) {
                        int indent = 3;
                        String prefix = StringTools.replicateString(" ", indent);
                        sbData.append(prefix).append("<Record sequence=\"" + recordCount + "\">\n");
                        for (int i3 = 0; i3 < fields.length; ++i3) {
                            String value = DBFieldValues.toStringValue(fields[i3].getResultSetValue(rs));
                            DBFactory.writeXML_DBField(sbData, 2 * indent, fields[i3], false, value);
                        }
                        sbData.append(prefix).append("</Record>\n");
                    } else if (outFmt == 1) {
                        for (i2 = 0; i2 < fields.length; ++i2) {
                            if (i2 > 0) {
                                sbData.append(", ");
                            }
                            n = fields[i2].getName();
                            Object r = fields[i2].getResultSetValue(rs);
                            v = r != null ? r.toString() : "";
                            sbData.append(fields[i2].getQValue(v));
                        }
                        sbData.append("\n");
                    }
                    dumpOutStream.write(sbData.toString());
                }
                sbData.setLength(0);
                if (outFmt != 0) {
                    if (outFmt == 2) {
                        sbData.append("</Records>\n");
                    } else if (outFmt == 1) {
                        // empty if block
                    }
                }
                dumpOutStream.write(sbData.toString());
                dumpOutStream.flush();
                if (rs == null) break block47;
            }
            catch (DBException dbe) {
                try {
                    throw dbe;
                    catch (SQLException sqe) {
                        throw new DBException("Dumping table", sqe);
                    }
                    catch (Throwable th) {
                        throw new DBException("Dumping table", th);
                    }
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sqe) {
                            // empty catch block
                        }
                    }
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException sqe) {
                            // empty catch block
                        }
                    }
                    DBConnection.release(dbc);
                    throw throwable;
                }
            }
            try {
                rs.close();
            }
            catch (SQLException sqe) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (SQLException sqe) {
                // empty catch block
            }
        }
        DBConnection.release(dbc);
    }

    public long loadTable(File fromFile) throws DBException {
        return this.loadTable(fromFile, null, true, true);
    }

    public long loadTable(File fromFile, boolean insertRecords, boolean overwriteExisting) throws DBException {
        return this.loadTable(fromFile, null, insertRecords, overwriteExisting);
    }

    public long loadTable(File fromFile, InsertionValidator validator, boolean insertRecords, boolean overwriteExisting) throws DBException {
        if (fromFile == null) {
            throw new DBException("'From' file not specified");
        }
        String fn = fromFile.getName();
        if (fn.endsWith(".csv")) {
            return this._loadTableCSV(fromFile, validator, insertRecords, overwriteExisting);
        }
        if (fn.endsWith(_LOAD_EXT_DUMP)) {
            return this._loadTable(null, fromFile, validator, insertRecords, overwriteExisting);
        }
        if (fn.endsWith(".sql")) {
            File sqlFile = fromFile;
            String[] fields = this.readSQLDumpColumns(sqlFile);
            File txtFile = new File(FileTools.removeExtension(fromFile.getPath()) + ".txt");
            return this._loadTable(fields, txtFile, validator, insertRecords, overwriteExisting);
        }
        if (fn.endsWith(".txt")) {
            File sqlFile = new File(FileTools.removeExtension(fromFile.getPath()) + ".sql");
            String[] fields = this.readSQLDumpColumns(sqlFile);
            File txtFile = fromFile;
            return this._loadTable(fields, txtFile, validator, insertRecords, overwriteExisting);
        }
        throw new DBException("Unrecognized file extension '" + fromFile + "'");
    }

    protected long _loadTable(String[] oldFieldNames, File fromFile, InsertionValidator validator, boolean insertRecords, boolean overwriteExisting) throws DBException {
        MySQLDumpReader fr = null;
        long recordCount = 0L;
        try {
            String r;
            fr = new MySQLDumpReader(fromFile);
            if (ListTools.isEmpty(oldFieldNames)) {
                String firstLine = fr.readLineString();
                if (firstLine.startsWith("#")) {
                    oldFieldNames = StringTools.parseArray(firstLine.substring(1).trim());
                } else {
                    Print.logError("Unable to determine column mapping definitions", new Object[0]);
                    throw new DBException("Missing column definitions, unable to load file");
                }
            }
            for (int i = 0; i < oldFieldNames.length; ++i) {
                DBField field = this.getField(oldFieldNames[i]);
                if (field == null) {
                    Print.logInfo("Column : " + oldFieldNames[i] + "  - will be dropped", new Object[0]);
                    continue;
                }
                Print.logInfo("Column : " + oldFieldNames[i], new Object[0]);
            }
            if (validator != null && !validator.setFields(oldFieldNames)) {
                throw new DBException("Load fields rejected by insertion validator");
            }
            int rowNumber = 2;
            while ((r = fr.readLineString()) != null) {
                if (r != null && !r.startsWith("#")) {
                    String[] rowValues = StringTools.parseArray(r);
                    if (rowValues.length != oldFieldNames.length) {
                        Print.logError("Fields - #found != #expected: " + rowValues.length + " != " + oldFieldNames.length + " [row " + rowNumber + "]", new Object[0]);
                        Print.logError("Row: " + r, new Object[0]);
                    } else if ((validator == null || validator.validate(rowValues)) && this._loadInsertRecord(oldFieldNames, rowValues, insertRecords, overwriteExisting)) {
                        ++recordCount;
                    }
                }
                ++rowNumber;
            }
        }
        catch (SQLException sqe) {
            throw new DBException("SQL error", sqe);
        }
        catch (IOException ioe) {
            throw new DBException("Parsing error", ioe);
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (Throwable t) {}
            }
        }
        return recordCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] readSQLDumpColumns(File tableSQLFile) throws DBException {
        if (!tableSQLFile.exists() || tableSQLFile.isDirectory()) {
            return null;
        }
        Vector<String> clist = new Vector<String>();
        BufferedReader fr = null;
        boolean createFound = false;
        try {
            String r;
            fr = new BufferedReader(new FileReader(tableSQLFile));
            while ((r = fr.readLine()) != null) {
                String cnam;
                if ((r = r.trim()).length() == 0 || r.startsWith("/") || r.startsWith("-")) continue;
                if (!createFound) {
                    if (!r.toUpperCase().startsWith("CREATE")) continue;
                    createFound = true;
                    continue;
                }
                if (r.startsWith(")")) {
                    break;
                }
                String rup = r.toUpperCase();
                if (rup.startsWith("PRIMARY") || rup.startsWith("UNIQUE") || rup.startsWith("KEY")) continue;
                String c = r;
                int s = c.startsWith("`") ? 1 : 0;
                int p = c.indexOf(" ");
                if (p > s + 1 && c.charAt(p - 1) == '`') {
                    --p;
                }
                if ((cnam = p > s ? c.substring(s, p) : "").equals("")) continue;
                clist.add(cnam);
            }
        }
        catch (IOException ioe) {
            Print.logStackTrace("Parsing error", ioe);
            String[] stringArray = null;
            return stringArray;
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (Throwable t) {}
            }
        }
        return clist.toArray(new String[clist.size()]);
    }

    protected long _loadTableCSV(File fromFile, InsertionValidator validator, boolean insertRecords, boolean overwriteExisting) throws DBException {
        FileInputStream fis = null;
        long recordCount = 0L;
        try {
            try {
                fis = new FileInputStream(fromFile);
            }
            catch (IOException ioe) {
                throw new DBException("Unable to open CSV file", ioe);
            }
            String[] oldFieldNames = null;
            try {
                String header = FileTools.readLine(fis);
                oldFieldNames = StringTools.parseArray(header);
                if (ListTools.isEmpty(oldFieldNames)) {
                    throw new DBException("Unable to parse field names");
                }
            }
            catch (EOFException eofe) {
                throw new DBException("Premature EOF");
            }
            for (int i = 0; i < oldFieldNames.length; ++i) {
                DBField field = this.getField(oldFieldNames[i]);
                if (field == null) {
                    Print.logInfo("Column : " + oldFieldNames[i] + "  - will be dropped", new Object[0]);
                    continue;
                }
                Print.logInfo("Column : " + oldFieldNames[i], new Object[0]);
            }
            if (validator != null && !validator.setFields(oldFieldNames)) {
                throw new DBException("Load fields rejected by insertion validator");
            }
            int rowNumber = 2;
            while (true) {
                block25: {
                    String[] rowValues;
                    block26: {
                        rowValues = null;
                        try {
                            String line = FileTools.readLine(fis).trim();
                            if (line.equals("")) break block25;
                            rowValues = StringTools.parseArray(line);
                            if (rowValues.length == oldFieldNames.length) break block26;
                            Print.logError("Fields - #found != #expected: " + rowValues.length + " != " + oldFieldNames.length + " [row " + rowNumber + "]", new Object[0]);
                            Print.logError("Row: " + line, new Object[0]);
                            break block25;
                        }
                        catch (EOFException eofe) {
                            break;
                        }
                    }
                    if ((validator == null || validator.validate(rowValues)) && this._loadInsertRecord(oldFieldNames, rowValues, insertRecords, overwriteExisting)) {
                        ++recordCount;
                    }
                }
                ++rowNumber;
            }
        }
        catch (DBException dbe) {
            throw dbe;
        }
        catch (SQLException sqe) {
            throw new DBException("SQL error", sqe);
        }
        catch (IOException ioe) {
            throw new DBException("Parsing error", ioe);
        }
        catch (Throwable th) {
            throw new DBException("Critical error", th);
        }
        finally {
            if (fis != null) {
                try {
                    ((InputStream)fis).close();
                }
                catch (Throwable t) {}
            }
        }
        return recordCount;
    }

    private boolean _loadInsertRecord(String[] oldFieldNames, String[] rowValues, boolean insertRecord, boolean overwriteExisting) throws DBException, SQLException, IOException {
        DBRecordKey<gDBR> dbRcdKey = this.createKey();
        DBFieldValues dbKeyVals = dbRcdKey.getKeyValues();
        DBFieldValues dbFldVals = dbRcdKey.getFieldValues();
        gDBR dbRcd = dbRcdKey.getDBRecord();
        boolean addedField = false;
        HashSet<String> fieldNameList = new HashSet<String>();
        for (int i = 0; i < oldFieldNames.length; ++i) {
            String rowVal;
            Object objVal;
            String fieldName = oldFieldNames[i];
            DBField dbFld = this.getField(fieldName);
            if (dbFld == null) continue;
            boolean priKey = dbFld.isPrimaryKey();
            DBFieldValues dbVals = priKey ? dbKeyVals : dbFldVals;
            boolean didSet = dbVals._setFieldValue(dbFld, objVal = dbFld.parseStringValue(rowVal = i < rowValues.length && !rowValues[i].equals("\\N") ? rowValues[i] : null));
            if (!didSet) {
                Print.logError("Invalid field type: %s [%s]", fieldName, StringTools.className(objVal));
            } else if (!priKey) {
                fieldNameList.add(fieldName);
            }
            addedField = true;
        }
        if (!insertRecord) {
            return false;
        }
        if (dbRcdKey.exists()) {
            if (!overwriteExisting) {
                return false;
            }
            if (fieldNameList.isEmpty()) {
                throw new DBException("No fields to update");
            }
            fieldNameList.remove("creationTime");
            fieldNameList.remove("creationMillis");
            ((DBRecord)dbRcd).update(fieldNameList);
        } else {
            ((DBRecord)dbRcd).insert();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _old_loadInsertRecord(String[] oldFieldNames, String[] rowValues, boolean insertRecord, boolean overwriteExisting) throws DBException, SQLException, IOException {
        block24: {
            String xtableName = this.getTranslatedTableName();
            DBRecordKey<gDBR> rcdKey = this.createKey();
            Object[] fieldValues = new Object[oldFieldNames.length];
            for (int i = 0; i < oldFieldNames.length; ++i) {
                String fieldName = oldFieldNames[i];
                DBField field = this.getField(fieldName);
                if (field != null) {
                    Object objVal;
                    String rowVal = i < rowValues.length && !rowValues[i].equals("\\N") ? rowValues[i] : null;
                    fieldValues[i] = objVal = field.parseStringValue(rowVal);
                    if (!field.isPrimaryKey() || rcdKey.setKeyValue(fieldName, objVal)) continue;
                    Print.logError("Couldn't find Key fieldName: " + fieldName, new Object[0]);
                    continue;
                }
                fieldValues[i] = null;
            }
            if (!insertRecord) {
                return false;
            }
            boolean recordExists = rcdKey.exists();
            if (recordExists && !overwriteExisting) {
                return false;
            }
            boolean addedField = false;
            StringBuffer sbSql = new StringBuffer();
            if (recordExists) {
                sbSql.append("UPDATE ").append(this.getTranslatedTableName());
                sbSql.append(" SET ");
                for (int i = 0; i < oldFieldNames.length; ++i) {
                    String fieldName = oldFieldNames[i];
                    DBField field = this.getField(fieldName);
                    if (field == null || field.isPrimaryKey()) continue;
                    if (addedField) {
                        sbSql.append(",");
                    }
                    sbSql.append(DBProvider.getProvider().quoteColumnName(fieldName));
                    sbSql.append("=").append(field.getQValue(fieldValues[i]));
                    addedField = true;
                }
                sbSql.append(" ").append(rcdKey.getWhereClause(DBWhere.KEY_FULL));
            } else {
                StringBuffer colSB = new StringBuffer();
                StringBuffer valSB = new StringBuffer();
                for (int i = 0; i < oldFieldNames.length; ++i) {
                    String fieldName = oldFieldNames[i];
                    DBField field = this.getField(fieldName);
                    if (field == null) continue;
                    if (addedField) {
                        colSB.append(",");
                        valSB.append(",");
                    }
                    colSB.append(DBProvider.getProvider().quoteColumnName(fieldName));
                    valSB.append(field.getQValue(fieldValues[i]));
                    addedField = true;
                }
                sbSql.append("INSERT INTO ").append(xtableName);
                sbSql.append(" (").append(colSB).append(")");
                sbSql.append(" VALUES (").append(valSB).append(")");
            }
            if (!addedField) {
                throw new DBException("No fields in dump file match fields in current table");
            }
            DBConnection dbc = null;
            Statement stmt = null;
            try {
                dbc = DBConnection.getDefaultConnection();
                stmt = dbc.execute(sbSql.toString());
            }
            catch (SQLException sqe) {
                if (sqe.getErrorCode() == 1062) {
                    Print.logInfo("Duplicate Key Skipped: " + rcdKey, new Object[0]);
                    break block24;
                }
                throw sqe;
            }
            finally {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException sqe) {}
                }
                DBConnection.release(dbc);
            }
        }
        return true;
    }

    public void addParentTable(String utableName) {
        if (utableName != null && !this.parentTables.contains(utableName)) {
            this.parentTables.add(utableName);
        }
    }

    public List<String> getParentTables() {
        return this.parentTables;
    }

    public boolean hasParentTable(String utableName) {
        return this.parentTables.contains(utableName);
    }

    public DBFactory<? extends DBRecord>[] getChildFactories() {
        if (this.childFactories == null) {
            this.childFactories = DBAdmin.getChildTableFactories(this);
        }
        return this.childFactories;
    }

    public String getIndexType() {
        if (this.indexType == null) {
            try {
                this.getMySQLTableStatus();
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (this.indexType == null) {
                this._setIndexType("?");
            }
        }
        return this.indexType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _setIndexType(String ndxType) {
        if (this.indexType == null) {
            Object object = this.indexTypeLock;
            synchronized (object) {
                if (this.indexType == null) {
                    this.indexType = ndxType;
                }
            }
        }
    }

    public boolean isMySQLInnoDB() {
        if (DBProvider.getProvider().getID() != 1) {
            return false;
        }
        return this.getIndexType().equalsIgnoreCase("InnoDB");
    }

    public boolean supportsEfficientCount() {
        return !this.isMySQLInnoDB();
    }

    public boolean getAllowInnoDBCOUNT() {
        return this.allowInnoDBCOUNT;
    }

    public void setAllowInnoDBCOUNT(boolean countOK) {
        this.allowInnoDBCOUNT = countOK;
    }

    public long getRecordCount(String where, boolean actualCount) throws DBException {
        if (where == null) {
            return -1L;
        }
        if (!StringTools.isBlank(where)) {
            return DBRecord.getRecordCount(new DBSelect(this, where));
        }
        if (actualCount) {
            return DBRecord.getRecordCount(new DBSelect(this, ""));
        }
        return this.getMySQLTableStatus();
    }

    public long getRecordCount(DBWhere where, boolean actualCount) throws DBException {
        if (where == null) {
            return -1L;
        }
        if (actualCount) {
            return DBRecord.getRecordCount(new DBSelect(this, where));
        }
        return this.getMySQLTableStatus();
    }

    public StringBuffer toXML(StringBuffer sb, int indent) {
        return this.toXML(sb, indent, false);
    }

    public StringBuffer toXML(StringBuffer sb, int indent, boolean soapXML) {
        if (sb == null) {
            sb = new StringBuffer();
        }
        String PFX1 = XMLTools.PREFIX(soapXML, indent);
        String PFX2 = XMLTools.PREFIX(soapXML, 2 * indent);
        String utableName = this.getUntranslatedTableName();
        sb.append(PFX1);
        sb.append(XMLTools.startTAG(soapXML, TAG_TableSchema, XMLTools.ATTR(ATTR_table, utableName), false, true));
        sb.append(PFX2);
        sb.append(XMLTools.startTAG(soapXML, TAG_Description, "", false, false));
        sb.append(XMLTools.CDATA(soapXML, this.getDescription(null)));
        sb.append(XMLTools.endTAG(soapXML, TAG_Description, true));
        DBField[] fld = this.getFields();
        for (int i = 0; i < fld.length; ++i) {
            DBFactory.writeXML_DBField(sb, 2 * indent, fld[i], true, null, soapXML);
        }
        sb.append(PFX1);
        sb.append(XMLTools.endTAG(soapXML, TAG_TableSchema, true));
        return sb;
    }

    public String toString() {
        return this.getUntranslatedTableName();
    }

    public boolean equals(Object other) {
        if (other instanceof DBFactory) {
            return this.toString().equals(other.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.getUntranslatedTableName().hashCode();
    }

    public void setRecordListener(DBRecordListener<gDBR> rcdListener) {
        this.recordListener = rcdListener;
    }

    public DBRecordListener<gDBR> getRecordListener() {
        return this.recordListener;
    }

    @Override
    public void recordWillInsert(gDBR rcd) {
        if (this.recordListener != null) {
            this.recordListener.recordWillInsert(rcd);
        }
    }

    @Override
    public void recordDidInsert(gDBR rcd) {
        if (this.recordListener != null) {
            this.recordListener.recordDidInsert(rcd);
        }
    }

    @Override
    public void recordWillUpdate(gDBR rcd) {
        if (this.recordListener != null) {
            this.recordListener.recordWillUpdate(rcd);
        }
    }

    @Override
    public void recordDidUpdate(gDBR rcd) {
        if (this.recordListener != null) {
            this.recordListener.recordDidUpdate(rcd);
        }
    }

    protected static String _beanMethodName(String prefix, String fieldName) {
        StringBuffer sb = new StringBuffer(prefix);
        sb.append(fieldName.substring(0, 1).toUpperCase());
        sb.append(fieldName.substring(1));
        return sb.toString();
    }

    protected static String _methodScope(int mods) {
        if ((mods & 1) == 1) {
            return "public";
        }
        if ((mods & 4) == 1) {
            return "protected";
        }
        if ((mods & 2) == 1) {
            return "private";
        }
        return "package";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List validateFieldBeanMethods(DBField field) {
        Class<gDBR> tableClass = this.getRecordClass();
        String fldName = field.getName();
        Class typeClass = field.getTypeClass();
        boolean ok = true;
        Vector<String> errMsg = new Vector<String>();
        String getMethN = DBFactory._beanMethodName("get", fldName);
        Method getMethod = null;
        for (Class<gDBR> target = tableClass; target != null; target = target.getSuperclass()) {
            try {
                getMethod = target.getDeclaredMethod(getMethN, new Class[0]);
                break;
            }
            catch (NoSuchMethodException nsme) {
                continue;
            }
        }
        if (getMethod != null) {
            int mods;
            Class<?> rtnClass = getMethod.getReturnType();
            if (!rtnClass.equals(typeClass)) {
                errMsg.add("Invalid getter return type: " + rtnClass.getName() + " [expected " + StringTools.className(typeClass) + "]");
                ok = false;
            }
            if (((mods = getMethod.getModifiers()) & 1) != 0) {
                // empty if block
            }
        } else {
            errMsg.add("Getter not found");
            ok = false;
        }
        boolean setFound = false;
        String setMethN = DBFactory._beanMethodName("set", fldName);
        Method setMethod = null;
        for (Class<gDBR> target = tableClass; target != null; target = target.getSuperclass()) {
            try {
                setMethod = target.getDeclaredMethod(setMethN, typeClass);
                break;
            }
            catch (NoSuchMethodException nsme) {
                continue;
            }
        }
        if (setMethod != null) {
            int mods;
            Class<?> rtnClass = setMethod.getReturnType();
            if (!rtnClass.equals(Void.TYPE)) {
                errMsg.add("Invalid setter return type: " + rtnClass.getName() + " [expected void]");
                ok = false;
            }
            if (((mods = setMethod.getModifiers()) & 1) != 0) {
                // empty if block
            }
        } else {
            errMsg.add("Setter not found");
            ok = false;
        }
        if (ok) {
            return null;
        }
        Vector<String> vector = errMsg;
        return vector;
    }

    public void validateTableBeanMethods() {
        String utableName = this.getUntranslatedTableName();
        Class<gDBR> tableClass = this.getRecordClass();
        DBField[] field = this.getFields();
        Print.logInfo("", new Object[0]);
        Print.logInfo("Validating bean access methods for table: " + utableName, new Object[0]);
        for (int i = 0; i < field.length; ++i) {
            String fieldName = field[i].getName();
            String className = StringTools.className(field[i].getTypeClass());
            Print.logInfo("  Field: " + fieldName + " (type=" + className + ")", new Object[0]);
            List errMsg = this.validateFieldBeanMethods(field[i]);
            if (errMsg == null || errMsg.isEmpty()) {
                Print.logInfo("    OK", new Object[0]);
                continue;
            }
            Iterator e = errMsg.iterator();
            while (e.hasNext()) {
                Print.logInfo("    " + e.next(), new Object[0]);
            }
        }
        Print.logInfo("", new Object[0]);
    }

    public static StringBuffer writeXML_DBFields(StringBuffer sb, int indent, DBField[] fld, DBFieldValues fldVals) {
        return DBFactory.writeXML_DBFields(sb, indent, fld, fldVals, false);
    }

    public static StringBuffer writeXML_DBFields(StringBuffer sb, int indent, DBField[] fld, DBFieldValues fldVals, boolean soapXML) {
        for (int i = 0; i < fld.length; ++i) {
            String name = fld[i].getName();
            String value = fldVals != null ? fldVals.getFieldValueAsString(name) : null;
            DBFactory.writeXML_DBField(sb, indent, fld[i], false, value, soapXML);
        }
        return sb;
    }

    public static StringBuffer writeXML_DBField(StringBuffer sb, int indent, DBField fld, boolean inclInfo, String value) {
        return DBFactory.writeXML_DBField(sb, indent, fld, inclInfo, value, false);
    }

    public static StringBuffer writeXML_DBField(StringBuffer sb, int indent, DBField fld, boolean inclInfo, String value, boolean soapXML) {
        sb.append(XMLTools.PREFIX(soapXML, indent));
        sb.append(XMLTools.startTAG(soapXML, TAG_Field, XMLTools.ATTR(ATTR_name, fld.getName()) + (fld.isPrimaryKey() ? XMLTools.ATTR(ATTR_primaryKey, "true") : "") + (fld.isAlternateKey() ? XMLTools.ATTR(ATTR_alternateKeys, StringTools.join(fld.getAlternateIndexes(), ',')) : "") + (inclInfo ? XMLTools.ATTR(ATTR_type, fld.getDataType()) + XMLTools.ATTR(ATTR_title, fld.getTitle(null)) : ""), value == null, value == null));
        if (value != null) {
            if (fld.isBoolean()) {
                sb.append(StringTools.parseBoolean(value, false));
            } else if (fld.isNumeric()) {
                sb.append(value);
            } else if (fld.isBinary()) {
                sb.append(value);
            } else if (!StringTools.isBlank(value)) {
                sb.append(XMLTools.CDATA(soapXML, value));
            }
            sb.append(XMLTools.endTAG(soapXML, TAG_Field, true));
        }
        return sb;
    }

    public static DBFactory parseXML_DBFactory(Element node, String ... nodeNames) throws DBException {
        String name;
        if (node == null) {
            throw new DBException("Node tag element is null");
        }
        if (!ListTools.isEmpty(nodeNames) && !ListTools.containsIgnoreCase(nodeNames, name = node.getTagName())) {
            throw new DBException("Invalid Node name: " + name);
        }
        String utableName = XMLTools.getAttribute(node, ATTR_table, null, false);
        if (StringTools.isBlank(utableName)) {
            throw new DBException("Table name is blank");
        }
        DBFactory tableFact = DBFactory.getFactoryByName(utableName);
        if (tableFact == null) {
            throw new DBException("Table name not found: " + utableName);
        }
        return tableFact;
    }

    public static Map<String, String> parseXML_FieldValueMap(Element node, DBFactory tableFact) throws DBException {
        if (node == null) {
            throw new DBException("Node tag element is null");
        }
        OrderedMap<String, String> valueMap = new OrderedMap<String, String>();
        NodeList fieldList = XMLTools.getChildElements(node, TAG_Field);
        for (int f = 0; f < fieldList.getLength(); ++f) {
            Element field = (Element)fieldList.item(f);
            String name = XMLTools.getAttribute(field, ATTR_name, null, false);
            if (StringTools.isBlank(name)) {
                Print.logWarn("Specified field name is null/blank", new Object[0]);
                continue;
            }
            if (!tableFact.hasField(name)) {
                Print.logWarn("Field does not exist in DBFactory: " + name, new Object[0]);
                continue;
            }
            String type = XMLTools.getAttribute(field, ATTR_type, null, false);
            String priKey = XMLTools.getAttribute(field, ATTR_primaryKey, null, false);
            String altKeys = XMLTools.getAttribute(field, ATTR_alternateKeys, null, false);
            String value = XMLTools.getNodeText(field, "\\n", false, "");
            valueMap.put(name, value);
        }
        return valueMap;
    }

    public static DBRecordKey<?> parseXML_DBRecordKey(Element rcdTag) throws DBException {
        DBFactory tableFact = DBFactory.parseXML_DBFactory(rcdTag, TAG_Record, TAG_RecordKey);
        boolean isRecordKey = rcdTag.getTagName().equalsIgnoreCase(TAG_RecordKey);
        int keyType = DBWhere.KEY_FULL;
        String partialKey = XMLTools.getAttribute(rcdTag, ATTR_partial, null, false);
        if (StringTools.isBlank(partialKey) || partialKey.equalsIgnoreCase("full")) {
            keyType = DBWhere.KEY_FULL;
        } else if (partialKey.equalsIgnoreCase("first")) {
            keyType = DBWhere.KEY_PARTIAL_FIRST;
        } else if (partialKey.equalsIgnoreCase("true") || partialKey.equalsIgnoreCase("all")) {
            keyType = DBWhere.KEY_PARTIAL_ALL_EMPTY;
        } else if (partialKey.equalsIgnoreCase("auto") || partialKey.equalsIgnoreCase("autoIndex")) {
            keyType = DBWhere.KEY_AUTO_INDEX;
        } else {
            Print.logWarn("Unrecognized 'partial' attribute value: %s", partialKey);
            keyType = DBWhere.KEY_FULL;
        }
        Map<String, String> valueMap = DBFactory.parseXML_FieldValueMap(rcdTag, tableFact);
        DBRecordKey rcdKey = null;
        rcdKey = tableFact.createKey(valueMap, keyType);
        HashSet<String> dataFlds = null;
        for (String fldName : valueMap.keySet()) {
            DBField fld = tableFact.getField(fldName);
            if (fld == null || fld.isPrimaryKey()) continue;
            if (dataFlds == null) {
                dataFlds = new HashSet<String>();
            }
            dataFlds.add(fldName);
        }
        rcdKey.setTaggedFieldNames(dataFlds);
        return rcdKey;
    }

    public static DBRecord<?> parseXML_DBRecord(Element rcdTag) throws DBException {
        DBFactory tableFact = DBFactory.parseXML_DBFactory(rcdTag, TAG_Record);
        Map<String, String> valueMap = DBFactory.parseXML_FieldValueMap(rcdTag, tableFact);
        return tableFact.createRecord(valueMap);
    }

    public static interface InsertionValidator {
        public boolean setFields(String[] var1) throws DBException;

        public boolean validate(String[] var1) throws DBException;
    }

    protected static class MySQLDumpReader {
        private int pushedByte = -1;
        private FileInputStream fis = null;

        public MySQLDumpReader(File file) throws IOException {
            this.fis = new FileInputStream(file);
        }

        public String readLineString() throws IOException {
            byte[] buff = this.readLineBytes();
            if (buff != null) {
                String line = StringTools.toStringValue(buff);
                return line;
            }
            return null;
        }

        public byte[] readLineBytes() throws IOException {
            byte[] buff = new byte[10240];
            int len = 0;
            boolean quoted = false;
            boolean eof = false;
            while (len < buff.length) {
                int ch = this.read();
                if (ch < 0) {
                    eof = true;
                    break;
                }
                if (ch == 34) {
                    quoted = !quoted;
                    buff[len++] = 34;
                    continue;
                }
                if (ch == 92) {
                    buff[len++] = 92;
                    ch = this.read();
                    if (ch < 0) break;
                    buff[len++] = (byte)ch;
                    continue;
                }
                if (quoted) {
                    buff[len++] = (byte)ch;
                    continue;
                }
                if (ch == 13) {
                    ch = this.read();
                    if (ch < 0 || ch == 10) break;
                    this.pushedByte = ch & 0xFF;
                    break;
                }
                if (ch == 10) break;
                buff[len++] = (byte)ch;
            }
            if (!eof || len > 0) {
                byte[] line = new byte[len];
                System.arraycopy(buff, 0, line, 0, len);
                return line;
            }
            return null;
        }

        private int read() throws IOException {
            int b = -1;
            if (this.pushedByte >= 0) {
                b = (byte)this.pushedByte;
                this.pushedByte = -1;
            } else {
                b = this.fis.read();
            }
            return b == -1 ? -1 : b & 0xFF;
        }

        public void close() throws IOException {
            this.fis.close();
        }
    }

    public static class ValidationNotImplementedException
    extends Exception {
        public ValidationNotImplementedException(String msg) {
            super(msg);
        }
    }

    public static class ValidationLog {
        private String utableName = "";
        private boolean inclWarn = true;
        private StringBuffer out = null;
        private String header = "";
        private int hasErrors = 0;

        public ValidationLog(String utableName, boolean inclWarn) {
            this.utableName = utableName != null ? utableName : "";
            this.inclWarn = inclWarn;
            this.out = new StringBuffer();
            this.header = "";
            this.hasErrors = 0;
        }

        public void clear() {
            this.out.setLength(0);
            this.header = "";
            this.hasErrors = 0;
        }

        public void logHeader(String header) {
            this.header = header != null ? header : "";
        }

        public boolean hasHeader() {
            return !StringTools.isBlank(this.header);
        }

        public void logInfo(String msg) {
            this.out.append("\n  [INFO] " + msg);
        }

        public void logWarn(String msg) {
            if (this.inclWarn) {
                this.out.append("\n  [WARN] " + msg);
                ++this.hasErrors;
            }
        }

        public void logSevere(String msg) {
            this.out.append("\n  [SEVERE] " + msg);
            ++this.hasErrors;
        }

        public boolean hasErrors() {
            return this.hasErrors > 0;
        }

        public String toString() {
            return this.header + this.out.toString();
        }
    }

    public static interface CustomFactoryHandler {
        public <T extends DBRecord<T>> DBFactory<T> createDBFactory(String var1, DBField[] var2, KeyType var3, Class<T> var4, Class<? extends DBRecordKey<T>> var5, boolean var6, boolean var7);

        public List<DBField> selectFields(DBFactory var1, List<DBField> var2);
    }

    public static enum KeyType {
        PRIMARY,
        UNIQUE,
        INDEX,
        UNIQUE_INDEX;

    }
}

