/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.dbtools;

import java.sql.SQLException;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class DBException
extends Exception {
    private static String CreateDBxceptionMessage(String msg, Throwable cause) {
        int errCode;
        if (cause instanceof SQLException && (errCode = ((SQLException)cause).getErrorCode()) > 0) {
            return msg + " [SQLErr=" + errCode + "]";
        }
        return msg;
    }

    public DBException(String msg) {
        super(msg);
    }

    public DBException(String msg, Throwable cause) {
        super(DBException.CreateDBxceptionMessage(msg, cause), cause);
    }

    public boolean isSQLException() {
        return this.getCause() instanceof SQLException;
    }

    public boolean isCauseCommunicationsException() {
        return DBException.isCommunicationsException(this.getCause());
    }

    public static boolean isCommunicationsException(Throwable th) {
        if (th == null) {
            return false;
        }
        String cn = StringTools.className(th);
        String msg = th.getMessage().toLowerCase();
        return cn.indexOf("CommunicationsException") >= 0 || msg.indexOf("CommunicationsException") >= 0 || msg.indexOf("communications link failure") >= 0;
    }

    public boolean isOutOfMemoryError() {
        return this.getCause() instanceof OutOfMemoryError;
    }

    public void printException() {
        Throwable cause = this.getCause();
        if (cause instanceof SQLException) {
            Print.logSQLError(1, this.getMessage(), (SQLException)cause);
        } else {
            Print.logException(this.getMessage(), this);
        }
    }

    @Override
    public String toString() {
        Throwable cause = this.getCause();
        if (cause != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(super.toString());
            sb.append(" [").append(cause.toString()).append("]");
            return sb.toString();
        }
        return super.toString();
    }
}

