/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.dbtools;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.Vector;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBFieldType;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordKey;
import org.opengts.util.DateTime;
import org.opengts.util.DayNumber;
import org.opengts.util.EnumTools;
import org.opengts.util.FileTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class DBEdit {
    private static final String LINE_SEPARATOR = "-----------------------------------------";
    private static final int EDIT_MODE = 1;
    private DBRecordKey recordKey = null;
    private DBField[] editableFields = null;

    public DBEdit(DBRecordKey key) {
        this.recordKey = key;
        this.recordKey.getDBRecord(true);
    }

    public DBEdit(DBRecord rcd) {
        this(rcd.getRecordKey());
    }

    private DBField[] getAllFields() {
        return this.recordKey.getFields();
    }

    private DBField[] getEditableFields() {
        if (this.editableFields == null) {
            DBField[] fld = this.recordKey.getFields();
            Vector<DBField> fldList = new Vector<DBField>();
            for (int i = 0; i < fld.length; ++i) {
                if (!fld[i].isEditable(1)) continue;
                fldList.add(fld[i]);
            }
            this.editableFields = fldList.toArray(new DBField[fldList.size()]);
        }
        return this.editableFields;
    }

    public void print(boolean allFlds) {
        Print.sysPrintln("", new Object[0]);
        Print.sysPrintln(LINE_SEPARATOR, new Object[0]);
        Print.sysPrintln("Key: " + this.recordKey, new Object[0]);
        Print.sysPrintln(LINE_SEPARATOR, new Object[0]);
        DBField[] fld = allFlds ? this.getAllFields() : this.getEditableFields();
        Object dbRcd = this.recordKey.getDBRecord();
        for (int i = 0; i < fld.length; ++i) {
            boolean editable = fld[i].isEditable(1);
            boolean isPriKey = fld[i].isPrimaryKey();
            boolean isAltKey = fld[i].isAlternateKey();
            OrderedMap<String, Integer> enumMap = fld[i].getEnumValues();
            OrderedMap<String, Long> maskMap = fld[i].getMaskValues();
            String ndx = StringTools.rightJustify(String.valueOf(i), 2);
            String title = StringTools.leftJustify(fld[i].getTitle(null), 35);
            Object value = ((DBRecord)dbRcd).getValue(fld[i].getName());
            StringBuffer sb = new StringBuffer();
            sb.append(ndx);
            if (editable) {
                sb.append(") ");
            } else {
                sb.append("- ");
            }
            sb.append(title);
            if (isPriKey) {
                sb.append("[K]");
            } else if (isAltKey) {
                sb.append("[A]");
            } else {
                sb.append("   ");
            }
            if (editable) {
                sb.append(": ");
            } else {
                sb.append("- ");
            }
            if (value != null) {
                sb.append("\"").append(fld[i].formatValue(value)).append("\"");
                if (enumMap != null) {
                    int v = value instanceof Number ? ((Number)value).intValue() : -1;
                    int e = EnumTools.getValueOf(fld[i].getEnumClass(), v);
                    sb.append("  [").append(e.toString()).append("]");
                } else if (maskMap != null) {
                    long v = value instanceof Number ? ((Number)value).longValue() : 0L;
                    Enum[] m = EnumTools.getValuesForMask(fld[i].getMaskClass(), (long)v);
                    if (m != null) {
                        sb.append("  [");
                        for (int e = 0; e < m.length; ++e) {
                            if (e > 0) {
                                sb.append(",");
                            }
                            sb.append(m[e].toString());
                        }
                        sb.append("]");
                    }
                }
            } else {
                sb.append("null");
            }
            Print.sysPrintln(sb.toString(), new Object[0]);
        }
    }

    public boolean editField(DBField fld) throws IOException {
        Number v;
        String k;
        Iterator<String> e;
        StringBuffer sb;
        String name = fld.getName();
        Class type = fld.getTypeClass();
        OrderedMap<String, Integer> enumMap = fld.getEnumValues();
        OrderedMap<String, Long> maskMap = fld.getMaskValues();
        String extType = enumMap != null ? " [Enum]" : (maskMap != null ? " [BitMask]" : "");
        Print.sysPrintln("", new Object[0]);
        Print.sysPrintln(LINE_SEPARATOR, new Object[0]);
        Print.sysPrintln("Field: " + name, new Object[0]);
        Print.sysPrintln("Title: " + fld.getTitle(null), new Object[0]);
        Print.sysPrintln("Type : " + type + extType, new Object[0]);
        if (enumMap != null) {
            sb = new StringBuffer();
            e = enumMap.keyIterator();
            while (e.hasNext()) {
                k = e.next();
                v = enumMap.get(k);
                sb.append(v).append("=").append(k);
                if (!e.hasNext()) continue;
                sb.append(", ");
            }
            Print.sysPrintln("Enum : " + sb, new Object[0]);
        } else if (maskMap != null) {
            sb = new StringBuffer();
            e = maskMap.keyIterator();
            while (e.hasNext()) {
                k = e.next();
                v = maskMap.get(k);
                sb.append(fld.formatValue(v)).append("=").append(k);
                if (!e.hasNext()) continue;
                sb.append(", ");
            }
            Print.sysPrintln("Mask : " + sb, new Object[0]);
        }
        Object dbRcd = this.recordKey.getDBRecord();
        Print.sysPrintln("Value: " + fld.formatValue(((DBRecord)dbRcd).getValue(name)), new Object[0]);
        if (!fld.isEditable(1)) {
            Print.sysPrintln("(Field is not editable)", new Object[0]);
            return false;
        }
        Object dbrcd = this.recordKey.getDBRecord();
        while (true) {
            Print.sysPrint("Enter new value: ", new Object[0]);
            String line = FileTools.readLine_stdin().trim();
            if (StringTools.isBlank(line)) {
                return false;
            }
            if (type == String.class) {
                String val = line.equals("\\") ? "" : line;
                ((DBRecord)dbrcd).setValue(name, val);
                return true;
            }
            if (type == Integer.class || type == Integer.TYPE) {
                int val = (int)StringTools.parseLong(line, Integer.MIN_VALUE);
                if (val != Integer.MIN_VALUE) {
                    ((DBRecord)dbrcd).setValue(name, val);
                    return true;
                }
            } else if (type == Long.class || type == Long.TYPE) {
                String fmt = StringTools.trim(fld.getFormat());
                if (fmt.equals("date") && line.indexOf("/") >= 0) {
                    try {
                        DateTime.ParsedDateTime pdt = DateTime.parseDateTime(line, null, DateTime.DefaultParsedTime.DayStart);
                        ((DBRecord)dbrcd).setValue(name, pdt.getDayNumber());
                        return true;
                    }
                    catch (DateTime.DateParseException dpe) {
                        Print.logError("Unable to parse date: " + line + " [" + dpe.getMessage() + "]", new Object[0]);
                        return false;
                    }
                }
                if (fmt.equals("time") && (line.indexOf("/") >= 0 || line.indexOf(":") >= 0)) {
                    try {
                        DateTime.ParsedDateTime pdt = DateTime.parseDateTime(line, null, DateTime.DefaultParsedTime.DayStart);
                        ((DBRecord)dbrcd).setValue(name, pdt.getEpochTime());
                        return true;
                    }
                    catch (DateTime.DateParseException dpe) {
                        Print.logError("Unable to parse date/time: " + line + " [" + dpe.getMessage() + "]", new Object[0]);
                        return false;
                    }
                }
                long val = StringTools.parseLong(line, Long.MIN_VALUE);
                if (val != Long.MIN_VALUE) {
                    ((DBRecord)dbrcd).setValue(name, val);
                    return true;
                }
            } else if (type == Float.class || type == Float.TYPE) {
                float val = (float)StringTools.parseDouble(line, (double)1.4E-45f);
                if (val != Float.MIN_VALUE) {
                    ((DBRecord)dbrcd).setValue(name, val);
                    return true;
                }
            } else if (type == Double.class || type == Double.TYPE) {
                double val = StringTools.parseDouble(line, Double.MIN_VALUE);
                if (val != Double.MIN_VALUE) {
                    ((DBRecord)dbrcd).setValue(name, val);
                    return true;
                }
            } else if (type == Boolean.class || type == Boolean.TYPE) {
                if (StringTools.isBoolean(line, true)) {
                    boolean val = StringTools.parseBoolean(line, false);
                    ((DBRecord)dbrcd).setValue(name, val);
                    return true;
                }
            } else {
                if (type == DateTime.class) {
                    try {
                        DateTime dt = DateTime.parseArgumentDate(line);
                        ((DBRecord)dbrcd).setValue(name, dt);
                        return true;
                    }
                    catch (DateTime.DateParseException dpe) {
                        Print.logError("Unable to parse date: " + line + " [" + dpe.getMessage() + "]", new Object[0]);
                        return false;
                    }
                }
                if (type == DayNumber.class) {
                    try {
                        DateTime.ParsedDateTime pdt = DateTime.parseDateTime(line, null, DateTime.DefaultParsedTime.DayStart);
                        ((DBRecord)dbrcd).setValue(name, pdt.getDayNumber());
                        return true;
                    }
                    catch (DateTime.DateParseException dpe) {
                        Print.logError("Unable to parse date: " + line + " [" + dpe.getMessage() + "]", new Object[0]);
                        return false;
                    }
                }
                if (DBFieldType.class.isAssignableFrom(type)) {
                    try {
                        Constructor typeConst = type.getConstructor(String.class);
                        Object val = typeConst.newInstance(line);
                        ((DBRecord)dbrcd).setValue(name, val);
                        return true;
                    }
                    catch (Throwable t) {
                        Print.logError("ERROR: Unable to parse this field type", new Object[0]);
                        return false;
                    }
                }
                Print.logError("ERROR: Unable to parse this field type", new Object[0]);
                return false;
            }
            Print.logError("Entered value is improper type", new Object[0]);
        }
    }

    public boolean edit() throws IOException {
        try {
            return this._edit(false);
        }
        catch (IOException ioe) {
            Print.sysPrintln("", new Object[0]);
            throw ioe;
        }
    }

    public boolean edit(boolean allFlds) throws IOException {
        try {
            return this._edit(allFlds);
        }
        catch (IOException ioe) {
            Print.sysPrintln("", new Object[0]);
            throw ioe;
        }
    }

    protected boolean _edit(boolean allFlds) throws IOException {
        Print.sysPrintln("", new Object[0]);
        Print.sysPrintln(LINE_SEPARATOR, new Object[0]);
        Print.sysPrintln("Editing table: " + this.recordKey.getUntranslatedTableName(), new Object[0]);
        Print.sysPrintln("Record Key   : " + this.recordKey, new Object[0]);
        Print.sysPrintln(LINE_SEPARATOR, new Object[0]);
        Print.sysPrintln("Commands:", new Object[0]);
        Print.sysPrintln("   ##   - Field number to edit", new Object[0]);
        Print.sysPrintln("   save - Save changes and exit", new Object[0]);
        Print.sysPrintln("   exit - Exit without saving changes", new Object[0]);
        DBField[] fld = allFlds ? this.getAllFields() : this.getEditableFields();
        while (true) {
            Print.sysPrintln("", new Object[0]);
            this.print(allFlds);
            Print.sysPrint("Enter field number [or 'save','exit']: ", new Object[0]);
            String line = FileTools.readLine_stdin().trim();
            if (StringTools.isBlank(line)) continue;
            if (line.equalsIgnoreCase("exit")) {
                Print.sysPrintln("\nExiting, record not saved", new Object[0]);
                Print.sysPrintln("", new Object[0]);
                return false;
            }
            if (line.equalsIgnoreCase("save")) {
                Object rcd = this.recordKey.getDBRecord();
                try {
                    ((DBRecord)rcd).save();
                    Print.sysPrintln("\nRecord saved", new Object[0]);
                    Print.sysPrintln("", new Object[0]);
                    return true;
                }
                catch (DBException dbe) {
                    Print.sysPrintln("\nERROR: Unable to save record!", new Object[0]);
                    dbe.printException();
                    Print.sysPrintln("", new Object[0]);
                    return false;
                }
            }
            long fldNdx = StringTools.parseLong(line, -1L);
            if (fldNdx < 0L || fldNdx >= (long)fld.length) continue;
            this.editField(fld[(int)fldNdx]);
        }
    }
}

