/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.dbtools;

import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBWhere;
import org.opengts.util.StringTools;

public class DBDelete {
    private DBFactory factory = null;
    private String utableName = null;
    private String where = null;

    public DBDelete(DBFactory fact) {
        this.factory = fact;
    }

    public boolean hasFactory() {
        return this.factory != null;
    }

    public DBFactory getFactory() {
        return this.factory;
    }

    public void setUntranslatedTableName(String utableName) {
        this.utableName = !StringTools.isBlank(utableName) ? utableName : null;
    }

    public String getUntranslatedTableName() {
        if (this.utableName != null) {
            return this.utableName;
        }
        if (this.hasFactory()) {
            return this.getFactory().getUntranslatedTableName();
        }
        return "UNKNOWN";
    }

    public String getTranslatedTableName() {
        return DBProvider.translateTableName(this.getUntranslatedTableName());
    }

    public DBWhere createDBWhere() {
        return new DBWhere(this.getFactory());
    }

    public void setWhere(String wh) {
        this.where = StringTools.isBlank(wh) ? null : (StringTools.startsWithIgnoreCase(wh = wh.trim(), "WHERE ") ? wh : "WHERE ( " + wh + " )");
    }

    public boolean hasWhere() {
        return this.where != null;
    }

    public String getWhere() {
        return this.where;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DELETE FROM ");
        sb.append(DBProvider.getProvider().quoteTableName(this.getTranslatedTableName()));
        if (this.hasWhere()) {
            sb.append(" ");
            sb.append(this.getWhere());
        }
        return sb.toString();
    }
}

