/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.dbtools;

import java.io.IOException;
import java.net.ConnectException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.sql.DataSource;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBProvider;
import org.opengts.util.DateTime;
import org.opengts.util.MethodAction;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;
import org.opengts.util.ThreadLocalMap;

public class DBConnection {
    private static final String USER_NONE = "none";
    private static boolean DefaultShowErrorSQL;
    private static boolean ShowErrorSQL;
    private static boolean DefaultShowExecutedSQL;
    private static boolean ShowExecutedSQL;
    private static int ShowExecutedSQL_level;
    private static boolean USE_DRIVER_MANAGER;
    private static boolean DBCONNECTION_POOL;
    public static boolean ALWAYS_NEW_CONNECTION;
    private static long INACTIVE_TIMEOUT;
    private static String LastSQLExecuted;
    private static DataSource DBDataSource;
    protected static Map<String, DBConnection> dbConnectionMap;
    protected static Map<String, ArrayList<DBConnection>> dbConnectionPool;
    protected static Collection<DBConnection> dbConnectionList;
    private static Object ConnectionPoolLock;
    private String threadName = null;
    private String dbUri = null;
    private String userName = null;
    private String password = null;
    private Connection dbConnection = null;
    private long connectOpenCount = 0L;
    private long connectCloseCount = 0L;
    private long connectTime = 0L;
    private long lastUseTime = 0L;
    private int lockCount = 0;
    private Throwable lastLockTrace = null;
    private static String loadedDriverName;

    public static void setShowExecutedSQL(boolean showSQL) {
        ShowExecutedSQL = showSQL;
    }

    public static boolean getShowExecutedSQL() {
        return ShowExecutedSQL;
    }

    public static void pushShowExecutedSQL() {
        ++ShowExecutedSQL_level;
        DBConnection.setShowExecutedSQL(true);
    }

    public static void popShowExecutedSQL() {
        if ((long)ShowExecutedSQL_level > 0L) {
            --ShowExecutedSQL_level;
        }
        if ((long)ShowExecutedSQL_level == 0L) {
            DBConnection.setShowExecutedSQL(DefaultShowExecutedSQL);
        }
    }

    private static boolean parseCommunicationsException(SQLException sqe) {
        if (sqe == null) {
            return false;
        }
        String sqeCN = StringTools.className(sqe);
        String sqlMsg = sqe.getMessage();
        int errCode = sqe.getErrorCode();
        Throwable cause = sqe.getCause();
        if (sqeCN.indexOf("CommunicationsException") >= 0 || sqlMsg.indexOf("IOException") >= 0 || sqlMsg.indexOf("EOFException") >= 0) {
            String ageMS;
            int e = sqlMsg.indexOf(" milliseconds");
            int s = e > 0 ? sqlMsg.lastIndexOf(" ", e - 1) : -1;
            String string = ageMS = s > 0 ? sqlMsg.substring(s, e).trim() : null;
            if (!StringTools.isBlank(ageMS)) {
                ageMS = StringTools.stripChars(ageMS, ',');
                Print.logWarn("SQL(CommunicationsException) close/retry [" + errCode + "]: Connection Age " + ageMS + " ms", new Object[0]);
            } else {
                Print.logWarn("SQL(CommunicationsException) close/retry [" + errCode + "]: " + sqlMsg, new Object[0]);
            }
            return true;
        }
        if (cause != null && cause instanceof ConnectException) {
            Print.logWarn("SQL(ConnectException) close/retry [" + errCode + "]: " + sqlMsg, new Object[0]);
            return true;
        }
        return false;
    }

    private static DBConnection _getDBConnection(String uri) {
        if (uri == null) {
            return null;
        }
        if (DBCONNECTION_POOL) {
            ArrayList<DBConnection> dbcArray;
            if (dbConnectionPool != null && (dbcArray = dbConnectionPool.get(uri)) != null) {
                for (int d = 0; d < dbcArray.size(); ++d) {
                    DBConnection dbc = dbcArray.get(d);
                    if (dbc._getLockCount() > 0) continue;
                    dbcArray.remove(d);
                    dbcArray.add(dbc);
                    return dbc;
                }
            }
            return null;
        }
        return dbConnectionMap != null ? dbConnectionMap.get(uri) : null;
    }

    protected static void _saveDBConnection(DBConnection dbc) {
        if (dbc != null) {
            String uri = dbc.getUri();
            if (DBCONNECTION_POOL) {
                ArrayList<DBConnection> dbcArray;
                if (dbConnectionPool == null) {
                    dbConnectionPool = new HashMap<String, ArrayList<DBConnection>>();
                }
                if ((dbcArray = dbConnectionPool.get(uri)) == null) {
                    dbcArray = new ArrayList();
                    dbConnectionPool.put(uri, dbcArray);
                }
                dbcArray.add(dbc);
            } else {
                if (dbConnectionMap == null) {
                    dbConnectionMap = new ThreadLocalMap<String, DBConnection>();
                }
                dbConnectionMap.put(uri, dbc);
            }
            if (dbConnectionList == null) {
                dbConnectionList = new Vector<DBConnection>();
            }
            dbConnectionList.add(dbc);
        }
    }

    public static void closeAllConnections() {
        int closed = 0;
        if (dbConnectionList != null) {
            for (DBConnection dbc : dbConnectionList) {
                if (dbc == null || dbc.isConnectionClosed()) continue;
                dbc.closeConnection();
                ++closed;
            }
        }
        if (closed > 0) {
            Print.logInfo("Closed all open DBConnections: " + closed, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBConnection getDBConnection(String uri, String user, String pass) {
        if (uri != null) {
            DBConnection dbc = null;
            String dbConnMsg = null;
            Throwable previousLock = null;
            Object object = ConnectionPoolLock;
            synchronized (object) {
                dbc = DBConnection._getDBConnection(uri);
                if (dbc == null) {
                    String threadName = Thread.currentThread().getName();
                    dbc = new DBConnection(uri, user, pass);
                    dbc.threadName = StringTools.trim(threadName);
                    DBConnection._saveDBConnection(dbc);
                    dbConnMsg = "New Connection [" + threadName + "] " + uri;
                }
                previousLock = dbc._lock();
            }
            if (dbConnMsg != null) {
                Print.logDebug(dbConnMsg, new Object[0]);
            }
            if (previousLock != null) {
                Print.logException("DBConnection connection not released!", previousLock);
            }
            return dbc;
        }
        return null;
    }

    public static DBConnection getDefaultConnection() {
        String uri = DBProvider.getDBUri(true);
        String usr = DBProvider.getDBUsername();
        String pwd = DBProvider.getDBPassword();
        return DBConnection.getDBConnection(uri, usr, pwd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLocked(DBConnection dbc) {
        if (dbc != null) {
            int LC = 0;
            Object object = ConnectionPoolLock;
            synchronized (object) {
                LC = dbc._getLockCount();
            }
            return LC > 0;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(DBConnection dbc) {
        if (dbc != null) {
            boolean alreadyReleased = false;
            Object object = ConnectionPoolLock;
            synchronized (object) {
                alreadyReleased = dbc._release();
            }
        }
    }

    public static void release(DBConnection dbc, Statement stmt, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (stmt != null) {
            try {
                stmt.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        DBConnection.release(dbc);
    }

    protected DBConnection(String uri, String user, String pass) {
        this.dbUri = uri;
        this.userName = user;
        this.password = pass;
    }

    protected void finalize() {
    }

    private int _getLockCount() {
        return this.lockCount;
    }

    private Throwable _lock() {
        if (this.lockCount++ > 0) {
            if (DBCONNECTION_POOL) {
                return this.lastLockTrace;
            }
            return null;
        }
        this.lastLockTrace = new Throwable("First DBConnection Lock");
        this.lastLockTrace.fillInStackTrace();
        return null;
    }

    private boolean _release() {
        if (this.lockCount > 0) {
            --this.lockCount;
            if (this.lockCount == 0) {
                this.lastLockTrace = null;
            }
            return false;
        }
        return true;
    }

    public String getUri() {
        return this.dbUri != null ? this.dbUri : DBProvider.getDBUri(true);
    }

    public String getUser() {
        if (this.userName == null) {
            return DBProvider.getDBUsername();
        }
        if (this.userName.equals(USER_NONE)) {
            return "";
        }
        return this.userName;
    }

    public String getPassword() {
        return this.password != null ? this.password : DBProvider.getDBPassword();
    }

    public Connection getConnection() throws SQLException {
        if (this.isConnectionClosed()) {
            String user;
            this.closeConnection();
            if (loadedDriverName == null && (loadedDriverName = DBProvider.loadJDBCDriver()) != null && RTConfig.isDebugMode()) {
                Print.logDebug("Loaded JDBC driver '" + loadedDriverName + "'", new Object[0]);
            }
            if (StringTools.isBlank(user = this.getUser())) {
                this.dbConnection = USE_DRIVER_MANAGER || DBDataSource == null ? DriverManager.getConnection(this.getUri()) : DBDataSource.getConnection();
            } else {
                String pass = this.getPassword();
                this.dbConnection = USE_DRIVER_MANAGER || DBDataSource == null ? DriverManager.getConnection(this.getUri(), user, pass) : DBDataSource.getConnection();
            }
            this.connectTime = DateTime.getCurrentTimeSec();
            ++this.connectOpenCount;
            if (RTConfig.getBoolean("db.showConnections")) {
                Print.logInfo("New Connection: [" + this.threadName + "]" + " openCount=" + this.connectOpenCount + ", closeCount=" + this.connectCloseCount, new Object[0]);
            } else {
                Print.logDebug("New Connection: [" + this.threadName + "]" + " openCount=" + this.connectOpenCount + ", closeCount=" + this.connectCloseCount, new Object[0]);
            }
        }
        this.lastUseTime = DateTime.getCurrentTimeSec();
        return this.dbConnection;
    }

    public void closeConnection() {
        if (this.dbConnection != null) {
            try {
                if (!this.dbConnection.isClosed()) {
                    try {
                        this.dbConnection.close();
                        ++this.connectCloseCount;
                    }
                    catch (SQLException sqe) {
                        Print.logError("Error closing DBConnection: " + sqe, new Object[0]);
                    }
                }
            }
            catch (SQLException sqle) {
                try {
                    this.dbConnection.close();
                    ++this.connectCloseCount;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isConnectionClosed() {
        try {
            if (this.dbConnection == null) {
                return true;
            }
            if (this.dbConnection.isClosed()) {
                return true;
            }
            if (this.isConnectionTimeout()) {
                return true;
            }
            return ALWAYS_NEW_CONNECTION;
        }
        catch (SQLException sqe) {
            return true;
        }
    }

    public boolean isConnectionTimeout() {
        long connTimeout;
        long nowTime = DateTime.getCurrentTimeSec();
        return nowTime - this.lastUseTime > (connTimeout = RTConfig.getLong("db.inactiveTimeout", INACTIVE_TIMEOUT));
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(false);
    }

    public Statement createStatement(boolean rowByRow) throws SQLException {
        Connection conn = this.getConnection();
        Statement stmt = null;
        if (rowByRow) {
            stmt = conn.createStatement(1003, 1007);
            stmt.setFetchSize(Integer.MIN_VALUE);
        } else {
            stmt = conn.createStatement();
        }
        return stmt;
    }

    public Statement execute(String sql) throws SQLException, DBException {
        return this.execute(sql, false);
    }

    public Statement execute(String sql, boolean rowByRow) throws SQLException, DBException {
        try {
            if (ShowExecutedSQL) {
                Print.logInfo("SQL(Show): " + sql, new Object[0]);
            }
            return this._execute(sql, rowByRow);
        }
        catch (SQLException sqe) {
            String sqlMsg = sqe.getMessage();
            int errCode = sqe.getErrorCode();
            if (DBConnection.parseCommunicationsException(sqe)) {
                this.closeConnection();
                return this._execute(sql, rowByRow);
            }
            if (errCode == 1064 || errCode == 1054) {
                Print.logError("SQL(SyntaxError): " + sql, new Object[0]);
                throw sqe;
            }
            if (sqlMsg.indexOf("Data truncation") >= 0) {
                Print.logError("SQL(DataTruncation): " + sql, new Object[0]);
            }
            throw sqe;
        }
    }

    protected Statement _execute(String sql, boolean rowByRow) throws SQLException, DBException {
        LastSQLExecuted = sql;
        Statement stmt = this.createStatement(rowByRow);
        stmt.execute(sql);
        return stmt;
    }

    public ResultSet executeQuery(String sql) throws SQLException, DBException {
        try {
            if (ShowExecutedSQL) {
                Print.logInfo("SQL: " + sql, new Object[0]);
            }
            return this._executeQuery(sql);
        }
        catch (SQLException sqe) {
            if (DBConnection.parseCommunicationsException(sqe)) {
                this.closeConnection();
                return this._executeQuery(sql);
            }
            throw sqe;
        }
    }

    protected ResultSet _executeQuery(String sql) throws SQLException, DBException {
        Statement stmt = null;
        ResultSet rs = null;
        LastSQLExecuted = sql;
        stmt = this.createStatement();
        rs = stmt.executeQuery(sql);
        return rs;
    }

    public void executeUpdate(String sql) throws SQLException, DBException {
        this.executeUpdate(sql, false);
    }

    public long executeUpdate(String sql, boolean rtnAutoIncrVal) throws SQLException, DBException {
        try {
            if (ShowExecutedSQL) {
                Print.logInfo("SQL: " + sql, new Object[0]);
            }
            return this._executeUpdate(sql, rtnAutoIncrVal);
        }
        catch (IOException ioe) {
            String ioMsg = ioe.getMessage();
            Print.logWarn("SQL(IOException) close/retry: " + ioMsg, new Object[0]);
            this.closeConnection();
            try {
                return this._executeUpdate(sql, rtnAutoIncrVal);
            }
            catch (IOException ioe2) {
                throw new DBException("JDBC IOException", ioe2);
            }
        }
        catch (SQLException sqe) {
            if (DBConnection.parseCommunicationsException(sqe)) {
                this.closeConnection();
                try {
                    return this._executeUpdate(sql, rtnAutoIncrVal);
                }
                catch (IOException ioe2) {
                    throw new DBException("JDBC IOException", ioe2);
                }
            }
            throw sqe;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long _executeUpdate(String sql, boolean rtnAutoIncrVal) throws SQLException, IOException, DBException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            LastSQLExecuted = sql;
            stmt = this.createStatement();
            if (rtnAutoIncrVal) {
                stmt.executeUpdate(sql, 1);
                rs = stmt.getGeneratedKeys();
                if (rs.next()) {
                    long l = rs.getLong(1);
                    return l;
                }
                Print.logError("Expected Auto-Increment value not found!", new Object[0]);
                long l = -1L;
                return l;
            }
            stmt.executeUpdate(sql);
            long l = -1L;
            return l;
        }
        catch (SQLException sqe) {
            throw sqe;
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Throwable t) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    static {
        ShowErrorSQL = DefaultShowErrorSQL = true;
        ShowExecutedSQL = DefaultShowExecutedSQL = false;
        ShowExecutedSQL_level = 0;
        DefaultShowExecutedSQL = RTConfig.getBoolean("db.showSQL");
        DBConnection.setShowExecutedSQL(DefaultShowExecutedSQL);
        USE_DRIVER_MANAGER = false;
        DBCONNECTION_POOL = false;
        ALWAYS_NEW_CONNECTION = false;
        INACTIVE_TIMEOUT = 21600L;
        LastSQLExecuted = null;
        DBDataSource = null;
        DBCONNECTION_POOL = RTConfig.getBoolean("db.dbConnectionPool");
        if (DBCONNECTION_POOL) {
            Print.logDebug("DBConnection pooling enabled", new Object[0]);
        } else {
            Print.logDebug("DBConnection per-thread enabled", new Object[0]);
        }
        String dataSrcClass = RTConfig.getString("db.dataSource.class");
        if (!StringTools.isBlank(dataSrcClass)) {
            Print.logInfo("Attempting to load DataSource: " + dataSrcClass, new Object[0]);
            Class<?> bdsClass = null;
            if (dataSrcClass.equalsIgnoreCase("true") || dataSrcClass.equalsIgnoreCase("default")) {
                String[] bdsClassName = new String[]{"org.apache.tomcat.dbcp.dbcp.BasicDataSource", "org.apache.commons.dbcp.BasicDataSource"};
                for (int i = 0; i < bdsClassName.length; ++i) {
                    try {
                        bdsClass = Class.forName(bdsClassName[i]);
                        break;
                    }
                    catch (Throwable th) {
                        if (th.getMessage().indexOf("GenericObjectPool") >= 0) {
                            Print.logException("Apache 'Pool' Component missing! (see http://commons.apache.org/pool/)", th);
                            continue;
                        }
                        if (!RTConfig.isDebugMode()) continue;
                        Print.logInfo("Error loading '" + bdsClassName[i] + "'", new Object[0]);
                        Print.logInfo(th.toString(), new Object[0]);
                        continue;
                    }
                }
            } else {
                try {
                    bdsClass = Class.forName(dataSrcClass);
                }
                catch (Throwable th) {
                    bdsClass = null;
                }
            }
            if (bdsClass != null) {
                String driverName = DBProvider.getProvider().getDrivers()[0];
                String urlStr = DBProvider.getDBUri(true);
                String user = DBProvider.getDBUsername();
                String password = DBProvider.getDBPassword();
                int maxActive = RTConfig.getInt("db.dataSource.maxActive", 100);
                int maxIdle = RTConfig.getInt("db.dataSource.maxIdle", 30);
                long maxWait = RTConfig.getLong("db.dataSource.maxWait", 10000L);
                try {
                    DataSource ds = (DataSource)bdsClass.newInstance();
                    new MethodAction((Object)ds, "setDriverClassName", String.class).invoke(driverName);
                    new MethodAction((Object)ds, "setUrl", String.class).invoke(urlStr);
                    new MethodAction((Object)ds, "setUsername", String.class).invoke(user);
                    new MethodAction((Object)ds, "setPassword", String.class).invoke(password);
                    new MethodAction((Object)ds, "setMaxActive", Integer.TYPE).invoke(new Integer(maxActive));
                    new MethodAction((Object)ds, "setMaxIdle", Integer.TYPE).invoke(new Integer(maxIdle));
                    new MethodAction((Object)ds, "setMaxWait", Long.TYPE).invoke(new Long(maxWait));
                    DBDataSource = ds;
                }
                catch (Throwable th) {
                    Print.logWarn("Unable to load DataSource: " + th, new Object[0]);
                    DBDataSource = null;
                }
            } else {
                Print.logWarn("DataSource class not found: " + dataSrcClass, new Object[0]);
            }
        }
        if (DBDataSource != null) {
            Print.logInfo("Loaded DataSource: %s ...", StringTools.className(DBDataSource));
        } else {
            Print.logDebug("DriverManager will be used for new connections", new Object[0]);
            Print.logDebug("db.sql.provider = " + RTConfig.getString("db.sql.provider"), new Object[0]);
            Print.logDebug("db.sql.url = " + RTConfig.getString("db.sql.url"), new Object[0]);
            Print.logDebug("db.sql.url.db = " + RTConfig.getString("db.sql.url.db"), new Object[0]);
            Print.logDebug("DBProvider.getDBUri  = " + DBProvider.getDBUri(true), new Object[0]);
        }
        dbConnectionMap = null;
        dbConnectionPool = null;
        dbConnectionList = null;
        ConnectionPoolLock = new Object();
        loadedDriverName = null;
    }
}

