/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.dbtools;

import java.util.List;
import java.util.Vector;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class DBAlternateIndex {
    private static int UniqueIndexID = 1;
    private DBFactory factory = null;
    private String name = "";
    private List<DBField> keys = null;
    private DBField[] fld = null;
    private boolean isUnique = false;

    public DBAlternateIndex(DBFactory factory, String indexName) {
        this.factory = factory;
        if (StringTools.isBlank(indexName)) {
            Print.logStackTrace("Index name is blank!");
            this.name = "altIndex" + UniqueIndexID++;
        } else {
            this.name = indexName;
        }
        this.keys = new Vector<DBField>();
    }

    public DBFactory getFactory() {
        return this.factory;
    }

    public String getUntranslatedTableName() {
        return this.factory != null ? this.factory.getUntranslatedTableName() : "";
    }

    public String getIndexName() {
        return this.name;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public void addField(DBField field) {
        if (field != null) {
            this.keys.add(field);
            this.fld = null;
            if (field.isUniqueAltKey()) {
                this.isUnique = true;
            }
        }
    }

    public DBField[] getFields() {
        if (this.fld == null) {
            this.fld = this.keys.toArray(new DBField[this.keys.size()]);
        }
        return this.fld;
    }

    public String getFieldNames() {
        StringBuffer sb = new StringBuffer();
        for (DBField f : this.keys) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(f.getName());
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[").append(this.getUntranslatedTableName()).append("]");
        sb.append(this.getIndexName()).append(":").append(this.getFieldNames());
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof DBAlternateIndex) {
            return this.toString().equals(other.toString());
        }
        return false;
    }
}

