/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.dbtools;

import java.io.File;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import org.opengts.dbtools.DBConnection;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBProvider;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBSelect;
import org.opengts.util.DateTime;
import org.opengts.util.FileTools;
import org.opengts.util.I18N;
import org.opengts.util.ListTools;
import org.opengts.util.MethodAction;
import org.opengts.util.OrderedMap;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class DBAdmin {
    private static final boolean SKIP_OPTIONAL_TABLES = false;
    private static final String DUMP_ALL = "all";
    private static OrderedMap<String, DBFactory<? extends DBRecord>> tableFactoryMap = null;
    public static final int VALIDATE_CREATE_TABLE = 1;
    public static final int VALIDATE_ADD_COLUMNS = 2;
    public static final int VALIDATE_ALTER_COLUMNS = 4;
    public static final int VALIDATE_REBUILD_KEYS = 8;
    public static final int VALIDATE_CHECK_ENCODING = 16;
    public static final int VALIDATE_DISPLAY_ERRORS = 256;
    public static final int VALIDATE_DISPLAY_WARNINGS = 512;
    public static final int VALIDATE_SHOW_COLUMNS = 1024;
    public static final int VALIDATE_NAMED_TABLE_ONLY = 2048;
    public static final int VALIDATE_EXCLUDE_NAMED_TABLE = 4096;
    public static final int VALIDATE_DISPLAY_DB_ENGINE = 65536;
    public static final int VALIDATE_ACTUAL_RECORD_COUNT = 131072;
    private static String DEFAULT_DIRECTORY = File.separator + "tmp";
    public static final String[] ARG_ROOT_USER = new String[]{"rootUser", "user"};
    public static final String[] ARG_ROOT_PASS = new String[]{"rootPass", "pass"};
    public static final String[] ARG_CREATE_DB = new String[]{"createdb"};
    public static final String[] ARG_GRANT = new String[]{"grant"};
    public static final String[] ARG_DB = new String[]{"db"};
    public static final String[] ARG_DIR = new String[]{"dir"};
    public static final String[] ARG_LOAD = new String[]{"load"};
    public static final String[] ARG_DROP = new String[]{"drop"};
    public static final String[] ARG_TABLES = new String[]{"tables"};
    public static final String[] ARG_TABLENAME = new String[]{"tableName", "name"};
    public static final String[] ARG_SCHEMA = new String[]{"schema"};
    public static final String[] ARG_DUMP = new String[]{"dump"};
    public static final String[] ARG_WHERE = new String[]{"where"};
    public static final String[] ARG_VALIDATE = new String[]{"validate"};
    public static final String[] ARG_LAST = new String[]{"last"};
    public static final String[] ARG_NOINSERT = new String[]{"noInsert"};
    public static final String[] ARG_OVERWRITE = new String[]{"overwrite"};
    public static final String[] ARG_BEAN = new String[]{"bean"};

    private DBAdmin() {
    }

    protected static DBFactory<? extends DBRecord> _createDBRecordFactory(String className, boolean isRequired) {
        if (StringTools.isBlank(className)) {
            return null;
        }
        try {
            DBFactory dbFact = (DBFactory)new MethodAction((Object)className, "getFactory").invoke();
            if (dbFact != null) {
                dbFact.setRequired(isRequired);
                return dbFact;
            }
            Print.logError("\"" + className + ".getFactory()\" returned NULL!", new Object[0]);
            return null;
        }
        catch (ClassNotFoundException cnfe) {
            if (isRequired) {
                Print.logError("Required DBFactory not found: " + className, new Object[0]);
            }
            return null;
        }
        catch (Throwable t) {
            if (isRequired) {
                Print.logError("Required DBFactory Error: " + className + " [" + t + "]", new Object[0]);
            } else if (t instanceof NoClassDefFoundError) {
                String missingClass = t.getMessage().replace('/', '.');
                Print.logDebug("Optional DBFactory not found: " + className + " [missing " + missingClass + "]", new Object[0]);
            } else if (t instanceof NoSuchMethodError) {
                String methodInError = t.getMessage().replace('/', '.');
                Print.logDebug("Optional DBFactory dependent method error: " + className + " [" + t + "]", new Object[0]);
            } else {
                Print.logError("Optional DBFactory Error: " + className + " [" + t + "]", new Object[0]);
            }
            return null;
        }
    }

    public static boolean addTableFactory(String className, boolean isRequired) {
        DBFactory<? extends DBRecord> fact = DBAdmin._createDBRecordFactory(className, isRequired);
        if (fact != null) {
            DBAdmin.addTableFactory(fact);
            return true;
        }
        return false;
    }

    public static void addTableFactory(DBFactory<? extends DBRecord> factory) {
        if (factory != null) {
            if (factory.getFieldCount() <= 0) {
                Print.logStackTrace("Ignoring DBFactory with no fields: " + factory.getUntranslatedTableName());
            } else {
                String utableNameLC = factory.getUntranslatedTableName().toLowerCase();
                if (DBAdmin.getTableFactoryMap().containsKey(utableNameLC)) {
                    Print.logWarn("Overriding existing DBFactory: %s", factory.getUntranslatedTableName());
                }
                DBAdmin.getTableFactoryMap().put(utableNameLC, factory);
            }
        }
    }

    public static boolean includeFieldInFactory(DBFactory fact, DBField field) {
        return true;
    }

    public static int getTableFactoryCount() {
        return tableFactoryMap != null ? tableFactoryMap.size() : 0;
    }

    public static OrderedMap<String, DBFactory<? extends DBRecord>> getTableFactoryMap() {
        if (tableFactoryMap == null) {
            tableFactoryMap = new OrderedMap();
        }
        return tableFactoryMap;
    }

    public static DBFactory<? extends DBRecord>[] getChildTableFactories(DBFactory<? extends DBRecord> parentFactory) {
        Vector<DBFactory<? extends DBRecord>> list = new Vector<DBFactory<? extends DBRecord>>();
        if (parentFactory != null) {
            String uparentTableName = parentFactory.getUntranslatedTableName();
            for (DBFactory<? extends DBRecord> childFact : DBAdmin.getTableFactoryMap().values()) {
                if (!childFact.hasParentTable(uparentTableName)) continue;
                list.add(childFact);
            }
        }
        return list.toArray(new DBFactory[list.size()]);
    }

    private static DBFactory<? extends DBRecord> _getTableFactory(String utableName) {
        if (utableName != null) {
            String utableNameLC = utableName.toLowerCase();
            return DBAdmin.getTableFactoryMap().get(utableNameLC);
        }
        return null;
    }

    public static DBFactory<? extends DBRecord> getTableFactory(String utableName) {
        if (StringTools.isBlank(utableName)) {
            Print.logWarn("Table name is null/blank", new Object[0]);
            return null;
        }
        DBFactory<? extends DBRecord> fact = DBAdmin._getTableFactory(utableName);
        if (fact == null) {
            Print.logWarn("Table factory class not found: " + utableName, new Object[0]);
            Print.logStackTrace("Table factory class not found: " + utableName);
            return null;
        }
        return fact;
    }

    public static boolean hasTableFactory(String utableName) {
        return DBAdmin.getTableFactory(utableName) != null;
    }

    public static String getTableNameProperCase(String utableName) {
        DBFactory<? extends DBRecord> fact = DBAdmin.getTableFactory(utableName);
        return fact != null ? fact.getUntranslatedTableName() : utableName;
    }

    private static boolean validateTableColumns(int validateMask, String utableName) {
        DBFactory<? extends DBRecord> fact;
        boolean validatedColumns = true;
        int sepLen = 75;
        int cntLen = 9;
        boolean isMySQLInnoDB = DBProvider.isMySqlInnoDB();
        Print.sysPrintln("", new Object[0]);
        Print.sysPrintln("Validating table columns ...", new Object[0]);
        if ((validateMask & 0x800) != 0 && (validateMask & 0x1000) != 0) {
            Print.sysPrintln("ERROR: Include/Exclude table name mutually exclusive.", new Object[0]);
            return false;
        }
        if (!StringTools.isBlank(utableName = StringTools.trim(utableName)) && (fact = DBAdmin._getTableFactory(utableName)) == null) {
            Print.sysPrintln("ERROR: No DBFactory for table: " + utableName, new Object[0]);
            return false;
        }
        if ((validateMask & 0x800) != 0) {
            if (StringTools.isBlank(utableName)) {
                Print.sysPrintln("ERROR: Included table name not specified.", new Object[0]);
                return false;
            }
            Print.sysPrintln("(including only table '" + utableName + "')", new Object[0]);
        } else if ((validateMask & 0x1000) != 0) {
            if (StringTools.isBlank(utableName)) {
                Print.sysPrintln("ERROR: Excluded table name not specified.", new Object[0]);
                return false;
            }
            Print.sysPrintln("(excluding table '" + utableName + "')", new Object[0]);
        }
        Print.sysPrintln(StringTools.replicateString("-", sepLen), new Object[0]);
        OrderedMap<String, DBFactory<? extends DBRecord>> factMap = DBAdmin.getTableFactoryMap();
        Iterator<String> i = factMap.keyIterator();
        while (i.hasNext()) {
            String tn = i.next();
            if ((validateMask & 0x800) != 0 && !utableName.equalsIgnoreCase(tn) || (validateMask & 0x1000) != 0 && utableName.equalsIgnoreCase(tn)) continue;
            DBFactory<? extends DBRecord> f = factMap.get(tn);
            try {
                String rcs;
                StringBuffer sb = new StringBuffer();
                sb.append("  Table ");
                sb.append(StringTools.leftAlign("'" + f.getUntranslatedTableName() + "'", 25));
                if (!f.tableExists()) {
                    sb.append(StringTools.rightAlign("---", cntLen));
                    if ((validateMask & 1) != 0) {
                        String dbEng = DBProvider.getProviderIndexType();
                        int p = dbEng.indexOf("=");
                        if (p >= 0) {
                            dbEng = dbEng.substring(p + 1);
                        }
                        if ((validateMask & 0x10000) != 0) {
                            sb.append(" [" + dbEng + "]");
                        }
                        sb.append(" Creating table ...");
                        Print.sysPrintln(sb.toString(), new Object[0]);
                        f.createTable();
                        continue;
                    }
                    sb.append(" Table does not exist!");
                    Print.sysPrintln(sb.toString(), new Object[0]);
                    continue;
                }
                boolean actual = (validateMask & 0x20000) != 0;
                long rc = f.getRecordCount("", actual);
                String dbEng = f.getIndexType();
                String string = rcs = rc < 0L ? "n/a" : String.valueOf(rc);
                if (!actual && rc > 0L && dbEng.equalsIgnoreCase("InnoDB")) {
                    rcs = "~" + rcs;
                }
                sb.append(StringTools.rightAlign(rcs, cntLen));
                if ((validateMask & 0x10000) != 0) {
                    sb.append(" [" + dbEng + "]");
                }
                sb.append(" Validating columns ...");
                Print.sysPrintln(sb.toString(), new Object[0]);
                validatedColumns = f.validateColumns(validateMask) && validatedColumns;
            }
            catch (DBException dbe) {
                Print.sysPrintln("    ERROR: Unable to create/validate table '" + f.getUntranslatedTableName() + "'", new Object[0]);
                dbe.printException();
            }
        }
        Print.sysPrintln(StringTools.replicateString("-", sepLen), new Object[0]);
        if (!validatedColumns) {
            boolean rebuildKeys;
            boolean addCol = (validateMask & 2) != 0;
            boolean alterTypes = (validateMask & 4) != 0;
            boolean bl = rebuildKeys = (validateMask & 8) != 0;
            if (addCol || alterTypes || rebuildKeys) {
                Print.sysPrintln("WARNING: Attempted repair of column validation errors", new Object[0]);
                Print.sysPrintln("Rerun with option '-tables' to see if errors have been repaired.", new Object[0]);
            } else {
                Print.sysPrintln("ERROR: Fix/Recheck column validation errors", new Object[0]);
                Print.sysPrintln("Depending on the error displayed, rerun with one of the following options:", new Object[0]);
                Print.sysPrintln("  '-tables=c'   to add missing columns", new Object[0]);
                Print.sysPrintln("  '-tables=ca'  to also alter existing column types", new Object[0]);
                Print.sysPrintln("  '-tables=cak' to also recreate key indexes", new Object[0]);
            }
        } else {
            Print.sysPrintln("Column validation completed successfully.", new Object[0]);
        }
        Print.sysPrintln(StringTools.replicateString("-", sepLen), new Object[0]);
        Print.sysPrintln("", new Object[0]);
        return validatedColumns;
    }

    private static void validateTables(String utableName, boolean inclWarn) {
        boolean tableFound = false;
        OrderedMap<String, DBFactory<? extends DBRecord>> factMap = DBAdmin.getTableFactoryMap();
        Iterator<String> i = factMap.keyIterator();
        while (i.hasNext()) {
            String tn = i.next();
            DBFactory<? extends DBRecord> f = factMap.get(tn);
            try {
                if (!StringTools.isBlank(utableName) && !tn.equalsIgnoreCase(utableName)) continue;
                if (!f.tableExists()) {
                    Print.logError("Table does not exist '" + f.getUntranslatedTableName() + "'", new Object[0]);
                    continue;
                }
                f.validateTable(inclWarn);
                tableFound = true;
            }
            catch (DBException dbe) {
                Print.logError("Unable to validate table '" + f.getUntranslatedTableName() + "'", new Object[0]);
            }
        }
        if (!tableFound) {
            Print.logError("Table not found '" + utableName + "'", new Object[0]);
        }
        Print.logInfo("", new Object[0]);
    }

    private static void _printHeaderText(String text, int width) {
        String[] s = StringTools.parseStringArray(text, "\n");
        for (int i = 0; i < s.length; ++i) {
            while (s[i].length() > width) {
                int ch;
                for (ch = width; ch > 0 && !Character.isWhitespace(s[i].charAt(ch)); --ch) {
                }
                if (ch <= 0) break;
                Print.sysPrintln(s[i].substring(0, ch + 1).trim(), new Object[0]);
                s[i] = s[i].substring(ch + 1).trim();
            }
            if (s[i].length() <= 0) continue;
            Print.sysPrintln(s[i], new Object[0]);
        }
    }

    private static void _printSchemaRow(String index, String name, String title, String sqlType, String keyType) {
        int widIndex = 3;
        int widName = 22;
        int widTitle = 30;
        int widSqlType = 28;
        int widKeyType = 8;
        if (index == null) {
            index = StringTools.replicateString("-", widIndex);
        }
        if (name == null) {
            name = StringTools.replicateString("-", widName);
        }
        if (title == null) {
            title = StringTools.replicateString("-", widTitle);
        }
        if (sqlType == null) {
            sqlType = StringTools.replicateString("-", widSqlType);
        }
        if (keyType == null) {
            keyType = StringTools.replicateString("-", widKeyType);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" ");
        sb.append(StringTools.rightAlign(index, widIndex)).append(" ");
        sb.append(StringTools.leftAlign(name, widName)).append(" ");
        sb.append(StringTools.leftAlign(title, widTitle)).append(" ");
        sb.append(StringTools.leftAlign(sqlType, widSqlType)).append(" ");
        sb.append(StringTools.leftAlign(keyType, widKeyType));
        Print.sysPrintln(sb.toString(), new Object[0]);
    }

    public static void printTableSchema(int docWidth, String[] header, String utableName) {
        Locale locale = I18N.getLocale("en");
        if (!ListTools.isEmpty(header)) {
            Print.sysPrintln(StringTools.replicateString("=", docWidth + 1), new Object[0]);
            for (String h : header) {
                if (StringTools.isBlank(h)) {
                    Print.sysPrintln("", new Object[0]);
                    continue;
                }
                if (h.length() < docWidth) {
                    Print.sysPrintln(h, new Object[0]);
                    continue;
                }
                DBAdmin._printHeaderText(h, docWidth);
            }
        }
        int tablesFound = 0;
        OrderedMap<String, DBFactory<? extends DBRecord>> factMap = DBAdmin.getTableFactoryMap();
        Iterator<String> i = factMap.keyIterator();
        while (i.hasNext()) {
            String tn = i.next();
            if (!StringTools.isBlank(utableName) && !tn.equalsIgnoreCase(utableName)) continue;
            ++tablesFound;
            DBFactory<? extends DBRecord> f = factMap.get(tn);
            boolean tableExists = false;
            try {
                if (f.tableExists()) {
                    tableExists = true;
                }
            }
            catch (DBException dbe) {
                // empty catch block
            }
            boolean isRequired = f.isRequired();
            StringBuffer attr = new StringBuffer();
            attr.append(" [");
            attr.append(isRequired ? "required" : "optional");
            attr.append("]");
            Print.sysPrintln("", new Object[0]);
            Print.sysPrintln("", new Object[0]);
            Print.sysPrintln(StringTools.replicateString("=", docWidth + 1), new Object[0]);
            Print.sysPrintln("Table: " + f.getUntranslatedTableName() + attr, new Object[0]);
            Print.sysPrintln("Class: " + StringTools.className(f.getRecordClass()), new Object[0]);
            Print.sysPrintln("", new Object[0]);
            DBAdmin._printHeaderText(f.getDescription(locale), docWidth);
            Print.sysPrintln("", new Object[0]);
            DBAdmin._printSchemaRow("##", "Column", "Description", "SQL Type", "Key");
            DBAdmin._printSchemaRow(null, null, null, null, null);
            DBField[] colDef = f.getFields();
            for (int c = 0; c < colDef.length; ++c) {
                String index = String.valueOf(c + 1);
                String name = colDef[c].getName();
                String title = colDef[c].getTitle(locale);
                String sqlType = colDef[c].getSqlType(false);
                boolean isAuto = colDef[c].isAutoIncrement();
                boolean isUTF8 = colDef[c].isUTF8();
                if (isAuto || isUTF8) {
                    sqlType = sqlType + " [";
                    if (isAuto) {
                        sqlType = sqlType + "auto";
                    }
                    if (isUTF8) {
                        if (isAuto) {
                            sqlType = sqlType + ",";
                        }
                        sqlType = sqlType + "utf8";
                    }
                    sqlType = sqlType + "]";
                }
                String keyType = colDef[c].getIndexNames();
                DBAdmin._printSchemaRow(index, name, title, sqlType, keyType);
            }
        }
        if (tablesFound <= 0) {
            Print.sysPrintln("Table(s) not found", new Object[0]);
        }
        Print.sysPrintln("", new Object[0]);
        Print.sysPrintln("", new Object[0]);
    }

    public static boolean verifyTablesExist() {
        boolean allOK = true;
        OrderedMap<String, DBFactory<? extends DBRecord>> factMap = DBAdmin.getTableFactoryMap();
        Iterator<String> i = factMap.keyIterator();
        while (i.hasNext()) {
            String tn = i.next();
            DBFactory<? extends DBRecord> f = factMap.get(tn);
            try {
                if (f.tableExists()) continue;
                if (f.isRequired()) {
                    Print.logError("Required table not found: " + f.getUntranslatedTableName(), new Object[0]);
                    allOK = false;
                    continue;
                }
                Print.logWarn("Optional table not found: " + f.getUntranslatedTableName(), new Object[0]);
            }
            catch (DBException dbe) {
                Print.logError("Error checking for table '" + f.getUntranslatedTableName() + "'", new Object[0]);
                dbe.printException();
                allOK = false;
            }
        }
        return allOK;
    }

    public static File getDumpDirectory() {
        String dirName = DEFAULT_DIRECTORY + File.separator + DBProvider.getDBName();
        return new File(dirName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBAdminExec execCommands() {
        String dumpTable;
        String rootPass;
        String rootUser;
        RTConfig.setBoolean("log.email.sendExceptions", false);
        int execCmd = 0;
        if (RTConfig.hasProperty(ARG_DB)) {
            String dbArg = RTConfig.getString(ARG_DB, "");
            String dbName = DBProvider.getDBName();
            if (StringTools.isBlank(dbName)) {
                RTConfig.setString("db.sql.dbname", dbArg);
            } else if (!dbName.equals(dbArg)) {
                Print.logError("Argument DB (" + dbArg + ") does not match config DB (" + dbName + ")", new Object[0]);
                return DBAdminExec.ERROR;
            }
        }
        if (RTConfig.getBoolean(ARG_CREATE_DB, false)) {
            ++execCmd;
            rootUser = RTConfig.getString(ARG_ROOT_USER, null);
            rootPass = RTConfig.getString(ARG_ROOT_PASS, null);
            try {
                DBProvider.createDatabase(rootUser, rootPass);
            }
            catch (SQLException sqe) {
                String dbName = DBProvider.getDBName();
                String sqlMsg = sqe.getMessage();
                int errCode = sqe.getErrorCode();
                if (errCode == 1007) {
                    Print.logWarn("Database already exists: " + dbName, new Object[0]);
                }
                if (sqlMsg.indexOf("already exists") >= 0) {
                    Print.logWarn("Database already exists: " + dbName, new Object[0]);
                }
                Print.logError("SQLException message: " + sqlMsg, new Object[0]);
                Print.logSQLError("DB create error [" + DBProvider.getDBUri(false) + "]", sqe);
                return DBAdminExec.ERROR;
            }
            catch (DBException dbe) {
                Print.logException("DB create error [" + DBProvider.getDBUri(false) + "]", dbe);
            }
        }
        if (RTConfig.getBoolean(ARG_GRANT, false)) {
            ++execCmd;
            rootUser = RTConfig.getString(ARG_ROOT_USER, null);
            rootPass = RTConfig.getString(ARG_ROOT_PASS, null);
            try {
                DBProvider.grantDBUser(rootUser, rootPass);
            }
            catch (SQLException sqe) {
                Print.logSQLError("DB grant error [" + DBProvider.getDBUri(false) + "]", sqe);
                return DBAdminExec.ERROR;
            }
            catch (DBException dbe) {
                Print.logException("DB grant error [" + DBProvider.getDBUri(false) + "]", dbe);
            }
        }
        try {
            DBConnection dbc = null;
            try {
                dbc = DBConnection.getDefaultConnection();
                dbc.getConnection();
            }
            finally {
                DBConnection.release(dbc);
            }
        }
        catch (SQLException sqe) {
            String uri = DBProvider.getDBUri(true);
            Print.logSQLError("Connection error [" + uri + "]", sqe);
            return DBAdminExec.ERROR;
        }
        File dumpDir = RTConfig.getFile(ARG_DIR, DBAdmin.getDumpDirectory());
        File loadDir = RTConfig.getFile(ARG_DIR, DBAdmin.getDumpDirectory());
        File[] loadTableFiles = null;
        String[] loadTableNames = null;
        if (RTConfig.hasProperty(ARG_LOAD)) {
            ++execCmd;
            String loadTableArg = RTConfig.getString(ARG_LOAD, null);
            loadTableNames = StringTools.split(loadTableArg, ',');
            if (StringTools.isBlank(loadTableArg) || ListTools.isEmpty(loadTableNames)) {
                Print.logError("'Load' file(s) not specified", new Object[0]);
                return DBAdminExec.ERROR;
            }
            loadTableFiles = new File[loadTableNames.length];
            for (int t = 0; t < loadTableNames.length; ++t) {
                int p;
                if (FileTools.hasFileSeparator(loadTableNames[t])) {
                    if (loadTableNames.length > 1) {
                        Print.logError("Multiple load files may not contain directory specifications.", new Object[0]);
                        return DBAdminExec.ERROR;
                    }
                    File file = new File(loadTableNames[t]);
                    loadTableNames[t] = file.getName();
                    loadDir = file.getParentFile();
                }
                if ((p = loadTableNames[t].lastIndexOf(46)) < 0) {
                    loadTableFiles[t] = new File(loadDir, loadTableNames[t] + ".txt");
                    if (loadTableFiles[t].isFile()) continue;
                    loadTableFiles[t] = new File(loadDir, loadTableNames[t] + ".sql");
                    if (loadTableFiles[t].isFile()) continue;
                    String f = loadDir + File.separator + loadTableNames[t] + ".[txt|sql]";
                    Print.logWarn("'Load' file not found: " + f, new Object[0]);
                    return DBAdminExec.WARN;
                }
                String ext = loadTableNames[t].substring(p);
                if (ext.equals(".csv") || ext.equals(".txt") || ext.equals(".sql")) {
                    loadTableFiles[t] = new File(loadDir, loadTableNames[t]);
                    if (!loadTableFiles[t].isFile()) {
                        Print.logWarn("'Load' file not found: " + loadTableFiles[t], new Object[0]);
                        return DBAdminExec.WARN;
                    }
                } else {
                    Print.logError("Invalid 'load' file extension [expected txt|sql|csv]", new Object[0]);
                    return DBAdminExec.ERROR;
                }
                loadTableNames[t] = loadTableNames[t].substring(0, p);
            }
        }
        if ((dumpTable = RTConfig.getString(ARG_DUMP, null)) != null) {
            ++execCmd;
            String dftExt = ".txt";
            Vector tableList = new Vector();
            if (dumpTable.equalsIgnoreCase(DUMP_ALL)) {
                ListTools.toList(DBAdmin.getTableFactoryMap().keySet(), tableList);
                dftExt = ".txt";
            } else if (dumpTable.equalsIgnoreCase("all.csv")) {
                ListTools.toList(DBAdmin.getTableFactoryMap().keySet(), tableList);
                dftExt = ".csv";
            } else if (dumpTable.equalsIgnoreCase("all.txt")) {
                ListTools.toList(DBAdmin.getTableFactoryMap().keySet(), tableList);
                dftExt = ".txt";
            } else if (dumpTable.equalsIgnoreCase("all.xml")) {
                ListTools.toList(DBAdmin.getTableFactoryMap().keySet(), tableList);
                dftExt = ".xml";
            } else {
                ListTools.toList(StringTools.split(dumpTable, ','), tableList);
                dftExt = ".txt";
            }
            Iterator i = tableList.iterator();
            while (i.hasNext()) {
                Object dbfact = null;
                String utableName = (String)i.next();
                File toDir = dumpDir;
                if (FileTools.hasFileSeparator(utableName)) {
                    File file = new File(utableName);
                    utableName = file.getName();
                    toDir = file.getParentFile();
                }
                File dumpFile = null;
                int p = utableName.lastIndexOf(46);
                if (p < 0) {
                    utableName = DBAdmin.getTableNameProperCase(utableName);
                    dumpFile = new File(toDir, utableName + dftExt);
                } else {
                    String dotExt = utableName.substring(p);
                    utableName = DBAdmin.getTableNameProperCase(utableName.substring(0, p));
                    if (dotExt.equals(".csv") || dotExt.equals(".txt") || dotExt.equals(".xml")) {
                        dumpFile = new File(toDir, utableName + dotExt);
                    } else {
                        Print.logError("Invalid 'dump' file extension [expected txt|csv|xml]: " + dotExt, new Object[0]);
                        return DBAdminExec.ERROR;
                    }
                }
                String where = null;
                if (RTConfig.hasProperty(ARG_WHERE)) {
                    where = RTConfig.getString(ARG_WHERE, "");
                    Print.logInfo("Dumping '" + utableName + "' to file: " + dumpFile + " => " + where, new Object[0]);
                } else {
                    where = null;
                    Print.logInfo("Dumping '" + utableName + "' to file: " + dumpFile, new Object[0]);
                }
                DBFactory<? extends DBRecord> fact = DBAdmin.getTableFactory(utableName);
                if (fact != null) {
                    try {
                        DBSelect<? extends DBRecord> dbSel = new DBSelect<DBRecord>(fact, where);
                        fact.dumpTable(dumpFile, dbSel);
                        continue;
                    }
                    catch (DBException dbe) {
                        Print.logException("Error dumping table: " + utableName, dbe);
                        return DBAdminExec.ERROR;
                    }
                }
                Print.logError("No DBFactory for table: " + utableName, new Object[0]);
                return DBAdminExec.ERROR;
            }
        }
        if (RTConfig.hasProperty(ARG_DROP)) {
            ++execCmd;
            String dropTbl = RTConfig.getString(ARG_DROP, null);
            if (!StringTools.isBlank(dropTbl)) {
                Print.logInfo("Deleting table: " + dropTbl, new Object[0]);
                DBFactory<? extends DBRecord> dbf = DBAdmin.getTableFactory(dropTbl);
                if (dbf != null) {
                    try {
                        dbf.dropTable();
                        Print.logInfo("Table dropped: " + dropTbl, new Object[0]);
                    }
                    catch (DBException dbe) {
                        Print.logError("Unable to drop table", new Object[0]);
                        dbe.printException();
                    }
                } else {
                    Print.logError("No DBFactory for table: " + dropTbl, new Object[0]);
                }
            } else {
                Print.logError("Missing table name", new Object[0]);
            }
        }
        if (!ListTools.isEmpty(loadTableFiles)) {
            ++execCmd;
            for (int t = 0; t < loadTableFiles.length; ++t) {
                if (loadTableFiles[t].isFile()) {
                    DBFactory<? extends DBRecord> fact = DBAdmin.getTableFactory(loadTableNames[t]);
                    if (fact != null) {
                        boolean insertRecords = !RTConfig.getBoolean(ARG_NOINSERT, false);
                        boolean overwriteExisting = RTConfig.getBoolean(ARG_OVERWRITE, false);
                        try {
                            Print.logInfo("-----------------------------------", new Object[0]);
                            if (!fact.tableExists()) {
                                Print.logInfo("Creating table '" + loadTableNames[t] + "'", new Object[0]);
                                fact.createTable();
                            }
                            Print.logInfo("Loading table '" + loadTableNames[t] + "' from file: " + loadTableFiles[t], new Object[0]);
                            if (!insertRecords) {
                                Print.logWarn("---- No records will be inserted! (record validation only) ----", new Object[0]);
                            } else if (overwriteExisting) {
                                Print.logWarn("**** Existing data WILL be overwritten! ****", new Object[0]);
                            } else {
                                Print.logWarn("---- Existing data will NOT be overwritten! ----", new Object[0]);
                            }
                            long count = fact.loadTable(loadTableFiles[t], insertRecords, overwriteExisting);
                            Print.logInfo("(Loaded " + count + " records from file '" + loadTableFiles[t] + "' into table '" + loadTableNames[t] + "')", new Object[0]);
                            continue;
                        }
                        catch (DBException dbe) {
                            Print.logException("Error creating/loading table: " + loadTableNames[t], dbe);
                            return DBAdminExec.ERROR;
                        }
                    }
                    Print.logError("No DBFactory for table '" + loadTableNames[t] + "'", new Object[0]);
                    return DBAdminExec.ERROR;
                }
                Print.logError("File not found: " + loadDir + File.separator + loadTableNames[t] + ".[dump|sql|txt|csv]", new Object[0]);
                return DBAdminExec.ERROR;
            }
        }
        if (RTConfig.hasProperty(ARG_TABLES)) {
            boolean validateOK;
            ++execCmd;
            String utableName = RTConfig.getString(ARG_TABLENAME, null);
            String options = RTConfig.getString(ARG_TABLES, "").trim().toLowerCase();
            if (StringTools.isBlank(options)) {
                options = "t";
            }
            String validOpt = "tcakuewsnxg#";
            for (int c = 0; c < options.length(); ++c) {
                char ch = options.charAt(c);
                if (validOpt.indexOf(ch) >= 0) continue;
                Print.logError("Invalid '-tables' option: " + ch, new Object[0]);
                return DBAdminExec.ERROR;
            }
            int mask = 256;
            if (options.indexOf("t") >= 0) {
                mask |= 1;
            }
            if (options.indexOf("c") >= 0) {
                mask |= 3;
            }
            if (options.indexOf("a") >= 0) {
                mask |= 4;
            }
            if (options.indexOf("k") >= 0) {
                mask |= 8;
            }
            if (options.indexOf("u") >= 0) {
                mask |= 0x10;
            }
            if (options.indexOf("e") >= 0) {
                mask |= 0x100;
            }
            if (options.indexOf("w") >= 0) {
                mask |= 0x200;
            }
            if (options.indexOf("s") >= 0) {
                mask |= 0x400;
            }
            if (options.indexOf("n") >= 0) {
                mask |= 0x800;
            }
            if (options.indexOf("x") >= 0) {
                mask |= 0x1000;
            }
            if (options.indexOf("g") >= 0) {
                mask |= 0x10000;
            }
            if (options.indexOf("#") >= 0) {
                mask |= 0x20000;
            }
            if (!(validateOK = DBAdmin.validateTableColumns(mask, utableName))) {
                return DBAdminExec.ERROR;
            }
        }
        if (RTConfig.hasProperty(ARG_VALIDATE)) {
            ++execCmd;
            String validateTable = RTConfig.getString(ARG_VALIDATE, null);
            if (validateTable != null) {
                boolean inclWarn = true;
                if (validateTable.startsWith("/")) {
                    inclWarn = false;
                    validateTable = validateTable.substring(1);
                }
                Print.logInfo("Validating tables", new Object[0]);
                DBAdmin.validateTables(validateTable, inclWarn);
            }
        }
        if (RTConfig.hasProperty(ARG_LAST)) {
            ++execCmd;
            Print.logInfo("Table last update time:", new Object[0]);
            OrderedMap<String, DBFactory<? extends DBRecord>> factMap = DBAdmin.getTableFactoryMap();
            Iterator<String> i = factMap.keyIterator();
            while (i.hasNext()) {
                String tn = i.next();
                DBFactory<? extends DBRecord> f = factMap.get(tn);
                try {
                    long lut = DBRecord.getLastUpdateTime(f);
                    if (lut < 0L) {
                        Print.logInfo("  Last Table Update: " + tn + " - Not Available", new Object[0]);
                        continue;
                    }
                    if (lut == 0L) {
                        Print.logInfo("  Last Table Update: " + tn + " - No Data", new Object[0]);
                        continue;
                    }
                    Print.logInfo("  Last Table Update: " + tn + " - " + new DateTime(lut), new Object[0]);
                }
                catch (DBException dbe) {
                    Print.logError("  Last Table Update: " + tn + " - DB Error [" + dbe + "]", new Object[0]);
                }
            }
        }
        if (RTConfig.hasProperty(ARG_SCHEMA)) {
            ++execCmd;
            String schemaTable = RTConfig.getString(ARG_SCHEMA, null);
            DBAdmin.printTableSchema(95, null, schemaTable);
        }
        if (RTConfig.hasProperty(ARG_BEAN)) {
            ++execCmd;
            String table = RTConfig.getString(ARG_BEAN, null);
            if (table != null) {
                OrderedMap<String, DBFactory<? extends DBRecord>> factMap = DBAdmin.getTableFactoryMap();
                DBFactory<? extends DBRecord> f = DBAdmin._getTableFactory(table);
                if (f != null) {
                    f.validateTableBeanMethods();
                } else {
                    Print.logError("Table not found: " + table, new Object[0]);
                }
            }
        }
        return execCmd > 0 ? DBAdminExec.OK : DBAdminExec.NONE;
    }

    public static void main(String[] argv) {
        RTConfig.setCommandLineArgs(argv);
        DBAdminExec rtn = DBAdmin.execCommands();
        if (rtn.equals((Object)DBAdminExec.ERROR)) {
            System.exit(2);
        } else if (rtn.equals((Object)DBAdminExec.WARN)) {
            System.exit(1);
        }
    }

    public static enum DBAdminExec {
        NONE,
        OK,
        EXIT,
        WARN,
        ERROR;

    }
}

