/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.servers.tzavl05;

import java.net.BindException;
import java.net.DatagramSocket;
import java.util.Map;
import org.opengts.db.DCServerConfig;
import org.opengts.opt.servers.tzavl05.Constants;
import org.opengts.opt.servers.tzavl05.Main;
import org.opengts.opt.servers.tzavl05.TrackClientPacketHandler;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.Print;
import org.opengts.util.ServerSocketThread;

public class TrackServer {
    private static TrackServer trackTcpInstance = null;
    private static long tcpTimeout_idle = 10000L;
    private static long tcpTimeout_packet = 4000L;
    private static long tcpTimeout_session = 15000L;
    private static long udpTimeout_idle = 5000L;
    private static long udpTimeout_packet = 4000L;
    private static long udpTimeout_session = 60000L;
    private Map<Integer, ServerSocketThread> tcpThread = null;
    private Map<Integer, ServerSocketThread> udpThread = null;
    private OrderedMap<Integer, DatagramSocket> udpSocket = null;
    private ServerSocketThread cmdThread = null;

    public static void configInit() {
        DCServerConfig dCServerConfig = Main.getServerConfig();
        if (dCServerConfig != null) {
            TrackServer.setTcpIdleTimeout(dCServerConfig.getTcpIdleTimeoutMS(10000L));
            TrackServer.setTcpPacketTimeout(dCServerConfig.getTcpPacketTimeoutMS(4000L));
            TrackServer.setTcpSessionTimeout(dCServerConfig.getTcpSessionTimeoutMS(15000L));
            TrackServer.setUdpIdleTimeout(dCServerConfig.getUdpIdleTimeoutMS(5000L));
            TrackServer.setUdpPacketTimeout(dCServerConfig.getUdpPacketTimeoutMS(4000L));
            TrackServer.setUdpSessionTimeout(dCServerConfig.getUdpSessionTimeoutMS(60000L));
        }
    }

    public static TrackServer startTrackServer(int[] nArray, int[] nArray2, int n) throws Throwable {
        if (trackTcpInstance == null) {
            trackTcpInstance = new TrackServer(nArray, nArray2, n);
        }
        return trackTcpInstance;
    }

    public static void setTcpIdleTimeout(long l) {
        tcpTimeout_idle = l;
    }

    public static long getTcpIdleTimeout() {
        return tcpTimeout_idle;
    }

    public static void setTcpPacketTimeout(long l) {
        tcpTimeout_packet = l;
    }

    public static long getTcpPacketTimeout() {
        return tcpTimeout_packet;
    }

    public static void setTcpSessionTimeout(long l) {
        tcpTimeout_session = l;
    }

    public static long getTcpSessionTimeout() {
        return tcpTimeout_session;
    }

    public static void setUdpIdleTimeout(long l) {
        udpTimeout_idle = l;
    }

    public static long getUdpIdleTimeout() {
        return udpTimeout_idle;
    }

    public static void setUdpPacketTimeout(long l) {
        udpTimeout_packet = l;
    }

    public static long getUdpPacketTimeout() {
        return udpTimeout_packet;
    }

    public static void setUdpSessionTimeout(long l) {
        udpTimeout_session = l;
    }

    public static long getUdpSessionTimeout() {
        return udpTimeout_session;
    }

    private TrackServer(int[] nArray, int[] nArray2, int n) throws Throwable {
        ServerSocketThread serverSocketThread;
        int n2;
        int n3;
        int n4 = 0;
        if (!ListTools.isEmpty(nArray)) {
            this.tcpThread = new OrderedMap<Integer, ServerSocketThread>();
            for (n3 = 0; n3 < nArray.length; ++n3) {
                n2 = nArray[n3];
                if (ServerSocketThread.isValidPort(n2)) {
                    try {
                        serverSocketThread = this._startTCP(n2);
                        this.tcpThread.put(new Integer(n2), serverSocketThread);
                        ++n4;
                    }
                    catch (BindException bindException) {
                        Print.logError("TCP: Error binding to port: %d", n2);
                    }
                    continue;
                }
                throw new Exception("TCP: Invalid port number: " + n2);
            }
        }
        if (!ListTools.isEmpty(nArray2)) {
            this.udpThread = new OrderedMap<Integer, ServerSocketThread>();
            this.udpSocket = new OrderedMap();
            for (n3 = 0; n3 < nArray2.length; ++n3) {
                n2 = nArray2[n3];
                if (ServerSocketThread.isValidPort(n2)) {
                    try {
                        serverSocketThread = this._startUDP(n2);
                        this.udpThread.put(new Integer(n2), serverSocketThread);
                        this.udpSocket.put(new Integer(n2), serverSocketThread.getDatagramSocket());
                        ++n4;
                    }
                    catch (BindException bindException) {
                        Print.logError("UDP: Error binding to port: %d", n2);
                    }
                    continue;
                }
                throw new Exception("UDP: Invalid port number: " + n2);
            }
        }
        if (n4 <= 0) {
            Print.logWarn("No active device communication listeners!", new Object[0]);
        }
    }

    private ServerSocketThread _startTCP(int n) throws Throwable {
        ServerSocketThread serverSocketThread = null;
        try {
            serverSocketThread = Main.getServerConfig().createServerSocketThread_TCP(n);
        }
        catch (Throwable throwable) {
            Print.logException("ServerSocket error", throwable);
            throw throwable;
        }
        serverSocketThread.setTextPackets(false);
        serverSocketThread.setBackspaceChar(null);
        serverSocketThread.setLineTerminatorChar(Constants.ASCII_LINE_TERMINATOR);
        serverSocketThread.setIgnoreChar(Constants.ASCII_IGNORE_CHARS);
        serverSocketThread.setMaximumPacketLength(800);
        serverSocketThread.setMinimumPacketLength(4);
        serverSocketThread.setIdleTimeout(tcpTimeout_idle);
        serverSocketThread.setPacketTimeout(tcpTimeout_packet);
        serverSocketThread.setSessionTimeout(tcpTimeout_session);
        serverSocketThread.setLingerTimeoutSec(3);
        serverSocketThread.setTerminateOnTimeout(true);
        serverSocketThread.setClientPacketHandlerClass(TrackClientPacketHandler.class);
        DCServerConfig.startServerSocketThread(serverSocketThread, "Event");
        return serverSocketThread;
    }

    private ServerSocketThread _startUDP(int n) throws Throwable {
        ServerSocketThread serverSocketThread = null;
        try {
            serverSocketThread = Main.getServerConfig().createServerSocketThread_UDP(n);
        }
        catch (Throwable throwable) {
            Print.logException("ServerSocket error", throwable);
            throw throwable;
        }
        serverSocketThread.setTextPackets(false);
        serverSocketThread.setBackspaceChar(null);
        serverSocketThread.setLineTerminatorChar(Constants.ASCII_LINE_TERMINATOR);
        serverSocketThread.setIgnoreChar(Constants.ASCII_IGNORE_CHARS);
        serverSocketThread.setMaximumPacketLength(800);
        serverSocketThread.setMinimumPacketLength(4);
        serverSocketThread.setIdleTimeout(udpTimeout_idle);
        serverSocketThread.setPacketTimeout(udpTimeout_packet);
        serverSocketThread.setSessionTimeout(udpTimeout_session);
        serverSocketThread.setTerminateOnTimeout(true);
        serverSocketThread.setClientPacketHandlerClass(TrackClientPacketHandler.class);
        DCServerConfig.startServerSocketThread(serverSocketThread, "Event");
        return serverSocketThread;
    }
}

