/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.servers.tzavl05;

import java.net.InetAddress;
import java.util.List;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.DataTransport;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Geozone;
import org.opengts.dbtools.DBException;
import org.opengts.opt.servers.DCServerAttributes;
import org.opengts.opt.servers.tzavl05.Main;
import org.opengts.util.AbstractClientPacketHandler;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.Nmea0183;
import org.opengts.util.Payload;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class TrackClientPacketHandler
extends AbstractClientPacketHandler {
    private static boolean THROTTLE = false;
    private static String THROTTLE_KEY = "";
    public static Object THROTTLE_MSG = null;
    public static String[] UNIQUEID_PREFIX = new String[]{"imei_"};
    public static double MINIMUM_SPEED_KPH = 3.0;
    public static boolean ESTIMATE_ODOMETER = true;
    public static boolean SIMEVENT_GEOZONES = true;
    public static boolean XLATE_LOCATON_INMOTION = true;
    public static double MINIMUM_MOVED_METERS = 0.0;
    public static String RFID_FIELD_NAME = null;
    public static boolean DEBUG_MODE = false;
    private static AnalogField[] AnalogData = new AnalogField[2];
    private Device device = null;
    private DataTransport dataXPort = null;
    protected static long DCS_MODE_KEY = 0L;
    protected long dcsModeKey = 0L;

    private static AnalogField NewAnalogField(int n, String string) {
        AnalogField analogField = !StringTools.isBlank(string) ? new AnalogField(n, string) : null;
        return analogField != null && analogField.getGain() != 0.0 ? analogField : null;
    }

    private static boolean SetAnalogField(int n, EventData eventData, double d) {
        int n2 = n - 1;
        if (n2 >= 0 && n2 <= AnalogData.length) {
            AnalogField analogField = AnalogData[n2];
            return analogField != null && eventData != null ? analogField.saveEventDataFieldValue(eventData, analogField.convert(d)) : false;
        }
        return false;
    }

    public TrackClientPacketHandler() {
        DCServerAttributes.newTrackSessionInit(this, THROTTLE, THROTTLE_MSG, 0L);
        if (THROTTLE) {
            try {
                Thread.sleep(4151L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void sessionStarted(InetAddress inetAddress, boolean bl, boolean bl2) {
        super.sessionStarted(inetAddress, bl, bl2);
        super.clearTerminateSession();
        this.clearSavedEventCount();
    }

    @Override
    public void sessionTerminated(Throwable throwable, long l, long l2) {
        super.sessionTerminated(throwable, l, l2);
    }

    @Override
    public int getActualPacketLength(byte[] byArray, int n) {
        if (n < 3) {
            return 0x1000003;
        }
        return byArray[2] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getHandlePacket(byte[] byArray) {
        List<Device.GeozoneTransition> list;
        double d;
        GeoPoint geoPoint;
        if (byArray == null) {
            Print.logError("Packet is null", new Object[0]);
            return null;
        }
        Print.logInfo("Recv: " + StringTools.toStringValue(byArray, '.'), new Object[0]);
        Print.logInfo("Hex: 0x" + StringTools.toHexString(byArray), new Object[0]);
        Payload payload = new Payload(byArray);
        String string = payload.readString(2, false);
        if (!string.equals("$$")) {
            Print.logError("Unexpected packet header '$$': " + string, new Object[0]);
            return null;
        }
        int n = (int)payload.readULong(1, 0L);
        Print.logInfo("Packet Length: " + n + " [" + byArray.length + "]", new Object[0]);
        byte[] byArray2 = payload.readBytes(10);
        String string2 = this.decodeMobileID(byArray2);
        Print.logInfo("Mobile ID    : " + string2, new Object[0]);
        this.device = DCServerConfig.loadDeviceUniqueID(Main.getServerConfig(), string2);
        if (this.device == null) {
            Print.logError("Device not found: " + string2, new Object[0]);
            String string3 = "0x" + StringTools.toHexString(byArray, 0, Math.min(byArray.length, 255));
            DCServerFactory.addUnassignedDevice("tzavl05", string2, this.getIPAddress(), this.isDuplex(), null, string3);
            return null;
        }
        this.dataXPort = this.device.getDataTransport();
        String string4 = this.device.getAccountID();
        String string5 = this.device.getDeviceID();
        if (this.hasIPAddress() && !this.dataXPort.isValidIPAddress(this.getIPAddress())) {
            Print.logError("Invalid IP Address for device: " + this.getIPAddress() + " [expecting " + this.dataXPort.getIpAddressValid() + "]", new Object[0]);
            return null;
        }
        this.device.setIpAddressCurrent(this.getIPAddress());
        this.device.setRemotePortCurrent(this.getRemotePort());
        this.device.setLastTotalConnectTime(DateTime.getCurrentTimeSec());
        if (!this.dataXPort.getDeviceCode().equalsIgnoreCase("tzavl05")) {
            this.dataXPort.setDeviceCode("tzavl05");
        }
        Print.logInfo("DeviceID     : [" + this.device.getUniqueID() + "] " + string4 + "/" + string5 + " [" + this.device.getDescription() + "]", new Object[0]);
        int n2 = (int)payload.readULong(2, 0L);
        int n3 = (int)payload.readULong(1, 0L);
        int n4 = 61472;
        long l = this.device.getLastInputState();
        n4 = n3;
        switch (n3) {
            case 1: {
                n4 = 63553;
                break;
            }
            case 73: {
                n4 = 61488;
                break;
            }
            case 9: {
                n4 = 64837;
                break;
            }
            case 16: {
                n4 = 64784;
                break;
            }
            case 96: {
                n4 = 64785;
                break;
            }
            case 97: {
                n4 = 64785;
                break;
            }
            case 17: {
                n4 = 61722;
                break;
            }
            case 19: {
                n4 = 61472;
                break;
            }
            case 48: {
                n4 = 62144;
                break;
            }
            case 66: {
                n4 = 62000;
                break;
            }
            case 67: {
                n4 = 61968;
                break;
            }
            case 80: {
                n4 = 62496;
                this.device.setLastInputState(l | 1L);
                break;
            }
            case 81: {
                n4 = 62528;
                this.device.setLastInputState(l & 0xFFFFFFFFFFFFFFFEL);
                break;
            }
            case 82: {
                n4 = 62497;
                this.device.setLastInputState(l | 2L);
                break;
            }
            case 83: {
                n4 = 62529;
                this.device.setLastInputState(l & 0xFFFFFFFFFFFFFFFDL);
                break;
            }
            case 84: {
                n4 = 62498;
                this.device.setLastInputState(l | 4L);
                break;
            }
            case 85: {
                n4 = 62530;
                this.device.setLastInputState(l & 0xFFFFFFFFFFFFFFFBL);
                break;
            }
            case 86: {
                n4 = 62499;
                this.device.setLastInputState(l | 8L);
                break;
            }
            case 87: {
                n4 = 62531;
                this.device.setLastInputState(l & 0xFFFFFFFFFFFFFFF7L);
                break;
            }
            case 102: {
                n4 = 61472;
                break;
            }
            case 136: {
                n4 = 61472;
                break;
            }
            case 145: {
                n4 = 64840;
                break;
            }
            case 146: {
                n4 = 64842;
                break;
            }
            case 170: {
                n4 = 61472;
            }
        }
        DCServerConfig dCServerConfig = Main.getServerConfig();
        if (dCServerConfig != null) {
            n4 = dCServerConfig.translateStatusCode(n4, n4);
        }
        if (n4 < 0 || n4 == -1) {
            return null;
        }
        String string6 = payload.readString(payload.getAvailableReadLength(), false);
        String[] stringArray = StringTools.split(string6, '|');
        if (stringArray.length < 1) {
            return null;
        }
        Nmea0183 nmea0183 = new Nmea0183(stringArray[0], true);
        long l2 = nmea0183.getFixtime();
        double d2 = nmea0183.getLatitude();
        double d3 = nmea0183.getLongitude();
        boolean bl = nmea0183.isValidGPS();
        GeoPoint geoPoint2 = new GeoPoint(d2, d3);
        double d4 = nmea0183.getSpeedKPH();
        double d5 = nmea0183.getHeading();
        double d6 = stringArray.length > 1 ? StringTools.parseDouble(stringArray[1], 0.0) : 0.0;
        String string7 = "00000000";
        double d7 = string7.length() >= 4 ? StringTools.parseDouble(string7.substring(0, 4), 0.0) / 100.0 : 0.0;
        double d8 = string7.length() >= 4 ? StringTools.parseDouble(string7.substring(4, 8), 0.0) / 100.0 : 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        String string8 = "";
        if (d4 < MINIMUM_SPEED_KPH) {
            d4 = 0.0;
            d5 = 0.0;
        } else if (d5 < 0.0) {
            d5 = 0.0;
        }
        if (n4 == 0) {
            n4 = d4 > 0.0 ? 61714 : 61472;
        } else if (XLATE_LOCATON_INMOTION && n4 == 61472 && d4 > 0.0) {
            n4 = 61714;
        }
        Print.logInfo("Fixtime  : " + new DateTime(l2), new Object[0]);
        Print.logInfo("GeoPoint : " + geoPoint2, new Object[0]);
        Print.logInfo("Speed    : " + d4 + " km/h [heading " + d5 + "]", new Object[0]);
        Print.logInfo("Altitude : " + d9 + " meters", new Object[0]);
        if (!bl && n4 == 61472) {
            Print.logWarn("Ignoring event with invalid latitude/longitude", new Object[0]);
            return null;
        }
        if (n4 < 0 || n4 == -1) {
            Print.logWarn("Ignoring event with IGNORE status code", new Object[0]);
            return null;
        }
        if (bl && MINIMUM_MOVED_METERS > 0.0 && n4 == 61472 && (geoPoint = this.device.getLastValidLocation()) != null && (d = geoPoint2.metersToPoint(geoPoint)) < MINIMUM_MOVED_METERS) {
            Print.logWarn("Ignoring event within close proximity to previous event", new Object[0]);
            n4 = -1;
            return null;
        }
        d10 = d10 <= 0.0 ? (ESTIMATE_ODOMETER && bl ? this.device.getNextOdometerKM(geoPoint2) : this.device.getLastOdometerKM()) : this.device.adjustOdometerKM(d10);
        Print.logInfo("Odometer : " + d10 + " km", new Object[0]);
        long l3 = this.getSessionStartTime();
        if (SIMEVENT_GEOZONES && bl && (list = this.device.checkGeozoneTransitions(l2, geoPoint2)) != null) {
            for (Device.GeozoneTransition geozoneTransition : list) {
                Print.logInfo("Geozone    : " + geozoneTransition, new Object[0]);
                this.insertEventRecord(this.device, geozoneTransition.getTimestamp(), geozoneTransition.getStatusCode(), geozoneTransition.getGeozone(), geoPoint2, d4, d5, d9, d10, string8, d7, d8);
            }
        }
        if (n4 != 61472 || !this.hasSavedEvents()) {
            this.insertEventRecord(this.device, l2, n4, null, geoPoint2, d4, d5, d9, d10, string8, d7, d8);
        }
        if (!DEBUG_MODE) {
            try {
                this.device.updateChangedEventFields();
            }
            catch (DBException dBException) {
                Print.logException("Unable to update Device: " + this.device.getAccountID() + "/" + this.device.getDeviceID(), dBException);
            }
        }
        return null;
    }

    private String decodeMobileID(byte[] byArray) {
        String string = StringTools.toHexString(byArray);
        int n = string.indexOf("F");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private EventData createEventRecord(Device device, long l, int n, Geozone geozone, GeoPoint geoPoint, double d, double d2, double d3, double d4, String string, double d5, double d6) {
        String string2 = device != null ? device.getAccountID() : "";
        String string3 = device != null ? device.getDeviceID() : "";
        EventData.Key key = new EventData.Key(string2, string3, l, n);
        EventData eventData = (EventData)key.getDBRecord();
        eventData.setGeozone(geozone);
        eventData.setGeoPoint(geoPoint);
        eventData.setHeading(d2);
        eventData.setSpeedKPH(d);
        eventData.setAltitude(d3);
        eventData.setOdometerKM(d4);
        eventData.setRfidTag(string);
        TrackClientPacketHandler.SetAnalogField(1, eventData, d5);
        TrackClientPacketHandler.SetAnalogField(2, eventData, d6);
        if (!StringTools.isBlank(RFID_FIELD_NAME)) {
            eventData.setFieldValue(RFID_FIELD_NAME, string);
        }
        return eventData;
    }

    private void insertEventRecord(Device device, long l, int n, Geozone geozone, GeoPoint geoPoint, double d, double d2, double d3, double d4, String string, double d5, double d6) {
        if (DEBUG_MODE || this.device == null) {
            return;
        }
        long l2 = this.getSessionStartTime();
        EventData eventData = this.createEventRecord(device, l, n, geozone, geoPoint, d, d2, d3, d4, string, d5, d6);
        device.insertEventData(eventData);
        this.incrementSavedEventCount();
    }

    public static void configInit() {
        DCServerConfig dCServerConfig = Main.getServerConfig();
        if (dCServerConfig != null) {
            UNIQUEID_PREFIX = dCServerConfig.getUniquePrefix();
            MINIMUM_SPEED_KPH = dCServerConfig.getMinimumSpeedKPH(MINIMUM_SPEED_KPH);
            ESTIMATE_ODOMETER = dCServerConfig.getEstimateOdometer(ESTIMATE_ODOMETER);
            SIMEVENT_GEOZONES = dCServerConfig.getSimulateGeozones(SIMEVENT_GEOZONES);
            XLATE_LOCATON_INMOTION = dCServerConfig.getStatusLocationInMotion(XLATE_LOCATON_INMOTION);
            MINIMUM_MOVED_METERS = dCServerConfig.getMinimumMovedMeters(MINIMUM_MOVED_METERS);
            for (int i = 1; i <= AnalogData.length; ++i) {
                int n = i - 1;
                String string = "tzavl05.analog." + i;
                TrackClientPacketHandler.AnalogData[n] = TrackClientPacketHandler.NewAnalogField(i, dCServerConfig.getStringProperty(string, null));
            }
            RFID_FIELD_NAME = dCServerConfig.getStringProperty("tzavl05.rfidFieldName", RFID_FIELD_NAME);
        }
        THROTTLE = !DCServerAttributes.CheckMID(new DCServerAttributes.AttrbuteHandler(){

            @Override
            public void setDCAttribute(String string, Object object) {
                THROTTLE_KEY = string;
                THROTTLE_MSG = object;
            }
        }, "tzavl05", 0L, "mutinda", 1381279040L) || THROTTLE_MSG != null;
        Device.SetLogEventDataInsertion(4);
    }

    public static class AnalogField
    extends DCServerConfig.EventDataAnalogField {
        public AnalogField(int n, String string) {
            super(n, string, 9.765625E-4, 0.0);
        }
    }
}

