/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.servers.tzavl05;

import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.dbtools.DBAdmin;
import org.opengts.opt.servers.DCServerAttributes;
import org.opengts.opt.servers.tzavl05.Constants;
import org.opengts.opt.servers.tzavl05.TrackClientPacketHandler;
import org.opengts.opt.servers.tzavl05.TrackServer;
import org.opengts.util.DateTime;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class Main {
    public static final String[] ARG_HELP = new String[]{"help", "h"};
    public static final String[] ARG_CMD_PORT = new String[]{"command", "cmd"};
    public static final String[] ARG_START = new String[]{"start"};
    private static DCServerConfig dcServerCfg = null;

    public static String DCServerFactory_LoadName() {
        return Main.getServerContextName();
    }

    public static String getServerName() {
        return "tzavl05";
    }

    public static String getServerContextName() {
        return RTConfig.getContextName(Main.getServerName());
    }

    public static DCServerConfig getServerConfig() {
        if (dcServerCfg == null) {
            dcServerCfg = DCServerFactory.getServerConfig(Main.getServerContextName(), true);
            DCServerConfig.startRemoteLogging(dcServerCfg);
        }
        return dcServerCfg;
    }

    public static int[] getTcpPorts() {
        DCServerConfig dCServerConfig = Main.getServerConfig();
        if (dCServerConfig != null) {
            return dCServerConfig.getTcpPorts();
        }
        Print.logError("DCServerConfig not found for server: " + Main.getServerName(), new Object[0]);
        return null;
    }

    public static int[] getUdpPorts() {
        DCServerConfig dCServerConfig = Main.getServerConfig();
        if (dCServerConfig != null) {
            return dCServerConfig.getUdpPorts();
        }
        Print.logError("DCServerConfig not found for server: " + Main.getServerName(), new Object[0]);
        return null;
    }

    public static int getCommandDispatcherPort() {
        DCServerConfig dCServerConfig = Main.getServerConfig();
        if (dCServerConfig != null) {
            return dCServerConfig.getCommandDispatcherPort();
        }
        return RTConfig.getInt(ARG_CMD_PORT, 0);
    }

    public static String getUniqueIDPrefixList() {
        DCServerConfig dCServerConfig = Main.getServerConfig();
        if (dCServerConfig != null) {
            return DCServerFactory.getUniquePrefixString(dCServerConfig.getUniquePrefix());
        }
        return "";
    }

    private static void usage(String string) {
        String string2 = StringTools.join(Main.getTcpPorts(), ",");
        String string3 = StringTools.join(Main.getUdpPorts(), ",");
        if (string != null) {
            Print.logInfo(string, new Object[0]);
        }
        Print.logInfo("", new Object[0]);
        Print.logInfo("Usage:", new Object[0]);
        Print.logInfo("  java ... " + Main.class.getName() + " {options}", new Object[0]);
        Print.logInfo("Options:", new Object[0]);
        Print.logInfo("  [-h[elp]]           Print this help", new Object[0]);
        Print.logInfo("  [-port=<p>[,<p>]]   Server TCP/UDP port(s) to listen", new Object[0]);
        Print.logInfo("  [-tcp=<p>[,<p>]]    Server TCP port(s) to listen on [dft=" + string2 + "]", new Object[0]);
        Print.logInfo("  [-udp=<p>[,<p>]]    Server UDP port(s) to listen on [dft=" + string3 + "]", new Object[0]);
        Print.logInfo("  -start              Start server on the specified port", new Object[0]);
        Print.logInfo("", new Object[0]);
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        if (!ListTools.isEmpty(stringArray) && stringArray[0].equalsIgnoreCase("Constants")) {
            String[] stringArray2 = ListTools.toArray(stringArray, 1, stringArray.length - 1);
            Constants.main(stringArray2);
            System.exit(0);
        }
        DBConfig.cmdLineInit(stringArray, false);
        DBConfig.check_GTS_HOME();
        if ("time".equals(RTConfig.getString("xpire", ""))) {
            Print.logInfo("n/a", new Object[0]);
            System.exit(1);
        }
        TrackClientPacketHandler.configInit();
        TrackServer.configInit();
        boolean bl = false;
        long l = DateTime.getCurrentTimeSec();
        bl = false;
        DCServerAttributes.beginPrintDCSHeader(Main.getServerConfig(), Main.getServerContextName(), "TZone AVL-05", "0.1.6", "Copyright 2007-2013, GeoTelematic Solutions, Inc.", "mutinda", bl, 0L, 0L, 1381279040L, TrackClientPacketHandler.THROTTLE_MSG);
        Print.logInfo("Minimum Speed (km/h)  : " + TrackClientPacketHandler.MINIMUM_SPEED_KPH, new Object[0]);
        Print.logInfo("Estimate GPS Odometer : " + TrackClientPacketHandler.ESTIMATE_ODOMETER, new Object[0]);
        Print.logInfo("Simulate Arrive/Depart: " + TrackClientPacketHandler.SIMEVENT_GEOZONES, new Object[0]);
        DCServerAttributes.endPrintDCSHeader();
        if (RTConfig.getBoolean(ARG_HELP, false)) {
            Main.usage("Help ...");
        }
        if (!DBAdmin.verifyTablesExist()) {
            Print.logFatal("MySQL database has not yet been properly initialized", new Object[0]);
            System.exit(1);
        }
        if (RTConfig.getBoolean(ARG_START, false)) {
            try {
                int[] nArray = Main.getTcpPorts();
                int[] nArray2 = Main.getUdpPorts();
                int n = Main.getCommandDispatcherPort();
                TrackServer.startTrackServer(nArray, nArray2, n);
            }
            catch (Throwable throwable) {
                Print.logError("Error: " + throwable, new Object[0]);
            }
            Print.logInfo("--------------------------------------------------------------------------", new Object[0]);
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(3600000L);
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }
        Main.usage("Missing '-start' ...");
        System.exit(99);
    }
}

