/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.servers;

import java.net.BindException;
import java.net.DatagramSocket;
import org.opengts.Version;
import org.opengts.db.CommandPacketHandler;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.RuleFactory;
import org.opengts.db.tables.Device;
import org.opengts.util.ClientPacketHandler;
import org.opengts.util.DateTime;
import org.opengts.util.ListTools;
import org.opengts.util.MethodAction;
import org.opengts.util.OrderedMap;
import org.opengts.util.PosixSignalHandler;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.ServerSocketThread;
import org.opengts.util.StringTools;

public abstract class TrackServerAdapter {
    public static boolean TEST_MODE = false;
    public static final long TIMEOUT_TCP_IDLE = 10000L;
    public static final long TIMEOUT_TCP_PACKET = 4000L;
    public static final long TIMEOUT_TCP_SESSION = 15000L;
    public static final long TIMEOUT_UDP_IDLE = 1000L;
    public static final long TIMEOUT_UDP_PACKET = 1000L;
    public static final long TIMEOUT_UDP_SESSION = 2000L;
    public static final int LINGER_ON_CLOSE_SEC = 3;
    public static final String SEP_DASH = "--------------------------------------------------------------------------";
    public static final String SEP_EQUAL = "==========================================================================";
    public static final String SEP_STAR = "**************************************************************************";
    public static final String SEP = "--------------------------------------------------------------------------";
    private static int lastPrintIncludeStackFrameState = -1;
    public static final long SHUTDOWN_TIMEOUT = 4000L;
    public static final String[] SHUTDOWN_SIGNALS = new String[]{"SIGTERM"};
    private static TrackServerAdapter trackServerInstance = null;
    private DCServerConfig dcsConfig = null;
    private OrderedMap<Integer, ServerSocketThread> tcpThread = null;
    private OrderedMap<Integer, ServerSocketThread> udpThread = null;
    private OrderedMap<Integer, DatagramSocket> udpSocket = null;
    private ServerSocketThread cmdThread = null;

    public static void Log(String string, int n, String string2) {
        int n2 = n < 20 ? 20 : n;
        String string3 = StringTools.leftAlign(string, n2);
        Print.logInfo(string3 + ": " + string2, new Object[0]);
    }

    public static void PrintHeaderLogs(DCServerConfig dCServerConfig, int n) {
        if (dCServerConfig != null) {
            String string = TrackServerAdapter.getUniqueIDPrefixString(dCServerConfig);
            if (!StringTools.isBlank(string)) {
                TrackServerAdapter.Log("Unique-ID Prefix(s)", n, TrackServerAdapter.getUniqueIDPrefixString(dCServerConfig));
            }
            if (!RTConfig.isWebApp()) {
                TrackServerAdapter.Log("TCP Timeouts [ms]", n, "Idle=" + TrackServerAdapter.getTcpIdleTimeoutMS(dCServerConfig) + ", Packet=" + TrackServerAdapter.getTcpPacketTimeoutMS(dCServerConfig) + ", Session=" + TrackServerAdapter.getTcpSessionTimeoutMS(dCServerConfig));
                TrackServerAdapter.Log("UDP Timeouts [ms]", n, "Idle=" + TrackServerAdapter.getUdpIdleTimeoutMS(dCServerConfig) + ", Packet=" + TrackServerAdapter.getUdpPacketTimeoutMS(dCServerConfig) + ", Session=" + TrackServerAdapter.getUdpSessionTimeoutMS(dCServerConfig));
            }
        }
    }

    public static boolean beginPrintDCSHeader(DCServerConfig dCServerConfig, String string, String string2, String string3) {
        lastPrintIncludeStackFrameState = Print.setIncludeStackFrame(0);
        long l = 1381279040L;
        String string4 = "Copyright 2007-2013, GeoTelematic Solutions, Inc.";
        String string5 = StringTools.trim(RTConfig.getString("ServiceAccount.ID", ""));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string3);
        stringBuffer.append(", ");
        stringBuffer.append(l).append(" [").append(new DateTime(l).toString()).append("] S");
        String string6 = "n/a";
        RuleFactory ruleFactory = Device.getRuleFactory();
        if (ruleFactory != null) {
            string6 = ruleFactory.getVersion() + " (" + ruleFactory.getName() + ")";
        }
        int n = 20;
        Print.logInfo("--------------------------------------------------------------------------", new Object[0]);
        Print.logInfo("[" + string + "] " + string2, new Object[0]);
        Print.logInfo(string4, new Object[0]);
        TrackServerAdapter.Log("Service ID", n, string5);
        TrackServerAdapter.Log("GTS Version", n, Version.getVersion());
        TrackServerAdapter.Log("DCS Version", n, stringBuffer.toString());
        TrackServerAdapter.Log("Rule Version", n, string6);
        TrackServerAdapter.Log("Jar File", n, RTConfig.getString("%mainJar", "?"));
        TrackServerAdapter.Log("GTS_HOME", n, StringTools.trim(DBConfig.get_GTS_HOME()));
        TrackServerAdapter.PrintHeaderLogs(dCServerConfig, n);
        Print.logInfo("--------------------------------------------------------------------------", new Object[0]);
        return true;
    }

    public static void endPrintDCSHeader() {
        Print.logInfo("--------------------------------------------------------------------------", new Object[0]);
        Print.setIncludeStackFrame(lastPrintIncludeStackFrameState);
    }

    public static String[] getShutdownSignals(DCServerConfig dCServerConfig) {
        return SHUTDOWN_SIGNALS;
    }

    public String[] getShutdownSignals() {
        return TrackServerAdapter.getShutdownSignals(this.dcsConfig);
    }

    public static long getShutdownTimeoutMS(DCServerConfig dCServerConfig) {
        return 4000L;
    }

    public long getShutdownTimeoutMS() {
        return TrackServerAdapter.getShutdownTimeoutMS(this.dcsConfig);
    }

    public Class<? extends ClientPacketHandler> getClientPacketHandler(Class<? extends ClientPacketHandler> clazz) {
        DCServerConfig dCServerConfig = this.getDCServerConfig();
        if (dCServerConfig != null) {
            return dCServerConfig.getClientPacketHandlerClass(clazz);
        }
        return clazz;
    }

    public static boolean startTrackServer(DCServerConfig dCServerConfig, Class<?> clazz, Class<? extends CommandPacketHandler> clazz2, boolean bl) {
        String[] stringArray;
        if (dCServerConfig != null) {
            clazz = dCServerConfig.getTrackServerAdapterClass(TrackServerAdapter.class, clazz);
            clazz2 = dCServerConfig.getCommandPacketHandlerClass(clazz2);
        }
        if (clazz == null) {
            Print.logError("Specified TrackServer class is null", new Object[0]);
            return false;
        }
        int n = Print.setIncludeStackFrame(0);
        if (trackServerInstance == null) {
            try {
                stringArray = new MethodAction(clazz, DCServerConfig.class, Class.class);
                trackServerInstance = (TrackServerAdapter)stringArray.invoke(dCServerConfig, clazz2);
            }
            catch (Throwable throwable) {
                Print.setIncludeStackFrame(n);
                Print.logException("Unable to create TrackServer subclass: " + clazz, throwable);
                return false;
            }
        }
        if (!bl) {
            Print.setIncludeStackFrame(n);
            return true;
        }
        Print.logInfo("--------------------------------------------------------------------------", new Object[0]);
        Print.setIncludeStackFrame(n);
        try {
            stringArray = trackServerInstance.getShutdownSignals();
            long l = trackServerInstance.getShutdownTimeoutMS();
            new ShutdownHandler(stringArray, l);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Print.logException("Unable to install Signal Handler", illegalArgumentException);
        }
        TrackServerAdapter.sleepWaitForever();
        throw new RuntimeException("Control should never reach here");
    }

    public static void sleepWaitForever() {
        long l = DateTime.MinuteSeconds(60L);
        while (true) {
            try {
                while (true) {
                    Thread.sleep(l);
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    public static TrackServerAdapter getInstance() {
        return trackServerInstance;
    }

    public TrackServerAdapter(DCServerConfig dCServerConfig, Class<?> clazz) throws Throwable {
        int[] nArray;
        int n;
        int[] nArray2;
        int n2 = 0;
        this.dcsConfig = dCServerConfig;
        if (this.dcsConfig == null && !TEST_MODE) {
            Print.logWarn("Missing DCServerConfig instance (additional errors may follow)", new Object[0]);
            return;
        }
        if (TEST_MODE) {
            Print.logWarn("Running in test-mode, listeners will not be started", new Object[0]);
            return;
        }
        int[] nArray3 = nArray2 = this.dcsConfig != null ? this.dcsConfig.getTcpPorts() : null;
        if (!ListTools.isEmpty(nArray2)) {
            this.tcpThread = new OrderedMap();
            for (int i = 0; i < nArray2.length; ++i) {
                n = nArray2[i];
                if (ServerSocketThread.isValidPort(n)) {
                    try {
                        ServerSocketThread serverSocketThread = this._startTCP(n);
                        this.tcpThread.put(new Integer(n), serverSocketThread);
                        ++n2;
                    }
                    catch (BindException bindException) {
                        Print.logError("TCP: Error binding to port: %d", n);
                    }
                    continue;
                }
                throw new Exception("TCP: Invalid port number: " + n);
            }
        }
        int[] nArray4 = nArray = this.dcsConfig != null ? this.dcsConfig.getUdpPorts() : null;
        if (!ListTools.isEmpty(nArray)) {
            this.udpThread = new OrderedMap();
            this.udpSocket = new OrderedMap();
            for (n = 0; n < nArray.length; ++n) {
                int n3 = nArray[n];
                if (ServerSocketThread.isValidPort(n3)) {
                    try {
                        ServerSocketThread serverSocketThread = this._startUDP(n3);
                        this.udpThread.put(new Integer(n3), serverSocketThread);
                        this.udpSocket.put(new Integer(n3), serverSocketThread.getDatagramSocket());
                        ++n2;
                    }
                    catch (BindException bindException) {
                        Print.logError("UDP: Error binding to port: %d", n3);
                    }
                    continue;
                }
                throw new Exception("UDP: Invalid port number: " + n3);
            }
        }
        if (n2 <= 0) {
            Print.logWarn("No active device communication listeners!", new Object[0]);
        }
        int n4 = n = this.dcsConfig != null ? this.dcsConfig.getCommandDispatcherPort() : 0;
        if (n > 0) {
            if (clazz == null) {
                Print.logError("Command: Command port specified, but CommandListener is null", new Object[0]);
            } else {
                if (!ServerSocketThread.isValidPort(n)) {
                    throw new Exception("Command: Invalid port number: " + n);
                }
                try {
                    this._startCommand(n, clazz);
                }
                catch (BindException bindException) {
                    Print.logError("Command: Error binding to port: %d", n);
                }
            }
        }
    }

    public DCServerConfig getDCServerConfig() {
        return this.dcsConfig;
    }

    public static String getUniqueIDPrefixString(DCServerConfig dCServerConfig) {
        return dCServerConfig != null ? DCServerFactory.getUniquePrefixString(dCServerConfig.getUniquePrefix()) : "";
    }

    public String getUniqueIDPrefixString() {
        return TrackServerAdapter.getUniqueIDPrefixString(this.dcsConfig);
    }

    public static int getCommandDispatcherPort(DCServerConfig dCServerConfig) {
        return dCServerConfig != null ? dCServerConfig.getCommandDispatcherPort() : 0;
    }

    public int getCommandDispatcherPort() {
        return TrackServerAdapter.getCommandDispatcherPort(this.dcsConfig);
    }

    public static int[] getTcpPorts(DCServerConfig dCServerConfig) {
        return dCServerConfig != null ? dCServerConfig.getTcpPorts() : null;
    }

    public static String getTcpPortsString(DCServerConfig dCServerConfig) {
        return dCServerConfig != null ? StringTools.join(dCServerConfig.getTcpPorts(), ",") : "";
    }

    public int[] getTcpPorts() {
        return TrackServerAdapter.getTcpPorts(this.dcsConfig);
    }

    public static long getTcpIdleTimeoutMS(DCServerConfig dCServerConfig) {
        return dCServerConfig != null ? dCServerConfig.getTcpIdleTimeoutMS(10000L) : 10000L;
    }

    public long getTcpIdleTimeoutMS() {
        return TrackServerAdapter.getTcpIdleTimeoutMS(this.dcsConfig);
    }

    public static long getTcpPacketTimeoutMS(DCServerConfig dCServerConfig) {
        return dCServerConfig != null ? dCServerConfig.getTcpPacketTimeoutMS(4000L) : 4000L;
    }

    public long getTcpPacketTimeoutMS() {
        return TrackServerAdapter.getTcpPacketTimeoutMS(this.dcsConfig);
    }

    public static long getTcpSessionTimeoutMS(DCServerConfig dCServerConfig) {
        return dCServerConfig != null ? dCServerConfig.getTcpSessionTimeoutMS(15000L) : 15000L;
    }

    public long getTcpSessionTimeoutMS() {
        return TrackServerAdapter.getTcpSessionTimeoutMS(this.dcsConfig);
    }

    public int getLingerOnCloseSec() {
        return 3;
    }

    public ServerSocketThread getServerSocketThread_tcp(int n) {
        if (ListTools.isEmpty(this.tcpThread)) {
            return null;
        }
        if (n <= 0) {
            return this.tcpThread.getFirstValue();
        }
        ServerSocketThread serverSocketThread = this.tcpThread.get(new Integer(n));
        if (serverSocketThread != null) {
            return serverSocketThread;
        }
        Print.logWarn("TCP 'Listen' port[" + n + "] not found, returning first ServerSocketThread", new Object[0]);
        return this.tcpThread.getFirstValue();
    }

    public static void GetActiveSessionsLog(StringBuffer stringBuffer) {
        if (stringBuffer != null) {
            TrackServerAdapter trackServerAdapter = TrackServerAdapter.getInstance();
            trackServerAdapter.logActiveSessions(stringBuffer);
        }
    }

    public void logActiveSessions(StringBuffer stringBuffer) {
        ServerSocketThread serverSocketThread;
        if (!ListTools.isEmpty(this.tcpThread)) {
            for (Integer n : this.tcpThread.keySet()) {
                serverSocketThread = this.tcpThread.get(n);
                if (serverSocketThread == null) continue;
                serverSocketThread.logActiveSessions("Active TCP Sessions:", stringBuffer);
            }
        }
        if (!ListTools.isEmpty(this.udpThread)) {
            for (Integer n : this.udpThread.keySet()) {
                serverSocketThread = this.udpThread.get(n);
                if (serverSocketThread == null) continue;
                serverSocketThread.logActiveSessions("Active UDP Sessions:", stringBuffer);
            }
        }
    }

    public void logActiveSessions() {
        this.logActiveSessions(null);
    }

    public void sysPrintActiveSessions() {
        StringBuffer stringBuffer = new StringBuffer();
        this.logActiveSessions(stringBuffer);
        Print.sysPrintln(stringBuffer.toString(), new Object[0]);
    }

    protected ServerSocketThread _startTCP(int n) throws Throwable {
        ServerSocketThread serverSocketThread = null;
        try {
            serverSocketThread = this.dcsConfig.createServerSocketThread_TCP(n);
            serverSocketThread.setName("TCPListener_" + n);
        }
        catch (BindException bindException) {
            Print.logException("(TCP) Unable to bind to port [" + n + "]", bindException);
            throw bindException;
        }
        catch (Throwable throwable) {
            Print.logException("(TCP) ServerSocket error [port " + n + "]", throwable);
            throw throwable;
        }
        this.initTCP(serverSocketThread);
        DCServerConfig.startServerSocketThread(serverSocketThread, "Event");
        return serverSocketThread;
    }

    protected ServerSocketThread initTCP(ServerSocketThread serverSocketThread) throws Throwable {
        return serverSocketThread;
    }

    public static int[] getUdpPorts(DCServerConfig dCServerConfig) {
        return dCServerConfig != null ? dCServerConfig.getUdpPorts() : null;
    }

    public static String getUdpPortsString(DCServerConfig dCServerConfig) {
        return dCServerConfig != null ? StringTools.join(dCServerConfig.getUdpPorts(), ",") : "";
    }

    public int[] getUdpPorts() {
        return TrackServerAdapter.getUdpPorts(this.dcsConfig);
    }

    public static long getUdpIdleTimeoutMS(DCServerConfig dCServerConfig) {
        return dCServerConfig != null ? dCServerConfig.getUdpIdleTimeoutMS(1000L) : 1000L;
    }

    public long getUdpIdleTimeoutMS() {
        return TrackServerAdapter.getUdpIdleTimeoutMS(this.dcsConfig);
    }

    public static long getUdpPacketTimeoutMS(DCServerConfig dCServerConfig) {
        return dCServerConfig != null ? dCServerConfig.getUdpPacketTimeoutMS(1000L) : 1000L;
    }

    public long getUdpPacketTimeoutMS() {
        return TrackServerAdapter.getUdpPacketTimeoutMS(this.dcsConfig);
    }

    public static long getUdpSessionTimeoutMS(DCServerConfig dCServerConfig) {
        return dCServerConfig != null ? dCServerConfig.getUdpSessionTimeoutMS(2000L) : 2000L;
    }

    public long getUdpSessionTimeoutMS() {
        return TrackServerAdapter.getUdpSessionTimeoutMS(this.dcsConfig);
    }

    public ServerSocketThread getServerSocketThread_udp(int n) {
        if (ListTools.isEmpty(this.udpThread)) {
            return null;
        }
        if (n <= 0) {
            return this.udpThread.getFirstValue();
        }
        ServerSocketThread serverSocketThread = this.udpThread.get(new Integer(n));
        if (serverSocketThread != null) {
            return serverSocketThread;
        }
        Print.logWarn("UDP 'Listen' port[" + n + "] not found, returning first ServerSocketThread", new Object[0]);
        return this.udpThread.getFirstValue();
    }

    public DatagramSocket getUdpDatagramSocket(int n) {
        if (ListTools.isEmpty(this.udpSocket)) {
            return null;
        }
        if (n <= 0) {
            return this.udpSocket.getFirstValue();
        }
        DatagramSocket datagramSocket = this.udpSocket.get(new Integer(n));
        if (datagramSocket != null) {
            return datagramSocket;
        }
        Print.logWarn("'Listen' port[" + n + "] not found, returning first DatagramSocket", new Object[0]);
        return this.udpSocket.getFirstValue();
    }

    protected ServerSocketThread _startUDP(int n) throws Throwable {
        ServerSocketThread serverSocketThread = null;
        try {
            serverSocketThread = this.dcsConfig.createServerSocketThread_UDP(n);
            serverSocketThread.setName("UDPListener_" + n);
        }
        catch (BindException bindException) {
            Print.logException("(UDP) Unable to bind to port [" + n + "]", bindException);
            throw bindException;
        }
        catch (Throwable throwable) {
            Print.logException("(UDP) ServerSocket error [port " + n + "]", throwable);
            throw throwable;
        }
        this.initUDP(serverSocketThread);
        DCServerConfig.startServerSocketThread(serverSocketThread, "Event");
        return serverSocketThread;
    }

    protected ServerSocketThread initUDP(ServerSocketThread serverSocketThread) throws Throwable {
        return serverSocketThread;
    }

    public ServerSocketThread _startInputStream() throws Throwable {
        int n = 0;
        ServerSocketThread serverSocketThread = null;
        try {
            serverSocketThread = this.dcsConfig.createServerSocketThread_UDP(n);
            serverSocketThread.setName("InputStreamListener_" + n);
        }
        catch (BindException bindException) {
            Print.logException("(InputStream) Unable to bind to port [" + n + "]", bindException);
            throw bindException;
        }
        catch (Throwable throwable) {
            Print.logException("(InputStream) ServerSocket error [port " + n + "]", throwable);
            throw throwable;
        }
        this.initUDP(serverSocketThread);
        DCServerConfig.startServerSocketThread(serverSocketThread, "Event");
        return serverSocketThread;
    }

    public static ServerSocketThread startTestSessionServer(DCServerConfig dCServerConfig, Class<?> clazz) {
        try {
            TrackServerAdapter.startTrackServer(dCServerConfig, clazz, null, false);
            return TrackServerAdapter.getInstance()._startInputStream();
        }
        catch (Throwable throwable) {
            Print.logStackTrace("ERROR", throwable);
            return null;
        }
    }

    protected void _startCommand(int n, Class<? extends CommandPacketHandler> clazz) throws Throwable {
        this.cmdThread = DCServerConfig.startCommandHandler(n, clazz);
    }

    public static class ShutdownHandler
    extends PosixSignalHandler {
        private String[] shutdownSignals = SHUTDOWN_SIGNALS;
        private long shutdownTimeoutMS = 4000L;

        public ShutdownHandler() throws IllegalArgumentException {
            this(null, -1L);
        }

        public ShutdownHandler(String[] stringArray, long l) throws IllegalArgumentException {
            this.shutdownSignals = !ListTools.isEmpty(stringArray) ? stringArray : SHUTDOWN_SIGNALS;
            this.shutdownTimeoutMS = l >= 1000L ? l : 4000L;
            this.handleSignal(this.shutdownSignals);
            Print.logInfo("Installed Signal Handler(s): " + StringTools.join(SHUTDOWN_SIGNALS, ","), new Object[0]);
        }

        @Override
        protected void signal_TERM() {
            Print.logWarn("Received termination signal, starting shutdown procedure ...", new Object[0]);
            try {
                boolean bl = ServerSocketThread.shutdownAll(this.shutdownTimeoutMS);
                if (bl) {
                    Print.logWarn("Normal shutdown ...", new Object[0]);
                    System.exit(0);
                } else {
                    Print.logError("Forced shutdown ...", new Object[0]);
                    System.exit(1);
                }
            }
            catch (Throwable throwable) {
                Print.logException("Shutdown error, forcing shutdown ...", throwable);
                System.exit(1);
            }
        }
    }
}

