/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.servers;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Random;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.opengts.Version;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.RuleFactory;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.Resource;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBWhere;
import org.opengts.opt.servers.TrackServerAdapter;
import org.opengts.util.Base64;
import org.opengts.util.DateTime;
import org.opengts.util.FileTools;
import org.opengts.util.ListTools;
import org.opengts.util.MethodAction;
import org.opengts.util.OSTools;
import org.opengts.util.Payload;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.StringTools;

public class DCServerAttributes {
    public static final String SERVICE_ID = "mutinda";
    public static final String COPYRIGHT = "Copyright 2007-2013, GeoTelematic Solutions, Inc.";
    public static final String COMPILE_DATETIME = "2013/10/08 17:37:20 PDT";
    public static final long COMPILE_TIMESTAMP = 1381279040L;
    private static String DCS_NAME = "";
    private static long LIMIT_TEST = 0L;
    private static long VCHECK = -1L;
    private static long VCHECK_MSG = 0L;
    private static long VCHECK_MSGMOD = 21L;
    private static String VCHECK_ERROR = null;
    private static boolean SID_MATCH = true;
    private static boolean HASH_MATCH = true;
    private static int lastPrintIncludeStackFrameState = -1;
    private static long LICENSE_SEED = 1311693406324658740L;
    private static StringBuffer CaptureStdOutSB = null;
    private static final String[] ARG_VERSION = new String[]{"version"};
    private static final String[] ARG_LICENSE = new String[]{"license"};
    private static final String[] ARG_XPIRETIME = new String[]{"time"};
    private static final String[] ARG_COMPILETIME = new String[]{"compile", "compTime"};
    private static final String[] ARG_JARKEYS = new String[]{"jarKeys"};
    private static final String[] ARG_JARKAUTH = new String[]{"jarAuth"};
    private static final String[][] ARG_LIST = new String[][]{ARG_VERSION, ARG_LICENSE, ARG_XPIRETIME, ARG_COMPILETIME, ARG_JARKEYS, ARG_JARKAUTH};

    public static void logIE(String string) {
        String string2 = "Internal error, please contact your software vendor! ";
        if (!StringTools.isBlank(string)) {
            string2 = string2 + " [" + string + "]";
        }
        Print.logError(string2, new Object[0]);
    }

    public static String getRuleVersion() {
        RuleFactory ruleFactory = Device.getRuleFactory();
        if (ruleFactory != null) {
            return ruleFactory.getVersion() + " (" + ruleFactory.getName() + ")";
        }
        return "n/a";
    }

    public static String getDCSVersion(String string, boolean bl, long l, long l2, long l3, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        if (object != null && !string.startsWith("*")) {
            stringBuffer.append("*");
        }
        stringBuffer.append(string);
        if (l > 0L) {
            stringBuffer.append(bl ? "-X" : "-E");
        }
        if (l2 > 0L) {
            stringBuffer.append("-L").append(l2);
        }
        if (object != null) {
            stringBuffer.append("-H");
            int n = StringTools.parseInt(StringTools.trim(object), -1);
            if (n > 0) {
                stringBuffer.append(n);
            }
        }
        stringBuffer.append(", ");
        stringBuffer.append(l3).append(" [").append(new DateTime(l3).toString()).append("]");
        return stringBuffer.toString();
    }

    public static void printDiagnostic(Object object) {
        int n = 0;
        String string = null;
        if (object != null) {
            String string2 = StringTools.trim(object);
            n = StringTools.parseInt(string2, -1);
            int n2 = string2.indexOf(":");
            string = n2 >= 0 ? string2.substring(n2 + 1) : "";
            Print.logInfo("==========================================================================", new Object[0]);
            String string3 = string.length() > 10 ? String.valueOf(n) : string2;
            Print.logError("INTERNAL ERROR: Contact service provider [#" + string3 + "]", new Object[0]);
            if (string.length() > 10) {
                Print.logError("Diagnostic: " + string, new Object[0]);
            }
        }
    }

    public static boolean beginPrintDCSHeader(DCServerConfig dCServerConfig, String string, String string2, String string3, String string4, String string5, boolean bl, long l, long l2, long l3, Object object) {
        lastPrintIncludeStackFrameState = Print.setIncludeStackFrame(0);
        DCServerAttributes.printDiagnostic(object);
        string5 = StringTools.trim(string5);
        String string6 = RTConfig.getString("ServiceAccount.ID", "?");
        if (!string6.equals(string5)) {
            string5 = string5 + "/" + string6;
        }
        string6 = DCServerAttributes.getDCSVersion(string3, bl, l, l2, l3, object);
        String string7 = DCServerAttributes.getRuleVersion();
        String string8 = RTConfig.getString("%mainJar", "");
        String string9 = RTConfig.getString("%mainClass", "");
        File file = dCServerConfig != null ? dCServerConfig.getConfigFile() : null;
        String string10 = file != null ? file.toString() : "n/a";
        int n = 20;
        Print.logInfo("--------------------------------------------------------------------------", new Object[0]);
        Print.logInfo("[" + string + "] " + string2, new Object[0]);
        Print.logInfo(string4, new Object[0]);
        TrackServerAdapter.Log("Service ID", n, string5);
        TrackServerAdapter.Log("GTS Version", n, Version.getVersion());
        TrackServerAdapter.Log("DCS Version", n, string6.toString());
        TrackServerAdapter.Log("Rule Version", n, string7);
        if (!StringTools.isBlank(string8)) {
            TrackServerAdapter.Log("Jar File", n, string8);
        }
        if (!StringTools.isBlank(string9) && !RTConfig.isTrueServlet()) {
            TrackServerAdapter.Log("Main Class", n, string9);
        }
        TrackServerAdapter.Log("GTS_HOME", n, StringTools.trim(DBConfig.get_GTS_HOME()));
        TrackServerAdapter.Log("Config File", n, string10);
        TrackServerAdapter.Log("Start Time", n, new DateTime(DateTime.getCurrentTimeSec()).toString());
        TrackServerAdapter.Log("Mem Usage (Mb)", n, OSTools.getMemoryUsageStringMb(false));
        if (!COPYRIGHT.equals(string4)) {
            Print.logFatal("*** DCS Configuration Failure [cw] ***", new Object[0]);
            System.exit(1);
        } else if (!SERVICE_ID.equals(string5)) {
            Print.logFatal("*** DCS Configuration Failure [si] ***", new Object[0]);
            System.exit(1);
        }
        TrackServerAdapter.PrintHeaderLogs(dCServerConfig, n);
        Print.logInfo("--------------------------------------------------------------------------", new Object[0]);
        return true;
    }

    public static void endPrintDCSHeader() {
        Print.logInfo("--------------------------------------------------------------------------", new Object[0]);
        Print.setIncludeStackFrame(lastPrintIncludeStackFrameState);
    }

    public static void newTrackSessionInit(Object object, boolean bl, Object object2, long l) {
        Object object3;
        if (VCHECK < 0L) {
            VCHECK = 0L;
        }
        if (object == null) {
            try {
                Thread.sleep(1743L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            long l2 = VCHECK = VCHECK < 0L ? 1L : VCHECK + 1L;
            if (VCHECK > 3327L) {
                System.exit(1);
            }
            return;
        }
        Class<?> clazz = object.getClass();
        try {
            object3 = clazz.getDeclaredField("dcsModeKey");
            ((Field)object3).setAccessible(true);
            ((Field)object3).setLong(object, new BigInteger(DCS_NAME.getBytes()).longValue());
        }
        catch (Throwable throwable) {
            Print.logException("Unable to set dcsModeKey", throwable);
        }
        if (l > 0L && DateTime.getCurrentTimeSec() > l + DateTime.DaySeconds(11L)) {
            try {
                Thread.sleep(521L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            long l3 = VCHECK = VCHECK < 0L ? 1L : VCHECK + 1L;
            if (VCHECK > 3127L) {
                System.exit(1);
            }
            return;
        }
        if (VCHECK != 0L || object2 != null || bl) {
            if (VCHECK_MSG++ % VCHECK_MSGMOD == 0L) {
                object3 = StringTools.trim(object2);
                String string = String.valueOf(StringTools.parseInt((String)object3, -1));
                DCServerAttributes.logIE(string);
            }
            try {
                Thread.sleep(3127L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            long l4 = VCHECK = VCHECK < 0L ? 1L : VCHECK + 1L;
            if (VCHECK > 3327L) {
                System.exit(1);
            }
            return;
        }
    }

    public static long getDCSCount(String string) {
        DBFactory<Device> dBFactory = Device.getFactory();
        try {
            if (StringTools.isBlank(string)) {
                return DBRecord.getRecordCount(dBFactory);
            }
            DBWhere dBWhere = new DBWhere(dBFactory);
            String string2 = dBWhere.WHERE_(dBWhere.EQ("deviceCode", string));
            return DBRecord.getRecordCount(dBFactory, string2);
        }
        catch (DBException dBException) {
            return -1L;
        }
    }

    public static String getPackageContext(Class clazz, Class clazz2) {
        if (clazz == null) {
            return "";
        }
        if (clazz.equals(Thread.class)) {
            if (RTConfig.isTrueServlet() && clazz2 != null) {
                try {
                    String string = clazz2.getPackage().getName();
                    if (string.startsWith("org.opengts.opt.war.")) {
                        String string2 = string.substring("org.opengts.opt.war.".length());
                        return DCServerFactory.DCSNAME_SERVLET_PREFIX + string2;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return "";
        }
        String string = StringTools.className(clazz);
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return "";
        }
        String string3 = string.substring(0, n);
        int n2 = string3.lastIndexOf(".");
        if (n2 < 0) {
            return "";
        }
        return string3.substring(n2 + 1);
    }

    private static Class _getMainClass() {
        if (OSTools.hasGetCallerClass()) {
            Class clazz;
            Class clazz2 = null;
            int n = 2;
            while ((clazz = OSTools.getCallerClass(n)) != null) {
                clazz2 = clazz;
                ++n;
            }
            return clazz2;
        }
        return null;
    }

    private static Class _getCallerClass(int n) {
        if (OSTools.hasGetCallerClass()) {
            return OSTools.getCallerClass(n + 1);
        }
        return null;
    }

    public static String getDCSJarFilePath(String string) {
        File file = RTConfig.getLoadedConfigDir();
        if (file == null) {
            return "";
        }
        File file2 = new File(file, "build/lib/" + string + ".jar");
        if (file2 == null) {
            return "";
        }
        if (!file2.isFile()) {
            return "";
        }
        return file2.toString();
    }

    private static String getMainJarFilePath(String string, Class clazz, Class clazz2) {
        Object object;
        boolean bl = false;
        if (clazz == null) {
            clazz = OSTools.getCallerClass(2);
        } else if (clazz.equals(Thread.class) && clazz2 != null && RTConfig.isTrueServlet()) {
            try {
                object = clazz2.getPackage().getName();
                if (((String)object).startsWith("org.opengts.opt.war.")) {
                    clazz = clazz2;
                    bl = true;
                }
            }
            catch (Throwable throwable) {}
        } else if (StringTools.className(clazz).startsWith("org.opengts.opt.war.")) {
            bl = true;
        }
        object = clazz.getClassLoader();
        if (object == null && (object = ClassLoader.getSystemClassLoader()) == null) {
            return ":loader";
        }
        URL uRL = ((ClassLoader)object).getResource(clazz.getName().replace('.', '/') + ".class");
        if (uRL == null) {
            return ":resource";
        }
        String string2 = uRL.getPath();
        if (string2 == null) {
            return ":path";
        }
        String string3 = StringTools.trim(uRL.getProtocol());
        if (!string3.equalsIgnoreCase("jar")) {
            if (!string3.equalsIgnoreCase("file")) {
                return ":proto(" + uRL + ")";
            }
            if (string2.endsWith("TrackServer.class")) {
                return DCServerAttributes.getDCSJarFilePath(string);
            }
            if (string2.endsWith("TrackClientPacketHandler.class")) {
                return DCServerAttributes.getDCSJarFilePath(string);
            }
            if (bl) {
                return string2;
            }
            return ":proto(" + uRL + ")";
        }
        int n = StringTools.startsWithIgnoreCase(string2, "file:") ? "file:".length() : 0;
        int n2 = string2.indexOf("!");
        if (FileTools.isFile(string2 = n2 >= 0 ? string2.substring(n, n2) : string2.substring(n, string2.length()))) {
            return string2;
        }
        if (string2.length() >= 3 && string2.startsWith("/") && string2.charAt(2) == ':' && FileTools.isFile(string2 = string2.substring(1))) {
            return string2;
        }
        if (string2.indexOf("%20") >= 0 && FileTools.isFile(string2 = StringTools.replace(string2, "%20", " "))) {
            return string2;
        }
        return string2;
    }

    private static byte[] shuffle(byte[] byArray, Random random) {
        if (byArray != null && byArray.length > 1 && random != null) {
            for (int i = byArray.length - 1; i > 0; --i) {
                int n = random.nextInt(i + 1);
                if (i == n) continue;
                byte by = byArray[i];
                byArray[i] = byArray[n];
                byArray[n] = by;
            }
        }
        return byArray;
    }

    private static byte[] getRandomBytes(int n, Random random) {
        if (n > 0 && random != null) {
            byte[] byArray = new byte[n];
            random.nextBytes(byArray);
            return byArray;
        }
        return new byte[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFile(File file) {
        if (file == null || !file.isFile()) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            byte[] byArray = FileTools.readStream(fileInputStream);
            return byArray;
        }
        catch (IOException iOException) {
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean CheckMID(AttrbuteHandler var0, String var1_1, long var2_2, String var4_3, long var5_4) {
        block27: {
            block26: {
                block39: {
                    block38: {
                        block37: {
                            block36: {
                                block35: {
                                    block34: {
                                        block33: {
                                            block32: {
                                                block31: {
                                                    block30: {
                                                        block29: {
                                                            block28: {
                                                                var7_5 = 0;
                                                                var8_6 = "";
                                                                var9_7 = DCServerAttributes._getMainClass();
                                                                var10_8 = DCServerAttributes._getCallerClass(2);
                                                                var11_9 = false;
                                                                if (var9_7.equals(Thread.class) && RTConfig.isTrueServlet() && var10_8 != null) {
                                                                    try {
                                                                        var12_10 = var10_8.getPackage().getName();
                                                                        var11_9 = var12_10.startsWith("org.opengts.opt.war.");
                                                                    }
                                                                    catch (Throwable var12_11) {
                                                                        // empty catch block
                                                                    }
                                                                }
                                                                if (DCServerAttributes.VCHECK <= -1L) {
                                                                    DCServerAttributes.VCHECK = 0L;
                                                                }
                                                                if (!StringTools.isBlank(var1_1)) break block28;
                                                                var7_5 = 101;
                                                                ++DCServerAttributes.VCHECK;
                                                                var8_6 = var8_6 + (1000 + var7_5) + ":";
                                                                break block27;
                                                            }
                                                            DCServerAttributes.DCS_NAME = var1_1;
                                                            if (!StringTools.isBlank(var4_3)) break block29;
                                                            var7_5 = 200;
                                                            DCServerAttributes.SID_MATCH = false;
                                                            ++DCServerAttributes.VCHECK;
                                                            var8_6 = var8_6 + (1000 + var7_5) + ":";
                                                            break block27;
                                                        }
                                                        if (var4_3.equals(RTConfig.getString("ServiceAccount.ID", "")) && var4_3.equals("mutinda") && var4_3.equals("mutinda")) break block30;
                                                        var7_5 = 201;
                                                        DCServerAttributes.SID_MATCH = false;
                                                        ++DCServerAttributes.VCHECK;
                                                        var8_6 = var8_6 + (1000 + var7_5) + ":" + var4_3;
                                                        break block27;
                                                    }
                                                    if (var9_7 == null) {
                                                        var9_7 = DCServerAttributes.class;
                                                    }
                                                    var12_10 = StringTools.className(var9_7);
                                                    var13_13 = DCServerAttributes.getPackageContext(var9_7, var10_8);
                                                    if (var1_1.equals(var13_13)) break block31;
                                                    var7_5 = 110;
                                                    ++DCServerAttributes.VCHECK;
                                                    var8_6 = var8_6 + (1000 + var7_5) + ":" + var13_13;
                                                    break block27;
                                                }
                                                var14_14 = DCServerAttributes.getMainJarFilePath(var1_1, var9_7, var10_8);
                                                if (!StringTools.isBlank(var14_14)) break block32;
                                                var7_5 = 120;
                                                DCServerAttributes.HASH_MATCH = false;
                                                ++DCServerAttributes.VCHECK;
                                                var8_6 = var8_6 + (1000 + var7_5) + ":";
                                                break block27;
                                            }
                                            if (!var14_14.startsWith(":")) break block33;
                                            var7_5 = 120;
                                            DCServerAttributes.HASH_MATCH = false;
                                            ++DCServerAttributes.VCHECK;
                                            var8_6 = var8_6 + (1000 + var7_5) + ":" + var14_14;
                                            break block27;
                                        }
                                        if (var11_9 || StringTools.endsWithIgnoreCase(var14_14, ".jar")) break block34;
                                        var7_5 = 305;
                                        DCServerAttributes.HASH_MATCH = false;
                                        ++DCServerAttributes.VCHECK;
                                        var8_6 = var8_6 + (1000 + var7_5) + ":" + var14_14;
                                        break block27;
                                    }
                                    if (!var11_9 || StringTools.endsWithIgnoreCase(var14_14, ".class") || StringTools.endsWithIgnoreCase(var14_14, ".jar")) break block35;
                                    var7_5 = 306;
                                    DCServerAttributes.HASH_MATCH = false;
                                    ++DCServerAttributes.VCHECK;
                                    var8_6 = var8_6 + (1000 + var7_5) + ":" + var14_14;
                                    break block27;
                                }
                                if (FileTools.isFile(var14_14)) break block36;
                                var7_5 = 310;
                                DCServerAttributes.HASH_MATCH = false;
                                ++DCServerAttributes.VCHECK;
                                var8_6 = var8_6 + (1000 + var7_5) + ":" + var14_14;
                                break block27;
                            }
                            var15_15 = DCServerAttributes.readFile(new File(var14_14));
                            if (!ListTools.isEmpty(var15_15)) break block37;
                            var7_5 = 320;
                            DCServerAttributes.HASH_MATCH = false;
                            ++DCServerAttributes.VCHECK;
                            var8_6 = var8_6 + (1000 + var7_5) + ":" + var14_14;
                            break block27;
                        }
                        var16_16 = RTConfig.getLoadedConfigFile();
                        var17_17 = var16_16 != null ? new File(var16_16.getParentFile(), "GTS_Enterprise") : null;
                        var18_18 = DCServerAttributes.readFile(var17_17);
                        if (!ListTools.isEmpty(var18_18)) break block38;
                        var7_5 = 210;
                        ++DCServerAttributes.VCHECK;
                        var8_6 = var8_6 + (1000 + var7_5) + ":";
                        break block27;
                    }
                    var19_19 = false;
                    var20_20 = new RTProperties(new ByteArrayInputStream(var18_18));
                    var21_21 = new StringBuffer("GTS.");
                    var22_22 = var20_20.getString(var21_21 + "Copyright", "");
                    var23_23 = var20_20.getString(var21_21 + "ServiceID", "");
                    var24_24 = var20_20.getString(var21_21 + "Version", "");
                    if (!StringTools.isBlank(var22_22)) break block39;
                    var7_5 = 220;
                    ++DCServerAttributes.VCHECK;
                    var8_6 = var8_6 + (1000 + var7_5) + ":";
                    break block27;
                }
                var25_25 = "DCServerFactory." + var1_1;
                var26_26 = StringTools.trim(RTConfig.getString(var25_25, ""));
                if (StringTools.isBlank(var26_26) && var1_1.startsWith(DCServerFactory.DCSNAME_SERVLET_PREFIX) && (var27_27 = DBConfig.get_GTS_HOME()) != null) {
                    var28_28 = new File(var27_27, DBConfig.AUTHKEY_DCS_CONF(var1_1));
                    if (!var28_28.isFile()) {
                        var28_28 = new File(var27_27, "authkeys.conf");
                    }
                    if (var28_28.isFile()) {
                        var29_29 = new RTProperties(var28_28);
                        var26_26 = StringTools.trim(var29_29.getString(var25_25, ""));
                    }
                }
                var29_29 = "";
                var30_30 = "gtsauth:dcs." + var1_1;
                var31_31 = true;
                try {
                    var32_32 = RTConfig.getLong("DCServerFactory.key", 188900966474565L) & 0xFFFFFFFFFFFFL;
                    var34_34 = BigInteger.valueOf(var32_32).xor(new BigInteger(var1_1.getBytes())).longValue();
                    var36_36 = new Random(var34_34 & 0xFFFFFFFFFFFFL);
                    var37_38 = new Random(var34_34 / 2L & 0xFFFFFFFFFFFFL);
                    if (var36_36.nextBoolean()) {
                        var39_39 = MessageDigest.getInstance("MD5");
                        var39_39.update(DCServerAttributes.getRandomBytes(var36_36.nextInt(8), (Random)var36_36));
                        var39_39.update(String.valueOf(var2_2).getBytes());
                        var39_39.update(DCServerAttributes.getRandomBytes(var36_36.nextInt(8), (Random)var36_36));
                        var39_39.update(String.valueOf(var5_4).getBytes());
                        var39_39.update(DCServerAttributes.getRandomBytes(var36_36.nextInt(8), (Random)var36_36));
                        var39_39.update(var1_1.getBytes());
                        var39_39.update(DCServerAttributes.getRandomBytes(var36_36.nextInt(8), (Random)var36_36));
                        var39_39.update(var4_3.getBytes());
                        var39_39.update(DCServerAttributes.getRandomBytes(var36_36.nextInt(8), (Random)var36_36));
                        var39_39.update(var22_22.getBytes());
                        var39_39.update(var23_23.getBytes());
                        var39_39.update(DCServerAttributes.getRandomBytes(var36_36.nextInt(8), (Random)var36_36));
                        var38_40 = var39_39.digest();
                    } else {
                        var39_39 = new Payload();
                        var39_39.writeBytes(DCServerAttributes.getRandomBytes(4, (Random)var36_36));
                        var39_39.writeULong(var2_2, 4, false);
                        var39_39.writeULong(var5_4, 8);
                        var39_39.writeString(var1_1, 20, true);
                        var39_39.writeString(var4_3, 20, true);
                        var39_39.writeString(var22_22, 80, true);
                        var39_39.writeString(var23_23, 20, true);
                        var39_39.writeBytes(DCServerAttributes.getRandomBytes(160 - var39_39.getSize(), (Random)var36_36));
                        var38_40 = var39_39.getBytes();
                    }
                    var39_39 = Mac.getInstance("HmacSHA256");
                    var39_39.init(new SecretKeySpec(DCServerAttributes.shuffle(var38_40, (Random)var36_36), var39_39.getAlgorithm()));
                    if (var19_19) {
                        var39_39.update(var18_18);
                    }
                    if ((var41_42 = new BigInteger(1, var40_41 = DCServerAttributes.shuffle(var39_39.doFinal(var15_15), (Random)var36_36)).toString(16)).equalsIgnoreCase(var26_26) || var26_26.startsWith(var4_3 + "," + var1_1 + "," + var5_4)) break block26;
                    if (StringTools.isBlank(var26_26)) {
                        var7_5 = 330;
                        DCServerAttributes.HASH_MATCH = false;
                        ++DCServerAttributes.VCHECK;
                        var8_6 = var8_6 + (1000 + var7_5) + ":" + "DCServerFactory." + var1_1;
                        Resource.setGlobalResourceValue(var30_30, "binary", "", DCServerAttributes.shuffle(var40_41, (Random)var37_38));
                        break block27;
                    }
                    var7_5 = 350;
                    DCServerAttributes.HASH_MATCH = false;
                    ++DCServerAttributes.VCHECK;
                    var8_6 = var8_6 + (1000 + var7_5) + ":" + var4_3 + "," + var1_1 + "," + var5_4 + "," + var2_2 + "," + var32_32 + "," + var14_14;
                    Resource.setGlobalResourceValue(var30_30, "binary", "", DCServerAttributes.shuffle(var40_41, (Random)var37_38));
                }
                catch (Throwable var32_33) {
                    if (var26_26.startsWith(var4_3 + "," + var1_1 + "," + var5_4)) break block26;
                    if (StringTools.isBlank(var26_26)) ** break block40
                    var7_5 = 390;
                    DCServerAttributes.HASH_MATCH = false;
                    ++DCServerAttributes.VCHECK;
                    var8_6 = var8_6 + (1000 + var7_5) + ":";
                }
                break block27;
                {
                    var7_5 = 330;
                    DCServerAttributes.HASH_MATCH = false;
                    ++DCServerAttributes.VCHECK;
                    var8_6 = var8_6 + (1000 + var7_5) + ":" + "DCServerFactory." + var1_1;
                }
            }
            if (var2_2 > 0L) {
                var32_32 = -1L;
                var34_35 = null;
                var35_43 = Device.getFactory();
                try {
                    if (StringTools.isBlank(var1_1)) {
                        var32_32 = DBRecord.getRecordCount(var35_43);
                    } else {
                        var36_36 = new DBWhere(var35_43);
                        var37_38 = var1_1.startsWith(DCServerFactory.DCSNAME_SERVLET_PREFIX) != false ? var36_36.WHERE_(var36_36.OR(var36_36.EQ("deviceCode", var1_1), var36_36.EQ("deviceCode", var1_1.substring(2)))) : var36_36.WHERE_(var36_36.EQ("deviceCode", var1_1));
                        var32_32 = DBRecord.getRecordCount(var35_43, (String)var37_38);
                    }
                    if (var32_32 < 0L || var32_32 > (long)((double)var2_2 * 1.05)) {
                        var7_5 = 400;
                        DCServerAttributes.LIMIT_TEST = 1562587685504633840L;
                        ++DCServerAttributes.VCHECK;
                        var8_6 = var8_6 + (1000 + var7_5) + ":" + var32_32;
                    } else {
                        DCServerAttributes.LIMIT_TEST = -1562587685504633841L;
                    }
                }
                catch (DBException var36_37) {
                    var32_32 = -1L;
                    var7_5 = 490;
                    ++DCServerAttributes.VCHECK;
                    var8_6 = var8_6 + (1000 + var7_5) + ":" + var36_37.getMessage();
                }
            }
        }
        if (DCServerAttributes.VCHECK > 0L) {
            DCServerAttributes.VCHECK_ERROR = var8_6;
            DCServerAttributes.VCHECK_MSG = DCServerAttributes.VCHECK_MSGMOD - 2L;
        }
        if (var10_8 != null) {
            try {
                var12_10 = var10_8.getDeclaredField("DCS_MODE_KEY");
                var12_10.setAccessible(true);
                var12_10.setLong(var10_8, new BigInteger(DCServerAttributes.DCS_NAME.getBytes()).longValue() ^ -1L);
            }
            catch (Throwable var12_12) {
                // empty catch block
            }
        }
        if (var0 != null) {
            var12_10 = String.valueOf(var7_5);
            var13_13 = var8_6.equals("") == false ? var8_6 : (var7_5 != 0 ? var12_10 : null);
            var0.setDCAttribute((String)var12_10, var13_13);
        }
        return var7_5 == 0;
    }

    public static String GetLicenseString() {
        Object object;
        String string = RTConfig.getString("ServiceAccount.ID", "?");
        String string2 = SERVICE_ID;
        String string3 = "Basic GTS Enterprise";
        String string4 = StringTools.trim("");
        byte[] byArray = null;
        try {
            object = BigInteger.valueOf(LICENSE_SEED);
            byArray = Base64.decode(new StringBuffer(string4).reverse().toString(), (BigInteger)object);
        }
        catch (Base64.Base64DecodeException base64DecodeException) {
            byArray = new byte[]{};
        }
        Payload.SetDebugLogging(false);
        object = new Payload(byArray);
        String string5 = ((Payload)object).readString(((Payload)object).getMaximumReadLength());
        String string6 = ((Payload)object).readString(((Payload)object).getMaximumReadLength());
        StringBuffer stringBuffer = new StringBuffer();
        if (!string5.equalsIgnoreCase(string2)) {
            stringBuffer.append("*");
        } else if (!string5.equalsIgnoreCase(string2)) {
            stringBuffer.append("*");
        }
        stringBuffer.append("[").append(string5).append("] ").append(string6);
        return stringBuffer.toString();
    }

    public static void CapturePrintln(StringBuffer stringBuffer) {
        CaptureStdOutSB = stringBuffer;
    }

    private static void println(String string) {
        if (string != null) {
            if (CaptureStdOutSB != null) {
                CaptureStdOutSB.append(string);
                if (!string.endsWith("\n")) {
                    CaptureStdOutSB.append("\n");
                }
            } else {
                Print.sysPrintln(string, new Object[0]);
            }
        }
    }

    public static boolean _hasCommandArg(String[] stringArray) {
        RTProperties rTProperties = new RTProperties(stringArray);
        for (Object[] objectArray : ARG_LIST) {
            if (!rTProperties.hasProperty(objectArray)) continue;
            return true;
        }
        return false;
    }

    public static boolean _main(String string, String string2, String string3, long l, long l2) {
        return DCServerAttributes._main(1, string, string2, string3, l, l2, 1381279040L);
    }

    public static boolean _main(String string, String string2, String string3, long l, long l2, long l3) {
        return DCServerAttributes._main(1, string, string2, string3, l, l2, 1381279040L);
    }

    private static boolean _main(int n, String string, String string2, String string3, long l, long l2, long l3) {
        if (RTConfig.getBoolean(ARG_VERSION, false)) {
            DCServerAttributes.println(string3);
            return true;
        }
        if (RTConfig.getBoolean(ARG_LICENSE, false)) {
            DCServerAttributes.println(DCServerAttributes.GetLicenseString());
            return true;
        }
        if (ARG_XPIRETIME.equals(RTConfig.getString("xpire", ""))) {
            DCServerAttributes.println(l > 0L ? new DateTime(l - DateTime.DaySeconds(1.1)).toString() : "n/a");
            return true;
        }
        if (RTConfig.hasProperty(ARG_COMPILETIME)) {
            DCServerAttributes.println("[" + l3 + "] " + new DateTime(l3));
            return true;
        }
        if (RTConfig.hasProperty(ARG_JARKEYS) || RTConfig.hasProperty(ARG_JARKAUTH)) {
            String string4;
            boolean bl;
            String string5;
            String string6 = string5 = DCServerAttributes.getMainJarFilePath(string, OSTools.getCallerClass(n + 2), null);
            String string7 = SERVICE_ID;
            long l4 = RTConfig.getLong("DCServerFactory.key", 188900966474565L) & 0xFFFFFFFFFFFFL;
            String string8 = string7 + "," + string + "," + l3 + "," + l2 + "," + l4 + "," + string6;
            if (RTConfig.hasProperty(ARG_JARKEYS)) {
                bl = RTConfig.getString(ARG_JARKEYS, "").equals("prop");
                string4 = bl ? "DCServerFactory." + string + "=" : "";
                DCServerAttributes.println(string4 + string8);
            }
            if (RTConfig.hasProperty(ARG_JARKAUTH)) {
                bl = RTConfig.getString(ARG_JARKAUTH, "").equals("prop");
                string4 = bl ? "DCServerFactory." + string + "=" : "";
                try {
                    MethodAction methodAction = new MethodAction((Object)"org.opengts.opt.StartupInit", "CalcJarAuth", String.class);
                    String string9 = StringTools.trim((String)methodAction.invoke(string8)).toLowerCase();
                    DCServerAttributes.println(string4 + string9);
                }
                catch (Throwable throwable) {
                    DCServerAttributes.println(string4 + string8);
                }
            }
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        RTConfig.setCommandLineArgs(stringArray);
        String string = RTConfig.getString("dcs", null);
        if (!StringTools.isBlank(string)) {
            long l = RTConfig.getLong("DCServerFactory.key", 188900966474565L);
            Print.sysPrintln("DCSName: " + string, new Object[0]);
            Print.sysPrintln("Seed (before) " + l, new Object[0]);
            l = BigInteger.valueOf(l).xor(new BigInteger(string.getBytes())).longValue();
            Print.sysPrintln("Seed (after ) " + l, new Object[0]);
        }
    }

    public static interface AttrbuteHandler {
        public void setDCAttribute(String var1, Object var2);
    }
}

