/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers.template;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.opengts.db.CommandPacketHandler;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.dbtools.DBException;
import org.opengts.servers.template.Main;
import org.opengts.servers.template.TrackClientPacketHandler;
import org.opengts.servers.template.TrackServer;
import org.opengts.util.ClientSocketThread;
import org.opengts.util.DateTime;
import org.opengts.util.ListTools;
import org.opengts.util.Payload;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.RTProperties;
import org.opengts.util.ServerSocketThread;
import org.opengts.util.StringTools;

public class TemplateCommandHandler
extends CommandPacketHandler {
    private static final boolean SEND_TCP_COMMANDS_THROUGH_EXISTING_SESSION = true;
    private static final String[] ARG_ACCOUNT = new String[]{"acct", "account"};
    private static final String[] ARG_DEVICE = new String[]{"dev", "device"};
    private static final String[] ARG_TCP_COMMAND = new String[]{"tcpCmd", "tcpCommand"};

    public String decodeEscapeChars(String s) {
        int p = s.indexOf("\\");
        if (p >= 0) {
            StringBuffer sb = new StringBuffer(s.substring(0, p));
            while (p < s.length()) {
                char ch = s.charAt(p);
                if (ch == '\\' && p + 1 < s.length()) {
                    if ((ch = s.charAt(++p)) == '0') {
                        sb.append('\u0000');
                    } else if (ch == 'r') {
                        sb.append('\r');
                    } else if (ch == 'n') {
                        sb.append('\n');
                    } else if (ch == 't') {
                        sb.append('\t');
                    } else if (ch == '\\') {
                        sb.append('\\');
                    } else {
                        sb.append(ch);
                    }
                } else {
                    sb.append(ch);
                }
                ++p;
            }
            return sb.toString();
        }
        return s;
    }

    @Override
    public String getServerName() {
        return "template";
    }

    public int getClientCommandPort_udp(int dftPort) {
        DCServerConfig dcsc = Main.getServerConfig(null);
        int port = dcsc.getClientCommandPort_udp(0);
        return port > 0 ? port : dftPort;
    }

    public int getClientCommandPort_tcp(int dftPort) {
        DCServerConfig dcsc = Main.getServerConfig(null);
        int port = dcsc.getClientCommandPort_tcp(0);
        if (port > 0) {
            return port;
        }
        if (dftPort > 0) {
            return dftPort;
        }
        int[] tcp = dcsc.getTcpPorts();
        if (!ListTools.isEmpty(tcp)) {
            return tcp[0];
        }
        return 0;
    }

    public DCServerConfig.CommandProtocol getCommandProtocol() {
        DCServerConfig dcsc = Main.getServerConfig(null);
        DCServerConfig.CommandProtocol proto = dcsc.getCommandProtocol();
        return proto != null ? proto : DCServerConfig.CommandProtocol.UDP;
    }

    @Override
    public DCServerFactory.ResultCode handleCommand(Device device, String cmdType, String cmdName, String[] cmdArgs) {
        Print.logInfo("Received Command: type=%s name=%s args=%s", cmdType, cmdName, StringTools.join(cmdArgs, ','));
        if (device == null) {
            Print.logError("Device is null", new Object[0]);
            return DCServerFactory.ResultCode.INVALID_DEVICE;
        }
        if (cmdType.equalsIgnoreCase("ping")) {
            cmdType = "config";
            cmdName = "LocateNow";
        }
        DCServerConfig dcsc = Main.getServerConfig(null);
        DCServerConfig.Command command = dcsc.getCommand(cmdName);
        DCServerConfig.CommandProtocol cmdProto = null;
        String cmdStr = null;
        if (command != null) {
            cmdProto = command.getCommandProtocol();
            cmdStr = command.getCommandString(device, cmdArgs);
        } else {
            Print.logWarn("Command not found: " + cmdName, new Object[0]);
        }
        Print.logInfo("CmdStr: " + cmdStr, new Object[0]);
        if (cmdType.equalsIgnoreCase("config")) {
            if (command == null) {
                return DCServerFactory.ResultCode.INVALID_COMMAND;
            }
            DCServerFactory.ResultCode result = this.sendCommand(device, cmdStr, cmdProto);
            command.setDeviceCommandAttributes(result, device, cmdStr, true);
            Print.logInfo("Command result: [" + device.getUniqueID() + "] " + result, new Object[0]);
            return result;
        }
        return null;
    }

    private DCServerFactory.ResultCode sendCommand(Device device, String cmdStr, DCServerConfig.CommandProtocol cmdProto) {
        if (device == null) {
            Print.logError("Device is null", new Object[0]);
            return DCServerFactory.ResultCode.INVALID_ARG;
        }
        if (cmdProto == null) {
            cmdProto = this.getCommandProtocol();
        }
        if (StringTools.isBlank(cmdStr)) {
            Print.logError("Blank command: " + cmdStr, new Object[0]);
            return DCServerFactory.ResultCode.INVALID_ARG;
        }
        cmdStr = this.decodeEscapeChars(cmdStr);
        DCServerFactory.ResultCode result = DCServerFactory.ResultCode.INVALID_PROTO;
        switch (cmdProto) {
            case UDP: {
                result = this.sendCommandPacket_udp(device, cmdStr);
                break;
            }
            case TCP: {
                result = this.sendCommandPacket_tcp_existing(device, cmdStr);
                break;
            }
            case SMS: {
                break;
            }
            default: {
                result = DCServerFactory.ResultCode.INVALID_PROTO;
            }
        }
        return result;
    }

    private DCServerFactory.ResultCode sendCommandPacket_udp(Device device, String cmdStr) {
        int frPort = device.getListenPortCurrent();
        String toHost = StringTools.trim(device.getIpAddressCurrent());
        int toPort = this.getClientCommandPort_udp(device.getRemotePortCurrent());
        long age = DateTime.getCurrentTimeSec() - device.getLastTotalConnectTime();
        if (StringTools.isBlank(toHost) || toHost.equals("0.0.0.0") || toPort <= 0) {
            Print.logError("Device host:port not known> %s:%d", toHost, toPort);
            return DCServerFactory.ResultCode.UNKNOWN_HOST;
        }
        Payload p = new Payload();
        p.writeString(cmdStr, cmdStr.length());
        byte[] pktData = p.getBytes();
        Print.logInfo("Send '%s:%d'(%dsec) [%s] 0x%s", toHost, toPort, age, cmdStr, StringTools.toHexString(pktData));
        try {
            this.sendDatagramMessage(frPort, toHost, toPort, pktData);
            return DCServerFactory.ResultCode.SUCCESS;
        }
        catch (Throwable th) {
            Print.logException("UDP transmit failure", th);
            return DCServerFactory.ResultCode.TRANSMIT_FAIL;
        }
    }

    private void sendDatagramMessage(int frPort, String toHost, int toPort, byte[] pkt) throws IOException {
        boolean closeSocket = false;
        DatagramSocket dgSocket = TrackServer.getInstance().getUdpDatagramSocket(frPort);
        if (dgSocket == null) {
            Print.logWarn("Creating temporary DatagramSocket for transmission", new Object[0]);
            dgSocket = ServerSocketThread.createDatagramSocket(0);
            closeSocket = true;
        }
        DatagramPacket respPkt = new DatagramPacket(pkt, pkt.length, InetAddress.getByName(toHost), toPort);
        Print.logInfo("Sending Datagram (from %d) to %s:%d> 0x%s", dgSocket.getLocalPort(), toHost, toPort, StringTools.toHexString(pkt));
        dgSocket.send(respPkt);
        if (closeSocket) {
            dgSocket.close();
        }
    }

    private DCServerFactory.ResultCode sendCommandPacket_tcp_existing(Device device, String cmdStr) {
        Payload p = new Payload();
        p.writeString(cmdStr, cmdStr.length());
        byte[] pktData = p.getBytes();
        Print.logDebug("TCP Command: %s", StringTools.toStringValue(pktData, '.'));
        Print.logInfo("TCP Command packet: 0x" + StringTools.toHexString(pktData), new Object[0]);
        int remPort = device.getRemotePortCurrent();
        if (remPort <= 0) {
            // empty if block
        }
        int frPort = device.getListenPortCurrent();
        long age = DateTime.getCurrentTimeSec() - device.getLastTotalConnectTime();
        DCServerConfig dcs = Main.getServerConfig(null);
        String sessID = TrackClientPacketHandler.GetTcpSessionID(device);
        ServerSocketThread sst = TrackServer.getInstance().getServerSocketThread_tcp(frPort);
        if (sst != null) {
            boolean rtn = sst.tcpWriteToSessionID(sessID, pktData);
            if (rtn) {
                Print.logInfo("TCP session found, command sent: " + sessID, new Object[0]);
                return DCServerFactory.ResultCode.SUCCESS;
            }
            Print.logError("TCP session not found: " + sessID, new Object[0]);
            return DCServerFactory.ResultCode.NO_SESSION;
        }
        Print.logError("TCP commands not supported for this port: " + frPort, new Object[0]);
        return DCServerFactory.ResultCode.TRANSMIT_FAIL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DCServerFactory.ResultCode sendCommandPacket_tcp_new(Device device, String cmdStr) {
        String host = StringTools.trim(device.getIpAddressCurrent());
        int port = this.getClientCommandPort_tcp(device.getRemotePortCurrent());
        if (StringTools.isBlank(host) || host.equals("0.0.0.0") || port <= 0) {
            Print.logError("Device host:port not known> %s:%d", host, port);
            return DCServerFactory.ResultCode.UNKNOWN_HOST;
        }
        Payload p = new Payload();
        p.writeString(cmdStr, cmdStr.length());
        byte[] pktData = p.getBytes();
        Print.logDebug("TCP Command: %s", cmdStr);
        Print.logInfo("TCP Command packet: 0x" + StringTools.toHexString(pktData), new Object[0]);
        DCServerFactory.ResultCode rtnErr = DCServerFactory.ResultCode.SUCCESS;
        ClientSocketThread cst = new ClientSocketThread(host, port);
        cst.setReadTimeout(5000L);
        try {
            Print.logInfo("Opening TCP Socket @ %s:%d", host, port);
            cst.openSocket(5000L);
            Print.logInfo("TCP Socket open %s:%d", host, port);
            cst.socketWriteBytes(pktData);
            byte[] resp = cst.socketReadBytes(2);
            int respLen = (resp[0] & 0xFF) << 8 | resp[1] & 0xFF;
            Print.logInfo("TCP Response length: " + respLen, new Object[0]);
            cst.setSocketReadTimeout();
            resp = cst.socketReadBytes(respLen - 2);
            Print.logInfo("TCP Response packet: 0x" + StringTools.toHexString(resp), new Object[0]);
            rtnErr = DCServerFactory.ResultCode.SUCCESS;
        }
        catch (IOException ioe) {
            Print.logError("TCP Socket error: " + ioe, new Object[0]);
            rtnErr = DCServerFactory.ResultCode.TRANSMIT_FAIL;
        }
        finally {
            try {
                cst.closeSocket();
            }
            catch (Throwable th) {}
            Print.logInfo("TCP Socket closed ...", new Object[0]);
        }
        return rtnErr;
    }

    public static void main(String[] argv) {
        DBConfig.cmdLineInit(argv, false);
        String accountID = RTConfig.getString(ARG_ACCOUNT, null);
        String deviceID = RTConfig.getString(ARG_DEVICE, null);
        if (StringTools.isBlank(accountID)) {
            Print.logError("Account-ID not specified.", new Object[0]);
            System.exit(1);
        }
        Account account = null;
        try {
            account = Account.getAccount(accountID);
            if (account == null) {
                Print.logError("Account-ID does not exist: " + accountID, new Object[0]);
                System.exit(1);
            }
        }
        catch (DBException dbe) {
            Print.logException("Error loading Account: " + accountID, dbe);
            System.exit(99);
        }
        if (StringTools.isBlank(deviceID)) {
            Print.logError("Device-ID not specified.", new Object[0]);
            System.exit(1);
        }
        Device device = null;
        try {
            device = Device.getDevice(account, deviceID, false);
            if (device == null) {
                Print.logError("Device-ID does not exist: " + accountID + "/" + deviceID, new Object[0]);
                System.exit(1);
            }
        }
        catch (DBException dbe) {
            Print.logError("Error getting Device: " + accountID + "/" + deviceID, new Object[0]);
            dbe.printException();
            System.exit(99);
        }
        if (RTConfig.hasProperty(ARG_TCP_COMMAND)) {
            device.setDeviceCode("template");
            RTProperties rtn = DCServerFactory.sendServerCommand(device, "config", "TcpTest", null);
            Print.sysPrintln("Result: " + rtn, new Object[0]);
            System.exit(0);
        }
    }
}

