/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers.template;

import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.tables.Device;
import org.opengts.dbtools.DBAdmin;
import org.opengts.servers.template.TrackClientPacketHandler;
import org.opengts.servers.template.TrackServer;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class Main {
    public static final String[] ARG_PARSEFILE = new String[]{"parse", "parseFile"};
    public static final String[] ARG_HELP = new String[]{"help", "h"};
    public static final String[] ARG_CMD_PORT = new String[]{"command", "cmd"};
    public static final String[] ARG_START = new String[]{"start"};
    public static final String[] ARG_DEBUG = new String[]{"debug"};
    public static final String[] ARG_FORMAT = new String[]{"format", "parseFormat"};
    public static final String[] ARG_INSERT = new String[]{"insert"};
    private static DCServerConfig dcServerCfg = null;

    public static String DCServerFactory_LoadName() {
        return Main.getServerContextName();
    }

    public static String getServerName() {
        return "template";
    }

    public static String getServerContextName() {
        return RTConfig.getContextName(Main.getServerName());
    }

    public static DCServerConfig getServerConfig(Device dev) {
        if (dcServerCfg == null) {
            dcServerCfg = DCServerFactory.getServerConfig(Main.getServerContextName());
            DCServerConfig.startRemoteLogging(dcServerCfg);
        }
        return dcServerCfg;
    }

    public static int[] getTcpPorts() {
        DCServerConfig dcs = Main.getServerConfig(null);
        if (dcs != null) {
            return dcs.getTcpPorts();
        }
        Print.logError("DCServerConfig not found for server: " + Main.getServerName(), new Object[0]);
        return null;
    }

    public static int[] getUdpPorts() {
        DCServerConfig dcs = Main.getServerConfig(null);
        if (dcs != null) {
            return dcs.getUdpPorts();
        }
        Print.logError("DCServerConfig not found for server: " + Main.getServerName(), new Object[0]);
        return null;
    }

    public static int getCommandDispatcherPort() {
        DCServerConfig dcs = Main.getServerConfig(null);
        if (dcs != null) {
            return dcs.getCommandDispatcherPort();
        }
        return RTConfig.getInt(ARG_CMD_PORT, 0);
    }

    private static void usage(String msg) {
        String tcp = StringTools.join(Main.getTcpPorts(), ",");
        String udp = StringTools.join(Main.getUdpPorts(), ",");
        String cmd = String.valueOf(Main.getCommandDispatcherPort());
        if (msg != null) {
            Print.logInfo(msg, new Object[0]);
        }
        String className = Main.class.getName();
        Print.logInfo("", new Object[0]);
        Print.logInfo("Usage:", new Object[0]);
        Print.logInfo("  java ... " + className + " -h[elp]", new Object[0]);
        Print.logInfo(" or", new Object[0]);
        Print.logInfo("  java ... " + className + " -parseFile=<filePath>", new Object[0]);
        Print.logInfo(" or", new Object[0]);
        Print.logInfo("  java ... " + className + " [-port=<port>[,<port>]] -start", new Object[0]);
        Print.logInfo("Options:", new Object[0]);
        Print.logInfo("  -help               This help", new Object[0]);
        Print.logInfo("  [-port=<p>[,<p>]]   Server TCP/UDP port(s) to listen", new Object[0]);
        Print.logInfo("  [-tcp=<p>[,<p>]]    Server TCP port(s) to listen on [dft=" + tcp + "]", new Object[0]);
        Print.logInfo("  [-udp=<p>[,<p>]]    Server UDP port(s) to listen on [dft=" + udp + "]", new Object[0]);
        Print.logInfo("  [-command=<p>]      Command port to listen on [dft=" + cmd + "]", new Object[0]);
        Print.logInfo("  [-dcs=<serverId>]   DCServer ID [dft=template]", new Object[0]);
        Print.logInfo("  [-format=<parser#>] Parser Format #", new Object[0]);
        Print.logInfo("  -start              Start server on the specified port.", new Object[0]);
        Print.logInfo("  -parseFile=<file>   File from which data will be parsed.", new Object[0]);
        Print.logInfo("", new Object[0]);
        System.exit(1);
    }

    public static void main(String[] argv) {
        DBConfig.cmdLineInit(argv, false);
        TrackClientPacketHandler.configInit();
        TrackServer.configInit();
        DCServerConfig dcsc = Main.getServerConfig(null);
        String uniquPfx = dcsc != null ? StringTools.join(dcsc.getUniquePrefix(), ",") : "n/a";
        String SEP = "--------------------------------------------------------------------------";
        Print.logInfo(SEP, new Object[0]);
        Print.logInfo("Template Example Server Version 0.2.8", new Object[0]);
        Print.logInfo("DeviceCode           : template", new Object[0]);
        Print.logInfo("UniqueID Prefix      : " + uniquPfx, new Object[0]);
        Print.logInfo("ParseFormat          : " + TrackClientPacketHandler.DATA_FORMAT_OPTION, new Object[0]);
        Print.logInfo("MinimumSpeed         : " + TrackClientPacketHandler.MINIMUM_SPEED_KPH, new Object[0]);
        Print.logInfo("EstimateOdom         : " + TrackClientPacketHandler.ESTIMATE_ODOMETER, new Object[0]);
        Print.logInfo("TCP Idle Timeout     : " + TrackServer.getTcpIdleTimeout() + " ms", new Object[0]);
        Print.logInfo("TCP Packet Timeout   : " + TrackServer.getTcpPacketTimeout() + " ms", new Object[0]);
        Print.logInfo("TCP Session Timeout  : " + TrackServer.getTcpSessionTimeout() + " ms", new Object[0]);
        Print.logInfo("UDP Idle Timeout     : " + TrackServer.getUdpIdleTimeout() + " ms", new Object[0]);
        Print.logInfo("UDP Packet Timeout   : " + TrackServer.getUdpPacketTimeout() + " ms", new Object[0]);
        Print.logInfo("UDP Session Timeout  : " + TrackServer.getUdpSessionTimeout() + " ms", new Object[0]);
        Print.logInfo("Copyright 2007-2013, GeoTelematic Solutions, Inc.", new Object[0]);
        Print.logInfo(SEP, new Object[0]);
        if (RTConfig.getBoolean(ARG_HELP, false)) {
            Main.usage("Help ...");
            System.exit(0);
        }
        if (!DBAdmin.verifyTablesExist()) {
            Print.logFatal("MySQL database has not yet been properly initialized", new Object[0]);
            System.exit(1);
        }
        if (RTConfig.hasProperty(ARG_PARSEFILE)) {
            Print.sysPrintln("Attempting to parse data from file: " + RTConfig.getString(ARG_PARSEFILE), new Object[0]);
            RTConfig.setString("parseFile", RTConfig.getString(ARG_PARSEFILE));
            int exit = TrackClientPacketHandler._main(true);
            System.exit(exit);
        }
        if (RTConfig.getBoolean(ARG_START, false)) {
            try {
                int[] tcpPorts = Main.getTcpPorts();
                int[] udpPorts = Main.getUdpPorts();
                int commandPort = Main.getCommandDispatcherPort();
                TrackServer.startTrackServer(tcpPorts, udpPorts, commandPort);
            }
            catch (Throwable t) {
                Print.logError("Error: " + t, new Object[0]);
            }
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(3600000L);
                    }
                }
                catch (Throwable t) {
                    continue;
                }
                break;
            }
        }
        Main.usage("Missing '-start' ...");
        System.exit(1);
    }
}

