/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.admin.rules;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import org.opengts.db.RuleFactory;
import org.opengts.db.tables.Account;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.dbtools.DBException;
import org.opengts.opt.admin.GTSAdmin;
import org.opengts.opt.admin.edit.StatusCodeEditor;
import org.opengts.opt.admin.edit.TimestampEditor;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VButton;
import org.opengts.opt.ui.VComboBox;
import org.opengts.opt.ui.VDialog;
import org.opengts.opt.ui.VFiller;
import org.opengts.opt.ui.VLabelValue;
import org.opengts.opt.ui.VSeparator;
import org.opengts.opt.ui.VTextField;
import org.opengts.util.DateTime;
import org.opengts.util.OrderedMap;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class RuleEvaluator
extends VDialog {
    private static final String FIELD_ACCOUNT = "rule.account";
    private static final String FIELD_DEVICE = "rule.device";
    private static final String FIELD_TIMESTAMP = "rule.timestamp";
    private static final String FIELD_STATUSCODE = "rule.statusCode";
    private static final String FIELD_LATITUDE = "rule.latitude";
    private static final String FIELD_LONGITUDE = "rule.longitude";
    private static final String FIELD_SPEEDKPH = "rule.speedKPH";
    private static final String FIELD_HEADING = "rule.heading";
    private static final String FIELD_ODOMETER = "rule.odometer";
    private static final String FIELD_GEOZONE = "rule.geozone";
    private static final String FIELD_DRIVER = "rule.driver";
    private Account account = null;
    private Device device = null;
    private VLabelValue labelValue = null;
    private VComboBox functionCB = null;
    private VTextField functionDesc = null;
    private VComboBox identifierCB = null;
    private VTextField identifierDesc = null;
    private VTextField selectorText = null;
    private VButton evaluateBtn = null;
    private VButton cancelBtn = null;
    private VButton okBtn = null;
    private Object selectorResult = null;
    private VTextField resultText = null;
    private static RuleEvaluator dialog = null;

    protected RuleEvaluator(Frame owner) {
        super(owner, "Rule Selector Test", true);
        this.setBackground(GTSAdmin.COLOR_BACKGROUND);
        this.initLayout();
        this.centerOnScreen(600, -1);
    }

    protected void initLayout() {
        List<String> names;
        VBox content = this.getContentBox();
        GridBagConstraints gbc = content.getDefaultGBC();
        gbc.anchor = 10;
        final RuleFactory ruleFactory = Device.getRuleFactory();
        int row = 0;
        this.labelValue = new VLabelValue("Event State:", null, true);
        VBox.SetGBCX((GridBagConstraints)gbc, (double)0.5, (int)0, (int)1, (int)10, (int)10);
        VBox.SetGBCY((GridBagConstraints)gbc, (double)0.0, (int)row++, (int)1, (int)5, (int)0);
        content.add((Component)this.labelValue, (Object)gbc);
        this.labelValue.addRow("Account ID:", "(must exist)", (VBox)VTextField.TextField((int)16), null, FIELD_ACCOUNT);
        this.labelValue.addRow("Device ID:", "(should exist)", (VBox)VTextField.TextField((int)16), null, FIELD_DEVICE);
        this.labelValue.addSeparator();
        this.labelValue.addRow("Timestamp:", "(epoch)", (VBox)new TimestampEditor(), null, FIELD_TIMESTAMP);
        this.labelValue.addRow("Status Code:", "", (VBox)new StatusCodeEditor(), null, FIELD_STATUSCODE);
        this.labelValue.addRow("Latitude:", "(degrees)", (VBox)VTextField.DoubleField((int)11), null, FIELD_LATITUDE);
        this.labelValue.addRow("Longitude:", "(degrees)", (VBox)VTextField.DoubleField((int)11), null, FIELD_LONGITUDE);
        this.labelValue.addRow("Speed:", "(kph)", (VBox)VTextField.DoubleField((int)5), null, FIELD_SPEEDKPH);
        this.labelValue.addRow("Heading:", "(degrees)", (VBox)VTextField.DoubleField((int)7), null, FIELD_HEADING);
        this.labelValue.addRow("Odometer:", "(kilometers)", (VBox)VTextField.DoubleField((int)11), null, FIELD_ODOMETER);
        this.labelValue.addRow("Geozone:", "", (VBox)VTextField.TextField((int)16), null, FIELD_GEOZONE);
        this.labelValue.addRow("Driver:", "", (VBox)VTextField.TextField((int)16), null, FIELD_DRIVER);
        this.labelValue.setRowValue(FIELD_TIMESTAMP, DateTime.getCurrentTimeSec());
        this.labelValue.setRowValue(FIELD_LATITUDE, 39.0);
        this.labelValue.setRowValue(FIELD_LONGITUDE, -141.0);
        this.labelValue.setRowValue(FIELD_SPEEDKPH, 53.0);
        this.labelValue.setRowValue(FIELD_HEADING, 127.2);
        this.labelValue.setRowValue(FIELD_ODOMETER, 123456.7);
        this.labelValue.setRowValue(FIELD_GEOZONE, "");
        this.labelValue.setRowValue(FIELD_DRIVER, "smith");
        VBox.SetGBCX((GridBagConstraints)gbc, (double)0.5, (int)0, (int)1, (int)0, (int)0);
        VBox.SetGBCY((GridBagConstraints)gbc, (double)0.0, (int)row++, (int)1, (int)5, (int)5);
        content.add((Component)new VSeparator(), (Object)gbc);
        this.functionCB = new VComboBox("Function Usage/Descriptions:", null, false);
        VBox.SetGBCX((GridBagConstraints)gbc, (double)0.5, (int)0, (int)1, (int)10, (int)10);
        VBox.SetGBCY((GridBagConstraints)gbc, (double)0.0, (int)row++, (int)1, (int)0, (int)0);
        content.add((Component)this.functionCB, (Object)gbc);
        if (ruleFactory != null) {
            names = ruleFactory.getFunctionNames();
            OrderedMap<String, String> usageMap = new OrderedMap<String, String>();
            for (String ftnName : names) {
                String usage = ruleFactory.getFunctionUsage(ftnName);
                if (StringTools.isBlank(usage)) continue;
                usageMap.put(usage, ftnName);
            }
            this.functionCB.setModel(usageMap);
        }
        this.functionDesc = new VTextField(null, "Description:", false);
        this.functionDesc.setReadOnly(true);
        VBox.SetGBCX((GridBagConstraints)gbc, (double)0.5, (int)0, (int)1, (int)10, (int)10);
        VBox.SetGBCY((GridBagConstraints)gbc, (double)0.0, (int)row++, (int)1, (int)5, (int)5);
        content.add((Component)this.functionDesc, (Object)gbc);
        this.functionCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String n = RuleEvaluator.this.functionCB.getStringValue("");
                String d = ruleFactory.getFunctionDescription(n);
                RuleEvaluator.this.functionDesc.setText(d);
                RuleEvaluator.this.appendSelectorText(n + "()");
            }
        });
        this.functionDesc.setText(ruleFactory.getFunctionDescription(this.functionCB.getStringValue("")));
        VBox.SetGBCX((GridBagConstraints)gbc, (double)0.5, (int)0, (int)1, (int)0, (int)0);
        VBox.SetGBCY((GridBagConstraints)gbc, (double)0.0, (int)row++, (int)1, (int)5, (int)5);
        content.add((Component)new VSeparator(), (Object)gbc);
        this.identifierCB = new VComboBox("Identfier Names/Descriptions:", null, false);
        VBox.SetGBCX((GridBagConstraints)gbc, (double)0.5, (int)0, (int)1, (int)10, (int)10);
        VBox.SetGBCY((GridBagConstraints)gbc, (double)0.0, (int)row++, (int)1, (int)5, (int)0);
        content.add((Component)this.identifierCB, (Object)gbc);
        if (ruleFactory != null) {
            names = ruleFactory.getIdentifierNames();
            this.identifierCB.setModel(names);
        }
        this.identifierDesc = new VTextField(null, "Description:", false);
        this.identifierDesc.setReadOnly(true);
        VBox.SetGBCX((GridBagConstraints)gbc, (double)0.5, (int)0, (int)1, (int)10, (int)10);
        VBox.SetGBCY((GridBagConstraints)gbc, (double)0.0, (int)row++, (int)1, (int)5, (int)5);
        content.add((Component)this.identifierDesc, (Object)gbc);
        this.identifierCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                String n = RuleEvaluator.this.identifierCB.getStringValue("");
                String d = ruleFactory.getIdentifierDescription(n);
                RuleEvaluator.this.identifierDesc.setText(d);
                RuleEvaluator.this.appendSelectorText(n);
            }
        });
        this.identifierDesc.setText(ruleFactory.getIdentifierDescription(this.identifierCB.getStringValue("")));
        VBox.SetGBCX((GridBagConstraints)gbc, (double)0.5, (int)0, (int)1, (int)0, (int)0);
        VBox.SetGBCY((GridBagConstraints)gbc, (double)0.0, (int)row++, (int)1, (int)5, (int)5);
        content.add((Component)new VSeparator(), (Object)gbc);
        this.selectorText = new VTextField("Selector:", null, false);
        VBox.SetGBCX((GridBagConstraints)gbc, (double)0.5, (int)0, (int)1, (int)10, (int)10);
        VBox.SetGBCY((GridBagConstraints)gbc, (double)0.0, (int)row++, (int)1, (int)5, (int)0);
        content.add((Component)this.selectorText, (Object)gbc);
        this.selectorText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                RuleEvaluator.this.evaluate();
            }
        });
        VBox.SetGBCX((GridBagConstraints)gbc, (double)0.5, (int)0, (int)1, (int)0, (int)0);
        VBox.SetGBCY((GridBagConstraints)gbc, (double)0.0, (int)row++, (int)1, (int)5, (int)5);
        content.add((Component)new VSeparator(), (Object)gbc);
        this.resultText = new VTextField("Result: (non-zero values yield a 'true' match)", null, false);
        this.resultText.setReadOnly(true);
        VBox.SetGBCX((GridBagConstraints)gbc, (double)0.5, (int)0, (int)1, (int)10, (int)10);
        VBox.SetGBCY((GridBagConstraints)gbc, (double)0.0, (int)row++, (int)1, (int)0, (int)0);
        content.add((Component)this.resultText, (Object)gbc);
        this.selectorResult = null;
        VBox.SetGBCX((GridBagConstraints)gbc, (double)0.5, (int)0, (int)1, (int)0, (int)0);
        VBox.SetGBCY((GridBagConstraints)gbc, (double)0.0, (int)row++, (int)1, (int)5, (int)5);
        content.add((Component)new VSeparator(), (Object)gbc);
        VBox btnBox = new VBox(null, null, false);
        VBox.SetGBCX((GridBagConstraints)gbc, (double)0.5, (int)0, (int)1, (int)10, (int)10);
        VBox.SetGBCY((GridBagConstraints)gbc, (double)0.0, (int)row++, (int)1);
        content.add((Component)btnBox, (Object)gbc);
        GridBagConstraints bbGBC = btnBox.getDefaultGBC();
        this.evaluateBtn = new VButton("Evaluate");
        this.evaluateBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                RuleEvaluator.this.evaluate();
            }
        });
        VBox.SetGBCX((GridBagConstraints)bbGBC, (double)0.0, (int)0, (int)1, (int)0, (int)0);
        VBox.SetGBCY((GridBagConstraints)bbGBC, (double)0.0, (int)0, (int)1);
        btnBox.add((Component)this.evaluateBtn, (Object)bbGBC);
        VBox.SetGBCX((GridBagConstraints)bbGBC, (double)0.5, (int)1, (int)1, (int)0, (int)0);
        VBox.SetGBCY((GridBagConstraints)bbGBC, (double)0.0, (int)0, (int)1);
        btnBox.add((Component)new VFiller(), (Object)bbGBC);
        this.cancelBtn = new VButton("Cancel");
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                RuleEvaluator.this.selectorResult = null;
                RuleEvaluator.this.setVisible(false);
            }
        });
        VBox.SetGBCX((GridBagConstraints)bbGBC, (double)0.0, (int)2, (int)1, (int)0, (int)0);
        VBox.SetGBCY((GridBagConstraints)bbGBC, (double)0.0, (int)0, (int)1);
        btnBox.add((Component)this.cancelBtn, (Object)bbGBC);
        this.okBtn = new VButton("OK/Exit");
        this.okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                RuleEvaluator.this.setVisible(false);
            }
        });
        VBox.SetGBCX((GridBagConstraints)bbGBC, (double)0.0, (int)3, (int)1, (int)10, (int)0);
        VBox.SetGBCY((GridBagConstraints)bbGBC, (double)0.0, (int)0, (int)1);
        btnBox.add((Component)this.okBtn, (Object)bbGBC);
        this.setDevice(null);
    }

    protected void appendSelectorText(String value) {
        String v = StringTools.trim(value);
        if (!StringTools.isBlank(v)) {
            StringBuffer sb = new StringBuffer(this.selectorText.getText().trim());
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(v);
            this.selectorText.setText(sb.toString());
        }
    }

    public void setAccount(Account account) {
        if (account != null) {
            this.labelValue.setRowReadOnly(FIELD_ACCOUNT, true);
            this.labelValue.setRowValue(FIELD_ACCOUNT, account.getAccountID());
            this.cancelBtn.setVisible(true);
            this.account = this.device.getAccount();
        } else {
            this.labelValue.setRowReadOnly(FIELD_ACCOUNT, false);
            this.labelValue.setRowValue(FIELD_ACCOUNT, "demo");
            this.cancelBtn.setVisible(false);
            this.account = null;
        }
    }

    public void setDevice(Device device) {
        if (device != null) {
            this.setAccount(device.getAccount());
            this.labelValue.setRowReadOnly(FIELD_DEVICE, true);
            this.labelValue.setRowValue(FIELD_DEVICE, device.getDeviceID());
            this.device = device.getDevice();
        } else {
            this.setAccount(null);
            this.labelValue.setRowReadOnly(FIELD_DEVICE, false);
            this.labelValue.setRowValue(FIELD_DEVICE, "");
            this.device = null;
        }
    }

    private String getRowString(String key, String dft) {
        Object s = this.labelValue.getRowValue(key);
        return s != null ? s.toString() : dft;
    }

    private int getRowInt(String key, int dft) {
        return this.labelValue.getRowValue(key, dft);
    }

    private long getRowLong(String key, long dft) {
        return this.labelValue.getRowValue(key, dft);
    }

    private double getRowDouble(String key, double dft) {
        return this.labelValue.getRowValue(key, dft);
    }

    private void evaluate() {
        this.selectorResult = null;
        this.resultText.setText("");
        String selector = this.selectorText.getText();
        if (StringTools.isBlank(selector)) {
            return;
        }
        RuleFactory ruleFactory = Device.getRuleFactory();
        if (ruleFactory == null) {
            return;
        }
        String accountID = this.getRowString(FIELD_ACCOUNT, "");
        try {
            if (!Account.exists(accountID)) {
                this.resultText.setText("Account does not exist: " + accountID);
                return;
            }
        }
        catch (DBException dbe) {
            Print.logException("Checking Account", dbe);
        }
        String deviceID = this.getRowString(FIELD_DEVICE, "");
        if (!StringTools.isBlank(deviceID)) {
            try {
                if (!Device.exists(accountID, deviceID)) {
                    this.resultText.setText("Device does not exist: " + accountID + "/" + deviceID);
                    return;
                }
            }
            catch (DBException dbe) {
                Print.logException("Checking Device", dbe);
            }
        }
        long timestamp = this.getRowLong(FIELD_TIMESTAMP, DateTime.getCurrentTimeSec());
        int statusCode = this.getRowInt(FIELD_STATUSCODE, 61472);
        EventData.Key evkey = new EventData.Key(accountID, deviceID, timestamp, statusCode);
        EventData evRcd = (EventData)evkey.getDBRecord();
        evRcd.setLatitude(this.getRowDouble(FIELD_LATITUDE, 0.0));
        evRcd.setLongitude(this.getRowDouble(FIELD_LONGITUDE, 0.0));
        evRcd.setSpeedKPH(this.getRowDouble(FIELD_SPEEDKPH, 0.0));
        evRcd.setHeading(this.getRowDouble(FIELD_HEADING, 0.0));
        evRcd.setOdometerKM(this.getRowDouble(FIELD_ODOMETER, 0.0));
        evRcd.setDistanceKM(this.getRowDouble(FIELD_ODOMETER, 0.0) / 2.0);
        evRcd.setGeozoneID(this.getRowString(FIELD_GEOZONE, ""));
        evRcd.setDriverID(this.getRowString(FIELD_DRIVER, ""));
        evRcd.setPostalCode("95603");
        evRcd.setCountry("US");
        evRcd.setSubdivision("US/CA");
        evRcd.setAltitude(1234.5);
        evRcd.setGpsAge(5L);
        evRcd.setEntityID("trailer");
        evRcd.setInputMask(21845L);
        if (this.account != null && this.account.getAccountID().equals(accountID)) {
            this.account.reload();
            evRcd.setAccount(this.account);
            if (this.device != null && this.device.getDeviceID().equals(deviceID)) {
                this.device.reload();
                evRcd.setDevice(this.device);
            }
        }
        try {
            this.selectorResult = ruleFactory.evaluateSelector(selector, evRcd);
            if (this.selectorResult instanceof String) {
                this.resultText.setText("\"" + this.selectorResult + "\"");
            } else if (this.selectorResult != null) {
                this.resultText.setText(this.selectorResult.toString());
            } else {
                this.resultText.setText("n/a");
            }
        }
        catch (Throwable th) {
            Throwable cause = th.getCause();
            if (cause != null) {
                this.resultText.setText(cause.getMessage());
            }
            this.resultText.setText(th.getMessage());
        }
        if (evRcd.hasAccount()) {
            this.account = evRcd.getAccount();
            if (evRcd.hasDevice()) {
                this.device = evRcd.getDevice();
            }
        }
    }

    public Object getResult() {
        return this.selectorResult;
    }

    private static RuleEvaluator _getDialog() {
        if (dialog == null) {
            dialog = new RuleEvaluator((Frame)((Object)GTSAdmin.getInstance()));
        }
        return dialog;
    }

    public static void showDialog() {
        RuleEvaluator._getResult(null, null);
    }

    public static Object getResult(Device device) {
        return RuleEvaluator._getResult(null, device);
    }

    public static Object getResult(Account account) {
        return RuleEvaluator._getResult(account, null);
    }

    protected static Object _getResult(Account account, Device device) {
        RuleEvaluator red = RuleEvaluator._getDialog();
        if (device != null) {
            red.setDevice(device);
        } else if (account != null) {
            red.setAccount(account);
        } else {
            red.setDevice(null);
        }
        red.setVisible(true);
        return red.getResult();
    }
}

