/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.admin.edit;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Vector;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBFactoryTree;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordKey;
import org.opengts.dbtools.DBWhere;
import org.opengts.opt.admin.GTSAdmin;
import org.opengts.opt.admin.edit.DBTableEditor;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VButton;
import org.opengts.opt.ui.VDialog;
import org.opengts.opt.ui.VLabelValue;
import org.opengts.opt.ui.VOptionPane;
import org.opengts.opt.ui.VTable;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;

public class KeyEntryDialog
extends VDialog {
    private static long BrowsePageRecordCount = 25L;
    private DBFactoryTree dbFactTree = null;
    private VLabelValue keyValues = null;
    private KeyBrowserTable browserTable = null;
    private long browserRcdCount = 0L;
    private long browserPage = 0L;
    private VButton browserNext = null;
    private VButton browserPrev = null;
    private String browserOrderBy = null;
    private Map<DBField, Object> fieldKeyMap = null;

    public KeyEntryDialog(DBFactoryTree factTree) {
        super((Frame)((Object)GTSAdmin.getInstance()), "Key Entry", true);
        this.setBackground(GTSAdmin.COLOR_BACKGROUND);
        this.dbFactTree = factTree;
        BrowsePageRecordCount = RTConfig.getLong("gtsAdmin.browsePageSize", BrowsePageRecordCount);
        if (BrowsePageRecordCount < 2L) {
            BrowsePageRecordCount = 2L;
        }
        this.init();
        this.centerOnScreen(-1, -1);
    }

    private void init() {
        VBox content = this.getContentBox();
        this.keyValues = new VLabelValue(null, null, false);
        content.setGBCX(0.5, 0, 1);
        content.setGBCY(0.0, 0, 1, 10, 0);
        content.add((Component)this.keyValues, (Object)content.getDefaultGBC());
        DBField[] keyFlds = this.dbFactTree.getKeyFields();
        for (int i = 0; i < keyFlds.length; ++i) {
            DBField fld = keyFlds[i];
            VBox editor = DBTableEditor.CreateFieldEditor(fld, -1);
            String fldName = fld.getName();
            StringBuffer title = new StringBuffer();
            title.append(fld.getTitle(null));
            title.append(" [").append(fldName).append("]");
            title.append(":");
            this.keyValues.addRow(title.toString(), editor, fldName);
        }
        this.browserTable = new KeyBrowserTable();
        this.browserTable.setPreferredHeight(250);
        content.setGBCX(0.5, 0, 1);
        content.setGBCY(0.5, 1, 1);
        content.add((Component)((Object)this.browserTable), (Object)content.getDefaultGBC());
        this.initButtons();
    }

    private void initButtons() {
        this.setButtonAnchor(10);
        this.browserPrev = new VButton("Prev");
        this.browserPrev.setMargin(new Insets(1, 3, 1, 3));
        this.browserPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                KeyEntryDialog.this.prevClicked();
            }
        });
        this.browserPrev.setEnabled(false);
        this.addButton(this.browserPrev);
        this.browserNext = new VButton("Next");
        this.browserNext.setMargin(new Insets(1, 3, 1, 3));
        this.browserNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                KeyEntryDialog.this.nextClicked();
            }
        });
        this.browserNext.setEnabled(false);
        this.addButton(this.browserNext);
        this.addButtonSeparator();
        VButton okBtn = new VButton("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                KeyEntryDialog.this.okClicked();
            }
        });
        this.addButton(okBtn, true);
        VButton cancelBtn = new VButton("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                KeyEntryDialog.this.cancelClicked();
            }
        });
        this.addButton(cancelBtn);
    }

    private String getRecordWhereClause() throws DBException {
        DBRecordKey rcdCntKey = this._createRecordKey(false);
        try {
            String rcdWhere = rcdCntKey.getWhereClause(DBWhere.KEY_PARTIAL_FIRST);
            return rcdWhere;
        }
        catch (DBException whe) {
            return "";
        }
    }

    private long getRecordCount() throws DBException {
        String rcdWhere = this.getRecordWhereClause();
        DBFactory<? extends DBRecord> fact = this.dbFactTree.getDBFactory();
        if (fact != null) {
            return fact.getRecordCount(rcdWhere, false);
        }
        return -1L;
    }

    private DBRecord[] getRecords(long limit, long offset, String[] orderBy) throws DBException {
        String rcdWhere = this.getRecordWhereClause();
        return DBRecord.getRecords(this.dbFactTree.getDBFactory(), (String)rcdWhere, null, (String[])orderBy, (boolean)true, (long)limit, (long)offset);
    }

    private DBRecordKey _createRecordKey(boolean fillWithValue) throws DBException {
        if (this.fieldKeyMap != null) {
            DBRecordKey<? extends DBRecord> rcdKey = this.dbFactTree.getDBFactory().createKey();
            for (DBField fld : this.fieldKeyMap.keySet()) {
                Object objVal = this.fieldKeyMap.get(fld);
                String name = fld.getName();
                if (objVal == null && !fillWithValue) continue;
                if (objVal == null) {
                    objVal = this.keyValues.getRowValue(fld.getName());
                }
                if (objVal instanceof String) {
                    rcdKey.setFieldValue(name, fld.parseStringValue((String)objVal));
                    continue;
                }
                rcdKey.setFieldValue(name, objVal);
            }
            return rcdKey;
        }
        return null;
    }

    public DBRecordKey getRecordKey(boolean browse) {
        this.fieldKeyMap = this.dbFactTree.getKeyMap();
        for (DBField fld : this.fieldKeyMap.keySet()) {
            Object value = this.fieldKeyMap.get(fld);
            String name = fld.getName();
            this.keyValues.setRowReadOnly(name, value != null);
            this.keyValues.setRowValue(name, value);
        }
        try {
            this.browserRcdCount = this.getRecordCount();
        }
        catch (DBException dbe) {
            Print.logException("Unable to determine record count", dbe);
            this.browserRcdCount = 0L;
        }
        if (browse) {
            this.browserTable.setTitle("Total Record Count: " + this.browserRcdCount);
            this.resetBrowser(null);
            this.browserTable.setVisible(true);
            this.browserPrev.setVisible(true);
            this.browserNext.setVisible(true);
        } else {
            this.browserTable.setTitle("");
            this.browserTable.clearTableData();
            this.browserTable.setVisible(false);
            this.browserPrev.setVisible(false);
            this.browserNext.setVisible(false);
        }
        this.centerOnScreen(-1, -1);
        this.setVisible(true);
        this.browserTable.clearTableData();
        if (this.fieldKeyMap == null) {
            return null;
        }
        try {
            return this._createRecordKey(true);
        }
        catch (DBException dbe) {
            VOptionPane.showErrorDialog((Component)((Object)this), (Object)("Error creating record key\n" + dbe), (String)"Error Creating Key");
            return null;
        }
    }

    protected void resetBrowser(String sortId) {
        this.browserPage = 0L;
        long limit = BrowsePageRecordCount;
        long offset = this.browserPage * BrowsePageRecordCount;
        this.browserOrderBy = sortId;
        this.fillBrowser(limit, offset, this.browserOrderBy);
    }

    private void prevClicked() {
        if (this.browserPage > 0L) {
            --this.browserPage;
        }
        long limit = BrowsePageRecordCount;
        long offset = this.browserPage * BrowsePageRecordCount;
        this.fillBrowser(limit, offset, this.browserOrderBy);
    }

    private void nextClicked() {
        ++this.browserPage;
        long limit = BrowsePageRecordCount;
        long offset = this.browserPage * BrowsePageRecordCount;
        if (offset >= this.browserRcdCount) {
            this.browserPage = this.browserRcdCount / BrowsePageRecordCount;
            offset = this.browserPage * BrowsePageRecordCount;
        }
        this.fillBrowser(limit, offset, this.browserOrderBy);
    }

    private void fillBrowser(long limit, long offset, String sortId) {
        String[] stringArray;
        if (sortId != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = sortId;
        } else {
            stringArray = this.dbFactTree.getKeyNames();
        }
        String[] orderBy = stringArray;
        try {
            DBRecord[] records = this.getRecords(limit, offset, orderBy);
            VTable.VTableRow[] rcdRows = new KeyRecordRow[records.length];
            for (int r = 0; r < records.length; ++r) {
                rcdRows[r] = new KeyRecordRow(offset + (long)r, records[r]);
            }
            this.browserTable.setTableData(rcdRows);
            this.browserPrev.setEnabled(this.browserPage > 0L);
            this.browserNext.setEnabled(offset + limit < this.browserRcdCount);
        }
        catch (DBException dbe) {
            this.browserTable.clearTableData();
            this.browserPrev.setEnabled(false);
            this.browserNext.setEnabled(false);
        }
    }

    private void okClicked() {
        if (this.fieldKeyMap != null) {
            for (DBField fld : this.fieldKeyMap.keySet()) {
                if (this.fieldKeyMap.get(fld) != null) continue;
                Object value = this.keyValues.getRowValue(fld.getName());
                if (value == null || value.equals("")) {
                    VOptionPane.showWarningDialog((Component)((Object)this), (Object)"Please enter all key values", (String)"Enter Keys");
                    return;
                }
                this.fieldKeyMap.put(fld, value);
            }
        }
        this.setVisible(false);
    }

    private void cancelClicked() {
        this.fieldKeyMap = null;
        this.setVisible(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    private VTable.VColumnInfo[] createTableColumnInfo() {
        Vector<VTable.VColumnInfo> columns = new Vector<VTable.VColumnInfo>();
        boolean sortAscending = true;
        columns.add(new VTable.VColumnInfo("<index>", "##", 50, false, false));
        DBField[] keyField = this.dbFactTree.getKeyFields();
        for (int i = 0; i < keyField.length; ++i) {
            DBField fld = keyField[i];
            String name = fld.getName();
            String title = fld.getTitle(null);
            boolean sort = false;
            columns.add(new VTable.VColumnInfo(name, title, 400, sort ? sortAscending : false, false));
        }
        if (this.dbFactTree.getDBFactory().hasField("description")) {
            String name = "description";
            String title = "Description";
            columns.add(new VTable.VColumnInfo(name, title, 500, sortAscending, false));
        }
        return columns.toArray(new VTable.VColumnInfo[columns.size()]);
    }

    private void _setSeletedKeyRecordRow(KeyRecordRow row) {
        if (row != null) {
            DBRecord record = row.getDBRecord();
            DBField[] keyFlds = this.dbFactTree.getKeyFields();
            for (int i = 0; i < keyFlds.length; ++i) {
                DBField fld = keyFlds[i];
                String name = fld.getName();
                if (this.keyValues.isRowReadOnly(name)) continue;
                Object value = record.getFieldValue(name);
                this.keyValues.setRowValue(name, value);
            }
        }
    }

    private class KeyRecordRow
    implements VTable.VTableRow {
        private long index = -1L;
        private DBRecord record = null;

        public KeyRecordRow(long ndx, DBRecord rcd) {
            this.index = ndx;
            this.record = rcd;
        }

        public DBRecord getDBRecord() {
            return this.record;
        }

        public Object getRowObject() {
            return this.record;
        }

        public Object getColumnValue(int col) {
            if (col <= 0) {
                return new Long(this.index + 1L);
            }
            int colNdx = col - 1;
            DBField[] keyField = KeyEntryDialog.this.dbFactTree.getKeyFields();
            if (colNdx < keyField.length) {
                Object val = this.record.getFieldValue(keyField[colNdx].getName());
                return val != null ? val : "";
            }
            Object val = this.record.getFieldValue("description");
            return val != null ? val : "";
        }

        public void setColumnValue(int col, Object value) {
        }

        public boolean isColumnEditable(int col) {
            return false;
        }
    }

    public class KeyBrowserTable
    extends VTable {
        private VTable.VColumnInfo[] columnInfo;

        public KeyBrowserTable() {
            super("", null, true);
            this.columnInfo = null;
            this.columnInfo = KeyEntryDialog.this.createTableColumnInfo();
            this.setTableColumns(this.columnInfo);
            this.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent lse) {
                    if (!lse.getValueIsAdjusting()) {
                        KeyRecordRow row = (KeyRecordRow)KeyBrowserTable.this.getSelectedRow();
                        KeyEntryDialog.this._setSeletedKeyRecordRow(row);
                    }
                }
            });
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    KeyRecordRow row = (KeyRecordRow)KeyBrowserTable.this.getSelectedRow();
                    KeyEntryDialog.this._setSeletedKeyRecordRow(row);
                    KeyEntryDialog.this.okClicked();
                }
            });
        }

        public void setSortableColumns() {
            if (KeyEntryDialog.this.fieldKeyMap != null) {
                for (int i = 0; i < this.columnInfo.length; ++i) {
                    String name = this.columnInfo[i].getColumnID();
                    if (!Character.isLetter(name.charAt(0))) continue;
                    DBField fld = KeyEntryDialog.this.dbFactTree.getField(name);
                    boolean browseValue = KeyEntryDialog.this.fieldKeyMap.get(fld) == null;
                    this.setColumnSortableAscending(i, browseValue);
                }
            }
        }

        public void setTableData(VTable.VTableRow[] data) {
            super.setTableData(data);
            this.setSortableColumns();
            String sortId = KeyEntryDialog.this.browserOrderBy;
            if (sortId != null && !sortId.equals("")) {
                this.setColumnIcon(this.getColumnIndex(sortId), this.getSortIcon(true));
            }
        }

        protected void sortByColumn(int modelCol, boolean ascending) {
            if (modelCol > 0) {
                KeyEntryDialog.this.resetBrowser(this.columnInfo[modelCol].getColumnID());
            }
        }
    }
}

