/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.admin.edit;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import org.opengts.db.dmtp.EventTemplate;
import org.opengts.dbtypes.DTTemplate;
import org.opengts.opt.ui.VTable;

public class EventTemplateEditor
extends VTable
implements ActionListener {
    private static VTable.VColumnInfo[] columns = new VTable.VColumnInfo[]{new VTable.VColumnInfo("field.numb", "##", 70, false), new VTable.VColumnInfo("field.type", "Field Type", 300, false), new VTable.VColumnInfo("field.resolution", "Resolution", 150, false), new VTable.VColumnInfo("field.startPos", "Position", 100, false), new VTable.VColumnInfo("field.length", "Length", 100, false)};
    private DTTemplate eventTemplate = null;

    public EventTemplateEditor() {
        super(null, null, false);
        super.setPreferredHeight(300);
        this.setTableColumns(columns);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.fireActionEvent(null);
    }

    public void setValue(Object value) {
        DTTemplate.Field f;
        this.eventTemplate = value == null ? new DTTemplate() : (value instanceof DTTemplate ? (DTTemplate)value : new DTTemplate(value.toString()));
        Vector<FieldRow> fieldRow = new Vector<FieldRow>();
        int p = 0;
        int i = 0;
        while ((f = this.eventTemplate.getField(i)) != null) {
            fieldRow.add(new FieldRow(i, p, f));
            p += f.getLength();
            ++i;
        }
        this.setTableData(fieldRow);
    }

    public Object getValue() {
        return this.eventTemplate;
    }

    private static class FieldRow
    implements VTable.VTableRow {
        private int index = -1;
        private int startPos = -1;
        private DTTemplate.Field field = null;

        public FieldRow(int ndx, int pos, DTTemplate.Field fld) {
            this.index = ndx;
            this.startPos = pos;
            this.field = fld;
        }

        public Object getRowObject() {
            return this.field;
        }

        public Object getColumnValue(int col) {
            switch (col) {
                case 0: {
                    return new Integer(this.index + 1);
                }
                case 1: {
                    return EventTemplate.getFieldTypeDescription(this.field.getType());
                }
                case 2: {
                    return this.field.isHiRes() ? "High" : "Low";
                }
                case 3: {
                    return new Integer(this.startPos);
                }
                case 4: {
                    return new Integer(this.field.getLength());
                }
            }
            return "";
        }

        public void setColumnValue(int col, Object value) {
        }

        public boolean isColumnEditable(int col) {
            return false;
        }
    }
}

