/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.admin.edit;

import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opengts.db.BasicPrivateLabel;
import org.opengts.db.BasicPrivateLabelLoader;
import org.opengts.dbtools.DBException;
import org.opengts.dbtools.DBFactoryTree;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordKey;
import org.opengts.opt.admin.DBNodeCustomView;
import org.opengts.opt.admin.EditorNode;
import org.opengts.opt.admin.GTSAdmin;
import org.opengts.opt.admin.edit.AccountStringEditor;
import org.opengts.opt.admin.edit.EncodingsEditor;
import org.opengts.opt.admin.edit.EventTemplateEditor;
import org.opengts.opt.admin.edit.KeyEntryDialog;
import org.opengts.opt.admin.edit.PasswordEditor;
import org.opengts.opt.admin.edit.PrivateLabelEditor;
import org.opengts.opt.admin.edit.RuleActionEditor;
import org.opengts.opt.admin.edit.RuleSelectorEditor;
import org.opengts.opt.admin.edit.StatusCodeEditor;
import org.opengts.opt.admin.edit.TextAreaEditor;
import org.opengts.opt.admin.edit.TimeZoneEditor;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VButton;
import org.opengts.opt.ui.VCheckBox;
import org.opengts.opt.ui.VComboBox;
import org.opengts.opt.ui.VFiller;
import org.opengts.opt.ui.VLabelValue;
import org.opengts.opt.ui.VOptionPane;
import org.opengts.opt.ui.VSeparator;
import org.opengts.opt.ui.VTextField;
import org.opengts.opt.ui.VTree;
import org.opengts.opt.ui.VTreeNode;
import org.opengts.util.ListTools;
import org.opengts.util.OrderedMap;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class DBTableEditor
extends VBox
implements DBNodeCustomView {
    private static Map<String, Class> editorClassMap = new HashMap<String, Class>();
    private DBFactoryTree dbFactTree = null;
    private VTree tree = null;
    private EditorNode treeNode = null;
    private KeyEntryDialog keyEntryDialog = null;
    private VLabelValue labelValue = null;
    private VButton saveButton = null;
    private VCheckBox confirmDelete = null;

    public static String[] GetTimeZones(String privLabelName) {
        if (privLabelName == null) {
            return BasicPrivateLabel.getAllTimeZones();
        }
        BasicPrivateLabel privLabel = BasicPrivateLabelLoader.getPrivateLabel(privLabelName);
        if (privLabel == null) {
            return BasicPrivateLabel.getAllTimeZones();
        }
        return privLabel.getTimeZones();
    }

    public static void AddEditorClass(String editorName, Class editorClass) {
        if (editorName != null) {
            editorClassMap.put(editorName.toLowerCase(), editorClass);
        }
    }

    public static VBox CreateFieldEditor(DBField fld, int editMode) {
        String editorName;
        Class editorClass;
        boolean readOnly;
        VBox editor = null;
        if (fld == null) {
            return editor;
        }
        boolean bl = readOnly = !fld.isEditable(editMode);
        if (fld.getName().startsWith("rep")) {
            // empty if block
        }
        Class clazz = editorClass = (editorName = fld.getEditor()) != null ? editorClassMap.get(editorName.toLowerCase()) : null;
        if (editorClass != null) {
            try {
                editor = (VBox)editorClass.newInstance();
                editor.setReadOnly(readOnly);
                return editor;
            }
            catch (Throwable th) {
                Print.logException("Unable to create instance of Editor class: " + editorName, th);
            }
        } else if (editorName != null) {
            Print.logError("Editor class not found: " + editorName, new Object[0]);
        }
        OrderedMap<String, Integer> enumMap = fld.getEnumValues();
        if (enumMap != null) {
            editor = new VComboBox(enumMap);
            ((VComboBox)editor).addFiller();
            editor.setReadOnly(readOnly);
            return editor;
        }
        OrderedMap<String, Integer> maskMap = fld.getEnumValues();
        if (maskMap != null) {
            editor = new VComboBox(maskMap);
            ((VComboBox)editor).addFiller();
            editor.setReadOnly(readOnly);
            return editor;
        }
        String format = fld.getFormat("");
        Class type = fld.getTypeClass();
        if (fld.isString()) {
            int len = fld.getStringLength();
            if (len > 40) {
                len = 40;
            }
            editor = VTextField.TextField((int)len);
        } else if (fld.isDecimal()) {
            editor = VTextField.DoubleField((int)11);
        } else if (fld.isUnsigned()) {
            editor = readOnly && format.startsWith("time") ? VTextField.TextField((int)20) : VTextField.LongField((int)11);
        } else if (fld.isNumeric()) {
            editor = readOnly && format.startsWith("time") ? VTextField.TextField((int)20) : VTextField.LongField((int)11);
        } else if (fld.isBoolean()) {
            editor = new VCheckBox();
        } else if (fld.isBinary()) {
            editor = VTextField.TextField((int)50);
        } else {
            Print.logError("Unrecognized field type: " + fld.getName() + " - 0x" + StringTools.toHexString(fld.getTypeMask(), 16), new Object[0]);
            editor = VTextField.TextField();
        }
        editor.setReadOnly(readOnly);
        return editor;
    }

    public static void initEditors() {
        DBTableEditor.AddEditorClass("ruleAction", RuleActionEditor.class);
        DBTableEditor.AddEditorClass("encodings", EncodingsEditor.class);
        DBTableEditor.AddEditorClass("statusCode", StatusCodeEditor.class);
        DBTableEditor.AddEditorClass("ruleSelector", RuleSelectorEditor.class);
        DBTableEditor.AddEditorClass("textArea", TextAreaEditor.class);
        DBTableEditor.AddEditorClass("privateLabel", PrivateLabelEditor.class);
        DBTableEditor.AddEditorClass("timeZone", TimeZoneEditor.class);
        DBTableEditor.AddEditorClass("password", PasswordEditor.class);
        DBTableEditor.AddEditorClass("accountString", AccountStringEditor.class);
        DBTableEditor.AddEditorClass("eventTemplate", EventTemplateEditor.class);
    }

    public DBTableEditor(DBFactoryTree dbFactTree, VTree tree, EditorNode node) {
        super(null, null, true);
        this.dbFactTree = dbFactTree;
        if (this.dbFactTree == null) {
            Print.logStackTrace("DBFactoryTree is null!");
        }
        this.tree = tree;
        this.treeNode = node;
        this.init();
        this.setEnabled(false);
    }

    public void init() {
        DBField fld;
        this.labelValue = new EditLabelValue();
        this.setGBCX(0.5, 0, 1);
        this.setGBCY(0.0, 0, 1);
        this.add((Component)this.labelValue, this.getDefaultGBC());
        this.setGBCX(0.5, 0, 1);
        this.setGBCY(0.5, 3, 1);
        this.add((Component)new VFiller(), this.getDefaultGBC());
        List<DBField> allFields = ListTools.toList(this.dbFactTree.getFields());
        boolean insertSep = false;
        Iterator<DBField> i = allFields.iterator();
        while (i.hasNext()) {
            fld = i.next();
            if (!fld.isPrimaryKey()) continue;
            this._addRow(fld);
            insertSep = true;
            i.remove();
        }
        if (insertSep) {
            this.labelValue.addSeparator();
            insertSep = false;
        }
        i = allFields.iterator();
        while (i.hasNext()) {
            fld = i.next();
            if (fld.getName().equals("creationTime") || fld.getName().equals("lastUpdateTime")) continue;
            this._addRow(fld);
            insertSep = true;
            i.remove();
        }
        if (insertSep) {
            this.labelValue.addSeparator();
            insertSep = false;
        }
        i = allFields.iterator();
        while (i.hasNext()) {
            fld = i.next();
            this._addRow(fld);
            insertSep = true;
            i.remove();
        }
        this.confirmDelete = new VCheckBox("Check here to confirm delete");
    }

    private void _addRow(DBField fld) {
        if (fld.getBooleanAttribute("presep", false)) {
            this.labelValue.addSeparator();
        }
        StringBuffer title = new StringBuffer();
        if (fld.isPrimaryKey()) {
            title.append("(K) ");
        } else if (fld.isAlternateKey()) {
            title.append("(A) ");
        }
        title.append(fld.getTitle(null)).append(":");
        String fldName = fld.getName();
        VBox editor = DBTableEditor.CreateFieldEditor(fld, 1);
        this.labelValue.addRow(title.toString(), editor, fldName);
    }

    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        if (!enable) {
            this.clearEditor();
        }
    }

    public void clearEditor() {
        this.labelValue.clearAllValues();
    }

    @Override
    public boolean hasChanged() {
        return this.labelValue.hasChanged();
    }

    public void clearChanged() {
        this.labelValue.clearChanged();
        if (this.tree != null && this.treeNode != null) {
            for (EditorNode node = this.treeNode; node != null; node = (VTreeNode)node.getParent()) {
                this.tree.nodeChanged((VTreeNode)node);
            }
        }
    }

    @Override
    public DBFactoryTree getDBFactoryTree() {
        return this.dbFactTree;
    }

    public boolean hasRecord() {
        return this.dbFactTree.hasDBRecord();
    }

    public DBRecord getRecord() {
        return this.hasRecord() ? this.dbFactTree.getDBRecord() : null;
    }

    public DBField[] getFields() {
        return this.dbFactTree.getFields();
    }

    @Override
    public void refresh() {
        DBRecord record = this.getRecord();
        if (record != null) {
            DBField[] allFields = this.getFields();
            for (int i = 0; i < allFields.length; ++i) {
                DBField fld = allFields[i];
                String name = fld.getName();
                String format = fld.getFormat("");
                Object value = record.getFieldValue(name);
                if (this.labelValue.isRowReadOnly(name) && format.startsWith("time")) {
                    this.labelValue.setRowValue(name, fld.formatValue(value));
                    continue;
                }
                this.labelValue.setRowValue(name, value);
            }
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }

    public KeyEntryDialog getKeyEntryDialog() {
        if (this.keyEntryDialog == null) {
            this.keyEntryDialog = new KeyEntryDialog(this.getDBFactoryTree());
        }
        return this.keyEntryDialog;
    }

    @Override
    public boolean newRecord() {
        DBRecordKey rcdKey = this.getKeyEntryDialog().getRecordKey(false);
        if (rcdKey == null) {
            return false;
        }
        try {
            if (!rcdKey.exists()) {
                Object record = rcdKey.getDBRecord();
                ((DBRecord)record).setCreationDefaultValues();
                ((DBRecord)record).save();
                Print.logInfo("Created record: " + rcdKey, new Object[0]);
                this.getDBFactoryTree().setDBRecord((DBRecord<?>)record);
                this.refresh();
                return true;
            }
            VOptionPane.showErrorDialog((Component)((Object)this), (Object)"Selected key already exists", (String)"Invalid Key");
            return false;
        }
        catch (DBException dbe) {
            VOptionPane.showErrorDialog((Component)((Object)this), (Object)("Error creating record\n" + dbe), (String)"Error Creating");
            return false;
        }
    }

    @Override
    public boolean openRecord() {
        DBRecordKey rcdKey = this.getKeyEntryDialog().getRecordKey(true);
        if (rcdKey == null) {
            return false;
        }
        try {
            if (rcdKey.exists()) {
                Object record = rcdKey.getDBRecord(true);
                this.getDBFactoryTree().setDBRecord((DBRecord<?>)record);
                this.refresh();
                return true;
            }
            VOptionPane.showErrorDialog((Component)((Object)this), (Object)"Selected key does not exist", (String)"Invalid Key");
            return false;
        }
        catch (DBException dbe) {
            VOptionPane.showErrorDialog((Component)((Object)this), (Object)("Error editing record\n" + dbe), (String)"Error Editing");
            return false;
        }
    }

    @Override
    public boolean reloadRecord() {
        DBRecord record = this.getRecord();
        if (record == null) {
            return false;
        }
        record.reload();
        this.refresh();
        this.clearChanged();
        return true;
    }

    @Override
    public boolean closeRecord() {
        this.getDBFactoryTree().setDBRecord(null);
        this.setEnabled(false);
        return true;
    }

    public boolean saveRecord() {
        DBRecord record = this.getRecord();
        if (record == null) {
            return false;
        }
        DBField[] allFields = this.getFields();
        for (int i = 0; i < allFields.length; ++i) {
            String name = allFields[i].getName();
            Object obj = this.labelValue.getRowValue(name);
            String value = obj != null ? obj.toString() : "";
            record.setFieldValue(name, allFields[i].parseStringValue(value));
        }
        try {
            String tableName = record.getFactory(true).getUntranslatedTableName();
            Print.logInfo("Saving " + tableName + " record ...", new Object[0]);
            record.save();
            this.clearChanged();
            return true;
        }
        catch (DBException dbe) {
            Print.logException("Error Saving", dbe);
            VOptionPane.showErrorDialog((Component)((Object)this), (Object)"Unable to save record", (String)"Error Saving");
            return false;
        }
    }

    @Override
    public boolean deleteRecord() {
        DBRecord record = this.getRecord();
        if (record == null) {
            return false;
        }
        DBRecordKey recordKey = record.getRecordKey();
        if (recordKey == null) {
            return false;
        }
        if (!RTConfig.getBoolean("gtsAdmin.allowRecordDelete", false)) {
            VOptionPane.showErrorDialog((Component)((Object)GTSAdmin.getInstance()), (Object)"Record Delete is currently not allowed", (String)"Delete Not Allowed");
            return false;
        }
        this.confirmDelete.setSelected(false);
        Object[] deleteMsg = new Object[]{"This record, as well as any dependent records, will be deleted!\nRECORD DELETION IS PERMANENT AND CANNOT BE UNDONE!\n", new VSeparator(), "ARE YOU ABSOLUTELY SURE YOU WANT TO DELETE THIS RECORD?", this.confirmDelete, new VSeparator()};
        boolean yes = VOptionPane.showYesNoDialog((Component)((Object)GTSAdmin.getInstance()), (Object)deleteMsg, (String)"Delete Confirmation");
        if (!yes) {
            return false;
        }
        if (!this.confirmDelete.isSelected()) {
            VOptionPane.showInfoDialog((Component)((Object)GTSAdmin.getInstance()), (Object)"Delete not confirmed, record not deleted.", (String)"Record Not Deleted");
            return false;
        }
        try {
            Print.logWarn("Deleting: " + recordKey, new Object[0]);
            recordKey.delete(true);
            VOptionPane.showInfoDialog((Component)((Object)GTSAdmin.getInstance()), (Object)"Record has been deleted", (String)"Record Deleted");
            return true;
        }
        catch (DBException dbe) {
            Print.logException("Error Deleting Record", dbe);
            VOptionPane.showErrorDialog((Component)((Object)GTSAdmin.getInstance()), (Object)("Error encountered while deleting record:\n" + dbe.toString()), (String)"Error Deleting Record");
            return false;
        }
    }

    private class EditLabelValue
    extends VLabelValue {
        public EditLabelValue() {
            super(null, null, false);
        }

        protected void changed(VLabelValue.VLabelValueRow row) {
            if (DBTableEditor.this.tree != null && DBTableEditor.this.treeNode != null) {
                DBTableEditor.this.tree.nodeChanged((VTreeNode)DBTableEditor.this.treeNode);
            }
        }
    }
}

