/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.admin.dmtpcalc;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.opengts.opt.admin.GTSAdmin;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VButton;
import org.opengts.opt.ui.VComboBox;
import org.opengts.opt.ui.VDialog;
import org.opengts.opt.ui.VLabel;
import org.opengts.opt.ui.VLabelValue;
import org.opengts.opt.ui.VSeparator;
import org.opengts.opt.ui.VSpinner;
import org.opengts.opt.ui.VTextArea;
import org.opengts.opt.ui.VTextField;
import org.opengts.util.DateTime;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class DMTPCalculator
extends VDialog {
    private static final String FIELD_TCP_UDP = "dmtp.tcpUdp";
    private static final String FIELD_PDP_ROUNDING = "dmtp.pdpRounding";
    private static final String FIELD_MOTION_INTERVAL = "dmtp.motionInterval";
    private static final String FIELD_MOTION_DURATION = "dmtp.motionDuration";
    private static final String FIELD_SERVICE_DAYS = "dmtp.serviceDays";
    private static final String FIELD_MIN_XMIT_INTERVAL = "dmtp.minXmitInterval";
    private static final String FIELD_STOPS_PER_DAY = "dmtp.stopsPerDay";
    private static final String FIELD_DORMANT_INTERVAL = "dmtp.dormantInterval";
    private static final String FIELD_DORMANT_COUNT = "dmtp.dormantCount";
    private static final String FIELD_OTHER_EVENT_COUNT = "dmtp.otherEvents";
    private static final String FIELD_DMTP_OVERHEAD = "dmtp.dmtpOverhead";
    private static final String FIELD_DMTP_EVENT_SIZE = "dmtp.dmtpEventSize";
    private VLabelValue labelValue = null;
    private VTextArea outputText = null;
    private static DMTPCalculator dialog = null;

    public DMTPCalculator(Frame owner) {
        super(owner, "DMTP Optimization Calculator", true);
        this.setBackground(GTSAdmin.COLOR_BACKGROUND);
        this.init();
        this.centerOnScreen(-1, -1);
    }

    private void init() {
        VBox content = this.getContentBox();
        GridBagConstraints gbc = content.getDefaultGBC();
        gbc.anchor = 10;
        int row = 0;
        VLabel descLabel = new VLabel("This calculator can be used to optimize the interval and\nconnection configuration for DMTP protocol based client devices.\n(Note that this calculator will provide only a very rough estimate\nof the data usage for a given client device configuration)");
        VBox.SetGBCX((GridBagConstraints)gbc, (double)0.5, (int)0, (int)1);
        VBox.SetGBCY((GridBagConstraints)gbc, (double)0.0, (int)row++, (int)1, (int)0, (int)10);
        content.add((Component)descLabel, (Object)gbc);
        VBox.SetGBCX((GridBagConstraints)gbc, (double)0.5, (int)0, (int)1);
        VBox.SetGBCY((GridBagConstraints)gbc, (double)0.0, (int)row++, (int)1, (int)5, (int)5);
        content.add((Component)new VSeparator(), (Object)gbc);
        this.labelValue = new VLabelValue(null, null, false);
        VBox.SetGBCX((GridBagConstraints)gbc, (double)0.0, (int)0, (int)1);
        VBox.SetGBCY((GridBagConstraints)gbc, (double)0.0, (int)row++, (int)1);
        content.add((Component)this.labelValue, (Object)gbc);
        VComboBox tcpUdpCombo = new VComboBox(new String[]{"tcp", "udp"}).addFiller();
        this.labelValue.addRow("TCP/UDP:", (VBox)tcpUdpCombo, (Object)"tcp", FIELD_TCP_UDP);
        this.labelValue.addRow("PDP Rounding:", "(bytes)", (VBox)DMTPCalculator.NewSpinEditor(4096, 1024), (Object)new Long(1024L), FIELD_PDP_ROUNDING);
        this.labelValue.addRow("In-Motion Interval:", "(seconds)", (VBox)DMTPCalculator.NewSpinEditor(3600, 30), (Object)new Long(300L), FIELD_MOTION_INTERVAL);
        this.labelValue.addRow("In-Motion Hours per Day:", "(hours)", (VBox)DMTPCalculator.NewSpinEditor(24, 1), (Object)new Long(12L), FIELD_MOTION_DURATION);
        this.labelValue.addRow("In-Service Days per Month:", "(days)", (VBox)DMTPCalculator.NewSpinEditor(30, 1), (Object)new Long(25L), FIELD_SERVICE_DAYS);
        this.labelValue.addRow("Minimum Transmit Interval:", "(minutes)", (VBox)DMTPCalculator.NewSpinEditor(60, 1), (Object)new Long(12L), FIELD_MIN_XMIT_INTERVAL);
        this.labelValue.addRow("Stops per Day:", "(#)", (VBox)DMTPCalculator.NewSpinEditor(50, 1), (Object)new Long(6L), FIELD_STOPS_PER_DAY);
        this.labelValue.addRow("Dormant Interval:", "(minutes)", (VBox)DMTPCalculator.NewSpinEditor(1440, 30), (Object)new Long(60L), FIELD_DORMANT_INTERVAL);
        this.labelValue.addRow("Dormant Count:", "(#)", (VBox)DMTPCalculator.NewSpinEditor(24, 1), (Object)new Long(2L), FIELD_DORMANT_COUNT);
        this.labelValue.addRow("Other Events per Day:", "(#)", (VBox)DMTPCalculator.NewSpinEditor(200, 1), (Object)new Long(0L), FIELD_OTHER_EVENT_COUNT);
        this.labelValue.addRow("DMTP Overhead:", "(bytes)", (VBox)DMTPCalculator.NewSpinEditor(50, 1), (Object)new Long(30L), FIELD_DMTP_OVERHEAD);
        this.labelValue.addRow("DMTP Event Packet Size:", "(bytes)", (VBox)DMTPCalculator.NewSpinEditor(100, 1), (Object)new Long(60L), FIELD_DMTP_EVENT_SIZE);
        this.setDefaultValues();
        VButton calcBtn = new VButton("Calculate");
        calcBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DMTPCalculator.this.calculate();
            }
        });
        VBox.SetGBCX((GridBagConstraints)gbc, (double)0.0, (int)0, (int)1);
        VBox.SetGBCY((GridBagConstraints)gbc, (double)0.0, (int)row++, (int)1);
        content.add((Component)calcBtn, (Object)gbc);
        VBox.SetGBCX((GridBagConstraints)gbc, (double)0.5, (int)0, (int)1);
        VBox.SetGBCY((GridBagConstraints)gbc, (double)0.0, (int)row++, (int)1, (int)5, (int)5);
        content.add((Component)new VSeparator(), (Object)gbc);
        this.outputText = new VTextArea(8, 30);
        this.outputText.setReadOnly(true);
        this.outputText.setTextFont(VBox.FONT_MONOSPACED_PLAIN);
        VBox.SetGBCX((GridBagConstraints)gbc, (double)0.5, (int)0, (int)1);
        VBox.SetGBCY((GridBagConstraints)gbc, (double)0.5, (int)row++, (int)1);
        content.add((Component)this.outputText, (Object)gbc);
    }

    private static VTextField NewLongEditor(int len) {
        VTextField longEditor = VTextField.LongField((int)len);
        longEditor.setSelectAllOnFocus();
        return longEditor;
    }

    private static VSpinner NewSpinEditor(int max, int step) {
        VSpinner spinEditor = new VSpinner(0, 0, max, step);
        spinEditor.setPreferredWidth(60);
        return spinEditor;
    }

    private void setDefaultValues() {
        for (int i = 0; i < this.labelValue.getRowCount(); ++i) {
            this.labelValue.setRowValue(i, this.labelValue.getRowData(i));
        }
    }

    private long getLongValue(String field) {
        Object rowVal = this.labelValue.getRowValue(field);
        long rowLong = StringTools.parseLong(rowVal, -9999L);
        if (rowLong < 0L) {
            rowVal = this.labelValue.getRowData(field);
            this.labelValue.setRowValue(field, rowVal);
            rowLong = StringTools.parseLong(rowVal, -9999L);
            if (rowLong < 0L) {
                Print.logError("Cannot parse " + rowVal, new Object[0]);
            }
        }
        return rowLong;
    }

    private void calculate() {
        long eventsPerSession;
        this.outputText.setText("");
        String tcpUdp = (String)this.labelValue.getRowValue(FIELD_TCP_UDP);
        long pdpRounding_byte = this.getLongValue(FIELD_PDP_ROUNDING);
        long motionInterval_sec = this.getLongValue(FIELD_MOTION_INTERVAL);
        long motionDuration_sec = this.getLongValue(FIELD_MOTION_DURATION) * 3600L;
        long serviceDays_cnt = this.getLongValue(FIELD_SERVICE_DAYS);
        long minXmitInterv_sec = this.getLongValue(FIELD_MIN_XMIT_INTERVAL) * 60L;
        long stopsPerDay_cnt = this.getLongValue(FIELD_STOPS_PER_DAY);
        long dormantInterv_sec = this.getLongValue(FIELD_DORMANT_INTERVAL) * 60L;
        long dormantCount_cnt = this.getLongValue(FIELD_DORMANT_COUNT);
        long otherEventCount = this.getLongValue(FIELD_OTHER_EVENT_COUNT);
        long dmtpOverhead_byte = this.getLongValue(FIELD_DMTP_OVERHEAD);
        long dmtpEventSize_byte = this.getLongValue(FIELD_DMTP_EVENT_SIZE);
        if (pdpRounding_byte <= 0L) {
            pdpRounding_byte = 1L;
            this.labelValue.setRowValue(FIELD_PDP_ROUNDING, (Object)new Long(pdpRounding_byte));
        }
        long eventsPerDay = 0L;
        if (motionInterval_sec > 0L) {
            eventsPerDay += motionDuration_sec / motionInterval_sec;
        }
        if (dormantInterv_sec > 0L) {
            if (dormantCount_cnt >= 0L) {
                eventsPerDay += dormantCount_cnt;
                eventsPerDay += dormantCount_cnt * stopsPerDay_cnt;
            } else {
                long dormantDuration = DateTime.DaySeconds(1L) - motionDuration_sec;
                eventsPerDay += dormantDuration / dormantInterv_sec;
            }
        }
        eventsPerDay += stopsPerDay_cnt * 4L;
        eventsPerDay += otherEventCount;
        long l = eventsPerSession = motionInterval_sec > 0L ? minXmitInterv_sec / motionInterval_sec : 1L;
        if (eventsPerSession <= 0L) {
            eventsPerSession = 1L;
        }
        if (tcpUdp.equalsIgnoreCase("udp")) {
            long udpEventsPerSession = eventsPerSession;
            long udpSessionsPerDay = eventsPerDay / udpEventsPerSession;
            long udpSessionOverhead = 28L;
            long udpSessionSize = udpSessionOverhead + dmtpOverhead_byte + udpEventsPerSession * dmtpEventSize_byte;
            long udpRoundedSize = (udpSessionSize + (pdpRounding_byte - 1L)) / pdpRounding_byte * pdpRounding_byte;
            this.outputText.println("Events Per Day            : " + eventsPerDay);
            this.outputText.println("Events Per Session        : " + eventsPerSession);
            this.outputText.println("Sessions per day          : " + udpSessionsPerDay);
            this.outputText.println("Actual UDP bytes per day  : " + udpSessionSize * udpSessionsPerDay);
            this.outputText.println("Actual UDP bytes per mon  : " + udpSessionSize * udpSessionsPerDay * serviceDays_cnt);
            this.outputText.println("Rounded UDP bytes per day : " + udpRoundedSize * udpSessionsPerDay);
            this.outputText.println("Rounded UDP bytes per mon : " + udpRoundedSize * udpSessionsPerDay * serviceDays_cnt);
        } else if (tcpUdp.equalsIgnoreCase("tcp")) {
            long tcpEventsPerSession = eventsPerSession;
            long tcpSessionsPerDay = eventsPerDay / tcpEventsPerSession;
            long tcpSessionOverhead = 328L;
            long tcpSessionSize = tcpSessionOverhead + dmtpOverhead_byte + tcpEventsPerSession * dmtpEventSize_byte;
            long tcpRoundedSize = (tcpSessionSize + (pdpRounding_byte - 1L)) / pdpRounding_byte * pdpRounding_byte;
            this.outputText.println("Events Per Day            : " + eventsPerDay);
            this.outputText.println("Events Per Session        : " + eventsPerSession);
            this.outputText.println("Sessions per day          : " + tcpSessionsPerDay);
            this.outputText.println("Actual TCP bytes per day  : " + tcpSessionSize * tcpSessionsPerDay);
            this.outputText.println("Actual TCP bytes per mon  : " + tcpSessionSize * tcpSessionsPerDay * serviceDays_cnt);
            this.outputText.println("Rounded TCP bytes per day : " + tcpRoundedSize * tcpSessionsPerDay);
            this.outputText.println("Rounded TCP bytes per mon : " + tcpRoundedSize * tcpSessionsPerDay * serviceDays_cnt);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
    }

    public static void showDialog() {
        if (dialog == null) {
            dialog = new DMTPCalculator((Frame)((Object)GTSAdmin.getInstance()));
        }
        dialog.setVisible(true);
    }
}

