/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.admin.dbinfo;

import java.awt.Color;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBField;
import org.opengts.opt.ui.VTable;
import org.opengts.opt.ui.VTree;
import org.opengts.opt.ui.VTreeNode;
import org.opengts.opt.ui.VTreeViewer;
import org.opengts.util.ColorTools;
import org.opengts.util.Print;

public class DBDefinedColumns
extends VTable {
    private static final Color BACKGROUND_INVALID_BEAN = new Color(255, 200, 200);
    private static VTable.VColumnInfo[] columns = new VTable.VColumnInfo[]{new VTable.VColumnInfo("field.numb", "##", 70, true), new VTable.VColumnInfo("field.name", "Field Name", 350, true), new VTable.VColumnInfo("field.desc", "Description", 600, true), new VTable.VColumnInfo("field.type", "SQL Type", 400, false), new VTable.VColumnInfo("field.key", "Key?", 130, false)};
    private VTreeViewer treeViewer = null;

    public DBDefinedColumns(VTreeViewer treeViewer) {
        super(null, null, true);
        this.treeViewer = treeViewer;
        this.setTableColumns(columns);
        this.getTableView().setDefaultRenderer(Object.class, (TableCellRenderer)((Object)new DBFieldRenderer(this)));
    }

    public VTreeViewer getVTreeViewer() {
        return this.treeViewer;
    }

    public VTree getVTree() {
        VTreeViewer tv = this.getVTreeViewer();
        return tv != null ? tv.getVTree() : null;
    }

    public VTreeNode getSelectedNode() {
        VTree tree = this.getVTree();
        return tree != null ? tree.getSelectedNode() : null;
    }

    public DBFactory getSelectedDBFactory() {
        VTreeNode node = this.getSelectedNode();
        Object usrObj = node != null ? node.getUserObject() : null;
        return (DBFactory)usrObj;
    }

    public int getErrors(DBFactory dbFact) {
        return this._refresh(dbFact, false);
    }

    public void refresh() {
        DBFactory dbf = this.getSelectedDBFactory();
        if (dbf == null) {
            this.clearTableData();
            return;
        }
        this._refresh(dbf, true);
    }

    protected int _refresh(DBFactory dbf, boolean updateTable) {
        if (dbf == null) {
            return 2;
        }
        boolean hasErrors = false;
        boolean hasWarnings = false;
        DBField[] fields = dbf.getFields();
        VTable.VTableRow[] tableRows = new DBFieldRow[fields.length];
        for (int f = 0; f < fields.length; ++f) {
            tableRows[f] = new DBFieldRow(f, fields[f]);
        }
        if (updateTable) {
            this.setTableData(tableRows);
        }
        return hasErrors ? 2 : (hasWarnings ? 1 : 0);
    }

    public class DBFieldRenderer
    extends VTable.VTableCellRenderer {
        private VTable table = null;

        public DBFieldRenderer(VTable table) {
            this.table = table;
        }

        public Component getTableCellRendererComponent(JTable tbl, Object val, boolean isSel, boolean focus, int row, int col) {
            Color bg;
            super.getTableCellRendererComponent(tbl, val, isSel, focus, row, col);
            DBFieldRow fldRow = (DBFieldRow)this.table.getRow(row);
            if (fldRow != null && (bg = fldRow.getBackground(col)) != null) {
                if (isSel) {
                    bg = ColorTools.mix(bg, tbl.getSelectionBackground(), 0.7f);
                }
                this.setBackground(bg);
            }
            return this;
        }
    }

    private static class DBFieldRow
    implements VTable.VTableRow {
        private int index = -1;
        private DBField field = null;

        public DBFieldRow(int ndx, DBField fld) {
            this.index = ndx;
            this.field = fld;
        }

        public Object getRowObject() {
            return this.field;
        }

        public DBField getDefinedField() {
            return this.field;
        }

        public DBFactory getFactory() {
            DBField field = this.getDefinedField();
            return field != null ? field.getFactory() : null;
        }

        public Object getColumnValue(int col) {
            switch (col) {
                case 0: {
                    return new Integer(this.index + 1);
                }
                case 1: {
                    return this.field.getName();
                }
                case 2: {
                    return this.field.getTitle(null);
                }
                case 3: {
                    return this.field.getSqlType();
                }
                case 4: {
                    return this.field.getIndexNames();
                }
            }
            return "";
        }

        public void setColumnValue(int col, Object value) {
        }

        public boolean isColumnEditable(int col) {
            return false;
        }

        public boolean validateBeanMethods() {
            DBFactory fact;
            DBField field = this.getDefinedField();
            DBFactory dBFactory = fact = field != null ? field.getFactory() : null;
            if (fact != null) {
                List errMsg = fact.validateFieldBeanMethods(field);
                if (errMsg == null || errMsg.isEmpty()) {
                    return true;
                }
                Print.logError("Bean Method validation error: " + fact, new Object[0]);
                Iterator i = errMsg.iterator();
                while (i.hasNext()) {
                    Print.logError("  Field: " + field.getName() + " ==> " + i.next(), new Object[0]);
                }
                return false;
            }
            Print.logError("Missing DBFactory: " + fact + "." + field, new Object[0]);
            return false;
        }

        public Color getBackground(int col) {
            switch (col) {
                case 0: {
                    return null;
                }
                case 1: {
                    return null;
                }
                case 2: {
                    return null;
                }
                case 3: {
                    return null;
                }
                case 4: {
                    return null;
                }
            }
            return null;
        }
    }
}

