/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.admin;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import org.opengts.db.DBConfig;
import org.opengts.dbtools.DBFactory;
import org.opengts.dbtools.DBRecord;
import org.opengts.opt.admin.GTSAdmin;
import org.opengts.opt.ui.VBox;
import org.opengts.opt.ui.VButton;
import org.opengts.opt.ui.VDialog;
import org.opengts.opt.ui.VList;
import org.opengts.opt.ui.VTextField;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class RecordChooserDialog
extends VDialog {
    private DBFactory dbFactory = null;
    private DBRecord record = null;
    private VTextField filter = null;
    private VList selectionList = null;

    public RecordChooserDialog(Frame owner) {
        super(owner, "DB Record Chooser", true);
        this.setBackground(GTSAdmin.COLOR_BACKGROUND);
        this.init();
        this.centerOnScreen(500, 300);
    }

    private void init() {
        VBox content = this.getContentBox();
        this.filter = new VTextField(null, "Filter", false);
        this.filter.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                RecordChooserDialog.this.refreshList();
            }
        });
        content.setGBCX(0.5, 0, 1);
        content.setGBCY(0.0, 0, 1);
        content.add((Component)this.filter, (Object)content.getDefaultGBC());
        this.selectionList = new VList("Record Selector", null, true);
        content.setGBCX(0.5, 0, 1);
        content.setGBCY(0.5, 1, 1);
        content.add((Component)this.selectionList, (Object)content.getDefaultGBC());
        VButton okBtn = new VButton("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                RecordChooserDialog.this.okClicked();
            }
        });
        this.addButton(okBtn, true);
        VButton cancelBtn = new VButton("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                RecordChooserDialog.this.cancelClicked();
            }
        });
        this.addButton(cancelBtn, true);
    }

    public DBRecord chooseRecord(DBFactory dbFact) {
        this.dbFactory = dbFact;
        this.refreshList();
        this.record = null;
        this.setVisible(true);
        return this.record;
    }

    private void refreshList() {
        String[] listData = new String[20];
        for (int i = 0; i < listData.length; ++i) {
            listData[i] = StringTools.createRandomString(15);
        }
        this.selectionList.setListData(listData);
    }

    private void okClicked() {
        this.record = null;
        this.setVisible(false);
    }

    private void cancelClicked() {
        this.record = null;
        this.setVisible(false);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            Print.logInfo("Clearing DBFactory ...", new Object[0]);
            this.dbFactory = null;
        }
    }

    public static void main(String[] argv) {
        DBConfig.cmdLineInit(argv, true);
        RecordChooserDialog rcdDialog = new RecordChooserDialog(null);
        DBRecord rcd = rcdDialog.chooseRecord(null);
        System.exit(0);
    }
}

