/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.admin;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import org.opengts.dbtools.DBFactoryTree;
import org.opengts.dbtools.DBField;
import org.opengts.dbtools.DBRecord;
import org.opengts.dbtools.DBRecordKey;
import org.opengts.opt.admin.DBNodeCustomView;
import org.opengts.opt.ui.VIcon;
import org.opengts.opt.ui.VScrollPane;
import org.opengts.opt.ui.VTreeNode;
import org.opengts.util.ColorTools;
import org.opengts.util.StringTools;

public class EditorNode
extends VTreeNode {
    private static String COLOR_CHILD_CHANGED = "#AA0000";
    private static String COLOR_NODE_CHANGED = "#CC0000";
    private static String COLOR_NODE_CLOSED = "#555555";
    private static String COLOR_NODE_OPEN = "#000000";

    public EditorNode(DBFactoryTree factTree) {
        super((Object)factTree, false);
        this.setOpenIcon(VIcon.getImageResource((String)"org/opengts/opt/ui/images/TreeLeaf_blue_11.gif"));
        this.setClosedIcon(VIcon.getImageResource((String)"org/opengts/opt/ui/images/TreeLeaf_darkblue_11.gif"));
        this.setLeafIcon(VIcon.getImageResource((String)"org/opengts/opt/ui/images/TreeLeaf_blue_11.gif"));
        this.setToolTipText("Right-click to view selectable options");
    }

    public DBNodeCustomView getNodeCustomEditor() {
        Component comp = this.getCustomView();
        if (comp instanceof VScrollPane) {
            comp = ((VScrollPane)comp).getViewportView();
        }
        if (comp instanceof DBNodeCustomView) {
            return (DBNodeCustomView)((Object)comp);
        }
        return null;
    }

    public boolean hasEditorChanged(boolean inclChildren) {
        if (this.hasDBRecord()) {
            DBNodeCustomView editor = this.getNodeCustomEditor();
            if (editor != null && editor.hasChanged()) {
                return true;
            }
            if (inclChildren && this.hasChildren()) {
                VTreeNode[] ch = this.getChildren();
                for (int i = 0; i < ch.length; ++i) {
                    if (!((EditorNode)ch[i]).hasEditorChanged(true)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public DBFactoryTree getDBFactoryTree() {
        return (DBFactoryTree)this.getUserObject();
    }

    public String getTableName() {
        DBFactoryTree dbFactTree = this.getDBFactoryTree();
        return dbFactTree != null ? dbFactTree.getUntranslatedTableName() : "";
    }

    public int getLevel() {
        DBFactoryTree dbFactTree = this.getDBFactoryTree();
        return dbFactTree != null ? dbFactTree.getLevel() : -1;
    }

    public boolean hasDBRecord() {
        return this.getDBFactoryTree().hasDBRecord();
    }

    public DBRecord getDBRecord() {
        return this.getDBFactoryTree().getDBRecord();
    }

    public DBRecordKey getDBRecordKey() {
        return this.hasDBRecord() ? this.getDBFactoryTree().getDBRecord().getRecordKey() : null;
    }

    protected String getKeyValue() {
        DBRecordKey rcdKey = this.getDBRecordKey();
        if (rcdKey == null) {
            return null;
        }
        DBField[] keyFlds = rcdKey.getKeyFields();
        int level = this.getLevel();
        if (level < 0 || level >= keyFlds.length) {
            return null;
        }
        DBField fld = keyFlds[level];
        String fldName = fld.getName();
        if (rcdKey.hasFieldValue(fldName)) {
            Object fldValue = rcdKey.getFieldValue(fldName);
            if (fldValue != null) {
                return fld.formatValue(fldValue);
            }
            return null;
        }
        return null;
    }

    public String getToolTipText() {
        DBFactoryTree factTree = this.getDBFactoryTree();
        if (factTree.hasDBRecord()) {
            return super.getToolTipText();
        }
        if (factTree.hasParentDBRecord()) {
            return super.getToolTipText();
        }
        if (factTree.hasChildren()) {
            return super.getToolTipText();
        }
        return null;
    }

    public Icon getRendererIcon(JTree tree, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
        return super.getRendererIcon(tree, isSelected, isExpanded, isLeaf, row, hasFocus);
    }

    public Color getRendererTextColor(JTree tree, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
        return super.getRendererTextColor(tree, isSelected, isExpanded, isLeaf, row, hasFocus);
    }

    public String toString() {
        String name = super.toString();
        StringBuffer sb = new StringBuffer();
        sb.append("<html>");
        if (this.hasDBRecord()) {
            String keyVal = this.getKeyValue();
            sb.append("<b>");
            if (this.hasEditorChanged(false)) {
                sb.append("<font color='" + COLOR_NODE_CHANGED + "'>");
                sb.append(name);
                sb.append("</font>");
            } else if (this.hasEditorChanged(true)) {
                sb.append("<font color='" + COLOR_CHILD_CHANGED + "'>");
                sb.append(StringTools.htmlFilterText(name));
                sb.append("</font>");
            } else {
                sb.append(name);
            }
            sb.append("</b>");
            if (keyVal != null) {
                sb.append("[<i>");
                sb.append(StringTools.htmlFilterText(keyVal));
                sb.append("</i>]");
            }
        } else {
            String color = ColorTools.toHexString(Color.darkGray);
            sb.append("<i>");
            sb.append("<font color='" + COLOR_NODE_CLOSED + "'>");
            sb.append(name);
            sb.append("</font>");
            sb.append("</i>");
        }
        sb.append("</html>");
        return sb.toString();
    }
}

