/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.opt.servers.tzavl05;

import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.dbtools.DBAdmin;
import org.opengts.opt.servers.DCServerAttributes;
import org.opengts.opt.servers.tzavl05.Constants;
import org.opengts.opt.servers.tzavl05.TrackClientPacketHandler;
import org.opengts.opt.servers.tzavl05.TrackServer;
import org.opengts.util.DateTime;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class Main {
    public static final String[] ARG_HELP = new String[]{"help", "h"};
    public static final String[] ARG_CMD_PORT = new String[]{"command", "cmd"};
    public static final String[] ARG_START = new String[]{"start"};
    private static DCServerConfig dcServerCfg = null;

    public static String DCServerFactory_LoadName() {
        return Main.getServerContextName();
    }

    public static String getServerName() {
        return "tzavl05";
    }

    public static String getServerContextName() {
        return RTConfig.getContextName((String)Main.getServerName());
    }

    public static DCServerConfig getServerConfig() {
        if (dcServerCfg == null) {
            dcServerCfg = DCServerFactory.getServerConfig((String)Main.getServerContextName(), (boolean)true);
            DCServerConfig.startRemoteLogging((DCServerConfig)dcServerCfg);
        }
        return dcServerCfg;
    }

    public static int[] getTcpPorts() {
        DCServerConfig dCServerConfig = Main.getServerConfig();
        if (dCServerConfig != null) {
            return dCServerConfig.getTcpPorts();
        }
        Print.logError((String)("DCServerConfig not found for server: " + Main.getServerName()), (Object[])new Object[0]);
        return null;
    }

    public static int[] getUdpPorts() {
        DCServerConfig dCServerConfig = Main.getServerConfig();
        if (dCServerConfig != null) {
            return dCServerConfig.getUdpPorts();
        }
        Print.logError((String)("DCServerConfig not found for server: " + Main.getServerName()), (Object[])new Object[0]);
        return null;
    }

    public static int getCommandDispatcherPort() {
        DCServerConfig dCServerConfig = Main.getServerConfig();
        if (dCServerConfig != null) {
            return dCServerConfig.getCommandDispatcherPort();
        }
        return RTConfig.getInt((String[])ARG_CMD_PORT, (int)0);
    }

    public static String getUniqueIDPrefixList() {
        DCServerConfig dCServerConfig = Main.getServerConfig();
        if (dCServerConfig != null) {
            return DCServerFactory.getUniquePrefixString((String[])dCServerConfig.getUniquePrefix());
        }
        return "";
    }

    private static void usage(String string) {
        String string2 = StringTools.join((int[])Main.getTcpPorts(), (String)",");
        String string3 = StringTools.join((int[])Main.getUdpPorts(), (String)",");
        if (string != null) {
            Print.logInfo((String)string, (Object[])new Object[0]);
        }
        Print.logInfo((String)"", (Object[])new Object[0]);
        Print.logInfo((String)"Usage:", (Object[])new Object[0]);
        Print.logInfo((String)("  java ... " + Main.class.getName() + " {options}"), (Object[])new Object[0]);
        Print.logInfo((String)"Options:", (Object[])new Object[0]);
        Print.logInfo((String)"  [-h[elp]]           Print this help", (Object[])new Object[0]);
        Print.logInfo((String)"  [-port=<p>[,<p>]]   Server TCP/UDP port(s) to listen", (Object[])new Object[0]);
        Print.logInfo((String)("  [-tcp=<p>[,<p>]]    Server TCP port(s) to listen on [dft=" + string2 + "]"), (Object[])new Object[0]);
        Print.logInfo((String)("  [-udp=<p>[,<p>]]    Server UDP port(s) to listen on [dft=" + string3 + "]"), (Object[])new Object[0]);
        Print.logInfo((String)"  -start              Start server on the specified port", (Object[])new Object[0]);
        Print.logInfo((String)"", (Object[])new Object[0]);
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        if (!ListTools.isEmpty((Object[])stringArray) && stringArray[0].equalsIgnoreCase("Constants")) {
            String[] stringArray2 = (String[])ListTools.toArray((Object[])stringArray, (int)1, (int)(stringArray.length - 1));
            Constants.main(stringArray2);
            System.exit(0);
        }
        DBConfig.cmdLineInit((String[])stringArray, (boolean)false);
        DBConfig.check_GTS_HOME();
        if ("time".equals(RTConfig.getString((String)"xpire", (String)""))) {
            Print.logInfo((String)"n/a", (Object[])new Object[0]);
            System.exit(1);
        }
        TrackClientPacketHandler.configInit();
        TrackServer.configInit();
        boolean bl = false;
        long l = DateTime.getCurrentTimeSec();
        bl = false;
        DCServerAttributes.beginPrintDCSHeader(Main.getServerConfig(), Main.getServerContextName(), "TZone AVL-05", "0.1.6", "Copyright 2007-2013, GeoTelematic Solutions, Inc.", "mutinda", bl, 0L, 0L, 1381279040L, TrackClientPacketHandler.THROTTLE_MSG);
        Print.logInfo((String)("Minimum Speed (km/h)  : " + TrackClientPacketHandler.MINIMUM_SPEED_KPH), (Object[])new Object[0]);
        Print.logInfo((String)("Estimate GPS Odometer : " + TrackClientPacketHandler.ESTIMATE_ODOMETER), (Object[])new Object[0]);
        Print.logInfo((String)("Simulate Arrive/Depart: " + TrackClientPacketHandler.SIMEVENT_GEOZONES), (Object[])new Object[0]);
        DCServerAttributes.endPrintDCSHeader();
        if (RTConfig.getBoolean((String[])ARG_HELP, (boolean)false)) {
            Main.usage("Help ...");
        }
        if (!DBAdmin.verifyTablesExist()) {
            Print.logFatal((String)"MySQL database has not yet been properly initialized", (Object[])new Object[0]);
            System.exit(1);
        }
        if (RTConfig.getBoolean((String[])ARG_START, (boolean)false)) {
            try {
                int[] nArray = Main.getTcpPorts();
                int[] nArray2 = Main.getUdpPorts();
                int n = Main.getCommandDispatcherPort();
                TrackServer.startTrackServer(nArray, nArray2, n);
            }
            catch (Throwable throwable) {
                Print.logError((String)("Error: " + throwable), (Object[])new Object[0]);
            }
            Print.logInfo((String)"--------------------------------------------------------------------------", (Object[])new Object[0]);
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(3600000L);
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }
        Main.usage("Missing '-start' ...");
        System.exit(99);
    }
}

