/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers.aspicore;

import java.net.InetAddress;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opengts.cellid.CellTower;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.db.DataTransport;
import org.opengts.db.StatusCodes;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Geozone;
import org.opengts.dbtools.DBException;
import org.opengts.servers.aspicore.Main;
import org.opengts.util.AbstractClientPacketHandler;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.Nmea0183;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class TrackClientPacketHandler
extends AbstractClientPacketHandler {
    public static String[] UNIQUEID_PREFIX = new String[]{"imei_"};
    public static double MINIMUM_SPEED_KPH = 3.0;
    public static boolean ESTIMATE_ODOMETER = false;
    public static boolean SIMEVENT_GEOZONES = false;
    public static boolean XLATE_LOCATON_INMOTION = false;
    public static double MINIMUM_MOVED_METERS = 0.0;
    public static boolean DEBUG_MODE = false;
    private String ipAddress = null;
    private int clientPort = 0;
    private Device device = null;
    private DataTransport dataXPort = null;
    private String mobileID = null;
    private Nmea0183 gprmc = null;
    private CellTower outboundCell = null;
    private CellTower inboundCell = null;
    private CellTower currentCell = null;
    private String label = null;
    private long sessionStartTime = 0L;
    private int eventTotalCount = 0;

    @Override
    public void sessionStarted(InetAddress inetAddr, boolean isTCP, boolean isText) {
        super.sessionStarted(inetAddr, isTCP, isText);
        super.clearTerminateSession();
        this.sessionStartTime = DateTime.getCurrentTimeSec();
        this.ipAddress = inetAddr != null ? inetAddr.getHostAddress() : null;
        this.clientPort = this.getSessionInfo().getRemotePort();
        this.eventTotalCount = 0;
        this.mobileID = null;
        this.device = null;
        this.gprmc = new Nmea0183();
    }

    @Override
    public void sessionTerminated(Throwable err, long readCount, long writeCount) {
        super.sessionTerminated(err, readCount, writeCount);
    }

    @Override
    public int getActualPacketLength(byte[] packet, int packetLen) {
        return -1;
    }

    @Override
    public byte[] getHandlePacket(byte[] pktBytes) {
        if (pktBytes == null || pktBytes.length == 0) {
            return null;
        }
        String s = StringTools.toStringValue(pktBytes).trim();
        Print.logInfo("Recv: " + s, new Object[0]);
        if (s.startsWith("IMEI")) {
            this.mobileID = s.substring(4).trim();
            this.gprmc = null;
            this.outboundCell = null;
            this.inboundCell = null;
            this.currentCell = null;
            this.label = null;
            return null;
        }
        if (s.startsWith("$GP")) {
            if (this.gprmc == null) {
                this.gprmc = new Nmea0183();
            }
            this.gprmc.parse(s);
            return null;
        }
        if (s.startsWith("No ")) {
            return null;
        }
        if (s.startsWith("Label")) {
            this.label = s.substring(5).trim();
            return null;
        }
        if (s.startsWith("OutCell")) {
            Pattern pat = Pattern.compile("\\bOutCell (\\d+) LAC (\\d+) Name ([\\S ]*) MCC (\\d+) MNC (\\d+) MODE (\\d+)\\b");
            Matcher mat = pat.matcher(s);
            if (mat.find()) {
                CellTower ct = new CellTower();
                ct.setCellTowerID(StringTools.parseInt(mat.group(1), 0));
                ct.setLocationAreaCode(StringTools.parseInt(mat.group(2), 0));
                ct.setName(mat.group(3));
                ct.setMobileCountryCode(StringTools.parseInt(mat.group(4), 0));
                ct.setMobileNetworkCode(StringTools.parseInt(mat.group(5), 0));
                this.outboundCell = ct;
            } else {
                Print.logError("Unable to parse 'OutCell' pattern", new Object[0]);
            }
            return null;
        }
        if (s.startsWith("In Cell")) {
            Pattern pat = Pattern.compile("\\bIn Cell (\\d+) LAC (\\d+) Name ([\\S ]*) MCC (\\d+) MNC (\\d+) MODE (\\d+)\\b");
            Matcher mat = pat.matcher(s);
            if (mat.find()) {
                CellTower ct = new CellTower();
                ct.setCellTowerID(StringTools.parseInt(mat.group(1), 0));
                ct.setLocationAreaCode(StringTools.parseInt(mat.group(2), 0));
                ct.setName(mat.group(3));
                ct.setMobileCountryCode(StringTools.parseInt(mat.group(4), 0));
                ct.setMobileNetworkCode(StringTools.parseInt(mat.group(5), 0));
                this.inboundCell = ct;
            } else {
                Print.logError("Unable to parse 'In Cell' pattern", new Object[0]);
            }
            return null;
        }
        if (s.startsWith("In Cell")) {
            Pattern pat = Pattern.compile("\\bCurCell (\\d+) LAC (\\d+) Name ([\\S ]*) MCC (\\d+) MNC (\\d+) MODE (\\d+)\\b");
            Matcher mat = pat.matcher(s);
            if (mat.find()) {
                CellTower ct = new CellTower();
                ct.setCellTowerID(StringTools.parseInt(mat.group(1), 0));
                ct.setLocationAreaCode(StringTools.parseInt(mat.group(2), 0));
                ct.setName(mat.group(3));
                ct.setMobileCountryCode(StringTools.parseInt(mat.group(4), 0));
                ct.setMobileNetworkCode(StringTools.parseInt(mat.group(5), 0));
                this.currentCell = ct;
            } else {
                Print.logError("Unable to parse 'CurCell' pattern", new Object[0]);
            }
            return null;
        }
        if (s.startsWith("*")) {
            this.insertData();
            this.gprmc = null;
            this.outboundCell = null;
            this.inboundCell = null;
            this.currentCell = null;
            this.label = null;
            return null;
        }
        return null;
    }

    @Override
    public byte[] getFinalPacket(boolean hasError) throws Exception {
        this.insertData();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean insertData() {
        List<Device.GeozoneTransition> zone;
        double deltaM;
        GeoPoint prevGPS;
        this.eventTotalCount = 0;
        if (this.mobileID == null || this.gprmc == null) {
            return false;
        }
        String imei = StringTools.trim(this.mobileID);
        Print.logInfo("Mobile ID    : " + imei, new Object[0]);
        this.device = DCServerConfig.loadDeviceUniqueID(Main.getServerConfig(), imei);
        if (this.device == null) {
            Print.logError("Device not found: " + imei, new Object[0]);
            DCServerFactory.addUnassignedDevice("aspicore", imei, this.ipAddress, this.isDuplex(), null);
            return false;
        }
        this.dataXPort = this.device.getDataTransport();
        String accountID = this.device.getAccountID();
        String deviceID = this.device.getDeviceID();
        if (this.ipAddress != null && !this.dataXPort.isValidIPAddress(this.ipAddress)) {
            Print.logError("Invalid IP Address for device: " + this.ipAddress + " [expecting " + this.dataXPort.getIpAddressValid() + "]", new Object[0]);
            return false;
        }
        this.device.setIpAddressCurrent(this.ipAddress);
        this.device.setRemotePortCurrent(this.clientPort);
        this.device.setLastTotalConnectTime(DateTime.getCurrentTimeSec());
        if (!this.dataXPort.getDeviceCode().equalsIgnoreCase("aspicore")) {
            this.dataXPort.setDeviceCode("aspicore");
        }
        Print.logInfo("DeviceID     : [" + this.device.getUniqueID() + "] " + accountID + "/" + deviceID + " [" + this.device.getDescription() + "]", new Object[0]);
        int statusCode = 61472;
        long fixtime = this.gprmc != null ? this.gprmc.getFixtime() : 0L;
        double latitude = this.gprmc != null ? this.gprmc.getLatitude() : 0.0;
        double longitude = this.gprmc != null ? this.gprmc.getLongitude() : 0.0;
        boolean validGPS = this.gprmc != null ? this.gprmc.isValidGPS() : false;
        double speedKPH = this.gprmc != null ? this.gprmc.getSpeedKPH() : 0.0;
        double headingDeg = this.gprmc != null ? this.gprmc.getHeading() : 0.0;
        double altitudeM = this.gprmc != null ? this.gprmc.getAltitudeMeters() : 0.0;
        double odomKM = 0.0;
        GeoPoint geoPoint = new GeoPoint(latitude, longitude);
        if (speedKPH < MINIMUM_SPEED_KPH) {
            speedKPH = 0.0;
            headingDeg = 0.0;
        } else if (headingDeg < 0.0) {
            headingDeg = 0.0;
        }
        if (statusCode == 0) {
            statusCode = speedKPH > 0.0 ? 61714 : 61472;
        } else if (XLATE_LOCATON_INMOTION && statusCode == 61472 && speedKPH > 0.0) {
            statusCode = 61714;
        }
        Print.logInfo("Fixtime  : " + new DateTime(fixtime), new Object[0]);
        Print.logInfo("GeoPoint : " + geoPoint, new Object[0]);
        Print.logInfo("Speed    : " + speedKPH + " km/h [heading " + headingDeg + "]", new Object[0]);
        if (!validGPS && statusCode == 61472) {
            Print.logWarn("Ignoring event with invalid latitude/longitude", new Object[0]);
            return true;
        }
        if (statusCode < 0 || statusCode == -1) {
            Print.logWarn("Ignoring event with IGNORE status code", new Object[0]);
            return true;
        }
        if (validGPS && MINIMUM_MOVED_METERS > 0.0 && statusCode == 61472 && (prevGPS = this.device.getLastValidLocation()) != null && (deltaM = geoPoint.metersToPoint(prevGPS)) < MINIMUM_MOVED_METERS) {
            Print.logWarn("Ignoring event within close proximity to previous event", new Object[0]);
            return true;
        }
        odomKM = odomKM <= 0.0 ? (ESTIMATE_ODOMETER && validGPS ? this.device.getNextOdometerKM(geoPoint) : this.device.getLastOdometerKM()) : this.device.adjustOdometerKM(odomKM);
        Print.logInfo("Odometer : " + odomKM + " km", new Object[0]);
        if (SIMEVENT_GEOZONES && validGPS && (zone = this.device.checkGeozoneTransitions(fixtime, geoPoint)) != null) {
            for (Device.GeozoneTransition z : zone) {
                Print.logInfo("Geozone    : " + z, new Object[0]);
                this.insertEventRecord(this.device, z.getTimestamp(), z.getStatusCode(), z.getGeozone(), geoPoint, speedKPH, headingDeg, altitudeM, odomKM);
            }
        }
        if (statusCode != 61472 || this.eventTotalCount <= 0) {
            this.insertEventRecord(this.device, fixtime, statusCode, null, geoPoint, speedKPH, headingDeg, altitudeM, odomKM);
        }
        if (!DEBUG_MODE) {
            try {
                this.device.updateChangedEventFields();
            }
            catch (DBException dbe) {
                Print.logException("Unable to update Device: " + this.device.getAccountID() + "/" + this.device.getDeviceID(), dbe);
            }
        }
        return true;
    }

    private EventData createEventRecord(Device device, long fixtime, int statusCode, Geozone geozone, GeoPoint geoPoint, double speedKPH, double heading, double altitude, double odomKM) {
        String accountID = device != null ? device.getAccountID() : "";
        String deviceID = device != null ? device.getDeviceID() : "";
        EventData.Key evKey = new EventData.Key(accountID, deviceID, fixtime, statusCode);
        EventData evdb = (EventData)evKey.getDBRecord();
        evdb.setGeozone(geozone);
        evdb.setGeoPoint(geoPoint);
        evdb.setHeading(heading);
        evdb.setSpeedKPH(speedKPH);
        evdb.setAltitude(altitude);
        evdb.setOdometerKM(odomKM);
        return evdb;
    }

    private void insertEventRecord(Device device, long fixtime, int statusCode, Geozone geozone, GeoPoint geoPoint, double speedKPH, double heading, double altitude, double odomKM) {
        if (DEBUG_MODE || this.device == null) {
            return;
        }
        EventData evdb = this.createEventRecord(device, fixtime, statusCode, geozone, geoPoint, speedKPH, heading, altitude, odomKM);
        Print.logInfo("Event     : [0x" + StringTools.toHexString(statusCode, 16) + "] " + StatusCodes.GetDescription(statusCode, null), new Object[0]);
        device.insertEventData(evdb);
        ++this.eventTotalCount;
    }

    public static void configInit() {
        DCServerConfig dcsc = Main.getServerConfig();
        if (dcsc != null) {
            UNIQUEID_PREFIX = dcsc.getUniquePrefix();
            MINIMUM_SPEED_KPH = dcsc.getMinimumSpeedKPH(MINIMUM_SPEED_KPH);
            ESTIMATE_ODOMETER = dcsc.getEstimateOdometer(ESTIMATE_ODOMETER);
            SIMEVENT_GEOZONES = dcsc.getSimulateGeozones(SIMEVENT_GEOZONES);
            XLATE_LOCATON_INMOTION = dcsc.getStatusLocationInMotion(XLATE_LOCATON_INMOTION);
            MINIMUM_MOVED_METERS = dcsc.getMinimumMovedMeters(MINIMUM_MOVED_METERS);
        }
    }
}

