/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers.aspicore;

import org.opengts.Version;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.dbtools.DBAdmin;
import org.opengts.servers.aspicore.TrackClientPacketHandler;
import org.opengts.servers.aspicore.TrackServer;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class Main {
    public static final String[] ARG_HELP = new String[]{"help", "h"};
    public static final String[] ARG_CMD_PORT = new String[]{"command", "cmd"};
    public static final String[] ARG_START = new String[]{"start"};
    private static DCServerConfig dcServerCfg = null;

    public static String DCServerFactory_LoadName() {
        return Main.getServerContextName();
    }

    public static String getServerName() {
        return "aspicore";
    }

    public static String getServerContextName() {
        return RTConfig.getContextName(Main.getServerName());
    }

    public static DCServerConfig getServerConfig() {
        if (dcServerCfg == null) {
            dcServerCfg = DCServerFactory.getServerConfig(Main.getServerContextName());
            DCServerConfig.startRemoteLogging(dcServerCfg);
        }
        return dcServerCfg;
    }

    public static int[] getTcpPorts() {
        DCServerConfig dcs = Main.getServerConfig();
        if (dcs != null) {
            return dcs.getTcpPorts();
        }
        Print.logError("DCServerConfig not found for server: " + Main.getServerName(), new Object[0]);
        return null;
    }

    public static int[] getUdpPorts() {
        DCServerConfig dcs = Main.getServerConfig();
        if (dcs != null) {
            return dcs.getUdpPorts();
        }
        Print.logError("DCServerConfig not found for server: " + Main.getServerName(), new Object[0]);
        return null;
    }

    public static int getCommandDispatcherPort() {
        DCServerConfig dcs = Main.getServerConfig();
        if (dcs != null) {
            return dcs.getCommandDispatcherPort();
        }
        return RTConfig.getInt(ARG_CMD_PORT, 0);
    }

    public static String getUniqueIDPrefixList() {
        DCServerConfig dcsc = Main.getServerConfig();
        if (dcsc != null) {
            return DCServerFactory.getUniquePrefixString(dcsc.getUniquePrefix());
        }
        return "";
    }

    private static void usage(String msg) {
        String tcp = StringTools.join(Main.getTcpPorts(), ",");
        String udp = StringTools.join(Main.getUdpPorts(), ",");
        if (msg != null) {
            Print.logInfo(msg, new Object[0]);
        }
        Print.logInfo("", new Object[0]);
        Print.logInfo("Usage:", new Object[0]);
        Print.logInfo("  java ... " + Main.class.getName() + " {options}", new Object[0]);
        Print.logInfo("Options:", new Object[0]);
        Print.logInfo("  [-h[elp]]           Print this help", new Object[0]);
        Print.logInfo("  [-port=<p>[,<p>]]   Server TCP/UDP port(s) to listen", new Object[0]);
        Print.logInfo("  [-tcp=<p>[,<p>]]    Server TCP port(s) to listen on [dft=" + tcp + "]", new Object[0]);
        Print.logInfo("  [-udp=<p>[,<p>]]    Server UDP port(s) to listen on [dft=" + udp + "]", new Object[0]);
        Print.logInfo("  -start              Start server on the specified port", new Object[0]);
        Print.logInfo("", new Object[0]);
        System.exit(1);
    }

    public static void main(String[] argv) {
        DBConfig.cmdLineInit(argv, false);
        DBConfig.check_GTS_HOME();
        TrackClientPacketHandler.configInit();
        TrackServer.configInit();
        String SEP = "--------------------------------------------------------------------------";
        Print.logInfo(SEP, new Object[0]);
        Print.logInfo("Aspicore Server", new Object[0]);
        Print.logInfo("Copyright 2007-2013, GeoTelematic Solutions, Inc.", new Object[0]);
        Print.logInfo("Version: 0.1.0  [" + Version.getCompileTime() + "]", new Object[0]);
        Print.logInfo("Unique-ID Prefix(s)   : " + Main.getUniqueIDPrefixList(), new Object[0]);
        Print.logInfo("Minimum Speed (KPH)   : " + TrackClientPacketHandler.MINIMUM_SPEED_KPH, new Object[0]);
        Print.logInfo("Estimate GPS Odometer : " + TrackClientPacketHandler.ESTIMATE_ODOMETER, new Object[0]);
        Print.logInfo("Simulate Arrive/Depart: " + TrackClientPacketHandler.SIMEVENT_GEOZONES, new Object[0]);
        Print.logInfo("TCP Idle Timeout      : " + TrackServer.getTcpIdleTimeout() + " ms", new Object[0]);
        Print.logInfo("TCP Packet Timeout    : " + TrackServer.getTcpPacketTimeout() + " ms", new Object[0]);
        Print.logInfo("TCP Session Timeout   : " + TrackServer.getTcpSessionTimeout() + " ms", new Object[0]);
        Print.logInfo("UDP Idle Timeout      : " + TrackServer.getUdpIdleTimeout() + " ms", new Object[0]);
        Print.logInfo("UDP Packet Timeout    : " + TrackServer.getUdpPacketTimeout() + " ms", new Object[0]);
        Print.logInfo("UDP Session Timeout   : " + TrackServer.getUdpSessionTimeout() + " ms", new Object[0]);
        Print.logInfo(SEP, new Object[0]);
        if (RTConfig.getBoolean(ARG_HELP, false)) {
            Main.usage("Help ...");
        }
        if (!DBAdmin.verifyTablesExist()) {
            Print.logFatal("MySQL database has not yet been properly initialized", new Object[0]);
            System.exit(1);
        }
        if (RTConfig.getBoolean(ARG_START, false)) {
            try {
                int[] tcpPorts = Main.getTcpPorts();
                int[] udpPorts = Main.getUdpPorts();
                int commandPort = Main.getCommandDispatcherPort();
                TrackServer.startTrackServer(tcpPorts, udpPorts, commandPort);
            }
            catch (Throwable t) {
                Print.logError("Error: " + t, new Object[0]);
            }
            Print.logInfo(SEP, new Object[0]);
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(3600000L);
                    }
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }
        Main.usage("Missing '-start' ...");
        System.exit(99);
    }
}

