/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers.icare;

import java.util.List;
import java.util.Vector;
import org.opengts.db.DCServerFactory;
import org.opengts.servers.icare.Constants;
import org.opengts.servers.icare.TrackClientPacketHandler;
import org.opengts.util.ListTools;
import org.opengts.util.Print;
import org.opengts.util.ServerSocketThread;

public class TrackServer {
    private static TrackServer trackTcpInstance = null;
    private static long tcpTimeout_idle = 10000L;
    private static long tcpTimeout_packet = 4000L;
    private static long tcpTimeout_session = 15000L;
    private static long udpTimeout_idle = 5000L;
    private static long udpTimeout_packet = 4000L;
    private static long udpTimeout_session = 60000L;
    private List<ServerSocketThread> tcpThread = new Vector<ServerSocketThread>();
    private List<ServerSocketThread> udpThread = new Vector<ServerSocketThread>();

    public static TrackServer startTrackServer(int port) throws Throwable {
        return TrackServer.startTrackServer(new int[]{port});
    }

    public static TrackServer startTrackServer(int[] port) throws Throwable {
        if (trackTcpInstance == null) {
            trackTcpInstance = new TrackServer(port);
        }
        return trackTcpInstance;
    }

    public static void setTcpIdleTimeout(long timeout) {
        tcpTimeout_idle = timeout;
    }

    public static long getTcpIdleTimeout() {
        return tcpTimeout_idle;
    }

    public static void setTcpPacketTimeout(long timeout) {
        tcpTimeout_packet = timeout;
    }

    public static long getTcpPacketTimeout() {
        return tcpTimeout_packet;
    }

    public static void setTcpSessionTimeout(long timeout) {
        tcpTimeout_session = timeout;
    }

    public static long getTcpSessionTimeout() {
        return tcpTimeout_session;
    }

    public static void setUdpIdleTimeout(long timeout) {
        udpTimeout_idle = timeout;
    }

    public static long getUdpIdleTimeout() {
        return udpTimeout_idle;
    }

    public static void setUdpPacketTimeout(long timeout) {
        udpTimeout_packet = timeout;
    }

    public static long getUdpPacketTimeout() {
        return udpTimeout_packet;
    }

    public static void setUdpSessionTimeout(long timeout) {
        udpTimeout_session = timeout;
    }

    public static long getUdpSessionTimeout() {
        return udpTimeout_session;
    }

    private TrackServer(int[] port) throws Throwable {
        if (!ListTools.isEmpty(port)) {
            for (int i = 0; i < port.length; ++i) {
                this.startPortListeners(port[i]);
            }
        } else {
            throw new Exception("No ports specified");
        }
    }

    private void startPortListeners(int port) throws Throwable {
        if (!DCServerFactory.isValidPort(port)) {
            throw new Exception("Invalid port number: " + port);
        }
        this._startTCP(port);
        this._startUDP(port);
    }

    private void _startTCP(int port) throws Throwable {
        ServerSocketThread sst = null;
        try {
            sst = new ServerSocketThread(port);
        }
        catch (Throwable t) {
            Print.logException("ServerSocket error", t);
            throw t;
        }
        sst.setTextPackets(false);
        sst.setBackspaceChar(null);
        sst.setLineTerminatorChar(Constants.ASCII_LINE_TERMINATOR);
        sst.setIgnoreChar(Constants.ASCII_IGNORE_CHARS);
        sst.setMaximumPacketLength(600);
        sst.setMinimumPacketLength(12);
        sst.setIdleTimeout(tcpTimeout_idle);
        sst.setPacketTimeout(tcpTimeout_packet);
        sst.setSessionTimeout(tcpTimeout_session);
        sst.setLingerTimeoutSec(5);
        sst.setTerminateOnTimeout(true);
        sst.setClientPacketHandlerClass(TrackClientPacketHandler.class);
        Print.logInfo("Starting TCP listener thread on port " + port + " [timeout=" + sst.getSessionTimeout() + "ms] ...", new Object[0]);
        sst.start();
        this.tcpThread.add(sst);
    }

    private void _startUDP(int port) throws Throwable {
        ServerSocketThread sst = null;
        try {
            sst = new ServerSocketThread(ServerSocketThread.createDatagramSocket(port));
        }
        catch (Throwable t) {
            Print.logException("ServerSocket error", t);
            throw t;
        }
        sst.setTextPackets(true);
        sst.setBackspaceChar(null);
        sst.setLineTerminatorChar(new int[]{13});
        sst.setMaximumPacketLength(600);
        sst.setMinimumPacketLength(12);
        sst.setIdleTimeout(udpTimeout_idle);
        sst.setPacketTimeout(udpTimeout_packet);
        sst.setSessionTimeout(udpTimeout_session);
        sst.setTerminateOnTimeout(true);
        sst.setClientPacketHandlerClass(TrackClientPacketHandler.class);
        Print.logInfo("Starting UDP listener thread on port " + port + " [timeout=" + sst.getSessionTimeout() + "ms] ...", new Object[0]);
        sst.start();
        this.udpThread.add(sst);
    }
}

