/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers.icare;

import java.net.InetAddress;
import org.opengts.db.DataTransport;
import org.opengts.db.tables.Device;
import org.opengts.db.tables.EventData;
import org.opengts.db.tables.Transport;
import org.opengts.dbtools.DBException;
import org.opengts.servers.icare.Main;
import org.opengts.util.AbstractClientPacketHandler;
import org.opengts.util.DateTime;
import org.opengts.util.GeoPoint;
import org.opengts.util.Print;
import org.opengts.util.StringTools;

public class TrackClientPacketHandler
extends AbstractClientPacketHandler {
    public static final double KILOMETERS_PER_KNOT = 1.852;
    private String ipAddress = null;
    private int eventCount = 0;

    @Override
    public void sessionStarted(InetAddress inetAddr, boolean isTCP, boolean isText) {
        super.sessionStarted(inetAddr, isTCP, isText);
        super.clearTerminateSession();
        this.ipAddress = inetAddr != null ? inetAddr.getHostAddress() : null;
    }

    @Override
    public void sessionTerminated(Throwable err, long readCount, long writeCount) {
        super.sessionTerminated(err, readCount, writeCount);
    }

    @Override
    public int getActualPacketLength(byte[] packet, int packetLen) {
        return -1;
    }

    @Override
    public byte[] getHandlePacket(byte[] pktBytes) {
        if (pktBytes == null) {
            Print.logError("Packet is null", new Object[0]);
        } else if (pktBytes.length < 12) {
            Print.logError("Unexpected packet length: " + pktBytes.length, new Object[0]);
        } else {
            int ofs = 12;
            int len = pktBytes.length - ofs;
            String s = StringTools.toStringValue(pktBytes, ofs, len).trim();
            Print.logInfo("Recv: " + s, new Object[0]);
            this.parseInsertRecord(s);
            ++this.eventCount;
        }
        return null;
    }

    private long _getUTCSeconds(long dmy, long hms) {
        long DAY;
        int HH = (int)(hms / 10000L % 100L);
        int MM = (int)(hms / 100L % 100L);
        int SS = (int)(hms % 100L);
        long TOD = (long)HH * 3600L + (long)MM * 60L + (long)SS;
        if (dmy > 0L) {
            int yy = (int)(dmy % 100L) + 2000;
            int mm = (int)(dmy / 100L % 100L);
            int dd = (int)(dmy / 10000L % 100L);
            long yr = (long)yy * 1000L + (long)((mm - 3) * 1000 / 12);
            DAY = (367L * yr + 625L) / 1000L - 2L * (yr / 1000L) + yr / 4000L - yr / 100000L + yr / 400000L + (long)dd - 719469L;
        } else {
            long dif;
            long utc = DateTime.getCurrentTimeSec();
            long tod = utc % DateTime.DaySeconds(1L);
            DAY = utc / DateTime.DaySeconds(1L);
            long l = dif = tod >= TOD ? tod - TOD : TOD - tod;
            if (dif > DateTime.HourSeconds(12L)) {
                DAY = tod > TOD ? ++DAY : --DAY;
            }
        }
        long sec = DateTime.DaySeconds(DAY) + TOD;
        return sec;
    }

    private double _parseLatitude(String s, String d) {
        double _lat = StringTools.parseDouble(s, 99999.0);
        if (_lat < 99999.0) {
            double lat = (long)_lat / 100L;
            lat += (_lat - lat * 100.0) / 60.0;
            return d.equals("S") ? -lat : lat;
        }
        return 90.0;
    }

    private double _parseLongitude(String s, String d) {
        double _lon = StringTools.parseDouble(s, 99999.0);
        if (_lon < 99999.0) {
            double lon = (long)_lon / 100L;
            lon += (_lon - lon * 100.0) / 60.0;
            return d.equals("W") ? -lon : lon;
        }
        return 180.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseInsertRecord(String s) {
        Print.logInfo("Parsing: " + s, new Object[0]);
        if (s == null) {
            Print.logError("String is null", new Object[0]);
            return false;
        }
        String[] fld = StringTools.parseStringArray(s, ',');
        if (fld == null || fld.length < 11 || !fld[1].equals("$GPRMC")) {
            Print.logWarn("Invalid number of fields", new Object[0]);
            return false;
        }
        if (!fld[0].startsWith("%") || fld[0].length() < 10) {
            return false;
        }
        String imei = fld[0].substring(1).toLowerCase();
        long hms = StringTools.parseLong(fld[2], 0L);
        long dmy = StringTools.parseLong(fld[10], 0L);
        long fixtime = this._getUTCSeconds(dmy, hms);
        boolean validGPS = fld[3].equalsIgnoreCase("A");
        double latitude = validGPS ? this._parseLatitude(fld[4], fld[5]) : 0.0;
        double longitude = validGPS ? this._parseLongitude(fld[6], fld[7]) : 0.0;
        double knots = validGPS ? StringTools.parseDouble(fld[8], -1.0) : 0.0;
        double heading = validGPS ? StringTools.parseDouble(fld[9], -1.0) : 0.0;
        double speedKPH = knots >= 0.0 ? knots * 1.852 : -1.0;
        int statusCode = 61472;
        if (fixtime <= 0L) {
            Print.logWarn("Invalid date: " + fld[10] + "/" + fld[2], new Object[0]);
            fixtime = DateTime.getCurrentTimeSec();
        }
        if (validGPS && (latitude >= 90.0 || latitude <= -90.0 || longitude >= 180.0 || longitude <= -180.0)) {
            Print.logWarn("Invalid GPRMC lat/lon: " + latitude + "/" + longitude, new Object[0]);
            latitude = 0.0;
            longitude = 0.0;
            validGPS = false;
        }
        if (speedKPH < 3.0) {
            speedKPH = 0.0;
            heading = 0.0;
        }
        Print.logInfo("IMEI     : " + imei, new Object[0]);
        Print.logInfo("Timestamp: " + fixtime + " [" + new DateTime(fixtime) + "]", new Object[0]);
        Print.logInfo("GPS      : " + new GeoPoint(latitude, longitude), new Object[0]);
        Print.logInfo("Speed    : " + StringTools.format(speedKPH, "#0.0") + " kph " + heading, new Object[0]);
        String uniqueID = "imei_" + imei;
        Device device = null;
        DataTransport dataXPort = null;
        String accountID = null;
        String deviceID = null;
        try {
            device = Transport.loadDeviceByUniqueID(uniqueID);
            if (device == null) {
                String uniqueID_alt = "icare_" + imei;
                device = Transport.loadDeviceByUniqueID(uniqueID_alt);
                if (device == null) {
                    Print.logWarn("IMEI ID not found!: " + uniqueID, new Object[0]);
                    return false;
                }
                uniqueID = uniqueID_alt;
            }
            accountID = device.getAccountID();
            deviceID = device.getDeviceID();
            dataXPort = device.getDataTransport();
            if (!dataXPort.getDeviceCode().equalsIgnoreCase(Main.getServerName())) {
                dataXPort.setDeviceCode(Main.getServerName());
            }
        }
        catch (DBException dbe) {
            Print.logError("Exception getting Device: " + uniqueID + " [" + dbe + "]", new Object[0]);
            return false;
        }
        Print.logInfo("UniqueID : " + uniqueID, new Object[0]);
        Print.logInfo("DeviceID : " + accountID + "/" + deviceID, new Object[0]);
        if (this.ipAddress != null && !dataXPort.isValidIPAddress(this.ipAddress)) {
            Print.logError("Invalid IP Address for device: " + this.ipAddress + " [expecting " + dataXPort.getIpAddressValid() + "]", new Object[0]);
            return false;
        }
        device.setIpAddressCurrent(this.ipAddress);
        EventData.Key evKey = new EventData.Key(accountID, deviceID, fixtime, statusCode);
        EventData evdb = (EventData)evKey.getDBRecord();
        evdb.setLatitude(latitude);
        evdb.setLongitude(longitude);
        evdb.setHeading(heading);
        evdb.setSpeedKPH(speedKPH);
        device.insertEventData(evdb);
        device.setLastTotalConnectTime(DateTime.getCurrentTimeSec());
        try {
            device.update("deviceCode", "ipAddressCurrent", "lastTotalConnectTime");
        }
        catch (DBException dbe) {
            Print.logException("Unable to update Device: " + accountID + "/" + deviceID, dbe);
        }
        return true;
    }
}

