/*
 * Decompiled with CFR 0.152.
 */
package org.opengts.servers.icare;

import java.util.Vector;
import org.opengts.db.DBConfig;
import org.opengts.db.DCServerConfig;
import org.opengts.db.DCServerFactory;
import org.opengts.dbtools.DBAdmin;
import org.opengts.servers.icare.TrackServer;
import org.opengts.util.Print;
import org.opengts.util.RTConfig;
import org.opengts.util.StringTools;

public class Main {
    public static final String[] ARG_HELP = new String[]{"h", "help"};
    public static final String[] ARG_PORT = new String[]{"p", "port"};
    public static final String ARG_START = "start";
    private static DCServerConfig dcServerCfg = null;

    public static String DCServerFactory_LoadName() {
        return Main.getServerContextName();
    }

    public static String getServerName() {
        return "icare";
    }

    public static String getServerContextName() {
        return RTConfig.getContextName(Main.getServerName());
    }

    public static DCServerConfig getServerConfig() {
        if (dcServerCfg == null) {
            dcServerCfg = DCServerFactory.getServerConfig(Main.getServerContextName());
            DCServerConfig.startRemoteLogging(dcServerCfg);
        }
        return dcServerCfg;
    }

    public static int[] getTcpPorts() {
        DCServerConfig dcs = Main.getServerConfig();
        if (dcs != null) {
            return dcs.getTcpPorts();
        }
        Print.logError("DCServerConfig not found for server: " + Main.getServerName(), new Object[0]);
        return null;
    }

    public static int[] getUdpPorts() {
        DCServerConfig dcs = Main.getServerConfig();
        if (dcs != null) {
            return dcs.getUdpPorts();
        }
        Print.logError("DCServerConfig not found for server: " + Main.getServerName(), new Object[0]);
        return null;
    }

    public static int[] getListenPorts() {
        Vector<Integer> portList = new Vector<Integer>();
        int[] tcpPorts = Main.getTcpPorts();
        for (int t = 0; t < tcpPorts.length; ++t) {
            Integer tcp = new Integer(tcpPorts[t]);
            portList.add(tcp);
        }
        int[] udpPorts = Main.getUdpPorts();
        for (int u = 0; u < udpPorts.length; ++u) {
            Integer udp = new Integer(udpPorts[u]);
            if (portList.contains(udp)) continue;
            portList.add(udp);
        }
        int[] ports = new int[portList.size()];
        for (int p = 0; p < portList.size(); ++p) {
            ports[p] = (Integer)portList.get(p);
        }
        return ports;
    }

    private static void usage(String msg) {
        if (msg != null) {
            Print.logInfo(msg, new Object[0]);
        }
        Print.logInfo("", new Object[0]);
        Print.logInfo("Usage:", new Object[0]);
        Print.logInfo("  java ... " + StringTools.className(Main.class) + " {options}", new Object[0]);
        Print.logInfo("Options:", new Object[0]);
        Print.logInfo("  [-h[elp]]           Print this help", new Object[0]);
        Print.logInfo("  [-port=<p>[,<p>]]   Server port(s) to listen on", new Object[0]);
        Print.logInfo("  -start              Start server on the specified port", new Object[0]);
        Print.logInfo("", new Object[0]);
        System.exit(1);
    }

    public static void main(String[] argv) {
        int[] listenPorts;
        String serverName;
        DBConfig.cmdLineInit(argv, false);
        String SEP = "--------------------------------------------------------------------------";
        Print.logInfo(SEP, new Object[0]);
        Print.logInfo("[" + Main.getServerContextName() + "] " + "I-Care G3300 Device Communication Server", new Object[0]);
        Print.logInfo("DCS Version: 0.2.2", new Object[0]);
        Print.logInfo("Copyright 2007-2013, GeoTelematic Solutions, Inc.", new Object[0]);
        Print.logInfo(SEP, new Object[0]);
        if (RTConfig.getBoolean(ARG_HELP, false)) {
            Main.usage("Help ...");
        }
        if (!DCServerFactory.hasServerConfig(serverName = Main.getServerName())) {
            Print.logWarn("This server name is not registered with DCServerConfig: %s", serverName);
            if (RTConfig.getBoolean("autoregister", false)) {
                String dftDescr = "Custom Server";
                int listenPort = 31200;
                String[] prefix = new String[]{"imei_", "icare_", ""};
                int[] ports = new int[]{listenPort};
                DCServerFactory.addDCS(serverName, dftDescr, ports, ports, 0, 12288L, prefix);
            }
        }
        if (!DCServerFactory.isValidPort(listenPorts = Main.getListenPorts())) {
            Main.usage("Invalid ports specified");
        }
        if (!DBAdmin.verifyTablesExist()) {
            Print.logFatal("MySQL database has not yet been properly initialized", new Object[0]);
            System.exit(1);
        }
        if (RTConfig.getBoolean(ARG_START, false)) {
            try {
                TrackServer.startTrackServer(listenPorts);
            }
            catch (Throwable t) {
                Print.logError("Error: " + t, new Object[0]);
            }
            while (true) {
                try {
                    while (true) {
                        Thread.sleep(3600000L);
                    }
                }
                catch (Throwable t) {
                    continue;
                }
                break;
            }
        }
        Main.usage("Missing '-start' ...");
    }
}

